/*
 * Decompiled with CFR 0.152.
 */
package bence.sipka.cmd;

import bence.sipka.cmd.AutoIndentOutputStream;
import bence.sipka.cmd.api.Command;
import bence.sipka.cmd.api.CommonConverter;
import bence.sipka.cmd.api.Converter;
import bence.sipka.cmd.api.Flag;
import bence.sipka.cmd.model.AbstractModelCommand;
import bence.sipka.cmd.model.ModelBaseCommand;
import bence.sipka.cmd.model.ModelCommand;
import bence.sipka.cmd.model.ModelCommonConverter;
import bence.sipka.cmd.model.ModelConverter;
import bence.sipka.cmd.model.ModelMultiParameter;
import bence.sipka.cmd.model.ModelParameter;
import bence.sipka.cmd.model.ModelSubCommand;
import bence.sipka.cmd.runtime.ParseUtil;
import bence.sipka.cmd.runtime.ParsingIterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class CommandLineProcessor
implements Processor {
    public static final String OPTION_GENERATE_HELP_INFO = "cmdline.help.generate";
    public static final String OPTION_HELP_LINE_LENGTH_ERROR_LIMIT = "cmdline.help.line.errorlimit";
    private static final String KEY_VALUE_HELP_APPENDIX = "<key>=<value>";
    private static final String DEPRECATED_HELP_FLAG = "[deprecated]";
    private static final String DEFAULT_COMMAND_HELP_FLAG = "[default]";
    private static final String REQUIRED_HELP_FLAG = "[required]";
    private static final String POSITIONAL_HELP_FLAG = "[positional]";
    private static final String MULTI_HELP_FLAG = "[multi]";
    private static final String HELP_FLAG_INDENT = "  ";
    private static final int HELP_FLAGS_MAX_LENGTH = 14;
    private static final int COLUMN_SPACE_WIDTH = 4;
    private static final String INDENTATION = "\t";
    private Elements elements;
    private Filer filer;
    private Types types;
    private Messager messager;
    private boolean supportsLambda;
    private TypeElement commandAnnot;
    private TypeElement converterAnnot;
    private TypeElement commonConverterAnnot;
    private TypeElement javaLangString;
    private TypeElement javaLangBoolean;
    private TypeElement javaLangCharacter;
    private TypeElement javaLangByte;
    private TypeElement javaLangShort;
    private TypeElement javaLangInteger;
    private TypeElement javaLangLong;
    private TypeElement javaLangFloat;
    private TypeElement javaLangDouble;
    private TypeElement parsingIteratorType;
    private TypeMirror collectionType;
    private TypeMirror mapType;
    private boolean generateHelpInfo = true;
    private int helpLineErrorLimit = -1;
    private String parameterSeparatorLines = "\n";
    private Set<TypeElement> commandElements = new LinkedHashSet<TypeElement>();
    private static final String HELP_BLOCK_INDENT = "    ";
    private Map<TypeElement, Boolean> uppercaseEnums = new LinkedHashMap<TypeElement, Boolean>();

    public Elements getElements() {
        return this.elements;
    }

    public Types getTypes() {
        return this.types;
    }

    public Messager getMessager() {
        return this.messager;
    }

    public boolean isSupportsLambda() {
        return this.supportsLambda;
    }

    public TypeElement getParsingIteratorType() {
        return this.parsingIteratorType;
    }

    public TypeElement getJavaLangBoolean() {
        return this.javaLangBoolean;
    }

    public TypeElement getJavaLangByte() {
        return this.javaLangByte;
    }

    public TypeElement getJavaLangCharacter() {
        return this.javaLangCharacter;
    }

    public TypeElement getJavaLangDouble() {
        return this.javaLangDouble;
    }

    public TypeElement getJavaLangFloat() {
        return this.javaLangFloat;
    }

    public TypeElement getJavaLangInteger() {
        return this.javaLangInteger;
    }

    public TypeElement getJavaLangLong() {
        return this.javaLangLong;
    }

    public TypeElement getJavaLangShort() {
        return this.javaLangShort;
    }

    public TypeElement getJavaLangString() {
        return this.javaLangString;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> supportedoptions = new TreeSet<String>();
        supportedoptions.add(OPTION_GENERATE_HELP_INFO);
        supportedoptions.add(OPTION_HELP_LINE_LENGTH_ERROR_LIMIT);
        return supportedoptions;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        TreeSet<String> result = new TreeSet<String>();
        result.add(Command.class.getName());
        return result;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        String linerrorlimitarg;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.supportsLambda = processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_7) > 0;
        Map<String, String> procoptions = processingEnv.getOptions();
        String helpinfoarg = procoptions.get(OPTION_GENERATE_HELP_INFO);
        if (helpinfoarg != null) {
            this.generateHelpInfo = Boolean.parseBoolean(helpinfoarg);
        }
        if ((linerrorlimitarg = procoptions.get(OPTION_HELP_LINE_LENGTH_ERROR_LIMIT)) != null) {
            this.helpLineErrorLimit = Integer.parseUnsignedInt(linerrorlimitarg);
        }
    }

    public static String getSimpleClassNameFromQualified(String qname) {
        return qname.substring(qname.lastIndexOf(46) + 1);
    }

    public static String getPackageNameFromQualified(String qname) {
        int idx = qname.lastIndexOf(46);
        if (idx < 0) {
            return null;
        }
        return qname.substring(0, idx);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.commandAnnot == null) {
            this.commandAnnot = this.elements.getTypeElement(Command.class.getName());
            this.converterAnnot = this.elements.getTypeElement(Converter.class.getName());
            this.commonConverterAnnot = this.elements.getTypeElement(CommonConverter.class.getName());
            this.javaLangString = this.elements.getTypeElement(String.class.getCanonicalName());
            this.javaLangBoolean = this.elements.getTypeElement(Boolean.class.getCanonicalName());
            this.javaLangCharacter = this.elements.getTypeElement(Character.class.getCanonicalName());
            this.javaLangByte = this.elements.getTypeElement(Byte.class.getCanonicalName());
            this.javaLangShort = this.elements.getTypeElement(Short.class.getCanonicalName());
            this.javaLangInteger = this.elements.getTypeElement(Integer.class.getCanonicalName());
            this.javaLangLong = this.elements.getTypeElement(Long.class.getCanonicalName());
            this.javaLangFloat = this.elements.getTypeElement(Float.class.getCanonicalName());
            this.javaLangDouble = this.elements.getTypeElement(Double.class.getCanonicalName());
            this.parsingIteratorType = this.elements.getTypeElement(ParsingIterator.class.getCanonicalName());
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(this.commandAnnot)) {
            TypeElement te = (TypeElement)element;
            this.commandElements.add(te);
        }
        if (roundEnv.processingOver()) {
            ArrayList<TypeElement> cmdelements = new ArrayList<TypeElement>(this.commandElements);
            this.commandElements.clear();
            for (TypeElement cmdelem : cmdelements) {
                ModelBaseCommand mc = new ModelBaseCommand(this, cmdelem.getAnnotation(Command.class), cmdelem);
                mc.resolve(this);
                HashSet<Element> dependentelements = new HashSet<Element>();
                dependentelements.add(cmdelem);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Throwable throwable = null;
                    try {
                        try (PrintStream ps = new PrintStream(new AutoIndentOutputStream(baos));){
                            this.generateForModel(mc, ps, dependentelements);
                        }
                        OutputStream os = this.filer.createSourceFile(mc.getGeneratedClassQualifiedName(), dependentelements.toArray(new Element[dependentelements.size()])).openOutputStream();
                        var11_15 = null;
                        try {
                            baos.writeTo(os);
                        }
                        catch (Throwable throwable2) {
                            var11_15 = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (os == null) continue;
                            if (var11_15 != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable throwable2) {
                                    var11_15.addSuppressed(throwable2);
                                }
                                continue;
                            }
                            os.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (baos == null) continue;
                        if (throwable != null) {
                            try {
                                baos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        baos.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    private static int getLeadingSpaceCount(CharSequence cs) {
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            if (cs.charAt(i) == ' ') continue;
            return i;
        }
        return len;
    }

    private static int getMaxStringWidth(Iterable<? extends String> strings) {
        int res = 0;
        for (String string : strings) {
            res = Math.max(res, string.length());
        }
        return res;
    }

    private static int getMaxSubCommandNameWidth(Iterable<? extends ModelSubCommand> commands) {
        int res = 14;
        for (ModelSubCommand modelSubCommand : commands) {
            for (String n : modelSubCommand.getNames()) {
                res = Math.max(n.length(), res);
            }
        }
        return res;
    }

    private static int getStringLengthDefault(String s, int def) {
        return s == null ? def : s.length();
    }

    private static int getMaxParameterNameWidth(Iterable<? extends ModelParameter> params) {
        int res = 14;
        for (ModelParameter modelParameter : params) {
            if (modelParameter.isMapParameter()) {
                for (String n : modelParameter.getNames()) {
                    res = Math.max(n.length() + KEY_VALUE_HELP_APPENDIX.length(), res);
                }
                continue;
            }
            int formatlen = CommandLineProcessor.getStringLengthDefault(modelParameter.getDocCommentFormat(), -1) + 1;
            for (String n : modelParameter.getNames()) {
                res = Math.max(n.length() + formatlen, res);
            }
        }
        return res;
    }

    private static void appendSpaces(StringBuilder sb, int count) {
        if (count <= 0) {
            return;
        }
        while (count-- > 0) {
            sb.append(' ');
        }
    }

    private static int getAllLeadingSpaceCount(Iterable<String> lines) {
        int c = Integer.MAX_VALUE;
        Iterator<String> it = lines.iterator();
        if (!it.hasNext()) {
            return 0;
        }
        while (it.hasNext()) {
            String l = it.next();
            int lsc = CommandLineProcessor.getLeadingSpaceCount(l);
            if (lsc == 0) {
                return 0;
            }
            if (lsc == l.length()) continue;
            c = Math.min(c, lsc);
        }
        if (c == Integer.MAX_VALUE) {
            return 0;
        }
        return c;
    }

    private static String removeLeadingSpaceCount(String s, int spacecount) {
        if (spacecount > s.length()) {
            return "";
        }
        return s.substring(spacecount);
    }

    private void appendHelpBlockParagraphed(StringBuilder sb, Iterable<String> leftcol, Iterable<String> rightcol) {
        for (String l : leftcol) {
            sb.append(HELP_BLOCK_INDENT);
            sb.append(l);
            sb.append('\n');
        }
        Iterator<String> rit = rightcol.iterator();
        if (!rit.hasNext()) {
            sb.append('\n');
        } else {
            while (rit.hasNext()) {
                String l;
                l = rit.next();
                sb.append("        ");
                sb.append(l);
                sb.append('\n');
            }
        }
        sb.append(this.parameterSeparatorLines);
    }

    private void appendHelpBlockSideBySide(StringBuilder sb, Iterable<String> leftcol, Iterable<String> rightcol, int leftcolwidth) {
        int rightspacecount = CommandLineProcessor.getAllLeadingSpaceCount(rightcol);
        Iterator<String> lit = leftcol.iterator();
        Iterator<String> rit = rightcol.iterator();
        while (lit.hasNext()) {
            String l = lit.next();
            sb.append(HELP_BLOCK_INDENT);
            sb.append(l);
            if (!rit.hasNext()) {
                sb.append('\n');
                continue;
            }
            String r = CommandLineProcessor.removeLeadingSpaceCount(rit.next(), rightspacecount);
            if (!r.isEmpty()) {
                CommandLineProcessor.appendSpaces(sb, leftcolwidth - l.length());
                sb.append(r);
            }
            sb.append('\n');
        }
        while (rit.hasNext()) {
            String r = CommandLineProcessor.removeLeadingSpaceCount(rit.next(), rightspacecount);
            if (!r.isEmpty()) {
                sb.append(HELP_BLOCK_INDENT);
                CommandLineProcessor.appendSpaces(sb, leftcolwidth);
                sb.append(r);
            }
            sb.append('\n');
        }
        sb.append(this.parameterSeparatorLines);
    }

    private static void appendLinesBlock(StringBuilder sb, Iterable<String> lines) {
        int spacecount = CommandLineProcessor.getAllLeadingSpaceCount(lines);
        for (String l : lines) {
            l = CommandLineProcessor.removeLeadingSpaceCount(l, spacecount);
            sb.append(HELP_BLOCK_INDENT);
            sb.append(l);
            sb.append('\n');
        }
    }

    private static String emptyIfNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private static String getFirstSentence(String comment) {
        int len = comment.length();
        for (int i = 0; i < len; ++i) {
            char c = comment.charAt(i);
            if (c != '.') continue;
            if (i + 1 >= len) {
                return comment;
            }
            char nc = comment.charAt(i + 1);
            if (!Character.isWhitespace(nc)) continue;
            return comment.substring(0, i + 1);
        }
        return comment;
    }

    private static List<String> splitToLines(String s) {
        String spl;
        String spl2;
        int i;
        String[] split = s.split("\n");
        ArrayList<String> result = new ArrayList<String>();
        for (i = 0; i < split.length && ((spl2 = split[i]).isEmpty() || CommandLineProcessor.getLeadingSpaceCount(spl2) == spl2.length()); ++i) {
        }
        while (i < split.length) {
            spl2 = split[i];
            result.add(spl2);
            ++i;
        }
        int size = result.size();
        for (int j = size - 1; j >= 0 && ((spl = result.get(j)).isEmpty() || CommandLineProcessor.getLeadingSpaceCount(spl) == spl.length()); --j) {
            result.remove(j);
        }
        return result;
    }

    public static String getDocCommentTag(String doccomment, String tagname) {
        if (doccomment == null) {
            return null;
        }
        int len = doccomment.length();
        for (int i = 0; i < len; ++i) {
            if (doccomment.charAt(i) != '@' || !doccomment.startsWith(tagname, i + 1)) continue;
            int nextat = doccomment.indexOf(64, i + 1);
            if (nextat < 0) {
                nextat = len;
            }
            return doccomment.substring(i + 1 + tagname.length(), nextat);
        }
        return null;
    }

    public static Iterator<String> getDocCommentTagIterator(final String doccomment, String tagname) {
        final String attag = "@" + tagname;
        return new Iterator<String>(){
            private String next;
            private int nextSearchIndex = 0;
            {
                this.moveToNext();
            }

            private void moveToNext() {
                int idx = doccomment.indexOf(attag, this.nextSearchIndex);
                if (idx < 0) {
                    this.next = null;
                    return;
                }
                int nextatidx = doccomment.indexOf(64, idx + 1);
                if (nextatidx < 0) {
                    this.next = doccomment.substring(idx + attag.length());
                    this.nextSearchIndex = doccomment.length();
                } else {
                    this.next = doccomment.substring(idx + attag.length(), nextatidx);
                    this.nextSearchIndex = nextatidx;
                }
            }

            @Override
            public String next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                String res = this.next;
                this.moveToNext();
                return res;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }
        };
    }

    public static String removeDocCommentTags(String doccomment) {
        int idx = doccomment.indexOf(64);
        String result = idx < 0 ? doccomment : doccomment.substring(0, idx);
        result = result.replace(INDENTATION, HELP_BLOCK_INDENT).replace("<pre>", "").replace("</pre>", "");
        return result;
    }

    public static boolean isSingleLine(String cs) {
        return cs.indexOf(10) < 0;
    }

    private void generatePrintHelpMethodImpl(PrintStream ps, List<ModelCommand> cmdlist, Set<Element> dependentelements) {
        ModelSubCommand sc;
        ModelCommand lastcmd = cmdlist.get(cmdlist.size() - 1);
        ps.println("public static String getHelpString(");
        int i = 1;
        Iterator<ModelCommand> it = cmdlist.iterator();
        while (it.hasNext()) {
            ModelCommand cmd = it.next();
            dependentelements.add(cmd.getTypeElement());
            ps.print("\t\t");
            ps.print(cmd.getTypeElement().getQualifiedName());
            ps.print(" cmd");
            ps.print(i);
            if (it.hasNext()) {
                ps.println(", ");
            }
            ++i;
        }
        ps.println(") {");
        Collection<ModelSubCommand> subcommands = lastcmd.getSubCommands();
        List<ModelParameter> parameters = lastcmd.getParameters();
        List<ModelParameter> posparams = lastcmd.getPositionalParameters();
        String doccomment = CommandLineProcessor.emptyIfNull(lastcmd.getDocComment());
        StringBuilder helpsb = new StringBuilder();
        helpsb.append("Usage:\n");
        helpsb.append(HELP_BLOCK_INDENT);
        boolean hadarg = false;
        Iterator<ModelCommand> cmdlistit = cmdlist.iterator();
        cmdlistit.next();
        while (cmdlistit.hasNext()) {
            ModelCommand c = cmdlistit.next();
            if (!(c instanceof ModelSubCommand)) continue;
            sc = (ModelSubCommand)c;
            if (hadarg) {
                helpsb.append(' ');
            }
            hadarg = true;
            helpsb.append(sc.getNames().iterator().next());
        }
        if (!parameters.isEmpty()) {
            for (ModelParameter p : posparams) {
                if (p.getPositional().value() < 0) continue;
                if (hadarg) {
                    helpsb.append(' ');
                }
                hadarg = true;
                helpsb.append(p.getNames().iterator().next());
                if (p.isRequired()) continue;
                helpsb.append('?');
            }
            for (ModelParameter p : parameters) {
                if (p.getPositional() != null) continue;
                if (hadarg) {
                    helpsb.append(' ');
                }
                hadarg = true;
                helpsb.append("[parameters]");
                break;
            }
            for (ModelParameter p : posparams) {
                if (p.getPositional().value() >= 0) continue;
                if (hadarg) {
                    helpsb.append(' ');
                }
                hadarg = true;
                helpsb.append(p.getNames().iterator().next());
                if (p.isRequired()) continue;
                helpsb.append('?');
            }
        }
        if (!subcommands.isEmpty()) {
            if (hadarg) {
                helpsb.append(' ');
            }
            hadarg = true;
            TypeElement cmdtypeelem = lastcmd.getTypeElement();
            dependentelements.add(cmdtypeelem);
            if (this.getMethodsWithName(cmdtypeelem, "call").isEmpty()) {
                helpsb.append("[subcommand] ...");
            } else {
                helpsb.append("[subcommand?] ...");
            }
        }
        helpsb.append('\n');
        helpsb.append('\n');
        if (!doccomment.isEmpty()) {
            helpsb.append("Description:\n");
            CommandLineProcessor.appendLinesBlock(helpsb, CommandLineProcessor.splitToLines(CommandLineProcessor.removeDocCommentTags(doccomment)));
        }
        if (!subcommands.isEmpty()) {
            Set<String> helpcommandname;
            Object basecmd;
            ModelSubCommand defaultsubcommand = lastcmd.getDefaultSubCommand();
            helpsb.append("\nSubcommands:\n");
            int nameswidth = CommandLineProcessor.getMaxSubCommandNameWidth(subcommands);
            if (cmdlist.size() == 1) {
                basecmd = (ModelBaseCommand)lastcmd;
                nameswidth = Math.max(CommandLineProcessor.getMaxStringWidth(((ModelBaseCommand)basecmd).getHelpCommandName()), nameswidth);
            }
            basecmd = subcommands.iterator();
            while (basecmd.hasNext()) {
                sc = (ModelSubCommand)basecmd.next();
                dependentelements.add(sc.getTypeElement());
                String subdoccomment = CommandLineProcessor.emptyIfNull(sc.getDocComment());
                ArrayList<String> names = new ArrayList<String>(sc.getNames());
                if (sc.isDeprecated()) {
                    names.add("  [deprecated]");
                }
                if (sc == defaultsubcommand) {
                    names.add("  [default]");
                }
                this.appendHelpBlockSideBySide(helpsb, names, CommandLineProcessor.splitToLines(CommandLineProcessor.getFirstSentence(CommandLineProcessor.removeDocCommentTags(subdoccomment))), nameswidth + 4);
            }
            if (cmdlist.size() == 1 && !(helpcommandname = ((ModelBaseCommand)(basecmd = (ModelBaseCommand)lastcmd)).getHelpCommandName()).isEmpty()) {
                helpcommandname = new LinkedHashSet<String>(helpcommandname);
                this.removeSubCommandNamesFromCollection(helpcommandname, ((AbstractModelCommand)basecmd).getSubCommands());
                if (!helpcommandname.isEmpty()) {
                    this.appendHelpBlockSideBySide(helpsb, helpcommandname, CommandLineProcessor.splitToLines("Prints help for the specified commands."), nameswidth + 4);
                }
            }
        }
        if (!parameters.isEmpty()) {
            ArrayList<String> names;
            String paramdoccomment;
            helpsb.append("\nParameters:\n");
            int nameswidth = CommandLineProcessor.getMaxParameterNameWidth(parameters);
            for (ModelParameter p : posparams) {
                if (p.getPositional().value() < 0) continue;
                dependentelements.add(p.getElement());
                paramdoccomment = CommandLineProcessor.emptyIfNull(p.getDocComment());
                names = new ArrayList<String>(p.getNames());
                names.add("  [positional]");
                if (p.isRequired()) {
                    names.add("  [required]");
                }
                this.appendHelpBlockSideBySide(helpsb, names, CommandLineProcessor.splitToLines(CommandLineProcessor.removeDocCommentTags(paramdoccomment)), nameswidth + 4);
            }
            for (ModelParameter p : parameters) {
                String formatstr;
                if (p.getPositional() != null) continue;
                dependentelements.add(p.getElement());
                paramdoccomment = CommandLineProcessor.emptyIfNull(p.getDocComment());
                names = new ArrayList<String>(p.getNames());
                if (p.isMapParameter()) {
                    ListIterator<String> it2 = names.listIterator();
                    while (it2.hasNext()) {
                        it2.set((String)it2.next() + KEY_VALUE_HELP_APPENDIX);
                    }
                }
                if ((formatstr = p.getDocCommentFormat()) != null && !formatstr.isEmpty()) {
                    Iterator<Object> it3 = names.listIterator();
                    while (it3.hasNext()) {
                        it3.set((String)it3.next() + " " + formatstr);
                    }
                }
                if (p.isRequired()) {
                    names.add("  [required]");
                }
                if (p.isDeprecated()) {
                    names.add("  [deprecated]");
                }
                if (p.isMultiParameter()) {
                    names.add("  [multi]");
                }
                for (String hmeta : p.getHelpMetaNames()) {
                    names.add(HELP_FLAG_INDENT + hmeta);
                }
                this.appendHelpBlockSideBySide(helpsb, names, CommandLineProcessor.splitToLines(CommandLineProcessor.removeDocCommentTags(paramdoccomment)), nameswidth + 4);
            }
            for (ModelParameter p : posparams) {
                if (p.getPositional().value() >= 0) continue;
                dependentelements.add(p.getElement());
                paramdoccomment = CommandLineProcessor.emptyIfNull(p.getDocComment());
                names = new ArrayList<String>(p.getNames());
                names.add("  [positional]");
                if (p.isRequired()) {
                    names.add("  [required]");
                }
                for (String hmeta : p.getHelpMetaNames()) {
                    names.add(HELP_FLAG_INDENT + hmeta);
                }
                this.appendHelpBlockSideBySide(helpsb, names, CommandLineProcessor.splitToLines(CommandLineProcessor.removeDocCommentTags(paramdoccomment)), nameswidth + 4);
            }
        }
        int helplen = helpsb.length();
        ps.println("return");
        if (helplen == 0) {
            ps.println("\t  \"\"");
        } else {
            int lastlineend = 0;
            for (int i2 = 0; i2 < helplen; ++i2) {
                char c = helpsb.charAt(i2);
                if (c != '\n') continue;
                if (lastlineend == 0) {
                    ps.print("\t  ");
                } else {
                    ps.print("\t+ ");
                }
                String substr = CommandLineProcessor.unescapeDocComment(helpsb.substring(lastlineend, i2 + 1));
                if (this.helpLineErrorLimit > 0 && substr.length() > this.helpLineErrorLimit) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Help line limit exceeded with length: " + substr.length() + " with " + substr);
                }
                ps.println(this.elements.getConstantExpression(substr));
                lastlineend = i2 + 1;
            }
            if (lastlineend < helplen) {
                if (lastlineend == 0) {
                    ps.print("\t  ");
                } else {
                    ps.print("\t+ ");
                }
                String substr = CommandLineProcessor.unescapeDocComment(helpsb.substring(lastlineend));
                if (this.helpLineErrorLimit > 0 && substr.length() > this.helpLineErrorLimit) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Help line limit exceeded with length: " + substr.length() + " with " + substr);
                }
                ps.println(this.elements.getConstantExpression(substr + "\n"));
            }
        }
        ps.println(";");
        ps.println("}");
        ps.println("");
    }

    private void generatePrintHelpMethodNewImpl(PrintStream ps, List<ModelCommand> cmdlist, Set<Element> dependentelements) {
        ModelSubCommand sc;
        ModelCommand lastcmd = cmdlist.get(cmdlist.size() - 1);
        ps.println("public static String getHelpString(");
        int i = 1;
        Iterator<ModelCommand> it = cmdlist.iterator();
        while (it.hasNext()) {
            ModelCommand cmd = it.next();
            dependentelements.add(cmd.getTypeElement());
            ps.print("\t\t");
            ps.print(cmd.getTypeElement().getQualifiedName());
            ps.print(" cmd");
            ps.print(i);
            if (it.hasNext()) {
                ps.println(", ");
            }
            ++i;
        }
        ps.println(") {");
        Collection<ModelSubCommand> subcommands = lastcmd.getSubCommands();
        List<ModelParameter> parameters = lastcmd.getParameters();
        List<ModelParameter> posparams = lastcmd.getPositionalParameters();
        String doccomment = CommandLineProcessor.emptyIfNull(lastcmd.getDocComment());
        StringBuilder helpsb = new StringBuilder();
        helpsb.append("Usage:\n");
        helpsb.append(HELP_BLOCK_INDENT);
        boolean hadarg = false;
        Iterator<ModelCommand> cmdlistit = cmdlist.iterator();
        cmdlistit.next();
        while (cmdlistit.hasNext()) {
            ModelCommand c = cmdlistit.next();
            if (!(c instanceof ModelSubCommand)) continue;
            sc = (ModelSubCommand)c;
            if (hadarg) {
                helpsb.append(' ');
            }
            hadarg = true;
            helpsb.append(sc.getNames().iterator().next());
        }
        if (!parameters.isEmpty()) {
            for (ModelParameter p : posparams) {
                if (p.getPositional().value() < 0) continue;
                if (hadarg) {
                    helpsb.append(' ');
                }
                hadarg = true;
                helpsb.append(p.getNames().iterator().next());
                if (p.isRequired()) continue;
                helpsb.append('?');
            }
            for (ModelParameter p : parameters) {
                if (p.getPositional() != null) continue;
                if (hadarg) {
                    helpsb.append(' ');
                }
                hadarg = true;
                helpsb.append("[parameters]");
                break;
            }
            for (ModelParameter p : posparams) {
                if (p.getPositional().value() >= 0) continue;
                if (hadarg) {
                    helpsb.append(' ');
                }
                hadarg = true;
                helpsb.append(p.getNames().iterator().next());
                if (p.isRequired()) continue;
                helpsb.append('?');
            }
        }
        if (!subcommands.isEmpty()) {
            if (hadarg) {
                helpsb.append(' ');
            }
            hadarg = true;
            TypeElement cmdtypeelem = lastcmd.getTypeElement();
            dependentelements.add(cmdtypeelem);
            if (this.getMethodsWithName(cmdtypeelem, "call").isEmpty()) {
                helpsb.append("[subcommand] ...");
            } else {
                helpsb.append("[subcommand?] ...");
            }
        }
        helpsb.append('\n');
        helpsb.append('\n');
        if (!doccomment.isEmpty()) {
            helpsb.append("Description:\n");
            CommandLineProcessor.appendLinesBlock(helpsb, CommandLineProcessor.splitToLines(CommandLineProcessor.removeDocCommentTags(doccomment)));
        }
        if (!subcommands.isEmpty()) {
            Set<String> helpcommandname;
            Object basecmd;
            ModelSubCommand defaultsubcommand = lastcmd.getDefaultSubCommand();
            helpsb.append("\nSubcommands:\n");
            int nameswidth = CommandLineProcessor.getMaxSubCommandNameWidth(subcommands);
            if (cmdlist.size() == 1) {
                basecmd = (ModelBaseCommand)lastcmd;
                nameswidth = Math.max(CommandLineProcessor.getMaxStringWidth(((ModelBaseCommand)basecmd).getHelpCommandName()), nameswidth);
            }
            basecmd = subcommands.iterator();
            while (basecmd.hasNext()) {
                sc = (ModelSubCommand)basecmd.next();
                dependentelements.add(sc.getTypeElement());
                String subdoccomment = CommandLineProcessor.emptyIfNull(sc.getDocComment());
                ArrayList<String> names = new ArrayList<String>(sc.getNames());
                if (sc.isDeprecated()) {
                    names.add("  [deprecated]");
                }
                if (sc == defaultsubcommand) {
                    names.add("  [default]");
                }
                this.appendHelpBlockParagraphed(helpsb, names, CommandLineProcessor.splitToLines(CommandLineProcessor.getFirstSentence(CommandLineProcessor.removeDocCommentTags(subdoccomment))));
            }
            if (cmdlist.size() == 1 && !(helpcommandname = ((ModelBaseCommand)(basecmd = (ModelBaseCommand)lastcmd)).getHelpCommandName()).isEmpty()) {
                helpcommandname = new LinkedHashSet<String>(helpcommandname);
                this.removeSubCommandNamesFromCollection(helpcommandname, ((AbstractModelCommand)basecmd).getSubCommands());
                if (!helpcommandname.isEmpty()) {
                    this.appendHelpBlockParagraphed(helpsb, helpcommandname, CommandLineProcessor.splitToLines("Prints help for the specified commands."));
                }
            }
        }
        if (!parameters.isEmpty()) {
            ArrayList<String> names;
            String paramdoccomment;
            helpsb.append("\nParameters:\n");
            for (ModelParameter p : posparams) {
                if (p.getPositional().value() < 0) continue;
                dependentelements.add(p.getElement());
                paramdoccomment = CommandLineProcessor.emptyIfNull(p.getDocComment());
                names = new ArrayList<String>(p.getNames());
                names.add("  [positional]");
                if (p.isRequired()) {
                    names.add("  [required]");
                }
                this.appendHelpBlockParagraphed(helpsb, names, CommandLineProcessor.splitToLines(CommandLineProcessor.removeDocCommentTags(paramdoccomment)));
            }
            for (ModelParameter p : parameters) {
                Object formatstr;
                if (p.getPositional() != null) continue;
                dependentelements.add(p.getElement());
                paramdoccomment = CommandLineProcessor.emptyIfNull(p.getDocComment());
                names = new ArrayList<String>(p.getNames());
                if (p.isMapParameter()) {
                    ListIterator<String> it2 = names.listIterator();
                    while (it2.hasNext()) {
                        it2.set((String)it2.next() + KEY_VALUE_HELP_APPENDIX);
                    }
                }
                if ((formatstr = p.getDocCommentFormat()) != null && !((String)formatstr).isEmpty()) {
                    Iterator<Object> it3 = names.listIterator();
                    while (it3.hasNext()) {
                        it3.set((String)it3.next() + " " + (String)formatstr);
                    }
                }
                if (p.isRequired()) {
                    names.add("  [required]");
                }
                if (p.isDeprecated()) {
                    names.add("  [deprecated]");
                }
                if (p.isMultiParameter()) {
                    names.add("  [multi]");
                }
                for (String hmeta : p.getHelpMetaNames()) {
                    names.add(HELP_FLAG_INDENT + hmeta);
                }
                this.appendHelpBlockParagraphed(helpsb, names, CommandLineProcessor.splitToLines(CommandLineProcessor.removeDocCommentTags(paramdoccomment)));
            }
            for (ModelParameter p : posparams) {
                if (p.getPositional().value() >= 0) continue;
                dependentelements.add(p.getElement());
                paramdoccomment = CommandLineProcessor.emptyIfNull(p.getDocComment());
                names = new ArrayList<String>(p.getNames());
                names.add("  [positional]");
                if (p.isRequired()) {
                    names.add("  [required]");
                }
                for (String hmeta : p.getHelpMetaNames()) {
                    names.add(HELP_FLAG_INDENT + hmeta);
                }
                this.appendHelpBlockParagraphed(helpsb, names, CommandLineProcessor.splitToLines(CommandLineProcessor.removeDocCommentTags(paramdoccomment)));
            }
        }
        int helplen = helpsb.length();
        ps.println("return");
        if (helplen == 0) {
            ps.println("\t  \"\"");
        } else {
            int lastlineend = 0;
            for (int i2 = 0; i2 < helplen; ++i2) {
                char c = helpsb.charAt(i2);
                if (c != '\n') continue;
                if (lastlineend == 0) {
                    ps.print("\t  ");
                } else {
                    ps.print("\t+ ");
                }
                String substr = CommandLineProcessor.unescapeDocComment(helpsb.substring(lastlineend, i2 + 1));
                if (this.helpLineErrorLimit > 0 && substr.length() > this.helpLineErrorLimit) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Help line limit exceeded with length: " + substr.length() + " with " + substr);
                }
                ps.println(this.elements.getConstantExpression(substr));
                lastlineend = i2 + 1;
            }
            if (lastlineend < helplen) {
                if (lastlineend == 0) {
                    ps.print("\t  ");
                } else {
                    ps.print("\t+ ");
                }
                String substr = CommandLineProcessor.unescapeDocComment(helpsb.substring(lastlineend));
                if (this.helpLineErrorLimit > 0 && substr.length() > this.helpLineErrorLimit) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Help line limit exceeded with length: " + substr.length() + " with " + substr);
                }
                ps.println(this.elements.getConstantExpression(substr + "\n"));
            }
        }
        ps.println(";");
        ps.println("}");
        ps.println("");
    }

    public static String unescapeDocComment(String s) {
        return s.replace("&nbsp;", " ").replace("&gt;", ">").replace("&lt;", "<").replace("&#064;", "@");
    }

    private void generatePrintHelpMethod(PrintStream ps, ModelCommand cmd, Set<Element> dependentelements) {
        LinkedList<ModelCommand> commandsstack = new LinkedList<ModelCommand>();
        commandsstack.addLast(cmd);
        this.generatePrintHelpMethod(ps, cmd, commandsstack, dependentelements);
    }

    private void generatePrintHelpMethod(PrintStream ps, ModelCommand cmd, LinkedList<ModelCommand> commandstack, Set<Element> dependentelements) {
        this.generatePrintHelpMethodNewImpl(ps, commandstack, dependentelements);
        for (ModelSubCommand sub : cmd.getSubCommands()) {
            commandstack.addLast(sub);
            this.generatePrintHelpMethod(ps, sub, commandstack, dependentelements);
            commandstack.removeLast();
        }
    }

    private void generateParserMethod(PrintStream ps, ModelBaseCommand cmd, Collection<TypeElement> throwntypes, Set<Element> dependentelements) {
        LinkedList<ModelCommand> commandsstack = new LinkedList<ModelCommand>();
        commandsstack.addLast(cmd);
        this.generateParserMethod(ps, cmd, commandsstack, throwntypes, dependentelements);
    }

    private void writeParameterParsing(PrintStream ps, ModelParameter parameter, String thisvarname, ModelCommand cmd, Set<Element> dependentelements) {
        Consumer<String> callwriter;
        TypeMirror targettype;
        dependentelements.add(parameter.getElement());
        ModelConverter converter = parameter.getConverter();
        ModelMultiParameter multiparameter = parameter.getMultiParameter();
        if (multiparameter == null) {
            targettype = parameter.getParameterType();
            callwriter = call -> {
                ps.print(thisvarname);
                parameter.getLocation().printAccess(ps);
                ElementKind parameterelementkind = parameter.getElement().getKind();
                switch (parameterelementkind) {
                    case FIELD: {
                        ps.print(" = ");
                        ps.print((String)call);
                        ps.println(";");
                        break;
                    }
                    case METHOD: {
                        ps.print("(");
                        ps.print((String)call);
                        ps.println(");");
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown parameter element type: " + (Object)((Object)parameterelementkind)));
                    }
                }
            };
        } else {
            targettype = multiparameter.getElementType();
            callwriter = call -> {
                ps.print(thisvarname);
                parameter.getLocation().printAccess(ps);
                ps.print(".");
                ps.print(multiparameter.getMethodName());
                ps.print("(");
                ps.print((String)call);
                ps.println(");");
            };
        }
        if (converter != null) {
            dependentelements.add(converter.getMethodDeclaringType());
            callwriter.accept(CommandLineProcessor.getConverterParameterParseCall(converter));
            return;
        }
        String commonconvertercall = this.getParameterParsingCallWithCommonConverters(ps, cmd, targettype, dependentelements);
        if (commonconvertercall != null) {
            callwriter.accept(commonconvertercall);
            return;
        }
        TypeKind typekind = targettype.getKind();
        switch (typekind) {
            case BYTE: {
                callwriter.accept(CommandLineProcessor.getByteParseCall());
                break;
            }
            case SHORT: {
                callwriter.accept(CommandLineProcessor.getShortParseCall());
                break;
            }
            case INT: {
                callwriter.accept(CommandLineProcessor.getIntParseCall());
                break;
            }
            case LONG: {
                callwriter.accept(CommandLineProcessor.getLongParseCall());
                break;
            }
            case CHAR: {
                callwriter.accept(CommandLineProcessor.getCharacterParseCall());
                break;
            }
            case BOOLEAN: {
                callwriter.accept(CommandLineProcessor.getBooleanParseCall(parameter.getFlag()));
                break;
            }
            case FLOAT: {
                callwriter.accept(CommandLineProcessor.getFloatParseCall());
                break;
            }
            case DOUBLE: {
                callwriter.accept(CommandLineProcessor.getDoubleParseCall());
                break;
            }
            case DECLARED: {
                DeclaredType dt = (DeclaredType)targettype;
                TypeElement elem = (TypeElement)dt.asElement();
                if (elem == null) {
                    throw new IllegalArgumentException("Failed to write parser for: " + parameter.getElement());
                }
                dependentelements.add(elem);
                if (this.javaLangBoolean.equals(elem)) {
                    callwriter.accept(CommandLineProcessor.getBooleanParseCall(parameter.getFlag()));
                    break;
                }
                if (this.javaLangByte.equals(elem)) {
                    callwriter.accept(CommandLineProcessor.getByteParseCall());
                    break;
                }
                if (this.javaLangShort.equals(elem)) {
                    callwriter.accept(CommandLineProcessor.getShortParseCall());
                    break;
                }
                if (this.javaLangInteger.equals(elem)) {
                    callwriter.accept(CommandLineProcessor.getIntParseCall());
                    break;
                }
                if (this.javaLangLong.equals(elem)) {
                    callwriter.accept(CommandLineProcessor.getLongParseCall());
                    break;
                }
                if (this.javaLangFloat.equals(elem)) {
                    callwriter.accept(CommandLineProcessor.getFloatParseCall());
                    break;
                }
                if (this.javaLangDouble.equals(elem)) {
                    callwriter.accept(CommandLineProcessor.getDoubleParseCall());
                    break;
                }
                if (this.javaLangCharacter.equals(elem)) {
                    callwriter.accept(CommandLineProcessor.getCharacterParseCall());
                    break;
                }
                if (this.javaLangString.equals(elem)) {
                    callwriter.accept(CommandLineProcessor.getStringParseCall());
                    break;
                }
                if (elem.getKind() == ElementKind.ENUM) {
                    callwriter.accept(this.getEnumParseCall(elem));
                    break;
                }
                throw new IllegalArgumentException("Failed to write parser for: " + parameter.getNames() + " : " + parameter.getElement());
            }
            default: {
                throw new IllegalArgumentException("Failed to write parser for: " + parameter.getNames() + " : " + parameter.getElement());
            }
        }
    }

    public ModelCommonConverter getCommonConverterForType(ModelCommand cmd, TypeMirror targettype) {
        if (targettype == null) {
            return null;
        }
        for (ModelCommonConverter cc : cmd.getCommonConverters()) {
            if (!this.types.isSameType(cc.getTargetType(), targettype)) continue;
            return cc;
        }
        ModelCommand parent = cmd.getParentCommand();
        if (parent != null) {
            return this.getCommonConverterForType(parent, targettype);
        }
        return null;
    }

    public String getParameterParsingCallWithCommonConverters(PrintStream ps, ModelCommand cmd, TypeMirror targettype, Set<Element> dependentelements) {
        ModelCommonConverter cc = this.getCommonConverterForType(cmd, targettype);
        if (cc != null) {
            dependentelements.add(cc.getMethodDeclaringType());
            return cc.getMethodDeclaringType().getQualifiedName() + "." + cc.getMethodName() + "(args)";
        }
        return null;
    }

    private static String getConverterParameterParseCall(ModelConverter converter) {
        return converter.getMethodDeclaringType().getQualifiedName() + "." + converter.getMethodName() + "(args)";
    }

    private void removeSubCommandNamesFromCollection(Collection<String> coll, Iterable<? extends ModelSubCommand> subcommands) {
        for (ModelSubCommand modelSubCommand : subcommands) {
            coll.removeAll(modelSubCommand.getNames());
        }
    }

    private void writeFindHelpStringCode(PrintStream ps, ModelCommand currentcmd, LinkedList<ModelCommand> commandstack) {
        Collection<ModelSubCommand> subcommands = currentcmd.getSubCommands();
        if (subcommands.isEmpty()) {
            CommandLineProcessor.writeReturnGetHelpString(ps, commandstack);
            return;
        }
        ps.println("if (!args.hasNext()) {");
        CommandLineProcessor.writeReturnGetHelpString(ps, commandstack);
        ps.println("}");
        ps.println("a = args.next();");
        for (ModelSubCommand sc : subcommands) {
            Set<String> names = sc.getNames();
            ps.print("if (");
            Iterator<String> it = names.iterator();
            while (it.hasNext()) {
                String hcn = it.next();
                ps.print(this.elements.getConstantExpression(hcn));
                ps.print(".equals(a)");
                if (!it.hasNext()) continue;
                ps.print(" || ");
            }
            ps.println(") {");
            commandstack.addLast(sc);
            this.writeFindHelpStringCode(ps, sc, commandstack);
            commandstack.removeLast();
            ps.println("}");
        }
        ps.print("return \"No subcommand found with name: \" + a + \"\\n\\n\" + ");
        CommandLineProcessor.writeGetHelpStringCall(ps, commandstack);
        ps.println(";");
    }

    private static void writeReturnGetHelpString(PrintStream ps, LinkedList<ModelCommand> commandstack) {
        ps.print("return ");
        CommandLineProcessor.writeGetHelpStringCall(ps, commandstack);
        ps.println(";");
    }

    private static void writeGetHelpStringCall(PrintStream ps, LinkedList<ModelCommand> commandstack) {
        ps.println("getHelpString(");
        Iterator it = commandstack.iterator();
        while (it.hasNext()) {
            ModelCommand argcmd = (ModelCommand)it.next();
            ps.print("\t(");
            ps.print(argcmd.getCommandClassQualifiedName());
            ps.print(") null");
            if (!it.hasNext()) continue;
            ps.println(", ");
        }
        ps.println();
        ps.print(")");
    }

    private void generateParserMethod(PrintStream ps, ModelCommand cmd, LinkedList<ModelCommand> commandstack, Collection<TypeElement> throwntypes, Set<Element> dependentelements) {
        Set<String> names;
        Set<String> helpcommandname;
        ModelBaseCommand first = (ModelBaseCommand)commandstack.getFirst();
        if (this.generateHelpInfo && commandstack.size() == 1) {
            ps.println("private static String findHelpString(java.util.Iterator<String> args) {");
            ps.println("String a;");
            this.writeFindHelpStringCode(ps, first, new LinkedList<ModelCommand>(commandstack));
            ps.println("}");
            ps.println("");
        }
        ps.println("private static void parse(" + ParsingIterator.class.getCanonicalName() + " args, ");
        String thisvarname = null;
        String currentvarname = "result";
        Iterator it = commandstack.iterator();
        while (it.hasNext()) {
            ModelCommand argcmd = (ModelCommand)it.next();
            dependentelements.add(argcmd.getTypeElement());
            if (argcmd == cmd) {
                thisvarname = currentvarname;
            }
            ps.print("\t\t");
            ps.print(argcmd.getCommandClassQualifiedName());
            ps.print(" ");
            ps.print(currentvarname);
            if (it.hasNext()) {
                ps.println(", ");
            }
            currentvarname = "sub" + currentvarname;
        }
        if (thisvarname == null) {
            throw new AssertionError((Object)"Failed to determine command var name.");
        }
        String fthisvarname = thisvarname;
        ps.println(") {");
        ps.println("String a;");
        Collection<ModelSubCommand> cmdsubcommands = cmd.getSubCommands();
        if (this.generateHelpInfo && commandstack.size() == 1 && !(helpcommandname = first.getHelpCommandName()).isEmpty()) {
            helpcommandname = new LinkedHashSet<String>(helpcommandname);
            this.removeSubCommandNamesFromCollection(helpcommandname, cmdsubcommands);
            if (!helpcommandname.isEmpty()) {
                ps.println("if (args.hasNext()) {");
                ps.println("a = args.peek();");
                ps.print("if (");
                Iterator<String> it2 = helpcommandname.iterator();
                while (it2.hasNext()) {
                    String hcn = it2.next();
                    ps.print(this.elements.getConstantExpression(hcn));
                    ps.print(".equals(a)");
                    if (!it2.hasNext()) continue;
                    ps.print(" || ");
                }
                ps.println(") {");
                ps.println("args.next();");
                ps.println("String helpstr = findHelpString(args);");
                ps.print("result.subCommandCaller = ");
                this.printRunnableLambda(ps, () -> ps.println("System.out.println(helpstr);"));
                ps.println(";");
                ps.println("return;");
                ps.println("}");
                ps.println("}");
            }
        }
        List<ModelParameter> reqparams = cmd.getRequiredParameters();
        int reqcount = reqparams.size();
        if (!reqparams.isEmpty()) {
            for (int i = 0; i < reqcount; i += 64) {
                ps.println("long requires" + i / 64 + " = 0;");
            }
        }
        ModelSubCommand defaultcommand = cmd.getDefaultSubCommand();
        ps.println("parse_block:");
        ps.println("{");
        List<ModelParameter> cmdparameters = cmd.getParameters();
        List<ModelParameter> posparams = cmd.getPositionalParameters();
        NavigableMap<String, ModelParameter> cmdmapparameters = cmd.getMapParameters();
        int positionalindex = 0;
        if (!posparams.isEmpty() && posparams.get(0).getPositional().value() >= 0) {
            ModelParameter modelParameter;
            ps.println("positional_block:");
            ps.println("{");
            Iterator<Object> iterator = posparams.iterator();
            while (iterator.hasNext() && (modelParameter = (ModelParameter)iterator.next()).getPositional().value() >= 0) {
                ps.println("if (!args.hasNext()) { ");
                ps.println("break positional_block;");
                ps.println("}");
                ps.print("a = ");
                ps.print(this.elements.getConstantExpression(modelParameter.getNames().iterator().next()));
                ps.println(";");
                this.printRequiredAssign(ps, reqparams, modelParameter);
                this.writeParameterParsing(ps, modelParameter, thisvarname, cmd, dependentelements);
                ++positionalindex;
            }
            ps.println("}");
        }
        ps.println("param_loop:");
        ps.println("while (args.hasNext()) {");
        ps.println("a = args.peek();");
        for (Map.Entry entry : cmdmapparameters.entrySet()) {
            ModelParameter param = (ModelParameter)entry.getValue();
            String prefix = (String)entry.getKey();
            ps.print("if (");
            ps.println("a.startsWith(" + this.elements.getConstantExpression(prefix) + ")) {");
            this.printRequiredAssign(ps, reqparams, param);
            ps.println("String[] mapkeyvalue = { null, null };");
            ps.println("ParseUtil.parseEqualsFormatArgument(" + prefix.length() + ", a, mapkeyvalue);");
            ps.print(thisvarname);
            param.getLocation().printAccess(ps);
            ElementKind parameterelementkind = param.getElement().getKind();
            switch (parameterelementkind) {
                case FIELD: {
                    ps.println(".put(mapkeyvalue[0], mapkeyvalue[1]);");
                    break;
                }
                case METHOD: {
                    ps.println("(mapkeyvalue[0], mapkeyvalue[1]);");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown parameter element type: " + parameterelementkind));
                }
            }
            ps.println("args.next();");
            ps.println("continue param_loop;");
            ps.println("}");
        }
        ps.println("switch (a) {");
        for (ModelParameter modelParameter : cmdparameters) {
            if (modelParameter.isMapParameter() || modelParameter.getPositional() != null) continue;
            names = modelParameter.getNames();
            this.writeCaseLabels(ps, names);
            ps.println(" {");
            ps.println("args.next();");
            this.printRequiredAssign(ps, reqparams, modelParameter);
            this.writeParameterParsing(ps, modelParameter, thisvarname, cmd, dependentelements);
            ps.println("break;");
            ps.println("}");
        }
        for (ModelSubCommand modelSubCommand : cmdsubcommands) {
            dependentelements.add(modelSubCommand.getTypeElement());
            if (modelSubCommand == defaultcommand) continue;
            names = modelSubCommand.getNames();
            this.writeCaseLabels(ps, names);
            ps.println(" {");
            ps.println("args.next();");
            ps.print("parse(args");
            String currentvarname2 = "result";
            for (ModelCommand c : commandstack) {
                ps.print(", ");
                ps.print(currentvarname2);
                currentvarname2 = "sub" + currentvarname2;
            }
            ps.print(", new " + modelSubCommand.getCommandClassQualifiedName() + "()");
            ps.println(");");
            ps.println("break parse_block;");
            ps.println("}");
        }
        if (defaultcommand != null) {
            this.writeCaseLabels(ps, defaultcommand.getNames());
            ps.println();
            ps.println("\targs.next();");
            ps.println("\t//fall-through");
        }
        ps.println("default: {");
        if (defaultcommand != null) {
            ps.println("break param_loop;");
        } else if (positionalindex < posparams.size()) {
            ps.println("break param_loop;");
        } else {
            ps.println("throw new IllegalArgumentException(\"Unrecognized argument: \" + a);");
        }
        ps.println("}");
        ps.println("}");
        ps.println("}");
        if (defaultcommand != null) {
            ps.print("parse(args");
            String currentvarname3 = "result";
            for (ModelCommand c : commandstack) {
                ps.print(", ");
                ps.print(currentvarname3);
                currentvarname3 = "sub" + currentvarname3;
            }
            ps.print(", new " + defaultcommand.getCommandClassQualifiedName() + "()");
            ps.println(");");
        } else {
            List<ModelCommand> querycommands;
            TypeElement cmdtypeelem;
            List<ExecutableElement> list;
            ModelMethodCall callmethodcall;
            if (positionalindex < posparams.size()) {
                ps.println("end_positional_block:");
                ps.println("{");
                int n = posparams.size();
                while (positionalindex < n) {
                    ModelParameter modelParameter = posparams.get(positionalindex);
                    ps.println("if (!args.hasNext()) { ");
                    ps.println("break end_positional_block;");
                    ps.println("}");
                    ps.print("a = ");
                    ps.print(this.elements.getConstantExpression(modelParameter.getNames().iterator().next()));
                    ps.println(";");
                    this.printRequiredAssign(ps, reqparams, modelParameter);
                    this.writeParameterParsing(ps, modelParameter, thisvarname, cmd, dependentelements);
                    ++positionalindex;
                }
                ps.println("}");
                ps.println("if (args.hasNext()) {");
                ps.println("throw new IllegalArgumentException(\"Unrecognized argument: \" + args.peek());");
                ps.println("}");
            }
            if ((callmethodcall = this.getBestMethodMatch(list = this.getMethodsWithName(cmdtypeelem = cmd.getTypeElement(), "call"), querycommands = commandstack.subList(0, commandstack.size() - 1))) == null) {
                ps.print("result.subCommandCaller = ");
                this.printRunnableLambda(ps, () -> ps.println("throw new UnsupportedOperationException(\"no call method in " + cmdtypeelem.getQualifiedName() + "\");"));
                ps.println(";");
            } else {
                ps.print("result.subCommandCaller = ");
                this.printRunnableLambda(ps, () -> {
                    String initvarname = "result";
                    for (int initi = 0; initi < commandstack.size(); ++initi) {
                        List<ModelCommand> initquerycommands = commandstack.subList(0, initi);
                        ModelMethodCall call = this.getBestMethodMatch(this.getMethodsWithName(((ModelCommand)commandstack.get(initi)).getTypeElement(), "init"), initquerycommands);
                        if (call != null) {
                            dependentelements.add(call.executable);
                            CommandLineProcessor.printMethodCallWithCommandResultArguments(ps, initvarname, call);
                            CommandLineProcessor.addThrownTypes(call.executable, throwntypes);
                        }
                        initvarname = "sub" + initvarname;
                    }
                    dependentelements.add(callmethodcall.executable);
                    CommandLineProcessor.printMethodCallWithCommandResultArguments(ps, fthisvarname, callmethodcall);
                    CommandLineProcessor.addThrownTypes(callmethodcall.executable, throwntypes);
                    int closei = commandstack.size();
                    String closevarname = fthisvarname;
                    while (closei-- > 0) {
                        List<ModelCommand> closequerycommands = commandstack.subList(0, closei);
                        ModelMethodCall call = this.getBestMethodMatch(this.getMethodsWithName(((ModelCommand)commandstack.get(closei)).getTypeElement(), "close"), closequerycommands);
                        if (call != null) {
                            dependentelements.add(call.executable);
                            CommandLineProcessor.printMethodCallWithCommandResultArguments(ps, closevarname, call);
                            CommandLineProcessor.addThrownTypes(call.executable, throwntypes);
                        }
                        closevarname = closevarname.substring(3);
                    }
                });
                ps.println(";");
            }
        }
        ps.println("}");
        if (!reqparams.isEmpty()) {
            for (int i = 0; i < reqcount; i += 64) {
                int diff = reqcount - i;
                long l = diff >= 64 ? -1L : (long)((1 << diff) - 1);
                String cfconst = CommandLineProcessor.toHexLongConstantString(l);
                ps.println("if ((requires" + i / 64 + " & " + cfconst + ") != " + cfconst + ") {");
                ps.println("throw new IllegalArgumentException(\"Required parameters missing.\");");
                ps.println("}");
            }
        }
        ps.println("}");
        ps.println("");
        for (ModelSubCommand sub : cmdsubcommands) {
            commandstack.addLast(sub);
            this.generateParserMethod(ps, sub, commandstack, throwntypes, dependentelements);
            commandstack.removeLast();
        }
    }

    private static void printMethodCallWithCommandResultArguments(PrintStream ps, String thisvarname, ModelMethodCall cmethod) {
        ps.print(thisvarname);
        ps.print(".");
        ps.print(cmethod.executable.getSimpleName());
        ps.print("(");
        Iterator<Integer> it = cmethod.argumentQueryIndices.iterator();
        while (it.hasNext()) {
            Integer argidx = it.next();
            int subc = argidx;
            while (subc-- > 0) {
                ps.print("sub");
            }
            ps.print("result");
            if (!it.hasNext()) continue;
            ps.print(", ");
        }
        ps.println(");");
    }

    private void printRequiredAssign(PrintStream ps, List<ModelParameter> reqparams, ModelParameter param) {
        if (param.isRequired()) {
            int bitidx = reqparams.indexOf(param);
            String cfconst = CommandLineProcessor.toHexLongConstantString(1L << bitidx % 64);
            ps.println("requires" + bitidx / 64 + " |= " + cfconst + ";");
        }
    }

    private static String toHexLongConstantString(long checkflag) {
        String cfconst = "0x" + Long.toUnsignedString(checkflag, 16) + "L";
        return cfconst;
    }

    private void generateForModel(ModelBaseCommand mc, PrintStream ps, Set<Element> dependentelements) {
        String packname = mc.getGeneratedPackageName();
        if (packname != null) {
            ps.println("package " + packname + ";");
            ps.println();
        }
        ps.println("import " + ParseUtil.class.getCanonicalName() + ";");
        ps.println();
        String cname = mc.getGeneratedSimpleClassName();
        ps.println("@SuppressWarnings({ \"fallthrough\" })");
        ps.println("public class " + cname + " extends " + mc.getTypeElement().getQualifiedName() + " {");
        LinkedHashSet<TypeElement> throwntypes = new LinkedHashSet<TypeElement>();
        ps.println("public static " + cname + " parse(java.util.Iterator<? extends String> arguments) {");
        ps.println(ParsingIterator.class.getCanonicalName() + " args = ParseUtil.createCommandFileArgumentIterator(arguments);");
        ps.println(cname + " result = new " + cname + "();");
        ps.println("parse(args, result);");
        ps.println("return result;");
        ps.println("}");
        ps.println("");
        if (this.generateHelpInfo) {
            this.generatePrintHelpMethod(ps, mc, dependentelements);
        }
        this.generateParserMethod(ps, mc, throwntypes, dependentelements);
        if (mc.createMainMethod()) {
            ps.print("public static void main(String... args)");
            CommandLineProcessor.printThrowsTypes(ps, throwntypes);
            ps.println(" {");
            ps.println("parse(java.util.Arrays.asList(args).iterator()).callCommand();");
            ps.println("}");
            ps.println("");
        }
        if (!throwntypes.isEmpty()) {
            if (this.supportsLambda) {
                ps.println("@FunctionalInterface");
            }
            ps.println("private interface Runnable {");
            ps.print("public void run()");
            CommandLineProcessor.printThrowsTypes(ps, throwntypes);
            ps.println(";");
            ps.println("}");
            ps.println("");
        }
        ps.println("private Runnable subCommandCaller;");
        ps.println("");
        ps.println("private " + cname + "() {");
        ps.println("}");
        ps.println("");
        ps.print("public void callCommand()");
        CommandLineProcessor.printThrowsTypes(ps, throwntypes);
        ps.println(" {");
        ps.println("this.subCommandCaller.run();");
        ps.println("}");
        ps.println("}");
    }

    public TypeElement getCommandAnnot() {
        return this.commandAnnot;
    }

    public TypeElement getConverterAnnot() {
        return this.converterAnnot;
    }

    public TypeElement getCommonConverterAnnot() {
        return this.commonConverterAnnot;
    }

    private static void printThrowsTypes(PrintStream ps, Iterable<? extends TypeElement> types) {
        Iterator<? extends TypeElement> it = types.iterator();
        if (!it.hasNext()) {
            return;
        }
        ps.println();
        ps.print(INDENTATION);
        ps.println("throws ");
        while (it.hasNext()) {
            TypeElement tt = it.next();
            ps.print(INDENTATION);
            ps.print(INDENTATION);
            ps.print(tt.getQualifiedName());
            if (!it.hasNext()) continue;
            ps.println(",");
        }
    }

    private static Set<TypeElement> getThrownTypes(Set<ExecutableElement> methods) {
        LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>();
        CommandLineProcessor.addThrownTypes(methods, result);
        return result;
    }

    private static void addThrownTypes(ExecutableElement ee, Collection<TypeElement> result) {
        for (TypeMirror typeMirror : ee.getThrownTypes()) {
            DeclaredType dt;
            Element e;
            if (typeMirror.getKind() != TypeKind.DECLARED || !((e = (dt = (DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
            result.add((TypeElement)e);
        }
    }

    private static void addThrownTypes(Set<ExecutableElement> methods, Collection<TypeElement> result) {
        for (ExecutableElement ee : methods) {
            CommandLineProcessor.addThrownTypes(ee, result);
        }
    }

    public String getImplQualifiedTypeName(TypeElement te) {
        return this.elements.getPackageOf(te).getQualifiedName() + "." + te.getSimpleName() + "Impl";
    }

    public TypeMirror getErasedMapType() {
        if (this.mapType == null) {
            this.mapType = this.types.erasure(this.elements.getTypeElement(Map.class.getCanonicalName()).asType());
        }
        return this.mapType;
    }

    public TypeMirror getErasedCollectionType() {
        if (this.collectionType == null) {
            this.collectionType = this.types.erasure(this.elements.getTypeElement(Collection.class.getCanonicalName()).asType());
        }
        return this.collectionType;
    }

    private String getEnumParseCall(TypeElement enumtype) {
        String call = this.isUpperCaseEnum(enumtype) ? "ParseUtil.parseEnumUpperCaseArgument(" + enumtype.getQualifiedName() + ".class, a, args)" : "ParseUtil.parseEnumArgument(" + enumtype.getQualifiedName() + ".class, a, args)";
        return call;
    }

    private static String getStringParseCall() {
        return "ParseUtil.parseStringArgument(a, args)";
    }

    private static String getFloatParseCall() {
        return "ParseUtil.parseFloatArgument(a, args)";
    }

    private static String getDoubleParseCall() {
        return "ParseUtil.parseDoubleArgument(a, args)";
    }

    private static String getBooleanParseCall(Flag flag) {
        String call = flag != null ? !flag.negate() + "" : "ParseUtil.parseBooleanArgument(a, args)";
        return call;
    }

    private static String getCharacterParseCall() {
        return "ParseUtil.parseCharacterArgument(a, args)";
    }

    private static String getLongParseCall() {
        return "ParseUtil.parseLongArgument(a, args)";
    }

    private static String getIntParseCall() {
        return "ParseUtil.parseIntegerArgument(a, args)";
    }

    private static String getShortParseCall() {
        return "ParseUtil.parseShortArgument(a, args)";
    }

    private static String getByteParseCall() {
        return "ParseUtil.parseByteArgument(a, args)";
    }

    private boolean isUpperCaseEnum(TypeElement te) {
        return this.uppercaseEnums.computeIfAbsent(te, CommandLineProcessor::isUpperCaseEnumImpl);
    }

    private static boolean isUpperCaseEnumImpl(TypeElement te) {
        for (Element element : te.getEnclosedElements()) {
            String name;
            if (element.getKind() != ElementKind.ENUM_CONSTANT || (name = element.getSimpleName().toString()).equals(name.toUpperCase())) continue;
            return false;
        }
        return true;
    }

    private static boolean isDistinctEnum(TypeElement te) {
        TreeSet<String> s = new TreeSet<String>();
        for (Element element : te.getEnclosedElements()) {
            String name;
            if (element.getKind() != ElementKind.ENUM_CONSTANT || s.add(name = element.getSimpleName().toString().toUpperCase())) continue;
            return false;
        }
        return true;
    }

    private void writeCaseLabels(PrintStream ps, Iterable<? extends String> name) {
        Iterator<? extends String> it = name.iterator();
        while (it.hasNext()) {
            String n = it.next();
            ps.print("case ");
            ps.print(this.elements.getConstantExpression(n));
            if (it.hasNext()) {
                ps.println(":");
                continue;
            }
            ps.print(":");
        }
    }

    private ModelMethodCall getBestMethodMatch(List<ExecutableElement> methods, List<ModelCommand> queryparams) {
        if (methods.isEmpty()) {
            return null;
        }
        ModelMethodCall result = null;
        ExecutableElement ambiguity = null;
        int queryparamssize = queryparams.size();
        block0: for (ExecutableElement ee : methods) {
            List<? extends VariableElement> params = ee.getParameters();
            int paramssize = params.size();
            if (paramssize > queryparamssize || result != null && paramssize < result.argumentQueryIndices.size()) continue;
            Iterator<ModelCommand> qit = queryparams.iterator();
            Iterator<? extends VariableElement> pit = params.iterator();
            ModelMethodCall resultcandidate = new ModelMethodCall(ee);
            int qidx = -1;
            block1: while (pit.hasNext()) {
                if (!qit.hasNext()) continue block0;
                VariableElement p = pit.next();
                do {
                    ++qidx;
                    TypeElement qte = qit.next().getTypeElement();
                    if (!this.types.isAssignable(qte.asType(), p.asType())) continue;
                    resultcandidate.argumentQueryIndices.add(qidx);
                    continue block1;
                } while (qit.hasNext());
                continue block0;
            }
            if (result == null) {
                result = resultcandidate;
                continue;
            }
            int cmp = Integer.compare(paramssize, result.argumentQueryIndices.size());
            if (cmp > 0) {
                result = resultcandidate;
                ambiguity = null;
                continue;
            }
            if (cmp != 0) continue;
            ambiguity = ee;
        }
        if (ambiguity != null) {
            throw new IllegalArgumentException("Ambiguous call methods: " + result.executable + " - " + ambiguity + " for parameters " + queryparams + " in " + result.executable.getEnclosingElement() + " - " + ambiguity.getEnclosingElement());
        }
        return result;
    }

    private void printRunnableLambda(PrintStream ps, Runnable content) {
        if (this.supportsLambda) {
            ps.println("() -> {");
            content.run();
            ps.print("}");
        } else {
            ps.println("new Runnable() {");
            ps.println("@Override");
            ps.print("public void run()");
            ps.println(" {");
            content.run();
            ps.println("}");
            ps.print("}");
        }
    }

    public List<ExecutableElement> getMethodsWithName(TypeElement te, String name) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        this.addMethodsWithName(te, name, result, te);
        return result;
    }

    private void addMethodsWithName(TypeElement te, String name, Collection<ExecutableElement> result, TypeElement searchingtype) {
        block0: for (Element element : te.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(name)) continue;
            ExecutableElement ee = (ExecutableElement)element;
            for (ExecutableElement present : result) {
                if (!this.elements.overrides(present, ee, searchingtype)) continue;
                continue block0;
            }
            result.add(ee);
        }
        TypeElement sc = CommandLineProcessor.getSuperClass(te);
        if (sc != null) {
            this.addMethodsWithName(sc, name, result, te);
        }
    }

    public TypeMirror getTypeMirror(Supplier<Class<?>> classsupplier) {
        try {
            return this.elements.getTypeElement(classsupplier.get().getCanonicalName()).asType();
        }
        catch (MirroredTypeException e) {
            TypeMirror tm = e.getTypeMirror();
            return tm;
        }
    }

    public Collection<? extends TypeElement> getTypeElements(Supplier<Class<?>[]> classsupplier) {
        try {
            Class<?>[] classes = classsupplier.get();
            LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>();
            for (Class<?> c : classes) {
                result.add(this.elements.getTypeElement(c.getCanonicalName()));
            }
            return result;
        }
        catch (MirroredTypesException e) {
            LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>();
            for (TypeMirror typeMirror : e.getTypeMirrors()) {
                DeclaredType dt;
                TypeElement te;
                if (typeMirror.getKind() != TypeKind.DECLARED || (te = (TypeElement)(dt = (DeclaredType)typeMirror).asElement()) == null) continue;
                result.add(te);
            }
            return result;
        }
    }

    public TypeElement getTypeElement(Supplier<Class<?>> classsupplier) {
        try {
            return this.elements.getTypeElement(classsupplier.get().getCanonicalName());
        }
        catch (MirroredTypeException e) {
            TypeMirror tm = e.getTypeMirror();
            if (tm.getKind() == TypeKind.DECLARED) {
                DeclaredType dt = (DeclaredType)tm;
                return (TypeElement)dt.asElement();
            }
            throw new IllegalArgumentException("Failed to determine type.", e);
        }
    }

    public static TypeElement getTypeElementOf(VariableElement var) {
        TypeMirror t = var.asType();
        if (t.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)t;
            return (TypeElement)dt.asElement();
        }
        return null;
    }

    private static TypeElement getSuperClass(TypeElement te) {
        Element superte;
        TypeMirror sc = te.getSuperclass();
        if (sc.getKind() == TypeKind.DECLARED && (superte = ((DeclaredType)sc).asElement()) instanceof TypeElement) {
            return (TypeElement)superte;
        }
        return null;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptyList();
    }

    private static class ModelMethodCall {
        protected ExecutableElement executable;
        protected List<Integer> argumentQueryIndices = new ArrayList<Integer>();

        public ModelMethodCall(ExecutableElement executable) {
            this.executable = executable;
        }
    }
}

