/*
 * Decompiled with CFR 0.152.
 */
package bence.sipka.cmd;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class AutoIndentOutputStream
extends FilterOutputStream {
    private int identCount = 0;
    private boolean addIdent = false;
    private byte[] indentation = "\t".getBytes();

    public AutoIndentOutputStream(OutputStream out) {
        super(out);
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation.getBytes();
    }

    @Override
    public void write(int b) throws IOException {
        switch (b) {
            case 123: {
                this.addIdentIfNecessary();
                ++this.identCount;
                break;
            }
            case 125: {
                if (this.identCount > 0) {
                    --this.identCount;
                }
                this.addIdentIfNecessary();
                break;
            }
            case 10: 
            case 13: {
                this.addIdent = true;
                break;
            }
            default: {
                this.addIdentIfNecessary();
            }
        }
        super.write(b);
    }

    private void addIdentIfNecessary() throws IOException {
        if (this.addIdent) {
            this.addIdent = false;
            for (int i = 0; i < this.identCount; ++i) {
                this.out.write(this.indentation);
            }
        }
    }
}

