# Slack open source code of conduct


## Introduction
Diversity and inclusion make our community strong. We encourage participation from the most varied and diverse backgrounds possible and want to be very clear about where we stand.

Our goal is to maintain a safe, helpful and friendly community for everyone, regardless of experience, gender identity and expression, sexual orientation, disability, personal appearance, body size, race, ethnicity, age, religion, nationality, or other defining characteristic.

This code and related procedures also apply to unacceptable behavior occurring outside the scope of community activities, in all community venues (online and in-person) as well as in all one-on-one communications, and anywhere such behavior has the potential to adversely affect the safety and well-being of community members.

## Expected Behavior
  * Be welcoming.
  * Be kind.
  * Look out for each other.

## Unacceptable Behavior
  * Conduct or speech which might be considered sexist, racist, homophobic, transphobic, ableist or otherwise discriminatory or offensive in nature.
  * Unwelcome, suggestive, derogatory or inappropriate nicknames or terms.
  * Disrespect towards others. (Jokes, innuendo, dismissive attitudes.)
  * Intimidation or harassment (online or in-person). Please read the [Citizen Code of Conduct](http://citizencodeofconduct.org/) for how we interpret harassment. 
  * Disrespect towards differences of opinion.
  * Inappropriate attention or contact. Be aware of how your actions affect others. If it makes someone uncomfortable, stop.
  * Not understanding the differences between constructive criticism and disparagement.
  * Sustained disruptions.
  * Violence, threats of violence or violent language.

## Enforcement 
Understand that speech and actions have consequences, and unacceptable behavior will not be tolerated.

If you are the subject of, or witness to any violations of this Code of Conduct, please contact us by submitting a form [here](https://docs.google.com/a/slack-corp.com/forms/d/1NVqj2S2Q49XVIOT5N3L6Tx1oihvk9CpMa_UX8T_6ESo/viewform), or email conduct@slack.com.

If violations occur, organizers will take any action they deem appropriate for the infraction, up to and including expulsion.

_Thanks to the [Django Code of Conduct](https://www.djangoproject.com/conduct/), [The Citizen Code of Conduct](http://citizencodeofconduct.org/), [The Rust Code of Conduct](https://www.rust-lang.org/conduct.html) and [The Ada Initiative](http://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/)._