# Contributing at Slack

![Header Image](contributing_header_slack.png)

## Before Contributing

Before contributing, please read our [Code of Conduct](./CODE_OF_CONDUCT.md). We take it very seriously, and expect that you will as well.

## New Issues

Before opening a new issue, please consider:

  - Reading [the documentation](https://github.com/slackhq/python-rtmbot/blob/master/README.md) and [the changelog](https://github.com/slackhq/python-rtmbot/blob/master/CHANGELOG.md) first.
  - Searching for any related issues and avoid creating duplicated issues.
  - Adding details, diagnoses, screenshots or any type of useful information in existing issues, even if they are marked as closed. The team will still review it.
  - Trying out the examples [provided in this repository](https://github.com/slackhq/python-rtmbot/tree/master/examples).
  - Taking the time to think of a solution and [**open a pull request**](#new-pull-requests) for either improving the documentation, fixing a bug or suggesting a feature.
  - Finally, **[open an issue]**(https://github.com/slackhq/python-rtmbot/issues/new) to report a bug, ask for help or suggest a feature. The more information you give, the better people can help you.


## New Pull Requests

We love pull requests and we are generally very receptive to contributions. Things to keep in mind:

- [Fork the repository](https://github.com/slackhq/python-rtmbot) and make sure to work on a branch up to date with origin master.
- Do your thing!
- Be mindful about doing atomic commits, adding documentation to your changes, not refactoring too much.
- Add tests covering the new code or functionality you are adding.
- Add a descriptive title and add any useful information for the reviewer. If your contribution is a user facing thing, please attach a screenshot and/or screencast (gif preferrably).
- Read and agree to our [Contributor License Agreement (CLA)](https://docs.google.com/a/slack-corp.com/forms/d/1q_w8rlJG_x_xJOoSUMNl7R35rkpA7N6pUkKhfHHMD9c/viewform). _We cannot accept your PR without your agreement to our CLA_.
- Create your pull request (yay!). If it is in relation to an existing issue, please mention it on the title or description.

[Interested in knowing more about about pull requests at Slack?](https://slack.engineering/on-empathy-pull-requests-979e4257d158#.awxtvmb2z)
