/*
 * Shadowsocks - A shadowsocks client for Android
 * Copyright (C) 2013 <max.c.lv@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *                            ___====-_  _-====___
 *                      _--^^^#####//      \\#####^^^--_
 *                   _-^##########// (    ) \\##########^-_
 *                  -############//  |\^^/|  \\############-
 *                _/############//   (@::@)   \\############\_
 *               /#############((     \\//     ))#############\
 *              -###############\\    (oo)    //###############-
 *             -#################\\  / VV \  //#################-
 *            -###################\\/      \//###################-
 *           _#/|##########/\######(   /\   )######/\##########|\#_
 *           |/ |#/\#/\#/\/  \#/\##\  |  |  /##/\#/  \/\#/\#/\#| \|
 *           `  |/  V  V  `   V  \#\| |  | |/#/  V   '  V  V  \|  '
 *              `   `  `      `   / | |  | | \   '      '  '   '
 *                               (  | |  | |  )
 *                              __\ | |  | | /__
 *                             (vvv(VVV)(VVV)vvv)
 *
 *                              HERE BE DRAGONS
 *
 */

package com.github.shadowsocks.preferences

import android.content.Context
import android.preference.EditTextPreference
import android.util.AttributeSet

class PasswordEditTextPreference(context: Context, attrs: AttributeSet, defStyle: Int)
  extends EditTextPreference(context, attrs, defStyle) {

  def this(context: Context, attrs: AttributeSet) = {
    this(context, attrs, android.R.attr.editTextPreferenceStyle)
    mDefaultSummary = getSummary
  }

  override def setText(text: String) {
    super.setText(text)
    setSummary(text)
  }

  override def setSummary(summary: CharSequence) {
    if (summary.toString.isEmpty) {
      super.setSummary(mDefaultSummary)
    } else {
      super.setSummary(summary.toString.map(c => "*").mkString)
    }
  }

  private var mDefaultSummary: CharSequence = getSummary
}
