// ⚠️ Part of this file is automatically generated
//    The :RUNTIMES comment is a delimiter and no code should be written/changed after
//    See rollup/build_interpreters.cjs to know more

/** @type {Map<string, object>} */
export const registry = new Map();

/** @type {Map<string, object>} */
export const configs = new Map();

/** @type {string[]} */
export const selectors = [];

/** @type {string[]} */
export const prefixes = [];

/* c8 ignore start */
export const interpreter = new Proxy(new Map(), {
    get(map, id) {
        if (!map.has(id)) {
            const [type, ...rest] = id.split('@');
            const interpreter = registry.get(type);
            const url = /^(?:\.?\.?\/|[a-z0-9-]+:\/\/)/i.test(rest)
                ? rest.join('@')
                : interpreter.module(...rest);
            map.set(id, {
                url,
                module: import(/* webpackIgnore: true */url),
                engine: interpreter.engine.bind(interpreter),
            });
        }
        const { url, module, engine } = map.get(id);
        return (config, baseURL) =>
            module.then((module) => {
                configs.set(id, config);
                return engine(module, config, url, baseURL);
            });
    },
});
/* c8 ignore stop */

const register = (interpreter) => {
    for (const type of [].concat(interpreter.type)) {
        registry.set(type, interpreter);
        selectors.push(`script[type="${type}"]`);
        prefixes.push(`${type}-`);
    }
};

//:RUNTIMES
import dummy from './interpreter/dummy.js';
import micropython from './interpreter/micropython.js';
import pyodide from './interpreter/pyodide.js';
import ruby_wasm_wasi from './interpreter/ruby-wasm-wasi.js';
import wasmoon from './interpreter/wasmoon.js';
import webr from './interpreter/webr.js';
for (const interpreter of [dummy, micropython, pyodide, ruby_wasm_wasi, wasmoon, webr])
    register(interpreter);
