// The content of this file was automatically generated

import fetch = require('node-fetch');

import ProcessOut = require('./processout');
import Response   = require('./networking/response');
import Request    = require('./networking/request');

import ProcessOutNetworkError = require('./errors/processoutnetworkerror');

import * as p from '.';

class Invoice {
    private client: ProcessOut = null;

    /**
     * ID of the invoice
     * @type {string}
     */
    private id: string = null;

    /**
     * Project to which the invoice belongs
     * @type {p.Project}
     */
    private project: p.Project = null;

    /**
     * ID of the project to which the invoice belongs
     * @type {string}
     */
    private projectId: string = null;

    /**
     * Transaction generated by the invoice
     * @type {p.Transaction}
     */
    private transaction: p.Transaction = null;

    /**
     * ID of the transaction generated by the invoice
     * @type {string}
     */
    private transactionId: string = null;

    /**
     * Customer linked to the invoice, if any
     * @type {p.Customer}
     */
    private customer: p.Customer = null;

    /**
     * ID of the customer linked to the invoice, if any
     * @type {string}
     */
    private customerId: string = null;

    /**
     * Subscription to which the invoice is linked to, if any
     * @type {p.Subscription}
     */
    private subscription: p.Subscription = null;

    /**
     * ID of the subscription to which the invoice is linked to, if any
     * @type {string}
     */
    private subscriptionId: string = null;

    /**
     * Token used to pay the invoice, if any
     * @type {p.Token}
     */
    private token: p.Token = null;

    /**
     * ID of the token used to pay the invoice, if any
     * @type {string}
     */
    private tokenId: string = null;

    /**
     * Details of the invoice
     * @type {any}
     */
    private details: any = null;

    /**
     * Submerchant data of the invoice
     * @type {p.InvoiceSubmerchant}
     */
    private submerchant: p.InvoiceSubmerchant = null;

    /**
     * URL to which you may redirect your customer to proceed with the payment
     * @type {string}
     */
    private url: string = null;

    /**
     * base64-encoded QR code for the invoice URL
     * @type {string}
     */
    private urlQrcode: string = null;

    /**
     * Name of the invoice
     * @type {string}
     */
    private name: string = null;

    /**
     * ID of the order for this transaction in merchant's system
     * @type {string}
     */
    private orderId: string = null;

    /**
     * Amount to be paid
     * @type {string}
     */
    private amount: string = null;

    /**
     * Currency of the invoice
     * @type {string}
     */
    private currency: string = null;

    /**
     * Type of the transaction initiated by the merchant (off-session). Can be either one-off or recurring, depending on the nature of the merchant initiated transaction.
     * @type {string}
     */
    private merchantInitiatorType: string = null;

    /**
     * Statement to be shown on the bank statement of your customer
     * @type {string}
     */
    private statementDescriptor: string = null;

    /**
     * Support phone number shown on the customer's bank statement
     * @type {string}
     */
    private statementDescriptorPhone: string = null;

    /**
     * City shown on the customer's bank statement
     * @type {string}
     */
    private statementDescriptorCity: string = null;

    /**
     * Your company name shown on the customer's bank statement
     * @type {string}
     */
    private statementDescriptorCompany: string = null;

    /**
     * URL shown on the customer's bank statement
     * @type {string}
     */
    private statementDescriptorUrl: string = null;

    /**
     * Metadata related to the invoice, in the form of a dictionary (key-value pair)
     * @type {any}
     */
    private metadata: any = null;

    /**
     * Dictionary that transmit specific informations to gateways (key-value pair)
     * @type {any}
     */
    private gatewayData: any = null;

    /**
     * URL where the customer will be redirected upon payment
     * @type {string}
     */
    private returnUrl: string = null;

    /**
     * URL where the customer will be redirected if the payment was canceled
     * @type {string}
     */
    private cancelUrl: string = null;

    /**
     * Custom webhook URL where updates about this specific payment will be sent, on top of your project-wide URLs
     * @type {string}
     */
    private webhookUrl: string = null;

    /**
     * Define whether the invoice can be captured from the front-end or not
     * @type {boolean}
     */
    private requireBackendCapture: boolean = null;

    /**
     * Define whether or not the invoice is in sandbox environment
     * @type {boolean}
     */
    private sandbox: boolean = null;

    /**
     * Date at which the invoice was created
     * @type {string}
     */
    private createdAt: string = null;

    /**
     * Date at which the invoice will expire
     * @type {string}
     */
    private expiresAt: string = null;

    /**
     * Risk information
     * @type {p.InvoiceRisk}
     */
    private risk: p.InvoiceRisk = null;

    /**
     * Shipping information
     * @type {p.InvoiceShipping}
     */
    private shipping: p.InvoiceShipping = null;

    /**
     * Device information
     * @type {p.InvoiceDevice}
     */
    private device: p.InvoiceDevice = null;

    /**
     * Contain objects that'll be forwarded to external fraud tools
     * @type {p.InvoiceExternalFraudTools}
     */
    private externalFraudTools: p.InvoiceExternalFraudTools = null;

    /**
     * (Deprecated - use sca_exemption_reason) Reason provided to request 3DS2 exemption
     * @type {string}
     */
    private exemptionReason3ds2: string = null;

    /**
     * Reason provided to request SCA exemption
     * @type {string}
     */
    private scaExemptionReason: string = null;

    /**
     * Challenge indicator when requesting 3DS2
     * @type {string}
     */
    private challengeIndicator: string = null;

    /**
     * A boolean to indicate if an invoice can have incremental authorizations created for it.
     * @type {boolean}
     */
    private incremental: boolean = null;

    /**
     * Tax for an invoice
     * @type {p.InvoiceTax}
     */
    private tax: p.InvoiceTax = null;

    /**
     * Payment type
     * @type {string}
     */
    private paymentType: string = null;

    /**
     * Native APM data
     * @type {p.NativeAPMRequest}
     */
    private nativeApm: p.NativeAPMRequest = null;

    /**
     * Initiation type of invoice
     * @type {string}
     */
    private initiationType: string = null;

    /**
     * Payment intent of invoice
     * @type {string}
     */
    private paymentIntent: string = null;

    /**
     * Billing information
     * @type {p.InvoiceBilling}
     */
    private billing: p.InvoiceBilling = null;

    /**
     * Flags to bypass unsupported features
     * @type {p.UnsupportedFeatureBypass}
     */
    private unsupportedFeatureBypass: p.UnsupportedFeatureBypass = null;

    /**
     * A boolean to indicate if an invoice is a verification invoice. This is used to manually create a verification invoice.
     * @type {boolean}
     */
    private verification: boolean = null;

    /**
     * A timestamp to indicate when an auto capture should take place following an authorization. This takes priority over the value sent in the authorization request.
     * @type {string}
     */
    private autoCaptureAt: string = null;

    /**
     * Invoice constructor
     * @param {ProcessOut} client
     * @param {array} prefill (optional)
     */
    constructor(client: ProcessOut, prefill: Invoice) {
        if (typeof client === 'undefined')
            throw new Error("The Invoice object must be instanciated with the ProcessOut client. You can create one using new ProcessOut('project-id', 'project-secret').newInvoice()");

        this.client = client;
        if (typeof prefill !== 'undefined')
            this.fillWithData(prefill);
    }

    public getProcessOutObjectClass(): string {
        return "Invoice";
    }

    /**
     * Get Id
     * ID of the invoice
     * @return {string}
     */
    public getId(): string {
        return this.id;
    }

    /**
     * Set Id
     * ID of the invoice
     * @param {string} val
     * @return {Invoice}
     */
    public setId(val: string): Invoice {
        this.id = val;
        return this;
    }

    /**
     * Get Project
     * Project to which the invoice belongs
     * @return {p.Project}
     */
    public getProject(): p.Project {
        return this.project;
    }

    /**
     * Set Project
     * Project to which the invoice belongs
     * @param {p.Project} val
     * @return {Invoice}
     */
    public setProject(val: p.Project): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newProject().getProcessOutObjectClass())
            this.project = val;
        else {
            var obj = this.client.newProject();
            obj.fillWithData(val);
            this.project = obj;
        }
        return this;
    }

    /**
     * Get ProjectId
     * ID of the project to which the invoice belongs
     * @return {string}
     */
    public getProjectId(): string {
        return this.projectId;
    }

    /**
     * Set ProjectId
     * ID of the project to which the invoice belongs
     * @param {string} val
     * @return {Invoice}
     */
    public setProjectId(val: string): Invoice {
        this.projectId = val;
        return this;
    }

    /**
     * Get Transaction
     * Transaction generated by the invoice
     * @return {p.Transaction}
     */
    public getTransaction(): p.Transaction {
        return this.transaction;
    }

    /**
     * Set Transaction
     * Transaction generated by the invoice
     * @param {p.Transaction} val
     * @return {Invoice}
     */
    public setTransaction(val: p.Transaction): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newTransaction().getProcessOutObjectClass())
            this.transaction = val;
        else {
            var obj = this.client.newTransaction();
            obj.fillWithData(val);
            this.transaction = obj;
        }
        return this;
    }

    /**
     * Get TransactionId
     * ID of the transaction generated by the invoice
     * @return {string}
     */
    public getTransactionId(): string {
        return this.transactionId;
    }

    /**
     * Set TransactionId
     * ID of the transaction generated by the invoice
     * @param {string} val
     * @return {Invoice}
     */
    public setTransactionId(val: string): Invoice {
        this.transactionId = val;
        return this;
    }

    /**
     * Get Customer
     * Customer linked to the invoice, if any
     * @return {p.Customer}
     */
    public getCustomer(): p.Customer {
        return this.customer;
    }

    /**
     * Set Customer
     * Customer linked to the invoice, if any
     * @param {p.Customer} val
     * @return {Invoice}
     */
    public setCustomer(val: p.Customer): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newCustomer().getProcessOutObjectClass())
            this.customer = val;
        else {
            var obj = this.client.newCustomer();
            obj.fillWithData(val);
            this.customer = obj;
        }
        return this;
    }

    /**
     * Get CustomerId
     * ID of the customer linked to the invoice, if any
     * @return {string}
     */
    public getCustomerId(): string {
        return this.customerId;
    }

    /**
     * Set CustomerId
     * ID of the customer linked to the invoice, if any
     * @param {string} val
     * @return {Invoice}
     */
    public setCustomerId(val: string): Invoice {
        this.customerId = val;
        return this;
    }

    /**
     * Get Subscription
     * Subscription to which the invoice is linked to, if any
     * @return {p.Subscription}
     */
    public getSubscription(): p.Subscription {
        return this.subscription;
    }

    /**
     * Set Subscription
     * Subscription to which the invoice is linked to, if any
     * @param {p.Subscription} val
     * @return {Invoice}
     */
    public setSubscription(val: p.Subscription): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newSubscription().getProcessOutObjectClass())
            this.subscription = val;
        else {
            var obj = this.client.newSubscription();
            obj.fillWithData(val);
            this.subscription = obj;
        }
        return this;
    }

    /**
     * Get SubscriptionId
     * ID of the subscription to which the invoice is linked to, if any
     * @return {string}
     */
    public getSubscriptionId(): string {
        return this.subscriptionId;
    }

    /**
     * Set SubscriptionId
     * ID of the subscription to which the invoice is linked to, if any
     * @param {string} val
     * @return {Invoice}
     */
    public setSubscriptionId(val: string): Invoice {
        this.subscriptionId = val;
        return this;
    }

    /**
     * Get Token
     * Token used to pay the invoice, if any
     * @return {p.Token}
     */
    public getToken(): p.Token {
        return this.token;
    }

    /**
     * Set Token
     * Token used to pay the invoice, if any
     * @param {p.Token} val
     * @return {Invoice}
     */
    public setToken(val: p.Token): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newToken().getProcessOutObjectClass())
            this.token = val;
        else {
            var obj = this.client.newToken();
            obj.fillWithData(val);
            this.token = obj;
        }
        return this;
    }

    /**
     * Get TokenId
     * ID of the token used to pay the invoice, if any
     * @return {string}
     */
    public getTokenId(): string {
        return this.tokenId;
    }

    /**
     * Set TokenId
     * ID of the token used to pay the invoice, if any
     * @param {string} val
     * @return {Invoice}
     */
    public setTokenId(val: string): Invoice {
        this.tokenId = val;
        return this;
    }

    /**
     * Get Details
     * Details of the invoice
     * @return {any}
     */
    public getDetails(): any {
        return this.details;
    }

    /**
     * Set Details
     * Details of the invoice
     * @param {any} val
     * @return {Invoice}
     */
    public setDetails(val: any): Invoice {
        if (val.length > 0 && typeof val[0] === 'object')
            this.details = val;
        else {
            var a = [];
            for (var i = val.length; i--;) {
                var obj = this.client.newInvoiceDetail();
                obj.fillWithData(val);
                a.push(obj);
            }
            this.details = a;
        }
        return this;
    }

    /**
     * Get Submerchant
     * Submerchant data of the invoice
     * @return {p.InvoiceSubmerchant}
     */
    public getSubmerchant(): p.InvoiceSubmerchant {
        return this.submerchant;
    }

    /**
     * Set Submerchant
     * Submerchant data of the invoice
     * @param {p.InvoiceSubmerchant} val
     * @return {Invoice}
     */
    public setSubmerchant(val: p.InvoiceSubmerchant): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceSubmerchant().getProcessOutObjectClass())
            this.submerchant = val;
        else {
            var obj = this.client.newInvoiceSubmerchant();
            obj.fillWithData(val);
            this.submerchant = obj;
        }
        return this;
    }

    /**
     * Get Url
     * URL to which you may redirect your customer to proceed with the payment
     * @return {string}
     */
    public getUrl(): string {
        return this.url;
    }

    /**
     * Set Url
     * URL to which you may redirect your customer to proceed with the payment
     * @param {string} val
     * @return {Invoice}
     */
    public setUrl(val: string): Invoice {
        this.url = val;
        return this;
    }

    /**
     * Get UrlQrcode
     * base64-encoded QR code for the invoice URL
     * @return {string}
     */
    public getUrlQrcode(): string {
        return this.urlQrcode;
    }

    /**
     * Set UrlQrcode
     * base64-encoded QR code for the invoice URL
     * @param {string} val
     * @return {Invoice}
     */
    public setUrlQrcode(val: string): Invoice {
        this.urlQrcode = val;
        return this;
    }

    /**
     * Get Name
     * Name of the invoice
     * @return {string}
     */
    public getName(): string {
        return this.name;
    }

    /**
     * Set Name
     * Name of the invoice
     * @param {string} val
     * @return {Invoice}
     */
    public setName(val: string): Invoice {
        this.name = val;
        return this;
    }

    /**
     * Get OrderId
     * ID of the order for this transaction in merchant's system
     * @return {string}
     */
    public getOrderId(): string {
        return this.orderId;
    }

    /**
     * Set OrderId
     * ID of the order for this transaction in merchant's system
     * @param {string} val
     * @return {Invoice}
     */
    public setOrderId(val: string): Invoice {
        this.orderId = val;
        return this;
    }

    /**
     * Get Amount
     * Amount to be paid
     * @return {string}
     */
    public getAmount(): string {
        return this.amount;
    }

    /**
     * Set Amount
     * Amount to be paid
     * @param {string} val
     * @return {Invoice}
     */
    public setAmount(val: string): Invoice {
        this.amount = val;
        return this;
    }

    /**
     * Get Currency
     * Currency of the invoice
     * @return {string}
     */
    public getCurrency(): string {
        return this.currency;
    }

    /**
     * Set Currency
     * Currency of the invoice
     * @param {string} val
     * @return {Invoice}
     */
    public setCurrency(val: string): Invoice {
        this.currency = val;
        return this;
    }

    /**
     * Get MerchantInitiatorType
     * Type of the transaction initiated by the merchant (off-session). Can be either one-off or recurring, depending on the nature of the merchant initiated transaction.
     * @return {string}
     */
    public getMerchantInitiatorType(): string {
        return this.merchantInitiatorType;
    }

    /**
     * Set MerchantInitiatorType
     * Type of the transaction initiated by the merchant (off-session). Can be either one-off or recurring, depending on the nature of the merchant initiated transaction.
     * @param {string} val
     * @return {Invoice}
     */
    public setMerchantInitiatorType(val: string): Invoice {
        this.merchantInitiatorType = val;
        return this;
    }

    /**
     * Get StatementDescriptor
     * Statement to be shown on the bank statement of your customer
     * @return {string}
     */
    public getStatementDescriptor(): string {
        return this.statementDescriptor;
    }

    /**
     * Set StatementDescriptor
     * Statement to be shown on the bank statement of your customer
     * @param {string} val
     * @return {Invoice}
     */
    public setStatementDescriptor(val: string): Invoice {
        this.statementDescriptor = val;
        return this;
    }

    /**
     * Get StatementDescriptorPhone
     * Support phone number shown on the customer's bank statement
     * @return {string}
     */
    public getStatementDescriptorPhone(): string {
        return this.statementDescriptorPhone;
    }

    /**
     * Set StatementDescriptorPhone
     * Support phone number shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    public setStatementDescriptorPhone(val: string): Invoice {
        this.statementDescriptorPhone = val;
        return this;
    }

    /**
     * Get StatementDescriptorCity
     * City shown on the customer's bank statement
     * @return {string}
     */
    public getStatementDescriptorCity(): string {
        return this.statementDescriptorCity;
    }

    /**
     * Set StatementDescriptorCity
     * City shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    public setStatementDescriptorCity(val: string): Invoice {
        this.statementDescriptorCity = val;
        return this;
    }

    /**
     * Get StatementDescriptorCompany
     * Your company name shown on the customer's bank statement
     * @return {string}
     */
    public getStatementDescriptorCompany(): string {
        return this.statementDescriptorCompany;
    }

    /**
     * Set StatementDescriptorCompany
     * Your company name shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    public setStatementDescriptorCompany(val: string): Invoice {
        this.statementDescriptorCompany = val;
        return this;
    }

    /**
     * Get StatementDescriptorUrl
     * URL shown on the customer's bank statement
     * @return {string}
     */
    public getStatementDescriptorUrl(): string {
        return this.statementDescriptorUrl;
    }

    /**
     * Set StatementDescriptorUrl
     * URL shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    public setStatementDescriptorUrl(val: string): Invoice {
        this.statementDescriptorUrl = val;
        return this;
    }

    /**
     * Get Metadata
     * Metadata related to the invoice, in the form of a dictionary (key-value pair)
     * @return {any}
     */
    public getMetadata(): any {
        return this.metadata;
    }

    /**
     * Set Metadata
     * Metadata related to the invoice, in the form of a dictionary (key-value pair)
     * @param {any} val
     * @return {Invoice}
     */
    public setMetadata(val: any): Invoice {
        this.metadata = val;
        return this;
    }

    /**
     * Get GatewayData
     * Dictionary that transmit specific informations to gateways (key-value pair)
     * @return {any}
     */
    public getGatewayData(): any {
        return this.gatewayData;
    }

    /**
     * Set GatewayData
     * Dictionary that transmit specific informations to gateways (key-value pair)
     * @param {any} val
     * @return {Invoice}
     */
    public setGatewayData(val: any): Invoice {
        this.gatewayData = val;
        return this;
    }

    /**
     * Get ReturnUrl
     * URL where the customer will be redirected upon payment
     * @return {string}
     */
    public getReturnUrl(): string {
        return this.returnUrl;
    }

    /**
     * Set ReturnUrl
     * URL where the customer will be redirected upon payment
     * @param {string} val
     * @return {Invoice}
     */
    public setReturnUrl(val: string): Invoice {
        this.returnUrl = val;
        return this;
    }

    /**
     * Get CancelUrl
     * URL where the customer will be redirected if the payment was canceled
     * @return {string}
     */
    public getCancelUrl(): string {
        return this.cancelUrl;
    }

    /**
     * Set CancelUrl
     * URL where the customer will be redirected if the payment was canceled
     * @param {string} val
     * @return {Invoice}
     */
    public setCancelUrl(val: string): Invoice {
        this.cancelUrl = val;
        return this;
    }

    /**
     * Get WebhookUrl
     * Custom webhook URL where updates about this specific payment will be sent, on top of your project-wide URLs
     * @return {string}
     */
    public getWebhookUrl(): string {
        return this.webhookUrl;
    }

    /**
     * Set WebhookUrl
     * Custom webhook URL where updates about this specific payment will be sent, on top of your project-wide URLs
     * @param {string} val
     * @return {Invoice}
     */
    public setWebhookUrl(val: string): Invoice {
        this.webhookUrl = val;
        return this;
    }

    /**
     * Get RequireBackendCapture
     * Define whether the invoice can be captured from the front-end or not
     * @return {boolean}
     */
    public getRequireBackendCapture(): boolean {
        return this.requireBackendCapture;
    }

    /**
     * Set RequireBackendCapture
     * Define whether the invoice can be captured from the front-end or not
     * @param {boolean} val
     * @return {Invoice}
     */
    public setRequireBackendCapture(val: boolean): Invoice {
        this.requireBackendCapture = val;
        return this;
    }

    /**
     * Get Sandbox
     * Define whether or not the invoice is in sandbox environment
     * @return {boolean}
     */
    public getSandbox(): boolean {
        return this.sandbox;
    }

    /**
     * Set Sandbox
     * Define whether or not the invoice is in sandbox environment
     * @param {boolean} val
     * @return {Invoice}
     */
    public setSandbox(val: boolean): Invoice {
        this.sandbox = val;
        return this;
    }

    /**
     * Get CreatedAt
     * Date at which the invoice was created
     * @return {string}
     */
    public getCreatedAt(): string {
        return this.createdAt;
    }

    /**
     * Set CreatedAt
     * Date at which the invoice was created
     * @param {string} val
     * @return {Invoice}
     */
    public setCreatedAt(val: string): Invoice {
        this.createdAt = val;
        return this;
    }

    /**
     * Get ExpiresAt
     * Date at which the invoice will expire
     * @return {string}
     */
    public getExpiresAt(): string {
        return this.expiresAt;
    }

    /**
     * Set ExpiresAt
     * Date at which the invoice will expire
     * @param {string} val
     * @return {Invoice}
     */
    public setExpiresAt(val: string): Invoice {
        this.expiresAt = val;
        return this;
    }

    /**
     * Get Risk
     * Risk information
     * @return {p.InvoiceRisk}
     */
    public getRisk(): p.InvoiceRisk {
        return this.risk;
    }

    /**
     * Set Risk
     * Risk information
     * @param {p.InvoiceRisk} val
     * @return {Invoice}
     */
    public setRisk(val: p.InvoiceRisk): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceRisk().getProcessOutObjectClass())
            this.risk = val;
        else {
            var obj = this.client.newInvoiceRisk();
            obj.fillWithData(val);
            this.risk = obj;
        }
        return this;
    }

    /**
     * Get Shipping
     * Shipping information
     * @return {p.InvoiceShipping}
     */
    public getShipping(): p.InvoiceShipping {
        return this.shipping;
    }

    /**
     * Set Shipping
     * Shipping information
     * @param {p.InvoiceShipping} val
     * @return {Invoice}
     */
    public setShipping(val: p.InvoiceShipping): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceShipping().getProcessOutObjectClass())
            this.shipping = val;
        else {
            var obj = this.client.newInvoiceShipping();
            obj.fillWithData(val);
            this.shipping = obj;
        }
        return this;
    }

    /**
     * Get Device
     * Device information
     * @return {p.InvoiceDevice}
     */
    public getDevice(): p.InvoiceDevice {
        return this.device;
    }

    /**
     * Set Device
     * Device information
     * @param {p.InvoiceDevice} val
     * @return {Invoice}
     */
    public setDevice(val: p.InvoiceDevice): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceDevice().getProcessOutObjectClass())
            this.device = val;
        else {
            var obj = this.client.newInvoiceDevice();
            obj.fillWithData(val);
            this.device = obj;
        }
        return this;
    }

    /**
     * Get ExternalFraudTools
     * Contain objects that'll be forwarded to external fraud tools
     * @return {p.InvoiceExternalFraudTools}
     */
    public getExternalFraudTools(): p.InvoiceExternalFraudTools {
        return this.externalFraudTools;
    }

    /**
     * Set ExternalFraudTools
     * Contain objects that'll be forwarded to external fraud tools
     * @param {p.InvoiceExternalFraudTools} val
     * @return {Invoice}
     */
    public setExternalFraudTools(val: p.InvoiceExternalFraudTools): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceExternalFraudTools().getProcessOutObjectClass())
            this.externalFraudTools = val;
        else {
            var obj = this.client.newInvoiceExternalFraudTools();
            obj.fillWithData(val);
            this.externalFraudTools = obj;
        }
        return this;
    }

    /**
     * Get ExemptionReason3ds2
     * (Deprecated - use sca_exemption_reason) Reason provided to request 3DS2 exemption
     * @return {string}
     */
    public getExemptionReason3ds2(): string {
        return this.exemptionReason3ds2;
    }

    /**
     * Set ExemptionReason3ds2
     * (Deprecated - use sca_exemption_reason) Reason provided to request 3DS2 exemption
     * @param {string} val
     * @return {Invoice}
     */
    public setExemptionReason3ds2(val: string): Invoice {
        this.exemptionReason3ds2 = val;
        return this;
    }

    /**
     * Get ScaExemptionReason
     * Reason provided to request SCA exemption
     * @return {string}
     */
    public getScaExemptionReason(): string {
        return this.scaExemptionReason;
    }

    /**
     * Set ScaExemptionReason
     * Reason provided to request SCA exemption
     * @param {string} val
     * @return {Invoice}
     */
    public setScaExemptionReason(val: string): Invoice {
        this.scaExemptionReason = val;
        return this;
    }

    /**
     * Get ChallengeIndicator
     * Challenge indicator when requesting 3DS2
     * @return {string}
     */
    public getChallengeIndicator(): string {
        return this.challengeIndicator;
    }

    /**
     * Set ChallengeIndicator
     * Challenge indicator when requesting 3DS2
     * @param {string} val
     * @return {Invoice}
     */
    public setChallengeIndicator(val: string): Invoice {
        this.challengeIndicator = val;
        return this;
    }

    /**
     * Get Incremental
     * A boolean to indicate if an invoice can have incremental authorizations created for it.
     * @return {boolean}
     */
    public getIncremental(): boolean {
        return this.incremental;
    }

    /**
     * Set Incremental
     * A boolean to indicate if an invoice can have incremental authorizations created for it.
     * @param {boolean} val
     * @return {Invoice}
     */
    public setIncremental(val: boolean): Invoice {
        this.incremental = val;
        return this;
    }

    /**
     * Get Tax
     * Tax for an invoice
     * @return {p.InvoiceTax}
     */
    public getTax(): p.InvoiceTax {
        return this.tax;
    }

    /**
     * Set Tax
     * Tax for an invoice
     * @param {p.InvoiceTax} val
     * @return {Invoice}
     */
    public setTax(val: p.InvoiceTax): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceTax().getProcessOutObjectClass())
            this.tax = val;
        else {
            var obj = this.client.newInvoiceTax();
            obj.fillWithData(val);
            this.tax = obj;
        }
        return this;
    }

    /**
     * Get PaymentType
     * Payment type
     * @return {string}
     */
    public getPaymentType(): string {
        return this.paymentType;
    }

    /**
     * Set PaymentType
     * Payment type
     * @param {string} val
     * @return {Invoice}
     */
    public setPaymentType(val: string): Invoice {
        this.paymentType = val;
        return this;
    }

    /**
     * Get NativeApm
     * Native APM data
     * @return {p.NativeAPMRequest}
     */
    public getNativeApm(): p.NativeAPMRequest {
        return this.nativeApm;
    }

    /**
     * Set NativeApm
     * Native APM data
     * @param {p.NativeAPMRequest} val
     * @return {Invoice}
     */
    public setNativeApm(val: p.NativeAPMRequest): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newNativeAPMRequest().getProcessOutObjectClass())
            this.nativeApm = val;
        else {
            var obj = this.client.newNativeAPMRequest();
            obj.fillWithData(val);
            this.nativeApm = obj;
        }
        return this;
    }

    /**
     * Get InitiationType
     * Initiation type of invoice
     * @return {string}
     */
    public getInitiationType(): string {
        return this.initiationType;
    }

    /**
     * Set InitiationType
     * Initiation type of invoice
     * @param {string} val
     * @return {Invoice}
     */
    public setInitiationType(val: string): Invoice {
        this.initiationType = val;
        return this;
    }

    /**
     * Get PaymentIntent
     * Payment intent of invoice
     * @return {string}
     */
    public getPaymentIntent(): string {
        return this.paymentIntent;
    }

    /**
     * Set PaymentIntent
     * Payment intent of invoice
     * @param {string} val
     * @return {Invoice}
     */
    public setPaymentIntent(val: string): Invoice {
        this.paymentIntent = val;
        return this;
    }

    /**
     * Get Billing
     * Billing information
     * @return {p.InvoiceBilling}
     */
    public getBilling(): p.InvoiceBilling {
        return this.billing;
    }

    /**
     * Set Billing
     * Billing information
     * @param {p.InvoiceBilling} val
     * @return {Invoice}
     */
    public setBilling(val: p.InvoiceBilling): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceBilling().getProcessOutObjectClass())
            this.billing = val;
        else {
            var obj = this.client.newInvoiceBilling();
            obj.fillWithData(val);
            this.billing = obj;
        }
        return this;
    }

    /**
     * Get UnsupportedFeatureBypass
     * Flags to bypass unsupported features
     * @return {p.UnsupportedFeatureBypass}
     */
    public getUnsupportedFeatureBypass(): p.UnsupportedFeatureBypass {
        return this.unsupportedFeatureBypass;
    }

    /**
     * Set UnsupportedFeatureBypass
     * Flags to bypass unsupported features
     * @param {p.UnsupportedFeatureBypass} val
     * @return {Invoice}
     */
    public setUnsupportedFeatureBypass(val: p.UnsupportedFeatureBypass): Invoice {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newUnsupportedFeatureBypass().getProcessOutObjectClass())
            this.unsupportedFeatureBypass = val;
        else {
            var obj = this.client.newUnsupportedFeatureBypass();
            obj.fillWithData(val);
            this.unsupportedFeatureBypass = obj;
        }
        return this;
    }

    /**
     * Get Verification
     * A boolean to indicate if an invoice is a verification invoice. This is used to manually create a verification invoice.
     * @return {boolean}
     */
    public getVerification(): boolean {
        return this.verification;
    }

    /**
     * Set Verification
     * A boolean to indicate if an invoice is a verification invoice. This is used to manually create a verification invoice.
     * @param {boolean} val
     * @return {Invoice}
     */
    public setVerification(val: boolean): Invoice {
        this.verification = val;
        return this;
    }

    /**
     * Get AutoCaptureAt
     * A timestamp to indicate when an auto capture should take place following an authorization. This takes priority over the value sent in the authorization request.
     * @return {string}
     */
    public getAutoCaptureAt(): string {
        return this.autoCaptureAt;
    }

    /**
     * Set AutoCaptureAt
     * A timestamp to indicate when an auto capture should take place following an authorization. This takes priority over the value sent in the authorization request.
     * @param {string} val
     * @return {Invoice}
     */
    public setAutoCaptureAt(val: string): Invoice {
        this.autoCaptureAt = val;
        return this;
    }

    /**
     * Fills the current object with the new values pulled from the data
     * @param  {array} data
     * @return {Invoice}
     */
    public fillWithData(data: any): Invoice {
        if (data["id"])
            this.setId(data["id"]);
        if (data["project"])
            this.setProject(data["project"]);
        if (data["project_id"])
            this.setProjectId(data["project_id"]);
        if (data["transaction"])
            this.setTransaction(data["transaction"]);
        if (data["transaction_id"])
            this.setTransactionId(data["transaction_id"]);
        if (data["customer"])
            this.setCustomer(data["customer"]);
        if (data["customer_id"])
            this.setCustomerId(data["customer_id"]);
        if (data["subscription"])
            this.setSubscription(data["subscription"]);
        if (data["subscription_id"])
            this.setSubscriptionId(data["subscription_id"]);
        if (data["token"])
            this.setToken(data["token"]);
        if (data["token_id"])
            this.setTokenId(data["token_id"]);
        if (data["details"])
            this.setDetails(data["details"]);
        if (data["submerchant"])
            this.setSubmerchant(data["submerchant"]);
        if (data["url"])
            this.setUrl(data["url"]);
        if (data["url_qrcode"])
            this.setUrlQrcode(data["url_qrcode"]);
        if (data["name"])
            this.setName(data["name"]);
        if (data["order_id"])
            this.setOrderId(data["order_id"]);
        if (data["amount"])
            this.setAmount(data["amount"]);
        if (data["currency"])
            this.setCurrency(data["currency"]);
        if (data["merchant_initiator_type"])
            this.setMerchantInitiatorType(data["merchant_initiator_type"]);
        if (data["statement_descriptor"])
            this.setStatementDescriptor(data["statement_descriptor"]);
        if (data["statement_descriptor_phone"])
            this.setStatementDescriptorPhone(data["statement_descriptor_phone"]);
        if (data["statement_descriptor_city"])
            this.setStatementDescriptorCity(data["statement_descriptor_city"]);
        if (data["statement_descriptor_company"])
            this.setStatementDescriptorCompany(data["statement_descriptor_company"]);
        if (data["statement_descriptor_url"])
            this.setStatementDescriptorUrl(data["statement_descriptor_url"]);
        if (data["metadata"])
            this.setMetadata(data["metadata"]);
        if (data["gateway_data"])
            this.setGatewayData(data["gateway_data"]);
        if (data["return_url"])
            this.setReturnUrl(data["return_url"]);
        if (data["cancel_url"])
            this.setCancelUrl(data["cancel_url"]);
        if (data["webhook_url"])
            this.setWebhookUrl(data["webhook_url"]);
        if (data["require_backend_capture"])
            this.setRequireBackendCapture(data["require_backend_capture"]);
        if (data["sandbox"])
            this.setSandbox(data["sandbox"]);
        if (data["created_at"])
            this.setCreatedAt(data["created_at"]);
        if (data["expires_at"])
            this.setExpiresAt(data["expires_at"]);
        if (data["risk"])
            this.setRisk(data["risk"]);
        if (data["shipping"])
            this.setShipping(data["shipping"]);
        if (data["device"])
            this.setDevice(data["device"]);
        if (data["external_fraud_tools"])
            this.setExternalFraudTools(data["external_fraud_tools"]);
        if (data["exemption_reason_3ds2"])
            this.setExemptionReason3ds2(data["exemption_reason_3ds2"]);
        if (data["sca_exemption_reason"])
            this.setScaExemptionReason(data["sca_exemption_reason"]);
        if (data["challenge_indicator"])
            this.setChallengeIndicator(data["challenge_indicator"]);
        if (data["incremental"])
            this.setIncremental(data["incremental"]);
        if (data["tax"])
            this.setTax(data["tax"]);
        if (data["payment_type"])
            this.setPaymentType(data["payment_type"]);
        if (data["native_apm"])
            this.setNativeApm(data["native_apm"]);
        if (data["initiation_type"])
            this.setInitiationType(data["initiation_type"]);
        if (data["payment_intent"])
            this.setPaymentIntent(data["payment_intent"]);
        if (data["billing"])
            this.setBilling(data["billing"]);
        if (data["unsupported_feature_bypass"])
            this.setUnsupportedFeatureBypass(data["unsupported_feature_bypass"]);
        if (data["verification"])
            this.setVerification(data["verification"]);
        if (data["auto_capture_at"])
            this.setAutoCaptureAt(data["auto_capture_at"]);
        return this;
    }

    /**
     * Implements a JSON custom marshaller
     * @return {any}
     */
    public toJSON(): any {
        return {
            "id": this.getId(),
            "project": this.getProject(),
            "project_id": this.getProjectId(),
            "transaction": this.getTransaction(),
            "transaction_id": this.getTransactionId(),
            "customer": this.getCustomer(),
            "customer_id": this.getCustomerId(),
            "subscription": this.getSubscription(),
            "subscription_id": this.getSubscriptionId(),
            "token": this.getToken(),
            "token_id": this.getTokenId(),
            "details": this.getDetails(),
            "submerchant": this.getSubmerchant(),
            "url": this.getUrl(),
            "url_qrcode": this.getUrlQrcode(),
            "name": this.getName(),
            "order_id": this.getOrderId(),
            "amount": this.getAmount(),
            "currency": this.getCurrency(),
            "merchant_initiator_type": this.getMerchantInitiatorType(),
            "statement_descriptor": this.getStatementDescriptor(),
            "statement_descriptor_phone": this.getStatementDescriptorPhone(),
            "statement_descriptor_city": this.getStatementDescriptorCity(),
            "statement_descriptor_company": this.getStatementDescriptorCompany(),
            "statement_descriptor_url": this.getStatementDescriptorUrl(),
            "metadata": this.getMetadata(),
            "gateway_data": this.getGatewayData(),
            "return_url": this.getReturnUrl(),
            "cancel_url": this.getCancelUrl(),
            "webhook_url": this.getWebhookUrl(),
            "require_backend_capture": this.getRequireBackendCapture(),
            "sandbox": this.getSandbox(),
            "created_at": this.getCreatedAt(),
            "expires_at": this.getExpiresAt(),
            "risk": this.getRisk(),
            "shipping": this.getShipping(),
            "device": this.getDevice(),
            "external_fraud_tools": this.getExternalFraudTools(),
            "exemption_reason_3ds2": this.getExemptionReason3ds2(),
            "sca_exemption_reason": this.getScaExemptionReason(),
            "challenge_indicator": this.getChallengeIndicator(),
            "incremental": this.getIncremental(),
            "tax": this.getTax(),
            "payment_type": this.getPaymentType(),
            "native_apm": this.getNativeApm(),
            "initiation_type": this.getInitiationType(),
            "payment_intent": this.getPaymentIntent(),
            "billing": this.getBilling(),
            "unsupported_feature_bypass": this.getUnsupportedFeatureBypass(),
            "verification": this.getVerification(),
            "auto_capture_at": this.getAutoCaptureAt(),
        };
    }

    /**
     * Create an incremental authorization
	 * @param string amount
     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    public incrementAuthorization(amount: string, options): Promise<p.Transaction> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(this.getId()) + "/increment_authorization";

        var data = {
			'metadata': (options['metadata']) ? options['metadata'] : null, 
			'amount': amount
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['transaction'];
                var obj0 = cur.client.newTransaction();
                returnValues.push(obj0.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.post(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Authorize the invoice using the given source (customer or token)
	 * @param string source
     * @param {any} options
     * @return {Promise<any>}
     */
    public authorize(source: string, options): Promise<any> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(this.getId()) + "/authorize";

        var data = {
			'device': this.getDevice(), 
			'incremental': this.getIncremental(), 
			'synchronous': (options['synchronous']) ? options['synchronous'] : null, 
			'retry_drop_liability_shift': (options['retry_drop_liability_shift']) ? options['retry_drop_liability_shift'] : null, 
			'capture_amount': (options['capture_amount']) ? options['capture_amount'] : null, 
			'enable_three_d_s_2': (options['enable_three_d_s_2']) ? options['enable_three_d_s_2'] : null, 
			'allow_fallback_to_sale': (options['allow_fallback_to_sale']) ? options['allow_fallback_to_sale'] : null, 
			'auto_capture_at': (options['auto_capture_at']) ? options['auto_capture_at'] : null, 
			'metadata': (options['metadata']) ? options['metadata'] : null, 
			'override_mac_blocking': (options['override_mac_blocking']) ? options['override_mac_blocking'] : null, 
			'external_three_d_s': (options['external_three_d_s']) ? options['external_three_d_s'] : null, 
			'save_source': (options['save_source']) ? options['save_source'] : null, 
			'source': source
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['transaction'];
                var obj0 = cur.client.newTransaction();
                returnValues.push(obj0.fillWithData(body));
                var body = respBody;
                body = body['customer_action'];
                if (typeof body !== 'undefined') {
                    var obj1 = cur.client.newCustomerAction();
                    var obj1Filled = obj1.fillWithData(body);
                    returnValues[0].customerAction = obj1Filled;
                }

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.post(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Capture the invoice using the given source (customer or token)
	 * @param string source
     * @param {any} options
     * @return {Promise<any>}
     */
    public capture(source: string, options): Promise<any> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(this.getId()) + "/capture";

        var data = {
			'device': this.getDevice(), 
			'incremental': this.getIncremental(), 
			'authorize_only': (options['authorize_only']) ? options['authorize_only'] : null, 
			'synchronous': (options['synchronous']) ? options['synchronous'] : null, 
			'retry_drop_liability_shift': (options['retry_drop_liability_shift']) ? options['retry_drop_liability_shift'] : null, 
			'capture_amount': (options['capture_amount']) ? options['capture_amount'] : null, 
			'auto_capture_at': (options['auto_capture_at']) ? options['auto_capture_at'] : null, 
			'enable_three_d_s_2': (options['enable_three_d_s_2']) ? options['enable_three_d_s_2'] : null, 
			'metadata': (options['metadata']) ? options['metadata'] : null, 
			'capture_statement_descriptor': (options['capture_statement_descriptor']) ? options['capture_statement_descriptor'] : null, 
			'override_mac_blocking': (options['override_mac_blocking']) ? options['override_mac_blocking'] : null, 
			'external_three_d_s': (options['external_three_d_s']) ? options['external_three_d_s'] : null, 
			'save_source': (options['save_source']) ? options['save_source'] : null, 
			'source': source
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['transaction'];
                var obj0 = cur.client.newTransaction();
                returnValues.push(obj0.fillWithData(body));
                var body = respBody;
                body = body['customer_action'];
                if (typeof body !== 'undefined') {
                    var obj1 = cur.client.newCustomerAction();
                    var obj1Filled = obj1.fillWithData(body);
                    returnValues[0].customerAction = obj1Filled;
                }

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.post(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Get the customer linked to the invoice.

     * @param {any} options
     * @return {Promise<p.Customer>}
     */
    public fetchCustomer(options): Promise<p.Customer> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(this.getId()) + "/customers";

        var data = {

        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['customer'];
                var obj0 = cur.client.newCustomer();
                returnValues.push(obj0.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.get(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Assign a customer to the invoice.
	 * @param string customerId
     * @param {any} options
     * @return {Promise<p.Customer>}
     */
    public assignCustomer(customerId: string, options): Promise<p.Customer> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(this.getId()) + "/customers";

        var data = {
			'customer_id': customerId
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['customer'];
                var obj0 = cur.client.newCustomer();
                returnValues.push(obj0.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.post(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Process the payout invoice using the given source (customer or token)
	 * @param string gatewayConfigurationId
	 * @param string source
     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    public payout(gatewayConfigurationId: string, source: string, options): Promise<p.Transaction> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(this.getId()) + "/payout";

        var data = {
			'force_gateway_configuration_id': (options['force_gateway_configuration_id']) ? options['force_gateway_configuration_id'] : null, 
			'gateway_configuration_id': gatewayConfigurationId, 
			'source': source
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['transaction'];
                var obj0 = cur.client.newTransaction();
                returnValues.push(obj0.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.post(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Fetches the Native APM payment
	 * @param string invoiceId
	 * @param string gatewayConfigurationId
     * @param {any} options
     * @return {Promise<p.NativeAPMTransactionDetails>}
     */
    public showNativePaymentTransaction(invoiceId: string, gatewayConfigurationId: string, options): Promise<p.NativeAPMTransactionDetails> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(invoiceId) + "/native-payment/" + encodeURI(gatewayConfigurationId) + "";

        var data = {

        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['native_apm'];
                var obj0 = cur.client.newNativeAPMTransactionDetails();
                returnValues.push(obj0.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.get(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Process the Native APM payment flow
	 * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    public processNativePayment(invoiceId: string, options): Promise<any> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(invoiceId) + "/native-payment";

        var data = {
			'gateway_configuration_id': (options['gateway_configuration_id']) ? options['gateway_configuration_id'] : null, 
			'native_apm': (options['native_apm']) ? options['native_apm'] : null
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['transaction'];
                var obj0 = cur.client.newTransaction();
                returnValues.push(obj0.fillWithData(body));
                var body = respBody;
                body = body['native_apm'];
                if (typeof body !== 'undefined') {
                    var obj1 = cur.client.newNativeAPMResponse();
                    var obj1Filled = obj1.fillWithData(body);
                    returnValues[0].nativeApm = obj1Filled;
                }

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.post(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Initiate a 3-D Secure authentication
	 * @param string source
     * @param {any} options
     * @return {Promise<p.CustomerAction>}
     */
    public initiateThreeDS(source: string, options): Promise<p.CustomerAction> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(this.getId()) + "/three-d-s";

        var data = {
			'enable_three_d_s_2': (options['enable_three_d_s_2']) ? options['enable_three_d_s_2'] : null, 
			'source': source
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['customer_action'];
                var obj0 = cur.client.newCustomerAction();
                returnValues.push(obj0.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.post(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Get the transaction of the invoice.

     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    public fetchTransaction(options): Promise<p.Transaction> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(this.getId()) + "/transactions";

        var data = {

        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['transaction'];
                var obj0 = cur.client.newTransaction();
                returnValues.push(obj0.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.get(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Void the invoice

     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    public void(options): Promise<p.Transaction> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(this.getId()) + "/void";

        var data = {
			'metadata': (options['metadata']) ? options['metadata'] : null, 
			'amount': (options['amount']) ? options['amount'] : null
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['transaction'];
                var obj0 = cur.client.newTransaction();
                returnValues.push(obj0.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.post(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Get all the invoices.
     * 
     * @param {any} options
     * @return {Promise<any>}
     */
    public all(options): Promise<any> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices";

        var data = {

        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var a    = [];
                var body = respBody['invoices'];
                for (var i = body.length; i--;) {
                    var tmp = cur.client.newInvoice();
                    tmp.fillWithData(body[i]);
                    a.push(tmp);
                }

                returnValues.push(a);
                    

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.get(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Create a new invoice.
     * 
     * @param {any} options
     * @return {Promise<any>}
     */
    public create(options): Promise<any> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices";

        var data = {
			'customer_id': this.getCustomerId(), 
			'name': this.getName(), 
			'order_id': this.getOrderId(), 
			'amount': this.getAmount(), 
			'currency': this.getCurrency(), 
			'metadata': this.getMetadata(), 
			'details': this.getDetails(), 
			'submerchant': this.getSubmerchant(), 
			'exemption_reason_3ds2': this.getExemptionReason3ds2(), 
			'sca_exemption_reason': this.getScaExemptionReason(), 
			'challenge_indicator': this.getChallengeIndicator(), 
			'gateway_data': this.getGatewayData(), 
			'merchant_initiator_type': this.getMerchantInitiatorType(), 
			'initiation_type': this.getInitiationType(), 
			'payment_intent': this.getPaymentIntent(), 
			'statement_descriptor': this.getStatementDescriptor(), 
			'statement_descriptor_phone': this.getStatementDescriptorPhone(), 
			'statement_descriptor_city': this.getStatementDescriptorCity(), 
			'statement_descriptor_company': this.getStatementDescriptorCompany(), 
			'statement_descriptor_url': this.getStatementDescriptorUrl(), 
			'return_url': this.getReturnUrl(), 
			'cancel_url': this.getCancelUrl(), 
			'webhook_url': this.getWebhookUrl(), 
			'risk': this.getRisk(), 
			'shipping': this.getShipping(), 
			'device': this.getDevice(), 
			'require_backend_capture': this.getRequireBackendCapture(), 
			'external_fraud_tools': this.getExternalFraudTools(), 
			'tax': this.getTax(), 
			'payment_type': this.getPaymentType(), 
			'billing': this.getBilling(), 
			'unsupported_feature_bypass': this.getUnsupportedFeatureBypass(), 
			'verification': this.getVerification(), 
			'auto_capture_at': this.getAutoCaptureAt(), 
			'expires_at': this.getExpiresAt()
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['invoice'];
                        
                returnValues.push(cur.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.post(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Find an invoice by its ID.
	 * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    public find(invoiceId: string, options): Promise<any> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(invoiceId) + "";

        var data = {

        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['invoice'];
                        
                returnValues.push(cur.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.get(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Delete an invoice by its ID. Only invoices that have not been used yet can be deleted.
	 * @param string invoiceId
     * @param {any} options
     * @return {Promise<boolean>}
     */
    public delete(invoiceId: string, options): Promise<boolean> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(invoiceId) + "";

        var data = {

        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                returnValues.push(response.isSuccess());

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.delete(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Refresh invoice by its ID with PSP.
	 * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    public syncWithPsp(invoiceId: string, options): Promise<any> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(invoiceId) + "/sync-with-psp";

        var data = {

        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['invoice'];
                        
                returnValues.push(cur.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.put(path, data, options).then(callback, callbackError);
            });
    }
    /**
     * Update invoice by its ID.
	 * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    public update(invoiceId: string, options): Promise<any> {
        if (!options) options = {};
        this.fillWithData(options);

        var request = new Request(this.client);
        var path    = "/invoices/" + encodeURI(invoiceId) + "";

        var data = {
			'amount': this.getAmount(), 
			'tax': this.getTax(), 
			'details': this.getDetails(), 
			'shipping': this.getShipping()
        };

        var cur = this;
        return new Promise(function(resolve, reject) {
            var callback = async function(resp: fetch.Response) {
                var respBody = {};
                try {
                    respBody = await resp.json();
                } catch(err) {}

                var response = new Response(resp, respBody);
                var err = response.check();
                if (err != null)
                    return reject(err);

                var returnValues = [];

                
                var body = respBody;
                body = body['invoice'];
                        
                returnValues.push(cur.fillWithData(body));

                return resolve.apply(this, returnValues);
            };
            var callbackError = function(err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };

            request.put(path, data, options).then(callback, callbackError);
            });
    }
    
}
export = Invoice;
