"use strict";
// The content of this file was automatically generated
var TransactionOperation = /** @class */ (function () {
    /**
     * TransactionOperation constructor
     * @param {ProcessOut} client
     * @param {array} prefill (optional)
     */
    function TransactionOperation(client, prefill) {
        this.client = null;
        /**
         * ID of the transaction operation
         * @type {string}
         */
        this.id = null;
        /**
         * Transaction to which the operation belongs
         * @type {p.Transaction}
         */
        this.transaction = null;
        /**
         * ID of the transaction to which the operation belongs
         * @type {string}
         */
        this.transactionId = null;
        /**
         * Token that was used by the operation, if any
         * @type {p.Token}
         */
        this.token = null;
        /**
         * ID of the token was used by the operation, if any
         * @type {string}
         */
        this.tokenId = null;
        /**
         * Card that was used by the operation, if any
         * @type {p.Card}
         */
        this.card = null;
        /**
         * ID of the card that was used by the operation, if any
         * @type {string}
         */
        this.cardId = null;
        /**
         * Gateway configuration that was used to process the operation
         * @type {p.GatewayConfiguration}
         */
        this.gatewayConfiguration = null;
        /**
         * ID of the gateway configuration that was used to process the operation
         * @type {string}
         */
        this.gatewayConfigurationId = null;
        /**
         * Amount of the operation
         * @type {string}
         */
        this.amount = null;
        /**
         * Currency of the operation
         * @type {string}
         */
        this.currency = null;
        /**
         * True if the operation is an attempt, false otherwise
         * @type {boolean}
         */
        this.isAttempt = null;
        /**
         * True if the operation has failed, false otherwise
         * @type {boolean}
         */
        this.hasFailed = null;
        /**
         * True if the operation amount can be accounted for, false otherwise
         * @type {boolean}
         */
        this.isAccountable = null;
        /**
         * Type of the operation, such as authorization, capture, refund or void
         * @type {string}
         */
        this.type = null;
        /**
         * ID of the operation done through the PSP
         * @type {string}
         */
        this.gatewayOperationId = null;
        /**
         * Acquirer Routing Number, can be used to track a payment or refund at the issuer
         * @type {string}
         */
        this.arn = null;
        /**
         * Error code returned when attempting the operation, if any
         * @type {string}
         */
        this.errorCode = null;
        /**
         * Error message returned when attempting the operation, if any
         * @type {string}
         */
        this.errorMessage = null;
        /**
         * Additionnal context saved when processing the transaction on the specific PSP
         * @type {any}
         */
        this.gatewayData = null;
        /**
         * ThreeDS request payment data (read-only)
         * @type {p.PaymentDataThreeDSRequest}
         */
        this.paymentDataThreeDSRequest = null;
        /**
         * 3-D Secure authentication payment data (read-only)
         * @type {p.PaymentDataThreeDSAuthentication}
         */
        this.paymentDataThreeDSAuthentication = null;
        /**
         * Network authentication payment data (read-only)
         * @type {p.PaymentDataNetworkAuthentication}
         */
        this.paymentDataNetworkAuthentication = null;
        /**
         * Initial scheme ID that was referenced in the request
         * @type {string}
         */
        this.initialSchemeTransactionId = null;
        /**
         * The ID assigned to the transaction by the scheme in the last successful authorization
         * @type {string}
         */
        this.schemeId = null;
        /**
         * Indicates whether the transaction was processed with a network token instead of raw card details
         * @type {boolean}
         */
        this.processedWithNetworkToken = null;
        /**
         * Payment type of the transaction
         * @type {string}
         */
        this.paymentType = null;
        /**
         * Metadata related to the operation, in the form of a dictionary (key-value pair)
         * @type {any}
         */
        this.metadata = null;
        /**
         * Gateway fee generated by the operation
         * @type {string}
         */
        this.gatewayFee = null;
        /**
         * Date at which the operation was created
         * @type {string}
         */
        this.createdAt = null;
        if (typeof client === 'undefined')
            throw new Error("The TransactionOperation object must be instanciated with the ProcessOut client. You can create one using new ProcessOut('project-id', 'project-secret').newTransactionOperation()");
        this.client = client;
        if (typeof prefill !== 'undefined')
            this.fillWithData(prefill);
    }
    TransactionOperation.prototype.getProcessOutObjectClass = function () {
        return "TransactionOperation";
    };
    /**
     * Get Id
     * ID of the transaction operation
     * @return {string}
     */
    TransactionOperation.prototype.getId = function () {
        return this.id;
    };
    /**
     * Set Id
     * ID of the transaction operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setId = function (val) {
        this.id = val;
        return this;
    };
    /**
     * Get Transaction
     * Transaction to which the operation belongs
     * @return {p.Transaction}
     */
    TransactionOperation.prototype.getTransaction = function () {
        return this.transaction;
    };
    /**
     * Set Transaction
     * Transaction to which the operation belongs
     * @param {p.Transaction} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setTransaction = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newTransaction().getProcessOutObjectClass())
            this.transaction = val;
        else {
            var obj = this.client.newTransaction();
            obj.fillWithData(val);
            this.transaction = obj;
        }
        return this;
    };
    /**
     * Get TransactionId
     * ID of the transaction to which the operation belongs
     * @return {string}
     */
    TransactionOperation.prototype.getTransactionId = function () {
        return this.transactionId;
    };
    /**
     * Set TransactionId
     * ID of the transaction to which the operation belongs
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setTransactionId = function (val) {
        this.transactionId = val;
        return this;
    };
    /**
     * Get Token
     * Token that was used by the operation, if any
     * @return {p.Token}
     */
    TransactionOperation.prototype.getToken = function () {
        return this.token;
    };
    /**
     * Set Token
     * Token that was used by the operation, if any
     * @param {p.Token} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setToken = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newToken().getProcessOutObjectClass())
            this.token = val;
        else {
            var obj = this.client.newToken();
            obj.fillWithData(val);
            this.token = obj;
        }
        return this;
    };
    /**
     * Get TokenId
     * ID of the token was used by the operation, if any
     * @return {string}
     */
    TransactionOperation.prototype.getTokenId = function () {
        return this.tokenId;
    };
    /**
     * Set TokenId
     * ID of the token was used by the operation, if any
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setTokenId = function (val) {
        this.tokenId = val;
        return this;
    };
    /**
     * Get Card
     * Card that was used by the operation, if any
     * @return {p.Card}
     */
    TransactionOperation.prototype.getCard = function () {
        return this.card;
    };
    /**
     * Set Card
     * Card that was used by the operation, if any
     * @param {p.Card} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setCard = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newCard().getProcessOutObjectClass())
            this.card = val;
        else {
            var obj = this.client.newCard();
            obj.fillWithData(val);
            this.card = obj;
        }
        return this;
    };
    /**
     * Get CardId
     * ID of the card that was used by the operation, if any
     * @return {string}
     */
    TransactionOperation.prototype.getCardId = function () {
        return this.cardId;
    };
    /**
     * Set CardId
     * ID of the card that was used by the operation, if any
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setCardId = function (val) {
        this.cardId = val;
        return this;
    };
    /**
     * Get GatewayConfiguration
     * Gateway configuration that was used to process the operation
     * @return {p.GatewayConfiguration}
     */
    TransactionOperation.prototype.getGatewayConfiguration = function () {
        return this.gatewayConfiguration;
    };
    /**
     * Set GatewayConfiguration
     * Gateway configuration that was used to process the operation
     * @param {p.GatewayConfiguration} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setGatewayConfiguration = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newGatewayConfiguration().getProcessOutObjectClass())
            this.gatewayConfiguration = val;
        else {
            var obj = this.client.newGatewayConfiguration();
            obj.fillWithData(val);
            this.gatewayConfiguration = obj;
        }
        return this;
    };
    /**
     * Get GatewayConfigurationId
     * ID of the gateway configuration that was used to process the operation
     * @return {string}
     */
    TransactionOperation.prototype.getGatewayConfigurationId = function () {
        return this.gatewayConfigurationId;
    };
    /**
     * Set GatewayConfigurationId
     * ID of the gateway configuration that was used to process the operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setGatewayConfigurationId = function (val) {
        this.gatewayConfigurationId = val;
        return this;
    };
    /**
     * Get Amount
     * Amount of the operation
     * @return {string}
     */
    TransactionOperation.prototype.getAmount = function () {
        return this.amount;
    };
    /**
     * Set Amount
     * Amount of the operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setAmount = function (val) {
        this.amount = val;
        return this;
    };
    /**
     * Get Currency
     * Currency of the operation
     * @return {string}
     */
    TransactionOperation.prototype.getCurrency = function () {
        return this.currency;
    };
    /**
     * Set Currency
     * Currency of the operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setCurrency = function (val) {
        this.currency = val;
        return this;
    };
    /**
     * Get IsAttempt
     * True if the operation is an attempt, false otherwise
     * @return {boolean}
     */
    TransactionOperation.prototype.getIsAttempt = function () {
        return this.isAttempt;
    };
    /**
     * Set IsAttempt
     * True if the operation is an attempt, false otherwise
     * @param {boolean} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setIsAttempt = function (val) {
        this.isAttempt = val;
        return this;
    };
    /**
     * Get HasFailed
     * True if the operation has failed, false otherwise
     * @return {boolean}
     */
    TransactionOperation.prototype.getHasFailed = function () {
        return this.hasFailed;
    };
    /**
     * Set HasFailed
     * True if the operation has failed, false otherwise
     * @param {boolean} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setHasFailed = function (val) {
        this.hasFailed = val;
        return this;
    };
    /**
     * Get IsAccountable
     * True if the operation amount can be accounted for, false otherwise
     * @return {boolean}
     */
    TransactionOperation.prototype.getIsAccountable = function () {
        return this.isAccountable;
    };
    /**
     * Set IsAccountable
     * True if the operation amount can be accounted for, false otherwise
     * @param {boolean} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setIsAccountable = function (val) {
        this.isAccountable = val;
        return this;
    };
    /**
     * Get Type
     * Type of the operation, such as authorization, capture, refund or void
     * @return {string}
     */
    TransactionOperation.prototype.getType = function () {
        return this.type;
    };
    /**
     * Set Type
     * Type of the operation, such as authorization, capture, refund or void
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setType = function (val) {
        this.type = val;
        return this;
    };
    /**
     * Get GatewayOperationId
     * ID of the operation done through the PSP
     * @return {string}
     */
    TransactionOperation.prototype.getGatewayOperationId = function () {
        return this.gatewayOperationId;
    };
    /**
     * Set GatewayOperationId
     * ID of the operation done through the PSP
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setGatewayOperationId = function (val) {
        this.gatewayOperationId = val;
        return this;
    };
    /**
     * Get Arn
     * Acquirer Routing Number, can be used to track a payment or refund at the issuer
     * @return {string}
     */
    TransactionOperation.prototype.getArn = function () {
        return this.arn;
    };
    /**
     * Set Arn
     * Acquirer Routing Number, can be used to track a payment or refund at the issuer
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setArn = function (val) {
        this.arn = val;
        return this;
    };
    /**
     * Get ErrorCode
     * Error code returned when attempting the operation, if any
     * @return {string}
     */
    TransactionOperation.prototype.getErrorCode = function () {
        return this.errorCode;
    };
    /**
     * Set ErrorCode
     * Error code returned when attempting the operation, if any
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setErrorCode = function (val) {
        this.errorCode = val;
        return this;
    };
    /**
     * Get ErrorMessage
     * Error message returned when attempting the operation, if any
     * @return {string}
     */
    TransactionOperation.prototype.getErrorMessage = function () {
        return this.errorMessage;
    };
    /**
     * Set ErrorMessage
     * Error message returned when attempting the operation, if any
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setErrorMessage = function (val) {
        this.errorMessage = val;
        return this;
    };
    /**
     * Get GatewayData
     * Additionnal context saved when processing the transaction on the specific PSP
     * @return {any}
     */
    TransactionOperation.prototype.getGatewayData = function () {
        return this.gatewayData;
    };
    /**
     * Set GatewayData
     * Additionnal context saved when processing the transaction on the specific PSP
     * @param {any} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setGatewayData = function (val) {
        this.gatewayData = val;
        return this;
    };
    /**
     * Get PaymentDataThreeDSRequest
     * ThreeDS request payment data (read-only)
     * @return {p.PaymentDataThreeDSRequest}
     */
    TransactionOperation.prototype.getPaymentDataThreeDSRequest = function () {
        return this.paymentDataThreeDSRequest;
    };
    /**
     * Set PaymentDataThreeDSRequest
     * ThreeDS request payment data (read-only)
     * @param {p.PaymentDataThreeDSRequest} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setPaymentDataThreeDSRequest = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newPaymentDataThreeDSRequest().getProcessOutObjectClass())
            this.paymentDataThreeDSRequest = val;
        else {
            var obj = this.client.newPaymentDataThreeDSRequest();
            obj.fillWithData(val);
            this.paymentDataThreeDSRequest = obj;
        }
        return this;
    };
    /**
     * Get PaymentDataThreeDSAuthentication
     * 3-D Secure authentication payment data (read-only)
     * @return {p.PaymentDataThreeDSAuthentication}
     */
    TransactionOperation.prototype.getPaymentDataThreeDSAuthentication = function () {
        return this.paymentDataThreeDSAuthentication;
    };
    /**
     * Set PaymentDataThreeDSAuthentication
     * 3-D Secure authentication payment data (read-only)
     * @param {p.PaymentDataThreeDSAuthentication} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setPaymentDataThreeDSAuthentication = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newPaymentDataThreeDSAuthentication().getProcessOutObjectClass())
            this.paymentDataThreeDSAuthentication = val;
        else {
            var obj = this.client.newPaymentDataThreeDSAuthentication();
            obj.fillWithData(val);
            this.paymentDataThreeDSAuthentication = obj;
        }
        return this;
    };
    /**
     * Get PaymentDataNetworkAuthentication
     * Network authentication payment data (read-only)
     * @return {p.PaymentDataNetworkAuthentication}
     */
    TransactionOperation.prototype.getPaymentDataNetworkAuthentication = function () {
        return this.paymentDataNetworkAuthentication;
    };
    /**
     * Set PaymentDataNetworkAuthentication
     * Network authentication payment data (read-only)
     * @param {p.PaymentDataNetworkAuthentication} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setPaymentDataNetworkAuthentication = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newPaymentDataNetworkAuthentication().getProcessOutObjectClass())
            this.paymentDataNetworkAuthentication = val;
        else {
            var obj = this.client.newPaymentDataNetworkAuthentication();
            obj.fillWithData(val);
            this.paymentDataNetworkAuthentication = obj;
        }
        return this;
    };
    /**
     * Get InitialSchemeTransactionId
     * Initial scheme ID that was referenced in the request
     * @return {string}
     */
    TransactionOperation.prototype.getInitialSchemeTransactionId = function () {
        return this.initialSchemeTransactionId;
    };
    /**
     * Set InitialSchemeTransactionId
     * Initial scheme ID that was referenced in the request
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setInitialSchemeTransactionId = function (val) {
        this.initialSchemeTransactionId = val;
        return this;
    };
    /**
     * Get SchemeId
     * The ID assigned to the transaction by the scheme in the last successful authorization
     * @return {string}
     */
    TransactionOperation.prototype.getSchemeId = function () {
        return this.schemeId;
    };
    /**
     * Set SchemeId
     * The ID assigned to the transaction by the scheme in the last successful authorization
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setSchemeId = function (val) {
        this.schemeId = val;
        return this;
    };
    /**
     * Get ProcessedWithNetworkToken
     * Indicates whether the transaction was processed with a network token instead of raw card details
     * @return {boolean}
     */
    TransactionOperation.prototype.getProcessedWithNetworkToken = function () {
        return this.processedWithNetworkToken;
    };
    /**
     * Set ProcessedWithNetworkToken
     * Indicates whether the transaction was processed with a network token instead of raw card details
     * @param {boolean} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setProcessedWithNetworkToken = function (val) {
        this.processedWithNetworkToken = val;
        return this;
    };
    /**
     * Get PaymentType
     * Payment type of the transaction
     * @return {string}
     */
    TransactionOperation.prototype.getPaymentType = function () {
        return this.paymentType;
    };
    /**
     * Set PaymentType
     * Payment type of the transaction
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setPaymentType = function (val) {
        this.paymentType = val;
        return this;
    };
    /**
     * Get Metadata
     * Metadata related to the operation, in the form of a dictionary (key-value pair)
     * @return {any}
     */
    TransactionOperation.prototype.getMetadata = function () {
        return this.metadata;
    };
    /**
     * Set Metadata
     * Metadata related to the operation, in the form of a dictionary (key-value pair)
     * @param {any} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setMetadata = function (val) {
        this.metadata = val;
        return this;
    };
    /**
     * Get GatewayFee
     * Gateway fee generated by the operation
     * @return {string}
     */
    TransactionOperation.prototype.getGatewayFee = function () {
        return this.gatewayFee;
    };
    /**
     * Set GatewayFee
     * Gateway fee generated by the operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setGatewayFee = function (val) {
        this.gatewayFee = val;
        return this;
    };
    /**
     * Get CreatedAt
     * Date at which the operation was created
     * @return {string}
     */
    TransactionOperation.prototype.getCreatedAt = function () {
        return this.createdAt;
    };
    /**
     * Set CreatedAt
     * Date at which the operation was created
     * @param {string} val
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.setCreatedAt = function (val) {
        this.createdAt = val;
        return this;
    };
    /**
     * Fills the current object with the new values pulled from the data
     * @param  {array} data
     * @return {TransactionOperation}
     */
    TransactionOperation.prototype.fillWithData = function (data) {
        if (data["id"])
            this.setId(data["id"]);
        if (data["transaction"])
            this.setTransaction(data["transaction"]);
        if (data["transaction_id"])
            this.setTransactionId(data["transaction_id"]);
        if (data["token"])
            this.setToken(data["token"]);
        if (data["token_id"])
            this.setTokenId(data["token_id"]);
        if (data["card"])
            this.setCard(data["card"]);
        if (data["card_id"])
            this.setCardId(data["card_id"]);
        if (data["gateway_configuration"])
            this.setGatewayConfiguration(data["gateway_configuration"]);
        if (data["gateway_configuration_id"])
            this.setGatewayConfigurationId(data["gateway_configuration_id"]);
        if (data["amount"])
            this.setAmount(data["amount"]);
        if (data["currency"])
            this.setCurrency(data["currency"]);
        if (data["is_attempt"])
            this.setIsAttempt(data["is_attempt"]);
        if (data["has_failed"])
            this.setHasFailed(data["has_failed"]);
        if (data["is_accountable"])
            this.setIsAccountable(data["is_accountable"]);
        if (data["type"])
            this.setType(data["type"]);
        if (data["gateway_operation_id"])
            this.setGatewayOperationId(data["gateway_operation_id"]);
        if (data["arn"])
            this.setArn(data["arn"]);
        if (data["error_code"])
            this.setErrorCode(data["error_code"]);
        if (data["error_message"])
            this.setErrorMessage(data["error_message"]);
        if (data["gateway_data"])
            this.setGatewayData(data["gateway_data"]);
        if (data["payment_data_three_d_s_request"])
            this.setPaymentDataThreeDSRequest(data["payment_data_three_d_s_request"]);
        if (data["payment_data_three_d_s_authentication"])
            this.setPaymentDataThreeDSAuthentication(data["payment_data_three_d_s_authentication"]);
        if (data["payment_data_network_authentication"])
            this.setPaymentDataNetworkAuthentication(data["payment_data_network_authentication"]);
        if (data["initial_scheme_transaction_id"])
            this.setInitialSchemeTransactionId(data["initial_scheme_transaction_id"]);
        if (data["scheme_id"])
            this.setSchemeId(data["scheme_id"]);
        if (data["processed_with_network_token"])
            this.setProcessedWithNetworkToken(data["processed_with_network_token"]);
        if (data["payment_type"])
            this.setPaymentType(data["payment_type"]);
        if (data["metadata"])
            this.setMetadata(data["metadata"]);
        if (data["gateway_fee"])
            this.setGatewayFee(data["gateway_fee"]);
        if (data["created_at"])
            this.setCreatedAt(data["created_at"]);
        return this;
    };
    /**
     * Implements a JSON custom marshaller
     * @return {any}
     */
    TransactionOperation.prototype.toJSON = function () {
        return {
            "id": this.getId(),
            "transaction": this.getTransaction(),
            "transaction_id": this.getTransactionId(),
            "token": this.getToken(),
            "token_id": this.getTokenId(),
            "card": this.getCard(),
            "card_id": this.getCardId(),
            "gateway_configuration": this.getGatewayConfiguration(),
            "gateway_configuration_id": this.getGatewayConfigurationId(),
            "amount": this.getAmount(),
            "currency": this.getCurrency(),
            "is_attempt": this.getIsAttempt(),
            "has_failed": this.getHasFailed(),
            "is_accountable": this.getIsAccountable(),
            "type": this.getType(),
            "gateway_operation_id": this.getGatewayOperationId(),
            "arn": this.getArn(),
            "error_code": this.getErrorCode(),
            "error_message": this.getErrorMessage(),
            "gateway_data": this.getGatewayData(),
            "payment_data_three_d_s_request": this.getPaymentDataThreeDSRequest(),
            "payment_data_three_d_s_authentication": this.getPaymentDataThreeDSAuthentication(),
            "payment_data_network_authentication": this.getPaymentDataNetworkAuthentication(),
            "initial_scheme_transaction_id": this.getInitialSchemeTransactionId(),
            "scheme_id": this.getSchemeId(),
            "processed_with_network_token": this.getProcessedWithNetworkToken(),
            "payment_type": this.getPaymentType(),
            "metadata": this.getMetadata(),
            "gateway_fee": this.getGatewayFee(),
            "created_at": this.getCreatedAt(),
        };
    };
    return TransactionOperation;
}());
module.exports = TransactionOperation;
//# sourceMappingURL=transactionoperation.js.map