import ProcessOut = require('./processout');
import * as p from '.';
declare class TransactionOperation {
    private client;
    /**
     * ID of the transaction operation
     * @type {string}
     */
    private id;
    /**
     * Transaction to which the operation belongs
     * @type {p.Transaction}
     */
    private transaction;
    /**
     * ID of the transaction to which the operation belongs
     * @type {string}
     */
    private transactionId;
    /**
     * Token that was used by the operation, if any
     * @type {p.Token}
     */
    private token;
    /**
     * ID of the token was used by the operation, if any
     * @type {string}
     */
    private tokenId;
    /**
     * Card that was used by the operation, if any
     * @type {p.Card}
     */
    private card;
    /**
     * ID of the card that was used by the operation, if any
     * @type {string}
     */
    private cardId;
    /**
     * Gateway configuration that was used to process the operation
     * @type {p.GatewayConfiguration}
     */
    private gatewayConfiguration;
    /**
     * ID of the gateway configuration that was used to process the operation
     * @type {string}
     */
    private gatewayConfigurationId;
    /**
     * Amount of the operation
     * @type {string}
     */
    private amount;
    /**
     * Currency of the operation
     * @type {string}
     */
    private currency;
    /**
     * True if the operation is an attempt, false otherwise
     * @type {boolean}
     */
    private isAttempt;
    /**
     * True if the operation has failed, false otherwise
     * @type {boolean}
     */
    private hasFailed;
    /**
     * True if the operation amount can be accounted for, false otherwise
     * @type {boolean}
     */
    private isAccountable;
    /**
     * Type of the operation, such as authorization, capture, refund or void
     * @type {string}
     */
    private type;
    /**
     * ID of the operation done through the PSP
     * @type {string}
     */
    private gatewayOperationId;
    /**
     * Acquirer Routing Number, can be used to track a payment or refund at the issuer
     * @type {string}
     */
    private arn;
    /**
     * Error code returned when attempting the operation, if any
     * @type {string}
     */
    private errorCode;
    /**
     * Error message returned when attempting the operation, if any
     * @type {string}
     */
    private errorMessage;
    /**
     * Additionnal context saved when processing the transaction on the specific PSP
     * @type {any}
     */
    private gatewayData;
    /**
     * ThreeDS request payment data (read-only)
     * @type {p.PaymentDataThreeDSRequest}
     */
    private paymentDataThreeDSRequest;
    /**
     * 3-D Secure authentication payment data (read-only)
     * @type {p.PaymentDataThreeDSAuthentication}
     */
    private paymentDataThreeDSAuthentication;
    /**
     * Network authentication payment data (read-only)
     * @type {p.PaymentDataNetworkAuthentication}
     */
    private paymentDataNetworkAuthentication;
    /**
     * Initial scheme ID that was referenced in the request
     * @type {string}
     */
    private initialSchemeTransactionId;
    /**
     * The ID assigned to the transaction by the scheme in the last successful authorization
     * @type {string}
     */
    private schemeId;
    /**
     * Indicates whether the transaction was processed with a network token instead of raw card details
     * @type {boolean}
     */
    private processedWithNetworkToken;
    /**
     * Payment type of the transaction
     * @type {string}
     */
    private paymentType;
    /**
     * Metadata related to the operation, in the form of a dictionary (key-value pair)
     * @type {any}
     */
    private metadata;
    /**
     * Gateway fee generated by the operation
     * @type {string}
     */
    private gatewayFee;
    /**
     * Date at which the operation was created
     * @type {string}
     */
    private createdAt;
    /**
     * TransactionOperation constructor
     * @param {ProcessOut} client
     * @param {array} prefill (optional)
     */
    constructor(client: ProcessOut, prefill: TransactionOperation);
    getProcessOutObjectClass(): string;
    /**
     * Get Id
     * ID of the transaction operation
     * @return {string}
     */
    getId(): string;
    /**
     * Set Id
     * ID of the transaction operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    setId(val: string): TransactionOperation;
    /**
     * Get Transaction
     * Transaction to which the operation belongs
     * @return {p.Transaction}
     */
    getTransaction(): p.Transaction;
    /**
     * Set Transaction
     * Transaction to which the operation belongs
     * @param {p.Transaction} val
     * @return {TransactionOperation}
     */
    setTransaction(val: p.Transaction): TransactionOperation;
    /**
     * Get TransactionId
     * ID of the transaction to which the operation belongs
     * @return {string}
     */
    getTransactionId(): string;
    /**
     * Set TransactionId
     * ID of the transaction to which the operation belongs
     * @param {string} val
     * @return {TransactionOperation}
     */
    setTransactionId(val: string): TransactionOperation;
    /**
     * Get Token
     * Token that was used by the operation, if any
     * @return {p.Token}
     */
    getToken(): p.Token;
    /**
     * Set Token
     * Token that was used by the operation, if any
     * @param {p.Token} val
     * @return {TransactionOperation}
     */
    setToken(val: p.Token): TransactionOperation;
    /**
     * Get TokenId
     * ID of the token was used by the operation, if any
     * @return {string}
     */
    getTokenId(): string;
    /**
     * Set TokenId
     * ID of the token was used by the operation, if any
     * @param {string} val
     * @return {TransactionOperation}
     */
    setTokenId(val: string): TransactionOperation;
    /**
     * Get Card
     * Card that was used by the operation, if any
     * @return {p.Card}
     */
    getCard(): p.Card;
    /**
     * Set Card
     * Card that was used by the operation, if any
     * @param {p.Card} val
     * @return {TransactionOperation}
     */
    setCard(val: p.Card): TransactionOperation;
    /**
     * Get CardId
     * ID of the card that was used by the operation, if any
     * @return {string}
     */
    getCardId(): string;
    /**
     * Set CardId
     * ID of the card that was used by the operation, if any
     * @param {string} val
     * @return {TransactionOperation}
     */
    setCardId(val: string): TransactionOperation;
    /**
     * Get GatewayConfiguration
     * Gateway configuration that was used to process the operation
     * @return {p.GatewayConfiguration}
     */
    getGatewayConfiguration(): p.GatewayConfiguration;
    /**
     * Set GatewayConfiguration
     * Gateway configuration that was used to process the operation
     * @param {p.GatewayConfiguration} val
     * @return {TransactionOperation}
     */
    setGatewayConfiguration(val: p.GatewayConfiguration): TransactionOperation;
    /**
     * Get GatewayConfigurationId
     * ID of the gateway configuration that was used to process the operation
     * @return {string}
     */
    getGatewayConfigurationId(): string;
    /**
     * Set GatewayConfigurationId
     * ID of the gateway configuration that was used to process the operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    setGatewayConfigurationId(val: string): TransactionOperation;
    /**
     * Get Amount
     * Amount of the operation
     * @return {string}
     */
    getAmount(): string;
    /**
     * Set Amount
     * Amount of the operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    setAmount(val: string): TransactionOperation;
    /**
     * Get Currency
     * Currency of the operation
     * @return {string}
     */
    getCurrency(): string;
    /**
     * Set Currency
     * Currency of the operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    setCurrency(val: string): TransactionOperation;
    /**
     * Get IsAttempt
     * True if the operation is an attempt, false otherwise
     * @return {boolean}
     */
    getIsAttempt(): boolean;
    /**
     * Set IsAttempt
     * True if the operation is an attempt, false otherwise
     * @param {boolean} val
     * @return {TransactionOperation}
     */
    setIsAttempt(val: boolean): TransactionOperation;
    /**
     * Get HasFailed
     * True if the operation has failed, false otherwise
     * @return {boolean}
     */
    getHasFailed(): boolean;
    /**
     * Set HasFailed
     * True if the operation has failed, false otherwise
     * @param {boolean} val
     * @return {TransactionOperation}
     */
    setHasFailed(val: boolean): TransactionOperation;
    /**
     * Get IsAccountable
     * True if the operation amount can be accounted for, false otherwise
     * @return {boolean}
     */
    getIsAccountable(): boolean;
    /**
     * Set IsAccountable
     * True if the operation amount can be accounted for, false otherwise
     * @param {boolean} val
     * @return {TransactionOperation}
     */
    setIsAccountable(val: boolean): TransactionOperation;
    /**
     * Get Type
     * Type of the operation, such as authorization, capture, refund or void
     * @return {string}
     */
    getType(): string;
    /**
     * Set Type
     * Type of the operation, such as authorization, capture, refund or void
     * @param {string} val
     * @return {TransactionOperation}
     */
    setType(val: string): TransactionOperation;
    /**
     * Get GatewayOperationId
     * ID of the operation done through the PSP
     * @return {string}
     */
    getGatewayOperationId(): string;
    /**
     * Set GatewayOperationId
     * ID of the operation done through the PSP
     * @param {string} val
     * @return {TransactionOperation}
     */
    setGatewayOperationId(val: string): TransactionOperation;
    /**
     * Get Arn
     * Acquirer Routing Number, can be used to track a payment or refund at the issuer
     * @return {string}
     */
    getArn(): string;
    /**
     * Set Arn
     * Acquirer Routing Number, can be used to track a payment or refund at the issuer
     * @param {string} val
     * @return {TransactionOperation}
     */
    setArn(val: string): TransactionOperation;
    /**
     * Get ErrorCode
     * Error code returned when attempting the operation, if any
     * @return {string}
     */
    getErrorCode(): string;
    /**
     * Set ErrorCode
     * Error code returned when attempting the operation, if any
     * @param {string} val
     * @return {TransactionOperation}
     */
    setErrorCode(val: string): TransactionOperation;
    /**
     * Get ErrorMessage
     * Error message returned when attempting the operation, if any
     * @return {string}
     */
    getErrorMessage(): string;
    /**
     * Set ErrorMessage
     * Error message returned when attempting the operation, if any
     * @param {string} val
     * @return {TransactionOperation}
     */
    setErrorMessage(val: string): TransactionOperation;
    /**
     * Get GatewayData
     * Additionnal context saved when processing the transaction on the specific PSP
     * @return {any}
     */
    getGatewayData(): any;
    /**
     * Set GatewayData
     * Additionnal context saved when processing the transaction on the specific PSP
     * @param {any} val
     * @return {TransactionOperation}
     */
    setGatewayData(val: any): TransactionOperation;
    /**
     * Get PaymentDataThreeDSRequest
     * ThreeDS request payment data (read-only)
     * @return {p.PaymentDataThreeDSRequest}
     */
    getPaymentDataThreeDSRequest(): p.PaymentDataThreeDSRequest;
    /**
     * Set PaymentDataThreeDSRequest
     * ThreeDS request payment data (read-only)
     * @param {p.PaymentDataThreeDSRequest} val
     * @return {TransactionOperation}
     */
    setPaymentDataThreeDSRequest(val: p.PaymentDataThreeDSRequest): TransactionOperation;
    /**
     * Get PaymentDataThreeDSAuthentication
     * 3-D Secure authentication payment data (read-only)
     * @return {p.PaymentDataThreeDSAuthentication}
     */
    getPaymentDataThreeDSAuthentication(): p.PaymentDataThreeDSAuthentication;
    /**
     * Set PaymentDataThreeDSAuthentication
     * 3-D Secure authentication payment data (read-only)
     * @param {p.PaymentDataThreeDSAuthentication} val
     * @return {TransactionOperation}
     */
    setPaymentDataThreeDSAuthentication(val: p.PaymentDataThreeDSAuthentication): TransactionOperation;
    /**
     * Get PaymentDataNetworkAuthentication
     * Network authentication payment data (read-only)
     * @return {p.PaymentDataNetworkAuthentication}
     */
    getPaymentDataNetworkAuthentication(): p.PaymentDataNetworkAuthentication;
    /**
     * Set PaymentDataNetworkAuthentication
     * Network authentication payment data (read-only)
     * @param {p.PaymentDataNetworkAuthentication} val
     * @return {TransactionOperation}
     */
    setPaymentDataNetworkAuthentication(val: p.PaymentDataNetworkAuthentication): TransactionOperation;
    /**
     * Get InitialSchemeTransactionId
     * Initial scheme ID that was referenced in the request
     * @return {string}
     */
    getInitialSchemeTransactionId(): string;
    /**
     * Set InitialSchemeTransactionId
     * Initial scheme ID that was referenced in the request
     * @param {string} val
     * @return {TransactionOperation}
     */
    setInitialSchemeTransactionId(val: string): TransactionOperation;
    /**
     * Get SchemeId
     * The ID assigned to the transaction by the scheme in the last successful authorization
     * @return {string}
     */
    getSchemeId(): string;
    /**
     * Set SchemeId
     * The ID assigned to the transaction by the scheme in the last successful authorization
     * @param {string} val
     * @return {TransactionOperation}
     */
    setSchemeId(val: string): TransactionOperation;
    /**
     * Get ProcessedWithNetworkToken
     * Indicates whether the transaction was processed with a network token instead of raw card details
     * @return {boolean}
     */
    getProcessedWithNetworkToken(): boolean;
    /**
     * Set ProcessedWithNetworkToken
     * Indicates whether the transaction was processed with a network token instead of raw card details
     * @param {boolean} val
     * @return {TransactionOperation}
     */
    setProcessedWithNetworkToken(val: boolean): TransactionOperation;
    /**
     * Get PaymentType
     * Payment type of the transaction
     * @return {string}
     */
    getPaymentType(): string;
    /**
     * Set PaymentType
     * Payment type of the transaction
     * @param {string} val
     * @return {TransactionOperation}
     */
    setPaymentType(val: string): TransactionOperation;
    /**
     * Get Metadata
     * Metadata related to the operation, in the form of a dictionary (key-value pair)
     * @return {any}
     */
    getMetadata(): any;
    /**
     * Set Metadata
     * Metadata related to the operation, in the form of a dictionary (key-value pair)
     * @param {any} val
     * @return {TransactionOperation}
     */
    setMetadata(val: any): TransactionOperation;
    /**
     * Get GatewayFee
     * Gateway fee generated by the operation
     * @return {string}
     */
    getGatewayFee(): string;
    /**
     * Set GatewayFee
     * Gateway fee generated by the operation
     * @param {string} val
     * @return {TransactionOperation}
     */
    setGatewayFee(val: string): TransactionOperation;
    /**
     * Get CreatedAt
     * Date at which the operation was created
     * @return {string}
     */
    getCreatedAt(): string;
    /**
     * Set CreatedAt
     * Date at which the operation was created
     * @param {string} val
     * @return {TransactionOperation}
     */
    setCreatedAt(val: string): TransactionOperation;
    /**
     * Fills the current object with the new values pulled from the data
     * @param  {array} data
     * @return {TransactionOperation}
     */
    fillWithData(data: any): TransactionOperation;
    /**
     * Implements a JSON custom marshaller
     * @return {any}
     */
    toJSON(): any;
}
export = TransactionOperation;
//# sourceMappingURL=transactionoperation.d.ts.map