"use strict";
// The content of this file was automatically generated
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var Response = require("./networking/response");
var Request = require("./networking/request");
var ProcessOutNetworkError = require("./errors/processoutnetworkerror");
var Invoice = /** @class */ (function () {
    /**
     * Invoice constructor
     * @param {ProcessOut} client
     * @param {array} prefill (optional)
     */
    function Invoice(client, prefill) {
        this.client = null;
        /**
         * ID of the invoice
         * @type {string}
         */
        this.id = null;
        /**
         * Project to which the invoice belongs
         * @type {p.Project}
         */
        this.project = null;
        /**
         * ID of the project to which the invoice belongs
         * @type {string}
         */
        this.projectId = null;
        /**
         * Transaction generated by the invoice
         * @type {p.Transaction}
         */
        this.transaction = null;
        /**
         * ID of the transaction generated by the invoice
         * @type {string}
         */
        this.transactionId = null;
        /**
         * Customer linked to the invoice, if any
         * @type {p.Customer}
         */
        this.customer = null;
        /**
         * ID of the customer linked to the invoice, if any
         * @type {string}
         */
        this.customerId = null;
        /**
         * Subscription to which the invoice is linked to, if any
         * @type {p.Subscription}
         */
        this.subscription = null;
        /**
         * ID of the subscription to which the invoice is linked to, if any
         * @type {string}
         */
        this.subscriptionId = null;
        /**
         * Token used to pay the invoice, if any
         * @type {p.Token}
         */
        this.token = null;
        /**
         * ID of the token used to pay the invoice, if any
         * @type {string}
         */
        this.tokenId = null;
        /**
         * Details of the invoice
         * @type {any}
         */
        this.details = null;
        /**
         * Submerchant data of the invoice
         * @type {p.InvoiceSubmerchant}
         */
        this.submerchant = null;
        /**
         * URL to which you may redirect your customer to proceed with the payment
         * @type {string}
         */
        this.url = null;
        /**
         * base64-encoded QR code for the invoice URL
         * @type {string}
         */
        this.urlQrcode = null;
        /**
         * Name of the invoice
         * @type {string}
         */
        this.name = null;
        /**
         * ID of the order for this transaction in merchant's system
         * @type {string}
         */
        this.orderId = null;
        /**
         * Amount to be paid
         * @type {string}
         */
        this.amount = null;
        /**
         * Currency of the invoice
         * @type {string}
         */
        this.currency = null;
        /**
         * Type of the transaction initiated by the merchant (off-session). Can be either one-off or recurring, depending on the nature of the merchant initiated transaction.
         * @type {string}
         */
        this.merchantInitiatorType = null;
        /**
         * Statement to be shown on the bank statement of your customer
         * @type {string}
         */
        this.statementDescriptor = null;
        /**
         * Support phone number shown on the customer's bank statement
         * @type {string}
         */
        this.statementDescriptorPhone = null;
        /**
         * City shown on the customer's bank statement
         * @type {string}
         */
        this.statementDescriptorCity = null;
        /**
         * Your company name shown on the customer's bank statement
         * @type {string}
         */
        this.statementDescriptorCompany = null;
        /**
         * URL shown on the customer's bank statement
         * @type {string}
         */
        this.statementDescriptorUrl = null;
        /**
         * Metadata related to the invoice, in the form of a dictionary (key-value pair)
         * @type {any}
         */
        this.metadata = null;
        /**
         * Dictionary that transmit specific informations to gateways (key-value pair)
         * @type {any}
         */
        this.gatewayData = null;
        /**
         * URL where the customer will be redirected upon payment
         * @type {string}
         */
        this.returnUrl = null;
        /**
         * URL where the customer will be redirected if the payment was canceled
         * @type {string}
         */
        this.cancelUrl = null;
        /**
         * Custom webhook URL where updates about this specific payment will be sent, on top of your project-wide URLs
         * @type {string}
         */
        this.webhookUrl = null;
        /**
         * Define whether the invoice can be captured from the front-end or not
         * @type {boolean}
         */
        this.requireBackendCapture = null;
        /**
         * Define whether or not the invoice is in sandbox environment
         * @type {boolean}
         */
        this.sandbox = null;
        /**
         * Date at which the invoice was created
         * @type {string}
         */
        this.createdAt = null;
        /**
         * Date at which the invoice will expire
         * @type {string}
         */
        this.expiresAt = null;
        /**
         * Risk information
         * @type {p.InvoiceRisk}
         */
        this.risk = null;
        /**
         * Shipping information
         * @type {p.InvoiceShipping}
         */
        this.shipping = null;
        /**
         * Device information
         * @type {p.InvoiceDevice}
         */
        this.device = null;
        /**
         * Contain objects that'll be forwarded to external fraud tools
         * @type {p.InvoiceExternalFraudTools}
         */
        this.externalFraudTools = null;
        /**
         * (Deprecated - use sca_exemption_reason) Reason provided to request 3DS2 exemption
         * @type {string}
         */
        this.exemptionReason3ds2 = null;
        /**
         * Reason provided to request SCA exemption
         * @type {string}
         */
        this.scaExemptionReason = null;
        /**
         * Challenge indicator when requesting 3DS2
         * @type {string}
         */
        this.challengeIndicator = null;
        /**
         * A boolean to indicate if an invoice can have incremental authorizations created for it.
         * @type {boolean}
         */
        this.incremental = null;
        /**
         * Tax for an invoice
         * @type {p.InvoiceTax}
         */
        this.tax = null;
        /**
         * Payment type
         * @type {string}
         */
        this.paymentType = null;
        /**
         * Native APM data
         * @type {p.NativeAPMRequest}
         */
        this.nativeApm = null;
        /**
         * Initiation type of invoice
         * @type {string}
         */
        this.initiationType = null;
        /**
         * Payment intent of invoice
         * @type {string}
         */
        this.paymentIntent = null;
        /**
         * Billing information
         * @type {p.InvoiceBilling}
         */
        this.billing = null;
        /**
         * Flags to bypass unsupported features
         * @type {p.UnsupportedFeatureBypass}
         */
        this.unsupportedFeatureBypass = null;
        /**
         * A boolean to indicate if an invoice is a verification invoice. This is used to manually create a verification invoice.
         * @type {boolean}
         */
        this.verification = null;
        /**
         * A timestamp to indicate when an auto capture should take place following an authorization. This takes priority over the value sent in the authorization request.
         * @type {string}
         */
        this.autoCaptureAt = null;
        if (typeof client === 'undefined')
            throw new Error("The Invoice object must be instanciated with the ProcessOut client. You can create one using new ProcessOut('project-id', 'project-secret').newInvoice()");
        this.client = client;
        if (typeof prefill !== 'undefined')
            this.fillWithData(prefill);
    }
    Invoice.prototype.getProcessOutObjectClass = function () {
        return "Invoice";
    };
    /**
     * Get Id
     * ID of the invoice
     * @return {string}
     */
    Invoice.prototype.getId = function () {
        return this.id;
    };
    /**
     * Set Id
     * ID of the invoice
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setId = function (val) {
        this.id = val;
        return this;
    };
    /**
     * Get Project
     * Project to which the invoice belongs
     * @return {p.Project}
     */
    Invoice.prototype.getProject = function () {
        return this.project;
    };
    /**
     * Set Project
     * Project to which the invoice belongs
     * @param {p.Project} val
     * @return {Invoice}
     */
    Invoice.prototype.setProject = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newProject().getProcessOutObjectClass())
            this.project = val;
        else {
            var obj = this.client.newProject();
            obj.fillWithData(val);
            this.project = obj;
        }
        return this;
    };
    /**
     * Get ProjectId
     * ID of the project to which the invoice belongs
     * @return {string}
     */
    Invoice.prototype.getProjectId = function () {
        return this.projectId;
    };
    /**
     * Set ProjectId
     * ID of the project to which the invoice belongs
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setProjectId = function (val) {
        this.projectId = val;
        return this;
    };
    /**
     * Get Transaction
     * Transaction generated by the invoice
     * @return {p.Transaction}
     */
    Invoice.prototype.getTransaction = function () {
        return this.transaction;
    };
    /**
     * Set Transaction
     * Transaction generated by the invoice
     * @param {p.Transaction} val
     * @return {Invoice}
     */
    Invoice.prototype.setTransaction = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newTransaction().getProcessOutObjectClass())
            this.transaction = val;
        else {
            var obj = this.client.newTransaction();
            obj.fillWithData(val);
            this.transaction = obj;
        }
        return this;
    };
    /**
     * Get TransactionId
     * ID of the transaction generated by the invoice
     * @return {string}
     */
    Invoice.prototype.getTransactionId = function () {
        return this.transactionId;
    };
    /**
     * Set TransactionId
     * ID of the transaction generated by the invoice
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setTransactionId = function (val) {
        this.transactionId = val;
        return this;
    };
    /**
     * Get Customer
     * Customer linked to the invoice, if any
     * @return {p.Customer}
     */
    Invoice.prototype.getCustomer = function () {
        return this.customer;
    };
    /**
     * Set Customer
     * Customer linked to the invoice, if any
     * @param {p.Customer} val
     * @return {Invoice}
     */
    Invoice.prototype.setCustomer = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newCustomer().getProcessOutObjectClass())
            this.customer = val;
        else {
            var obj = this.client.newCustomer();
            obj.fillWithData(val);
            this.customer = obj;
        }
        return this;
    };
    /**
     * Get CustomerId
     * ID of the customer linked to the invoice, if any
     * @return {string}
     */
    Invoice.prototype.getCustomerId = function () {
        return this.customerId;
    };
    /**
     * Set CustomerId
     * ID of the customer linked to the invoice, if any
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setCustomerId = function (val) {
        this.customerId = val;
        return this;
    };
    /**
     * Get Subscription
     * Subscription to which the invoice is linked to, if any
     * @return {p.Subscription}
     */
    Invoice.prototype.getSubscription = function () {
        return this.subscription;
    };
    /**
     * Set Subscription
     * Subscription to which the invoice is linked to, if any
     * @param {p.Subscription} val
     * @return {Invoice}
     */
    Invoice.prototype.setSubscription = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newSubscription().getProcessOutObjectClass())
            this.subscription = val;
        else {
            var obj = this.client.newSubscription();
            obj.fillWithData(val);
            this.subscription = obj;
        }
        return this;
    };
    /**
     * Get SubscriptionId
     * ID of the subscription to which the invoice is linked to, if any
     * @return {string}
     */
    Invoice.prototype.getSubscriptionId = function () {
        return this.subscriptionId;
    };
    /**
     * Set SubscriptionId
     * ID of the subscription to which the invoice is linked to, if any
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setSubscriptionId = function (val) {
        this.subscriptionId = val;
        return this;
    };
    /**
     * Get Token
     * Token used to pay the invoice, if any
     * @return {p.Token}
     */
    Invoice.prototype.getToken = function () {
        return this.token;
    };
    /**
     * Set Token
     * Token used to pay the invoice, if any
     * @param {p.Token} val
     * @return {Invoice}
     */
    Invoice.prototype.setToken = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newToken().getProcessOutObjectClass())
            this.token = val;
        else {
            var obj = this.client.newToken();
            obj.fillWithData(val);
            this.token = obj;
        }
        return this;
    };
    /**
     * Get TokenId
     * ID of the token used to pay the invoice, if any
     * @return {string}
     */
    Invoice.prototype.getTokenId = function () {
        return this.tokenId;
    };
    /**
     * Set TokenId
     * ID of the token used to pay the invoice, if any
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setTokenId = function (val) {
        this.tokenId = val;
        return this;
    };
    /**
     * Get Details
     * Details of the invoice
     * @return {any}
     */
    Invoice.prototype.getDetails = function () {
        return this.details;
    };
    /**
     * Set Details
     * Details of the invoice
     * @param {any} val
     * @return {Invoice}
     */
    Invoice.prototype.setDetails = function (val) {
        if (val.length > 0 && typeof val[0] === 'object')
            this.details = val;
        else {
            var a = [];
            for (var i = val.length; i--;) {
                var obj = this.client.newInvoiceDetail();
                obj.fillWithData(val);
                a.push(obj);
            }
            this.details = a;
        }
        return this;
    };
    /**
     * Get Submerchant
     * Submerchant data of the invoice
     * @return {p.InvoiceSubmerchant}
     */
    Invoice.prototype.getSubmerchant = function () {
        return this.submerchant;
    };
    /**
     * Set Submerchant
     * Submerchant data of the invoice
     * @param {p.InvoiceSubmerchant} val
     * @return {Invoice}
     */
    Invoice.prototype.setSubmerchant = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceSubmerchant().getProcessOutObjectClass())
            this.submerchant = val;
        else {
            var obj = this.client.newInvoiceSubmerchant();
            obj.fillWithData(val);
            this.submerchant = obj;
        }
        return this;
    };
    /**
     * Get Url
     * URL to which you may redirect your customer to proceed with the payment
     * @return {string}
     */
    Invoice.prototype.getUrl = function () {
        return this.url;
    };
    /**
     * Set Url
     * URL to which you may redirect your customer to proceed with the payment
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setUrl = function (val) {
        this.url = val;
        return this;
    };
    /**
     * Get UrlQrcode
     * base64-encoded QR code for the invoice URL
     * @return {string}
     */
    Invoice.prototype.getUrlQrcode = function () {
        return this.urlQrcode;
    };
    /**
     * Set UrlQrcode
     * base64-encoded QR code for the invoice URL
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setUrlQrcode = function (val) {
        this.urlQrcode = val;
        return this;
    };
    /**
     * Get Name
     * Name of the invoice
     * @return {string}
     */
    Invoice.prototype.getName = function () {
        return this.name;
    };
    /**
     * Set Name
     * Name of the invoice
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setName = function (val) {
        this.name = val;
        return this;
    };
    /**
     * Get OrderId
     * ID of the order for this transaction in merchant's system
     * @return {string}
     */
    Invoice.prototype.getOrderId = function () {
        return this.orderId;
    };
    /**
     * Set OrderId
     * ID of the order for this transaction in merchant's system
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setOrderId = function (val) {
        this.orderId = val;
        return this;
    };
    /**
     * Get Amount
     * Amount to be paid
     * @return {string}
     */
    Invoice.prototype.getAmount = function () {
        return this.amount;
    };
    /**
     * Set Amount
     * Amount to be paid
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setAmount = function (val) {
        this.amount = val;
        return this;
    };
    /**
     * Get Currency
     * Currency of the invoice
     * @return {string}
     */
    Invoice.prototype.getCurrency = function () {
        return this.currency;
    };
    /**
     * Set Currency
     * Currency of the invoice
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setCurrency = function (val) {
        this.currency = val;
        return this;
    };
    /**
     * Get MerchantInitiatorType
     * Type of the transaction initiated by the merchant (off-session). Can be either one-off or recurring, depending on the nature of the merchant initiated transaction.
     * @return {string}
     */
    Invoice.prototype.getMerchantInitiatorType = function () {
        return this.merchantInitiatorType;
    };
    /**
     * Set MerchantInitiatorType
     * Type of the transaction initiated by the merchant (off-session). Can be either one-off or recurring, depending on the nature of the merchant initiated transaction.
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setMerchantInitiatorType = function (val) {
        this.merchantInitiatorType = val;
        return this;
    };
    /**
     * Get StatementDescriptor
     * Statement to be shown on the bank statement of your customer
     * @return {string}
     */
    Invoice.prototype.getStatementDescriptor = function () {
        return this.statementDescriptor;
    };
    /**
     * Set StatementDescriptor
     * Statement to be shown on the bank statement of your customer
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setStatementDescriptor = function (val) {
        this.statementDescriptor = val;
        return this;
    };
    /**
     * Get StatementDescriptorPhone
     * Support phone number shown on the customer's bank statement
     * @return {string}
     */
    Invoice.prototype.getStatementDescriptorPhone = function () {
        return this.statementDescriptorPhone;
    };
    /**
     * Set StatementDescriptorPhone
     * Support phone number shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setStatementDescriptorPhone = function (val) {
        this.statementDescriptorPhone = val;
        return this;
    };
    /**
     * Get StatementDescriptorCity
     * City shown on the customer's bank statement
     * @return {string}
     */
    Invoice.prototype.getStatementDescriptorCity = function () {
        return this.statementDescriptorCity;
    };
    /**
     * Set StatementDescriptorCity
     * City shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setStatementDescriptorCity = function (val) {
        this.statementDescriptorCity = val;
        return this;
    };
    /**
     * Get StatementDescriptorCompany
     * Your company name shown on the customer's bank statement
     * @return {string}
     */
    Invoice.prototype.getStatementDescriptorCompany = function () {
        return this.statementDescriptorCompany;
    };
    /**
     * Set StatementDescriptorCompany
     * Your company name shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setStatementDescriptorCompany = function (val) {
        this.statementDescriptorCompany = val;
        return this;
    };
    /**
     * Get StatementDescriptorUrl
     * URL shown on the customer's bank statement
     * @return {string}
     */
    Invoice.prototype.getStatementDescriptorUrl = function () {
        return this.statementDescriptorUrl;
    };
    /**
     * Set StatementDescriptorUrl
     * URL shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setStatementDescriptorUrl = function (val) {
        this.statementDescriptorUrl = val;
        return this;
    };
    /**
     * Get Metadata
     * Metadata related to the invoice, in the form of a dictionary (key-value pair)
     * @return {any}
     */
    Invoice.prototype.getMetadata = function () {
        return this.metadata;
    };
    /**
     * Set Metadata
     * Metadata related to the invoice, in the form of a dictionary (key-value pair)
     * @param {any} val
     * @return {Invoice}
     */
    Invoice.prototype.setMetadata = function (val) {
        this.metadata = val;
        return this;
    };
    /**
     * Get GatewayData
     * Dictionary that transmit specific informations to gateways (key-value pair)
     * @return {any}
     */
    Invoice.prototype.getGatewayData = function () {
        return this.gatewayData;
    };
    /**
     * Set GatewayData
     * Dictionary that transmit specific informations to gateways (key-value pair)
     * @param {any} val
     * @return {Invoice}
     */
    Invoice.prototype.setGatewayData = function (val) {
        this.gatewayData = val;
        return this;
    };
    /**
     * Get ReturnUrl
     * URL where the customer will be redirected upon payment
     * @return {string}
     */
    Invoice.prototype.getReturnUrl = function () {
        return this.returnUrl;
    };
    /**
     * Set ReturnUrl
     * URL where the customer will be redirected upon payment
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setReturnUrl = function (val) {
        this.returnUrl = val;
        return this;
    };
    /**
     * Get CancelUrl
     * URL where the customer will be redirected if the payment was canceled
     * @return {string}
     */
    Invoice.prototype.getCancelUrl = function () {
        return this.cancelUrl;
    };
    /**
     * Set CancelUrl
     * URL where the customer will be redirected if the payment was canceled
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setCancelUrl = function (val) {
        this.cancelUrl = val;
        return this;
    };
    /**
     * Get WebhookUrl
     * Custom webhook URL where updates about this specific payment will be sent, on top of your project-wide URLs
     * @return {string}
     */
    Invoice.prototype.getWebhookUrl = function () {
        return this.webhookUrl;
    };
    /**
     * Set WebhookUrl
     * Custom webhook URL where updates about this specific payment will be sent, on top of your project-wide URLs
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setWebhookUrl = function (val) {
        this.webhookUrl = val;
        return this;
    };
    /**
     * Get RequireBackendCapture
     * Define whether the invoice can be captured from the front-end or not
     * @return {boolean}
     */
    Invoice.prototype.getRequireBackendCapture = function () {
        return this.requireBackendCapture;
    };
    /**
     * Set RequireBackendCapture
     * Define whether the invoice can be captured from the front-end or not
     * @param {boolean} val
     * @return {Invoice}
     */
    Invoice.prototype.setRequireBackendCapture = function (val) {
        this.requireBackendCapture = val;
        return this;
    };
    /**
     * Get Sandbox
     * Define whether or not the invoice is in sandbox environment
     * @return {boolean}
     */
    Invoice.prototype.getSandbox = function () {
        return this.sandbox;
    };
    /**
     * Set Sandbox
     * Define whether or not the invoice is in sandbox environment
     * @param {boolean} val
     * @return {Invoice}
     */
    Invoice.prototype.setSandbox = function (val) {
        this.sandbox = val;
        return this;
    };
    /**
     * Get CreatedAt
     * Date at which the invoice was created
     * @return {string}
     */
    Invoice.prototype.getCreatedAt = function () {
        return this.createdAt;
    };
    /**
     * Set CreatedAt
     * Date at which the invoice was created
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setCreatedAt = function (val) {
        this.createdAt = val;
        return this;
    };
    /**
     * Get ExpiresAt
     * Date at which the invoice will expire
     * @return {string}
     */
    Invoice.prototype.getExpiresAt = function () {
        return this.expiresAt;
    };
    /**
     * Set ExpiresAt
     * Date at which the invoice will expire
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setExpiresAt = function (val) {
        this.expiresAt = val;
        return this;
    };
    /**
     * Get Risk
     * Risk information
     * @return {p.InvoiceRisk}
     */
    Invoice.prototype.getRisk = function () {
        return this.risk;
    };
    /**
     * Set Risk
     * Risk information
     * @param {p.InvoiceRisk} val
     * @return {Invoice}
     */
    Invoice.prototype.setRisk = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceRisk().getProcessOutObjectClass())
            this.risk = val;
        else {
            var obj = this.client.newInvoiceRisk();
            obj.fillWithData(val);
            this.risk = obj;
        }
        return this;
    };
    /**
     * Get Shipping
     * Shipping information
     * @return {p.InvoiceShipping}
     */
    Invoice.prototype.getShipping = function () {
        return this.shipping;
    };
    /**
     * Set Shipping
     * Shipping information
     * @param {p.InvoiceShipping} val
     * @return {Invoice}
     */
    Invoice.prototype.setShipping = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceShipping().getProcessOutObjectClass())
            this.shipping = val;
        else {
            var obj = this.client.newInvoiceShipping();
            obj.fillWithData(val);
            this.shipping = obj;
        }
        return this;
    };
    /**
     * Get Device
     * Device information
     * @return {p.InvoiceDevice}
     */
    Invoice.prototype.getDevice = function () {
        return this.device;
    };
    /**
     * Set Device
     * Device information
     * @param {p.InvoiceDevice} val
     * @return {Invoice}
     */
    Invoice.prototype.setDevice = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceDevice().getProcessOutObjectClass())
            this.device = val;
        else {
            var obj = this.client.newInvoiceDevice();
            obj.fillWithData(val);
            this.device = obj;
        }
        return this;
    };
    /**
     * Get ExternalFraudTools
     * Contain objects that'll be forwarded to external fraud tools
     * @return {p.InvoiceExternalFraudTools}
     */
    Invoice.prototype.getExternalFraudTools = function () {
        return this.externalFraudTools;
    };
    /**
     * Set ExternalFraudTools
     * Contain objects that'll be forwarded to external fraud tools
     * @param {p.InvoiceExternalFraudTools} val
     * @return {Invoice}
     */
    Invoice.prototype.setExternalFraudTools = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceExternalFraudTools().getProcessOutObjectClass())
            this.externalFraudTools = val;
        else {
            var obj = this.client.newInvoiceExternalFraudTools();
            obj.fillWithData(val);
            this.externalFraudTools = obj;
        }
        return this;
    };
    /**
     * Get ExemptionReason3ds2
     * (Deprecated - use sca_exemption_reason) Reason provided to request 3DS2 exemption
     * @return {string}
     */
    Invoice.prototype.getExemptionReason3ds2 = function () {
        return this.exemptionReason3ds2;
    };
    /**
     * Set ExemptionReason3ds2
     * (Deprecated - use sca_exemption_reason) Reason provided to request 3DS2 exemption
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setExemptionReason3ds2 = function (val) {
        this.exemptionReason3ds2 = val;
        return this;
    };
    /**
     * Get ScaExemptionReason
     * Reason provided to request SCA exemption
     * @return {string}
     */
    Invoice.prototype.getScaExemptionReason = function () {
        return this.scaExemptionReason;
    };
    /**
     * Set ScaExemptionReason
     * Reason provided to request SCA exemption
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setScaExemptionReason = function (val) {
        this.scaExemptionReason = val;
        return this;
    };
    /**
     * Get ChallengeIndicator
     * Challenge indicator when requesting 3DS2
     * @return {string}
     */
    Invoice.prototype.getChallengeIndicator = function () {
        return this.challengeIndicator;
    };
    /**
     * Set ChallengeIndicator
     * Challenge indicator when requesting 3DS2
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setChallengeIndicator = function (val) {
        this.challengeIndicator = val;
        return this;
    };
    /**
     * Get Incremental
     * A boolean to indicate if an invoice can have incremental authorizations created for it.
     * @return {boolean}
     */
    Invoice.prototype.getIncremental = function () {
        return this.incremental;
    };
    /**
     * Set Incremental
     * A boolean to indicate if an invoice can have incremental authorizations created for it.
     * @param {boolean} val
     * @return {Invoice}
     */
    Invoice.prototype.setIncremental = function (val) {
        this.incremental = val;
        return this;
    };
    /**
     * Get Tax
     * Tax for an invoice
     * @return {p.InvoiceTax}
     */
    Invoice.prototype.getTax = function () {
        return this.tax;
    };
    /**
     * Set Tax
     * Tax for an invoice
     * @param {p.InvoiceTax} val
     * @return {Invoice}
     */
    Invoice.prototype.setTax = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceTax().getProcessOutObjectClass())
            this.tax = val;
        else {
            var obj = this.client.newInvoiceTax();
            obj.fillWithData(val);
            this.tax = obj;
        }
        return this;
    };
    /**
     * Get PaymentType
     * Payment type
     * @return {string}
     */
    Invoice.prototype.getPaymentType = function () {
        return this.paymentType;
    };
    /**
     * Set PaymentType
     * Payment type
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setPaymentType = function (val) {
        this.paymentType = val;
        return this;
    };
    /**
     * Get NativeApm
     * Native APM data
     * @return {p.NativeAPMRequest}
     */
    Invoice.prototype.getNativeApm = function () {
        return this.nativeApm;
    };
    /**
     * Set NativeApm
     * Native APM data
     * @param {p.NativeAPMRequest} val
     * @return {Invoice}
     */
    Invoice.prototype.setNativeApm = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newNativeAPMRequest().getProcessOutObjectClass())
            this.nativeApm = val;
        else {
            var obj = this.client.newNativeAPMRequest();
            obj.fillWithData(val);
            this.nativeApm = obj;
        }
        return this;
    };
    /**
     * Get InitiationType
     * Initiation type of invoice
     * @return {string}
     */
    Invoice.prototype.getInitiationType = function () {
        return this.initiationType;
    };
    /**
     * Set InitiationType
     * Initiation type of invoice
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setInitiationType = function (val) {
        this.initiationType = val;
        return this;
    };
    /**
     * Get PaymentIntent
     * Payment intent of invoice
     * @return {string}
     */
    Invoice.prototype.getPaymentIntent = function () {
        return this.paymentIntent;
    };
    /**
     * Set PaymentIntent
     * Payment intent of invoice
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setPaymentIntent = function (val) {
        this.paymentIntent = val;
        return this;
    };
    /**
     * Get Billing
     * Billing information
     * @return {p.InvoiceBilling}
     */
    Invoice.prototype.getBilling = function () {
        return this.billing;
    };
    /**
     * Set Billing
     * Billing information
     * @param {p.InvoiceBilling} val
     * @return {Invoice}
     */
    Invoice.prototype.setBilling = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newInvoiceBilling().getProcessOutObjectClass())
            this.billing = val;
        else {
            var obj = this.client.newInvoiceBilling();
            obj.fillWithData(val);
            this.billing = obj;
        }
        return this;
    };
    /**
     * Get UnsupportedFeatureBypass
     * Flags to bypass unsupported features
     * @return {p.UnsupportedFeatureBypass}
     */
    Invoice.prototype.getUnsupportedFeatureBypass = function () {
        return this.unsupportedFeatureBypass;
    };
    /**
     * Set UnsupportedFeatureBypass
     * Flags to bypass unsupported features
     * @param {p.UnsupportedFeatureBypass} val
     * @return {Invoice}
     */
    Invoice.prototype.setUnsupportedFeatureBypass = function (val) {
        if (val.getProcessOutObjectClass &&
            val.getProcessOutObjectClass() == this.client.newUnsupportedFeatureBypass().getProcessOutObjectClass())
            this.unsupportedFeatureBypass = val;
        else {
            var obj = this.client.newUnsupportedFeatureBypass();
            obj.fillWithData(val);
            this.unsupportedFeatureBypass = obj;
        }
        return this;
    };
    /**
     * Get Verification
     * A boolean to indicate if an invoice is a verification invoice. This is used to manually create a verification invoice.
     * @return {boolean}
     */
    Invoice.prototype.getVerification = function () {
        return this.verification;
    };
    /**
     * Set Verification
     * A boolean to indicate if an invoice is a verification invoice. This is used to manually create a verification invoice.
     * @param {boolean} val
     * @return {Invoice}
     */
    Invoice.prototype.setVerification = function (val) {
        this.verification = val;
        return this;
    };
    /**
     * Get AutoCaptureAt
     * A timestamp to indicate when an auto capture should take place following an authorization. This takes priority over the value sent in the authorization request.
     * @return {string}
     */
    Invoice.prototype.getAutoCaptureAt = function () {
        return this.autoCaptureAt;
    };
    /**
     * Set AutoCaptureAt
     * A timestamp to indicate when an auto capture should take place following an authorization. This takes priority over the value sent in the authorization request.
     * @param {string} val
     * @return {Invoice}
     */
    Invoice.prototype.setAutoCaptureAt = function (val) {
        this.autoCaptureAt = val;
        return this;
    };
    /**
     * Fills the current object with the new values pulled from the data
     * @param  {array} data
     * @return {Invoice}
     */
    Invoice.prototype.fillWithData = function (data) {
        if (data["id"])
            this.setId(data["id"]);
        if (data["project"])
            this.setProject(data["project"]);
        if (data["project_id"])
            this.setProjectId(data["project_id"]);
        if (data["transaction"])
            this.setTransaction(data["transaction"]);
        if (data["transaction_id"])
            this.setTransactionId(data["transaction_id"]);
        if (data["customer"])
            this.setCustomer(data["customer"]);
        if (data["customer_id"])
            this.setCustomerId(data["customer_id"]);
        if (data["subscription"])
            this.setSubscription(data["subscription"]);
        if (data["subscription_id"])
            this.setSubscriptionId(data["subscription_id"]);
        if (data["token"])
            this.setToken(data["token"]);
        if (data["token_id"])
            this.setTokenId(data["token_id"]);
        if (data["details"])
            this.setDetails(data["details"]);
        if (data["submerchant"])
            this.setSubmerchant(data["submerchant"]);
        if (data["url"])
            this.setUrl(data["url"]);
        if (data["url_qrcode"])
            this.setUrlQrcode(data["url_qrcode"]);
        if (data["name"])
            this.setName(data["name"]);
        if (data["order_id"])
            this.setOrderId(data["order_id"]);
        if (data["amount"])
            this.setAmount(data["amount"]);
        if (data["currency"])
            this.setCurrency(data["currency"]);
        if (data["merchant_initiator_type"])
            this.setMerchantInitiatorType(data["merchant_initiator_type"]);
        if (data["statement_descriptor"])
            this.setStatementDescriptor(data["statement_descriptor"]);
        if (data["statement_descriptor_phone"])
            this.setStatementDescriptorPhone(data["statement_descriptor_phone"]);
        if (data["statement_descriptor_city"])
            this.setStatementDescriptorCity(data["statement_descriptor_city"]);
        if (data["statement_descriptor_company"])
            this.setStatementDescriptorCompany(data["statement_descriptor_company"]);
        if (data["statement_descriptor_url"])
            this.setStatementDescriptorUrl(data["statement_descriptor_url"]);
        if (data["metadata"])
            this.setMetadata(data["metadata"]);
        if (data["gateway_data"])
            this.setGatewayData(data["gateway_data"]);
        if (data["return_url"])
            this.setReturnUrl(data["return_url"]);
        if (data["cancel_url"])
            this.setCancelUrl(data["cancel_url"]);
        if (data["webhook_url"])
            this.setWebhookUrl(data["webhook_url"]);
        if (data["require_backend_capture"])
            this.setRequireBackendCapture(data["require_backend_capture"]);
        if (data["sandbox"])
            this.setSandbox(data["sandbox"]);
        if (data["created_at"])
            this.setCreatedAt(data["created_at"]);
        if (data["expires_at"])
            this.setExpiresAt(data["expires_at"]);
        if (data["risk"])
            this.setRisk(data["risk"]);
        if (data["shipping"])
            this.setShipping(data["shipping"]);
        if (data["device"])
            this.setDevice(data["device"]);
        if (data["external_fraud_tools"])
            this.setExternalFraudTools(data["external_fraud_tools"]);
        if (data["exemption_reason_3ds2"])
            this.setExemptionReason3ds2(data["exemption_reason_3ds2"]);
        if (data["sca_exemption_reason"])
            this.setScaExemptionReason(data["sca_exemption_reason"]);
        if (data["challenge_indicator"])
            this.setChallengeIndicator(data["challenge_indicator"]);
        if (data["incremental"])
            this.setIncremental(data["incremental"]);
        if (data["tax"])
            this.setTax(data["tax"]);
        if (data["payment_type"])
            this.setPaymentType(data["payment_type"]);
        if (data["native_apm"])
            this.setNativeApm(data["native_apm"]);
        if (data["initiation_type"])
            this.setInitiationType(data["initiation_type"]);
        if (data["payment_intent"])
            this.setPaymentIntent(data["payment_intent"]);
        if (data["billing"])
            this.setBilling(data["billing"]);
        if (data["unsupported_feature_bypass"])
            this.setUnsupportedFeatureBypass(data["unsupported_feature_bypass"]);
        if (data["verification"])
            this.setVerification(data["verification"]);
        if (data["auto_capture_at"])
            this.setAutoCaptureAt(data["auto_capture_at"]);
        return this;
    };
    /**
     * Implements a JSON custom marshaller
     * @return {any}
     */
    Invoice.prototype.toJSON = function () {
        return {
            "id": this.getId(),
            "project": this.getProject(),
            "project_id": this.getProjectId(),
            "transaction": this.getTransaction(),
            "transaction_id": this.getTransactionId(),
            "customer": this.getCustomer(),
            "customer_id": this.getCustomerId(),
            "subscription": this.getSubscription(),
            "subscription_id": this.getSubscriptionId(),
            "token": this.getToken(),
            "token_id": this.getTokenId(),
            "details": this.getDetails(),
            "submerchant": this.getSubmerchant(),
            "url": this.getUrl(),
            "url_qrcode": this.getUrlQrcode(),
            "name": this.getName(),
            "order_id": this.getOrderId(),
            "amount": this.getAmount(),
            "currency": this.getCurrency(),
            "merchant_initiator_type": this.getMerchantInitiatorType(),
            "statement_descriptor": this.getStatementDescriptor(),
            "statement_descriptor_phone": this.getStatementDescriptorPhone(),
            "statement_descriptor_city": this.getStatementDescriptorCity(),
            "statement_descriptor_company": this.getStatementDescriptorCompany(),
            "statement_descriptor_url": this.getStatementDescriptorUrl(),
            "metadata": this.getMetadata(),
            "gateway_data": this.getGatewayData(),
            "return_url": this.getReturnUrl(),
            "cancel_url": this.getCancelUrl(),
            "webhook_url": this.getWebhookUrl(),
            "require_backend_capture": this.getRequireBackendCapture(),
            "sandbox": this.getSandbox(),
            "created_at": this.getCreatedAt(),
            "expires_at": this.getExpiresAt(),
            "risk": this.getRisk(),
            "shipping": this.getShipping(),
            "device": this.getDevice(),
            "external_fraud_tools": this.getExternalFraudTools(),
            "exemption_reason_3ds2": this.getExemptionReason3ds2(),
            "sca_exemption_reason": this.getScaExemptionReason(),
            "challenge_indicator": this.getChallengeIndicator(),
            "incremental": this.getIncremental(),
            "tax": this.getTax(),
            "payment_type": this.getPaymentType(),
            "native_apm": this.getNativeApm(),
            "initiation_type": this.getInitiationType(),
            "payment_intent": this.getPaymentIntent(),
            "billing": this.getBilling(),
            "unsupported_feature_bypass": this.getUnsupportedFeatureBypass(),
            "verification": this.getVerification(),
            "auto_capture_at": this.getAutoCaptureAt(),
        };
    };
    /**
     * Create an incremental authorization
     * @param string amount
     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    Invoice.prototype.incrementAuthorization = function (amount, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(this.getId()) + "/increment_authorization";
        var data = {
            'metadata': (options['metadata']) ? options['metadata'] : null,
            'amount': amount
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_1, response, err, returnValues, body, obj0;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_1 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['transaction'];
                                obj0 = cur.client.newTransaction();
                                returnValues.push(obj0.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.post(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Authorize the invoice using the given source (customer or token)
     * @param string source
     * @param {any} options
     * @return {Promise<any>}
     */
    Invoice.prototype.authorize = function (source, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(this.getId()) + "/authorize";
        var data = {
            'device': this.getDevice(),
            'incremental': this.getIncremental(),
            'synchronous': (options['synchronous']) ? options['synchronous'] : null,
            'retry_drop_liability_shift': (options['retry_drop_liability_shift']) ? options['retry_drop_liability_shift'] : null,
            'capture_amount': (options['capture_amount']) ? options['capture_amount'] : null,
            'enable_three_d_s_2': (options['enable_three_d_s_2']) ? options['enable_three_d_s_2'] : null,
            'allow_fallback_to_sale': (options['allow_fallback_to_sale']) ? options['allow_fallback_to_sale'] : null,
            'auto_capture_at': (options['auto_capture_at']) ? options['auto_capture_at'] : null,
            'metadata': (options['metadata']) ? options['metadata'] : null,
            'override_mac_blocking': (options['override_mac_blocking']) ? options['override_mac_blocking'] : null,
            'external_three_d_s': (options['external_three_d_s']) ? options['external_three_d_s'] : null,
            'save_source': (options['save_source']) ? options['save_source'] : null,
            'source': source
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_2, response, err, returnValues, body, obj0, body, obj1, obj1Filled;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_2 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['transaction'];
                                obj0 = cur.client.newTransaction();
                                returnValues.push(obj0.fillWithData(body));
                                body = respBody;
                                body = body['customer_action'];
                                if (typeof body !== 'undefined') {
                                    obj1 = cur.client.newCustomerAction();
                                    obj1Filled = obj1.fillWithData(body);
                                    returnValues[0].customerAction = obj1Filled;
                                }
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.post(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Capture the invoice using the given source (customer or token)
     * @param string source
     * @param {any} options
     * @return {Promise<any>}
     */
    Invoice.prototype.capture = function (source, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(this.getId()) + "/capture";
        var data = {
            'device': this.getDevice(),
            'incremental': this.getIncremental(),
            'authorize_only': (options['authorize_only']) ? options['authorize_only'] : null,
            'synchronous': (options['synchronous']) ? options['synchronous'] : null,
            'retry_drop_liability_shift': (options['retry_drop_liability_shift']) ? options['retry_drop_liability_shift'] : null,
            'capture_amount': (options['capture_amount']) ? options['capture_amount'] : null,
            'auto_capture_at': (options['auto_capture_at']) ? options['auto_capture_at'] : null,
            'enable_three_d_s_2': (options['enable_three_d_s_2']) ? options['enable_three_d_s_2'] : null,
            'metadata': (options['metadata']) ? options['metadata'] : null,
            'capture_statement_descriptor': (options['capture_statement_descriptor']) ? options['capture_statement_descriptor'] : null,
            'override_mac_blocking': (options['override_mac_blocking']) ? options['override_mac_blocking'] : null,
            'external_three_d_s': (options['external_three_d_s']) ? options['external_three_d_s'] : null,
            'save_source': (options['save_source']) ? options['save_source'] : null,
            'source': source
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_3, response, err, returnValues, body, obj0, body, obj1, obj1Filled;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_3 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['transaction'];
                                obj0 = cur.client.newTransaction();
                                returnValues.push(obj0.fillWithData(body));
                                body = respBody;
                                body = body['customer_action'];
                                if (typeof body !== 'undefined') {
                                    obj1 = cur.client.newCustomerAction();
                                    obj1Filled = obj1.fillWithData(body);
                                    returnValues[0].customerAction = obj1Filled;
                                }
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.post(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Get the customer linked to the invoice.

     * @param {any} options
     * @return {Promise<p.Customer>}
     */
    Invoice.prototype.fetchCustomer = function (options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(this.getId()) + "/customers";
        var data = {};
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_4, response, err, returnValues, body, obj0;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_4 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['customer'];
                                obj0 = cur.client.newCustomer();
                                returnValues.push(obj0.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.get(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Assign a customer to the invoice.
     * @param string customerId
     * @param {any} options
     * @return {Promise<p.Customer>}
     */
    Invoice.prototype.assignCustomer = function (customerId, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(this.getId()) + "/customers";
        var data = {
            'customer_id': customerId
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_5, response, err, returnValues, body, obj0;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_5 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['customer'];
                                obj0 = cur.client.newCustomer();
                                returnValues.push(obj0.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.post(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Process the payout invoice using the given source (customer or token)
     * @param string gatewayConfigurationId
     * @param string source
     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    Invoice.prototype.payout = function (gatewayConfigurationId, source, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(this.getId()) + "/payout";
        var data = {
            'force_gateway_configuration_id': (options['force_gateway_configuration_id']) ? options['force_gateway_configuration_id'] : null,
            'gateway_configuration_id': gatewayConfigurationId,
            'source': source
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_6, response, err, returnValues, body, obj0;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_6 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['transaction'];
                                obj0 = cur.client.newTransaction();
                                returnValues.push(obj0.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.post(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Fetches the Native APM payment
     * @param string invoiceId
     * @param string gatewayConfigurationId
     * @param {any} options
     * @return {Promise<p.NativeAPMTransactionDetails>}
     */
    Invoice.prototype.showNativePaymentTransaction = function (invoiceId, gatewayConfigurationId, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(invoiceId) + "/native-payment/" + encodeURI(gatewayConfigurationId) + "";
        var data = {};
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_7, response, err, returnValues, body, obj0;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_7 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['native_apm'];
                                obj0 = cur.client.newNativeAPMTransactionDetails();
                                returnValues.push(obj0.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.get(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Process the Native APM payment flow
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    Invoice.prototype.processNativePayment = function (invoiceId, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(invoiceId) + "/native-payment";
        var data = {
            'gateway_configuration_id': (options['gateway_configuration_id']) ? options['gateway_configuration_id'] : null,
            'native_apm': (options['native_apm']) ? options['native_apm'] : null
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_8, response, err, returnValues, body, obj0, body, obj1, obj1Filled;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_8 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['transaction'];
                                obj0 = cur.client.newTransaction();
                                returnValues.push(obj0.fillWithData(body));
                                body = respBody;
                                body = body['native_apm'];
                                if (typeof body !== 'undefined') {
                                    obj1 = cur.client.newNativeAPMResponse();
                                    obj1Filled = obj1.fillWithData(body);
                                    returnValues[0].nativeApm = obj1Filled;
                                }
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.post(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Initiate a 3-D Secure authentication
     * @param string source
     * @param {any} options
     * @return {Promise<p.CustomerAction>}
     */
    Invoice.prototype.initiateThreeDS = function (source, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(this.getId()) + "/three-d-s";
        var data = {
            'enable_three_d_s_2': (options['enable_three_d_s_2']) ? options['enable_three_d_s_2'] : null,
            'source': source
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_9, response, err, returnValues, body, obj0;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_9 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['customer_action'];
                                obj0 = cur.client.newCustomerAction();
                                returnValues.push(obj0.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.post(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Get the transaction of the invoice.

     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    Invoice.prototype.fetchTransaction = function (options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(this.getId()) + "/transactions";
        var data = {};
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_10, response, err, returnValues, body, obj0;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_10 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['transaction'];
                                obj0 = cur.client.newTransaction();
                                returnValues.push(obj0.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.get(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Void the invoice

     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    Invoice.prototype.void = function (options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(this.getId()) + "/void";
        var data = {
            'metadata': (options['metadata']) ? options['metadata'] : null,
            'amount': (options['amount']) ? options['amount'] : null
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_11, response, err, returnValues, body, obj0;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_11 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['transaction'];
                                obj0 = cur.client.newTransaction();
                                returnValues.push(obj0.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.post(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Get all the invoices.
     *
     * @param {any} options
     * @return {Promise<any>}
     */
    Invoice.prototype.all = function (options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices";
        var data = {};
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_12, response, err, returnValues, a, body, i, tmp;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_12 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                a = [];
                                body = respBody['invoices'];
                                for (i = body.length; i--;) {
                                    tmp = cur.client.newInvoice();
                                    tmp.fillWithData(body[i]);
                                    a.push(tmp);
                                }
                                returnValues.push(a);
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.get(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Create a new invoice.
     *
     * @param {any} options
     * @return {Promise<any>}
     */
    Invoice.prototype.create = function (options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices";
        var data = {
            'customer_id': this.getCustomerId(),
            'name': this.getName(),
            'order_id': this.getOrderId(),
            'amount': this.getAmount(),
            'currency': this.getCurrency(),
            'metadata': this.getMetadata(),
            'details': this.getDetails(),
            'submerchant': this.getSubmerchant(),
            'exemption_reason_3ds2': this.getExemptionReason3ds2(),
            'sca_exemption_reason': this.getScaExemptionReason(),
            'challenge_indicator': this.getChallengeIndicator(),
            'gateway_data': this.getGatewayData(),
            'merchant_initiator_type': this.getMerchantInitiatorType(),
            'initiation_type': this.getInitiationType(),
            'payment_intent': this.getPaymentIntent(),
            'statement_descriptor': this.getStatementDescriptor(),
            'statement_descriptor_phone': this.getStatementDescriptorPhone(),
            'statement_descriptor_city': this.getStatementDescriptorCity(),
            'statement_descriptor_company': this.getStatementDescriptorCompany(),
            'statement_descriptor_url': this.getStatementDescriptorUrl(),
            'return_url': this.getReturnUrl(),
            'cancel_url': this.getCancelUrl(),
            'webhook_url': this.getWebhookUrl(),
            'risk': this.getRisk(),
            'shipping': this.getShipping(),
            'device': this.getDevice(),
            'require_backend_capture': this.getRequireBackendCapture(),
            'external_fraud_tools': this.getExternalFraudTools(),
            'tax': this.getTax(),
            'payment_type': this.getPaymentType(),
            'billing': this.getBilling(),
            'unsupported_feature_bypass': this.getUnsupportedFeatureBypass(),
            'verification': this.getVerification(),
            'auto_capture_at': this.getAutoCaptureAt(),
            'expires_at': this.getExpiresAt()
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_13, response, err, returnValues, body;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_13 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['invoice'];
                                returnValues.push(cur.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.post(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Find an invoice by its ID.
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    Invoice.prototype.find = function (invoiceId, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(invoiceId) + "";
        var data = {};
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_14, response, err, returnValues, body;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_14 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['invoice'];
                                returnValues.push(cur.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.get(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Delete an invoice by its ID. Only invoices that have not been used yet can be deleted.
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<boolean>}
     */
    Invoice.prototype.delete = function (invoiceId, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(invoiceId) + "";
        var data = {};
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_15, response, err, returnValues;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_15 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                returnValues.push(response.isSuccess());
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.delete(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Refresh invoice by its ID with PSP.
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    Invoice.prototype.syncWithPsp = function (invoiceId, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(invoiceId) + "/sync-with-psp";
        var data = {};
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_16, response, err, returnValues, body;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_16 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['invoice'];
                                returnValues.push(cur.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.put(path, data, options).then(callback, callbackError);
        });
    };
    /**
     * Update invoice by its ID.
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    Invoice.prototype.update = function (invoiceId, options) {
        if (!options)
            options = {};
        this.fillWithData(options);
        var request = new Request(this.client);
        var path = "/invoices/" + encodeURI(invoiceId) + "";
        var data = {
            'amount': this.getAmount(),
            'tax': this.getTax(),
            'details': this.getDetails(),
            'shipping': this.getShipping()
        };
        var cur = this;
        return new Promise(function (resolve, reject) {
            var callback = function (resp) {
                return __awaiter(this, void 0, void 0, function () {
                    var respBody, err_17, response, err, returnValues, body;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                respBody = {};
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 3, , 4]);
                                return [4 /*yield*/, resp.json()];
                            case 2:
                                respBody = _a.sent();
                                return [3 /*break*/, 4];
                            case 3:
                                err_17 = _a.sent();
                                return [3 /*break*/, 4];
                            case 4:
                                response = new Response(resp, respBody);
                                err = response.check();
                                if (err != null)
                                    return [2 /*return*/, reject(err)];
                                returnValues = [];
                                body = respBody;
                                body = body['invoice'];
                                returnValues.push(cur.fillWithData(body));
                                return [2 /*return*/, resolve.apply(this, returnValues)];
                        }
                    });
                });
            };
            var callbackError = function (err) {
                return reject(new ProcessOutNetworkError('processout-sdk.network-issue', err.message));
            };
            request.put(path, data, options).then(callback, callbackError);
        });
    };
    return Invoice;
}());
module.exports = Invoice;
//# sourceMappingURL=invoice.js.map