import ProcessOut = require('./processout');
import * as p from '.';
declare class Invoice {
    private client;
    /**
     * ID of the invoice
     * @type {string}
     */
    private id;
    /**
     * Project to which the invoice belongs
     * @type {p.Project}
     */
    private project;
    /**
     * ID of the project to which the invoice belongs
     * @type {string}
     */
    private projectId;
    /**
     * Transaction generated by the invoice
     * @type {p.Transaction}
     */
    private transaction;
    /**
     * ID of the transaction generated by the invoice
     * @type {string}
     */
    private transactionId;
    /**
     * Customer linked to the invoice, if any
     * @type {p.Customer}
     */
    private customer;
    /**
     * ID of the customer linked to the invoice, if any
     * @type {string}
     */
    private customerId;
    /**
     * Subscription to which the invoice is linked to, if any
     * @type {p.Subscription}
     */
    private subscription;
    /**
     * ID of the subscription to which the invoice is linked to, if any
     * @type {string}
     */
    private subscriptionId;
    /**
     * Token used to pay the invoice, if any
     * @type {p.Token}
     */
    private token;
    /**
     * ID of the token used to pay the invoice, if any
     * @type {string}
     */
    private tokenId;
    /**
     * Details of the invoice
     * @type {any}
     */
    private details;
    /**
     * Submerchant data of the invoice
     * @type {p.InvoiceSubmerchant}
     */
    private submerchant;
    /**
     * URL to which you may redirect your customer to proceed with the payment
     * @type {string}
     */
    private url;
    /**
     * base64-encoded QR code for the invoice URL
     * @type {string}
     */
    private urlQrcode;
    /**
     * Name of the invoice
     * @type {string}
     */
    private name;
    /**
     * ID of the order for this transaction in merchant's system
     * @type {string}
     */
    private orderId;
    /**
     * Amount to be paid
     * @type {string}
     */
    private amount;
    /**
     * Currency of the invoice
     * @type {string}
     */
    private currency;
    /**
     * Type of the transaction initiated by the merchant (off-session). Can be either one-off or recurring, depending on the nature of the merchant initiated transaction.
     * @type {string}
     */
    private merchantInitiatorType;
    /**
     * Statement to be shown on the bank statement of your customer
     * @type {string}
     */
    private statementDescriptor;
    /**
     * Support phone number shown on the customer's bank statement
     * @type {string}
     */
    private statementDescriptorPhone;
    /**
     * City shown on the customer's bank statement
     * @type {string}
     */
    private statementDescriptorCity;
    /**
     * Your company name shown on the customer's bank statement
     * @type {string}
     */
    private statementDescriptorCompany;
    /**
     * URL shown on the customer's bank statement
     * @type {string}
     */
    private statementDescriptorUrl;
    /**
     * Metadata related to the invoice, in the form of a dictionary (key-value pair)
     * @type {any}
     */
    private metadata;
    /**
     * Dictionary that transmit specific informations to gateways (key-value pair)
     * @type {any}
     */
    private gatewayData;
    /**
     * URL where the customer will be redirected upon payment
     * @type {string}
     */
    private returnUrl;
    /**
     * URL where the customer will be redirected if the payment was canceled
     * @type {string}
     */
    private cancelUrl;
    /**
     * Custom webhook URL where updates about this specific payment will be sent, on top of your project-wide URLs
     * @type {string}
     */
    private webhookUrl;
    /**
     * Define whether the invoice can be captured from the front-end or not
     * @type {boolean}
     */
    private requireBackendCapture;
    /**
     * Define whether or not the invoice is in sandbox environment
     * @type {boolean}
     */
    private sandbox;
    /**
     * Date at which the invoice was created
     * @type {string}
     */
    private createdAt;
    /**
     * Date at which the invoice will expire
     * @type {string}
     */
    private expiresAt;
    /**
     * Risk information
     * @type {p.InvoiceRisk}
     */
    private risk;
    /**
     * Shipping information
     * @type {p.InvoiceShipping}
     */
    private shipping;
    /**
     * Device information
     * @type {p.InvoiceDevice}
     */
    private device;
    /**
     * Contain objects that'll be forwarded to external fraud tools
     * @type {p.InvoiceExternalFraudTools}
     */
    private externalFraudTools;
    /**
     * (Deprecated - use sca_exemption_reason) Reason provided to request 3DS2 exemption
     * @type {string}
     */
    private exemptionReason3ds2;
    /**
     * Reason provided to request SCA exemption
     * @type {string}
     */
    private scaExemptionReason;
    /**
     * Challenge indicator when requesting 3DS2
     * @type {string}
     */
    private challengeIndicator;
    /**
     * A boolean to indicate if an invoice can have incremental authorizations created for it.
     * @type {boolean}
     */
    private incremental;
    /**
     * Tax for an invoice
     * @type {p.InvoiceTax}
     */
    private tax;
    /**
     * Payment type
     * @type {string}
     */
    private paymentType;
    /**
     * Native APM data
     * @type {p.NativeAPMRequest}
     */
    private nativeApm;
    /**
     * Initiation type of invoice
     * @type {string}
     */
    private initiationType;
    /**
     * Payment intent of invoice
     * @type {string}
     */
    private paymentIntent;
    /**
     * Billing information
     * @type {p.InvoiceBilling}
     */
    private billing;
    /**
     * Flags to bypass unsupported features
     * @type {p.UnsupportedFeatureBypass}
     */
    private unsupportedFeatureBypass;
    /**
     * A boolean to indicate if an invoice is a verification invoice. This is used to manually create a verification invoice.
     * @type {boolean}
     */
    private verification;
    /**
     * A timestamp to indicate when an auto capture should take place following an authorization. This takes priority over the value sent in the authorization request.
     * @type {string}
     */
    private autoCaptureAt;
    /**
     * Invoice constructor
     * @param {ProcessOut} client
     * @param {array} prefill (optional)
     */
    constructor(client: ProcessOut, prefill: Invoice);
    getProcessOutObjectClass(): string;
    /**
     * Get Id
     * ID of the invoice
     * @return {string}
     */
    getId(): string;
    /**
     * Set Id
     * ID of the invoice
     * @param {string} val
     * @return {Invoice}
     */
    setId(val: string): Invoice;
    /**
     * Get Project
     * Project to which the invoice belongs
     * @return {p.Project}
     */
    getProject(): p.Project;
    /**
     * Set Project
     * Project to which the invoice belongs
     * @param {p.Project} val
     * @return {Invoice}
     */
    setProject(val: p.Project): Invoice;
    /**
     * Get ProjectId
     * ID of the project to which the invoice belongs
     * @return {string}
     */
    getProjectId(): string;
    /**
     * Set ProjectId
     * ID of the project to which the invoice belongs
     * @param {string} val
     * @return {Invoice}
     */
    setProjectId(val: string): Invoice;
    /**
     * Get Transaction
     * Transaction generated by the invoice
     * @return {p.Transaction}
     */
    getTransaction(): p.Transaction;
    /**
     * Set Transaction
     * Transaction generated by the invoice
     * @param {p.Transaction} val
     * @return {Invoice}
     */
    setTransaction(val: p.Transaction): Invoice;
    /**
     * Get TransactionId
     * ID of the transaction generated by the invoice
     * @return {string}
     */
    getTransactionId(): string;
    /**
     * Set TransactionId
     * ID of the transaction generated by the invoice
     * @param {string} val
     * @return {Invoice}
     */
    setTransactionId(val: string): Invoice;
    /**
     * Get Customer
     * Customer linked to the invoice, if any
     * @return {p.Customer}
     */
    getCustomer(): p.Customer;
    /**
     * Set Customer
     * Customer linked to the invoice, if any
     * @param {p.Customer} val
     * @return {Invoice}
     */
    setCustomer(val: p.Customer): Invoice;
    /**
     * Get CustomerId
     * ID of the customer linked to the invoice, if any
     * @return {string}
     */
    getCustomerId(): string;
    /**
     * Set CustomerId
     * ID of the customer linked to the invoice, if any
     * @param {string} val
     * @return {Invoice}
     */
    setCustomerId(val: string): Invoice;
    /**
     * Get Subscription
     * Subscription to which the invoice is linked to, if any
     * @return {p.Subscription}
     */
    getSubscription(): p.Subscription;
    /**
     * Set Subscription
     * Subscription to which the invoice is linked to, if any
     * @param {p.Subscription} val
     * @return {Invoice}
     */
    setSubscription(val: p.Subscription): Invoice;
    /**
     * Get SubscriptionId
     * ID of the subscription to which the invoice is linked to, if any
     * @return {string}
     */
    getSubscriptionId(): string;
    /**
     * Set SubscriptionId
     * ID of the subscription to which the invoice is linked to, if any
     * @param {string} val
     * @return {Invoice}
     */
    setSubscriptionId(val: string): Invoice;
    /**
     * Get Token
     * Token used to pay the invoice, if any
     * @return {p.Token}
     */
    getToken(): p.Token;
    /**
     * Set Token
     * Token used to pay the invoice, if any
     * @param {p.Token} val
     * @return {Invoice}
     */
    setToken(val: p.Token): Invoice;
    /**
     * Get TokenId
     * ID of the token used to pay the invoice, if any
     * @return {string}
     */
    getTokenId(): string;
    /**
     * Set TokenId
     * ID of the token used to pay the invoice, if any
     * @param {string} val
     * @return {Invoice}
     */
    setTokenId(val: string): Invoice;
    /**
     * Get Details
     * Details of the invoice
     * @return {any}
     */
    getDetails(): any;
    /**
     * Set Details
     * Details of the invoice
     * @param {any} val
     * @return {Invoice}
     */
    setDetails(val: any): Invoice;
    /**
     * Get Submerchant
     * Submerchant data of the invoice
     * @return {p.InvoiceSubmerchant}
     */
    getSubmerchant(): p.InvoiceSubmerchant;
    /**
     * Set Submerchant
     * Submerchant data of the invoice
     * @param {p.InvoiceSubmerchant} val
     * @return {Invoice}
     */
    setSubmerchant(val: p.InvoiceSubmerchant): Invoice;
    /**
     * Get Url
     * URL to which you may redirect your customer to proceed with the payment
     * @return {string}
     */
    getUrl(): string;
    /**
     * Set Url
     * URL to which you may redirect your customer to proceed with the payment
     * @param {string} val
     * @return {Invoice}
     */
    setUrl(val: string): Invoice;
    /**
     * Get UrlQrcode
     * base64-encoded QR code for the invoice URL
     * @return {string}
     */
    getUrlQrcode(): string;
    /**
     * Set UrlQrcode
     * base64-encoded QR code for the invoice URL
     * @param {string} val
     * @return {Invoice}
     */
    setUrlQrcode(val: string): Invoice;
    /**
     * Get Name
     * Name of the invoice
     * @return {string}
     */
    getName(): string;
    /**
     * Set Name
     * Name of the invoice
     * @param {string} val
     * @return {Invoice}
     */
    setName(val: string): Invoice;
    /**
     * Get OrderId
     * ID of the order for this transaction in merchant's system
     * @return {string}
     */
    getOrderId(): string;
    /**
     * Set OrderId
     * ID of the order for this transaction in merchant's system
     * @param {string} val
     * @return {Invoice}
     */
    setOrderId(val: string): Invoice;
    /**
     * Get Amount
     * Amount to be paid
     * @return {string}
     */
    getAmount(): string;
    /**
     * Set Amount
     * Amount to be paid
     * @param {string} val
     * @return {Invoice}
     */
    setAmount(val: string): Invoice;
    /**
     * Get Currency
     * Currency of the invoice
     * @return {string}
     */
    getCurrency(): string;
    /**
     * Set Currency
     * Currency of the invoice
     * @param {string} val
     * @return {Invoice}
     */
    setCurrency(val: string): Invoice;
    /**
     * Get MerchantInitiatorType
     * Type of the transaction initiated by the merchant (off-session). Can be either one-off or recurring, depending on the nature of the merchant initiated transaction.
     * @return {string}
     */
    getMerchantInitiatorType(): string;
    /**
     * Set MerchantInitiatorType
     * Type of the transaction initiated by the merchant (off-session). Can be either one-off or recurring, depending on the nature of the merchant initiated transaction.
     * @param {string} val
     * @return {Invoice}
     */
    setMerchantInitiatorType(val: string): Invoice;
    /**
     * Get StatementDescriptor
     * Statement to be shown on the bank statement of your customer
     * @return {string}
     */
    getStatementDescriptor(): string;
    /**
     * Set StatementDescriptor
     * Statement to be shown on the bank statement of your customer
     * @param {string} val
     * @return {Invoice}
     */
    setStatementDescriptor(val: string): Invoice;
    /**
     * Get StatementDescriptorPhone
     * Support phone number shown on the customer's bank statement
     * @return {string}
     */
    getStatementDescriptorPhone(): string;
    /**
     * Set StatementDescriptorPhone
     * Support phone number shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    setStatementDescriptorPhone(val: string): Invoice;
    /**
     * Get StatementDescriptorCity
     * City shown on the customer's bank statement
     * @return {string}
     */
    getStatementDescriptorCity(): string;
    /**
     * Set StatementDescriptorCity
     * City shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    setStatementDescriptorCity(val: string): Invoice;
    /**
     * Get StatementDescriptorCompany
     * Your company name shown on the customer's bank statement
     * @return {string}
     */
    getStatementDescriptorCompany(): string;
    /**
     * Set StatementDescriptorCompany
     * Your company name shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    setStatementDescriptorCompany(val: string): Invoice;
    /**
     * Get StatementDescriptorUrl
     * URL shown on the customer's bank statement
     * @return {string}
     */
    getStatementDescriptorUrl(): string;
    /**
     * Set StatementDescriptorUrl
     * URL shown on the customer's bank statement
     * @param {string} val
     * @return {Invoice}
     */
    setStatementDescriptorUrl(val: string): Invoice;
    /**
     * Get Metadata
     * Metadata related to the invoice, in the form of a dictionary (key-value pair)
     * @return {any}
     */
    getMetadata(): any;
    /**
     * Set Metadata
     * Metadata related to the invoice, in the form of a dictionary (key-value pair)
     * @param {any} val
     * @return {Invoice}
     */
    setMetadata(val: any): Invoice;
    /**
     * Get GatewayData
     * Dictionary that transmit specific informations to gateways (key-value pair)
     * @return {any}
     */
    getGatewayData(): any;
    /**
     * Set GatewayData
     * Dictionary that transmit specific informations to gateways (key-value pair)
     * @param {any} val
     * @return {Invoice}
     */
    setGatewayData(val: any): Invoice;
    /**
     * Get ReturnUrl
     * URL where the customer will be redirected upon payment
     * @return {string}
     */
    getReturnUrl(): string;
    /**
     * Set ReturnUrl
     * URL where the customer will be redirected upon payment
     * @param {string} val
     * @return {Invoice}
     */
    setReturnUrl(val: string): Invoice;
    /**
     * Get CancelUrl
     * URL where the customer will be redirected if the payment was canceled
     * @return {string}
     */
    getCancelUrl(): string;
    /**
     * Set CancelUrl
     * URL where the customer will be redirected if the payment was canceled
     * @param {string} val
     * @return {Invoice}
     */
    setCancelUrl(val: string): Invoice;
    /**
     * Get WebhookUrl
     * Custom webhook URL where updates about this specific payment will be sent, on top of your project-wide URLs
     * @return {string}
     */
    getWebhookUrl(): string;
    /**
     * Set WebhookUrl
     * Custom webhook URL where updates about this specific payment will be sent, on top of your project-wide URLs
     * @param {string} val
     * @return {Invoice}
     */
    setWebhookUrl(val: string): Invoice;
    /**
     * Get RequireBackendCapture
     * Define whether the invoice can be captured from the front-end or not
     * @return {boolean}
     */
    getRequireBackendCapture(): boolean;
    /**
     * Set RequireBackendCapture
     * Define whether the invoice can be captured from the front-end or not
     * @param {boolean} val
     * @return {Invoice}
     */
    setRequireBackendCapture(val: boolean): Invoice;
    /**
     * Get Sandbox
     * Define whether or not the invoice is in sandbox environment
     * @return {boolean}
     */
    getSandbox(): boolean;
    /**
     * Set Sandbox
     * Define whether or not the invoice is in sandbox environment
     * @param {boolean} val
     * @return {Invoice}
     */
    setSandbox(val: boolean): Invoice;
    /**
     * Get CreatedAt
     * Date at which the invoice was created
     * @return {string}
     */
    getCreatedAt(): string;
    /**
     * Set CreatedAt
     * Date at which the invoice was created
     * @param {string} val
     * @return {Invoice}
     */
    setCreatedAt(val: string): Invoice;
    /**
     * Get ExpiresAt
     * Date at which the invoice will expire
     * @return {string}
     */
    getExpiresAt(): string;
    /**
     * Set ExpiresAt
     * Date at which the invoice will expire
     * @param {string} val
     * @return {Invoice}
     */
    setExpiresAt(val: string): Invoice;
    /**
     * Get Risk
     * Risk information
     * @return {p.InvoiceRisk}
     */
    getRisk(): p.InvoiceRisk;
    /**
     * Set Risk
     * Risk information
     * @param {p.InvoiceRisk} val
     * @return {Invoice}
     */
    setRisk(val: p.InvoiceRisk): Invoice;
    /**
     * Get Shipping
     * Shipping information
     * @return {p.InvoiceShipping}
     */
    getShipping(): p.InvoiceShipping;
    /**
     * Set Shipping
     * Shipping information
     * @param {p.InvoiceShipping} val
     * @return {Invoice}
     */
    setShipping(val: p.InvoiceShipping): Invoice;
    /**
     * Get Device
     * Device information
     * @return {p.InvoiceDevice}
     */
    getDevice(): p.InvoiceDevice;
    /**
     * Set Device
     * Device information
     * @param {p.InvoiceDevice} val
     * @return {Invoice}
     */
    setDevice(val: p.InvoiceDevice): Invoice;
    /**
     * Get ExternalFraudTools
     * Contain objects that'll be forwarded to external fraud tools
     * @return {p.InvoiceExternalFraudTools}
     */
    getExternalFraudTools(): p.InvoiceExternalFraudTools;
    /**
     * Set ExternalFraudTools
     * Contain objects that'll be forwarded to external fraud tools
     * @param {p.InvoiceExternalFraudTools} val
     * @return {Invoice}
     */
    setExternalFraudTools(val: p.InvoiceExternalFraudTools): Invoice;
    /**
     * Get ExemptionReason3ds2
     * (Deprecated - use sca_exemption_reason) Reason provided to request 3DS2 exemption
     * @return {string}
     */
    getExemptionReason3ds2(): string;
    /**
     * Set ExemptionReason3ds2
     * (Deprecated - use sca_exemption_reason) Reason provided to request 3DS2 exemption
     * @param {string} val
     * @return {Invoice}
     */
    setExemptionReason3ds2(val: string): Invoice;
    /**
     * Get ScaExemptionReason
     * Reason provided to request SCA exemption
     * @return {string}
     */
    getScaExemptionReason(): string;
    /**
     * Set ScaExemptionReason
     * Reason provided to request SCA exemption
     * @param {string} val
     * @return {Invoice}
     */
    setScaExemptionReason(val: string): Invoice;
    /**
     * Get ChallengeIndicator
     * Challenge indicator when requesting 3DS2
     * @return {string}
     */
    getChallengeIndicator(): string;
    /**
     * Set ChallengeIndicator
     * Challenge indicator when requesting 3DS2
     * @param {string} val
     * @return {Invoice}
     */
    setChallengeIndicator(val: string): Invoice;
    /**
     * Get Incremental
     * A boolean to indicate if an invoice can have incremental authorizations created for it.
     * @return {boolean}
     */
    getIncremental(): boolean;
    /**
     * Set Incremental
     * A boolean to indicate if an invoice can have incremental authorizations created for it.
     * @param {boolean} val
     * @return {Invoice}
     */
    setIncremental(val: boolean): Invoice;
    /**
     * Get Tax
     * Tax for an invoice
     * @return {p.InvoiceTax}
     */
    getTax(): p.InvoiceTax;
    /**
     * Set Tax
     * Tax for an invoice
     * @param {p.InvoiceTax} val
     * @return {Invoice}
     */
    setTax(val: p.InvoiceTax): Invoice;
    /**
     * Get PaymentType
     * Payment type
     * @return {string}
     */
    getPaymentType(): string;
    /**
     * Set PaymentType
     * Payment type
     * @param {string} val
     * @return {Invoice}
     */
    setPaymentType(val: string): Invoice;
    /**
     * Get NativeApm
     * Native APM data
     * @return {p.NativeAPMRequest}
     */
    getNativeApm(): p.NativeAPMRequest;
    /**
     * Set NativeApm
     * Native APM data
     * @param {p.NativeAPMRequest} val
     * @return {Invoice}
     */
    setNativeApm(val: p.NativeAPMRequest): Invoice;
    /**
     * Get InitiationType
     * Initiation type of invoice
     * @return {string}
     */
    getInitiationType(): string;
    /**
     * Set InitiationType
     * Initiation type of invoice
     * @param {string} val
     * @return {Invoice}
     */
    setInitiationType(val: string): Invoice;
    /**
     * Get PaymentIntent
     * Payment intent of invoice
     * @return {string}
     */
    getPaymentIntent(): string;
    /**
     * Set PaymentIntent
     * Payment intent of invoice
     * @param {string} val
     * @return {Invoice}
     */
    setPaymentIntent(val: string): Invoice;
    /**
     * Get Billing
     * Billing information
     * @return {p.InvoiceBilling}
     */
    getBilling(): p.InvoiceBilling;
    /**
     * Set Billing
     * Billing information
     * @param {p.InvoiceBilling} val
     * @return {Invoice}
     */
    setBilling(val: p.InvoiceBilling): Invoice;
    /**
     * Get UnsupportedFeatureBypass
     * Flags to bypass unsupported features
     * @return {p.UnsupportedFeatureBypass}
     */
    getUnsupportedFeatureBypass(): p.UnsupportedFeatureBypass;
    /**
     * Set UnsupportedFeatureBypass
     * Flags to bypass unsupported features
     * @param {p.UnsupportedFeatureBypass} val
     * @return {Invoice}
     */
    setUnsupportedFeatureBypass(val: p.UnsupportedFeatureBypass): Invoice;
    /**
     * Get Verification
     * A boolean to indicate if an invoice is a verification invoice. This is used to manually create a verification invoice.
     * @return {boolean}
     */
    getVerification(): boolean;
    /**
     * Set Verification
     * A boolean to indicate if an invoice is a verification invoice. This is used to manually create a verification invoice.
     * @param {boolean} val
     * @return {Invoice}
     */
    setVerification(val: boolean): Invoice;
    /**
     * Get AutoCaptureAt
     * A timestamp to indicate when an auto capture should take place following an authorization. This takes priority over the value sent in the authorization request.
     * @return {string}
     */
    getAutoCaptureAt(): string;
    /**
     * Set AutoCaptureAt
     * A timestamp to indicate when an auto capture should take place following an authorization. This takes priority over the value sent in the authorization request.
     * @param {string} val
     * @return {Invoice}
     */
    setAutoCaptureAt(val: string): Invoice;
    /**
     * Fills the current object with the new values pulled from the data
     * @param  {array} data
     * @return {Invoice}
     */
    fillWithData(data: any): Invoice;
    /**
     * Implements a JSON custom marshaller
     * @return {any}
     */
    toJSON(): any;
    /**
     * Create an incremental authorization
     * @param string amount
     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    incrementAuthorization(amount: string, options: any): Promise<p.Transaction>;
    /**
     * Authorize the invoice using the given source (customer or token)
     * @param string source
     * @param {any} options
     * @return {Promise<any>}
     */
    authorize(source: string, options: any): Promise<any>;
    /**
     * Capture the invoice using the given source (customer or token)
     * @param string source
     * @param {any} options
     * @return {Promise<any>}
     */
    capture(source: string, options: any): Promise<any>;
    /**
     * Get the customer linked to the invoice.

     * @param {any} options
     * @return {Promise<p.Customer>}
     */
    fetchCustomer(options: any): Promise<p.Customer>;
    /**
     * Assign a customer to the invoice.
     * @param string customerId
     * @param {any} options
     * @return {Promise<p.Customer>}
     */
    assignCustomer(customerId: string, options: any): Promise<p.Customer>;
    /**
     * Process the payout invoice using the given source (customer or token)
     * @param string gatewayConfigurationId
     * @param string source
     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    payout(gatewayConfigurationId: string, source: string, options: any): Promise<p.Transaction>;
    /**
     * Fetches the Native APM payment
     * @param string invoiceId
     * @param string gatewayConfigurationId
     * @param {any} options
     * @return {Promise<p.NativeAPMTransactionDetails>}
     */
    showNativePaymentTransaction(invoiceId: string, gatewayConfigurationId: string, options: any): Promise<p.NativeAPMTransactionDetails>;
    /**
     * Process the Native APM payment flow
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    processNativePayment(invoiceId: string, options: any): Promise<any>;
    /**
     * Initiate a 3-D Secure authentication
     * @param string source
     * @param {any} options
     * @return {Promise<p.CustomerAction>}
     */
    initiateThreeDS(source: string, options: any): Promise<p.CustomerAction>;
    /**
     * Get the transaction of the invoice.

     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    fetchTransaction(options: any): Promise<p.Transaction>;
    /**
     * Void the invoice

     * @param {any} options
     * @return {Promise<p.Transaction>}
     */
    void(options: any): Promise<p.Transaction>;
    /**
     * Get all the invoices.
     *
     * @param {any} options
     * @return {Promise<any>}
     */
    all(options: any): Promise<any>;
    /**
     * Create a new invoice.
     *
     * @param {any} options
     * @return {Promise<any>}
     */
    create(options: any): Promise<any>;
    /**
     * Find an invoice by its ID.
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    find(invoiceId: string, options: any): Promise<any>;
    /**
     * Delete an invoice by its ID. Only invoices that have not been used yet can be deleted.
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<boolean>}
     */
    delete(invoiceId: string, options: any): Promise<boolean>;
    /**
     * Refresh invoice by its ID with PSP.
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    syncWithPsp(invoiceId: string, options: any): Promise<any>;
    /**
     * Update invoice by its ID.
     * @param string invoiceId
     * @param {any} options
     * @return {Promise<any>}
     */
    update(invoiceId: string, options: any): Promise<any>;
}
export = Invoice;
//# sourceMappingURL=invoice.d.ts.map