/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.tweak;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class TweakClient {
    private DatagramSocket socket;
    private InetAddress address;
    private boolean initialized;
    private int sketchPort;
    static final int VAR_INT = 0;
    static final int VAR_FLOAT = 1;
    static final int SHUTDOWN = -1;

    public TweakClient(int sketchPort) {
        this.sketchPort = sketchPort;
        try {
            this.socket = new DatagramSocket();
            this.address = InetAddress.getByName("127.0.0.1");
            this.initialized = true;
        }
        catch (SocketException e) {
            this.initialized = false;
        }
        catch (UnknownHostException e) {
            this.socket.close();
            this.initialized = false;
        }
        catch (SecurityException e) {
            this.socket.close();
            this.initialized = false;
        }
    }

    public void shutdown() {
        if (this.initialized) {
            this.sendShutdown();
            this.initialized = false;
        }
    }

    public boolean sendInt(int index, int val) {
        if (this.initialized) {
            try {
                byte[] buf = new byte[12];
                ByteBuffer bb = ByteBuffer.wrap(buf);
                bb.putInt(0, 0);
                bb.putInt(4, index);
                bb.putInt(8, val);
                DatagramPacket packet = new DatagramPacket(buf, buf.length, this.address, this.sketchPort);
                this.socket.send(packet);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean sendFloat(int index, float val) {
        if (this.initialized) {
            try {
                byte[] buf = new byte[12];
                ByteBuffer bb = ByteBuffer.wrap(buf);
                bb.putInt(0, 1);
                bb.putInt(4, index);
                bb.putFloat(8, val);
                this.socket.send(new DatagramPacket(buf, buf.length, this.address, this.sketchPort));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean sendShutdown() {
        if (this.initialized) {
            try {
                byte[] buf = new byte[12];
                ByteBuffer bb = ByteBuffer.wrap(buf);
                bb.putInt(0, -1);
                this.socket.send(new DatagramPacket(buf, buf.length, this.address, this.sketchPort));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getServerCode(int listenPort, boolean hasInts, boolean hasFloats) {
        String serverCode = "class TweakModeServer extends Thread\n{\n  protected DatagramSocket socket = null;\n  protected boolean running = true;\n  final int INT_VAR = 0;\n  final int FLOAT_VAR = 1;\n  final int SHUTDOWN = 0xffffffff;\n  public TweakModeServer() {\n    this(\"TweakModeServer\");\n  }\n  public TweakModeServer(String name) {\n    super(name);\n  }\n  public void setup()\n  {\n    try {\n      socket = new DatagramSocket(" + listenPort + ");\n      socket.setSoTimeout(250);\n    } catch (IOException e) {\n      println(\"error: could not create TweakMode server socket\");\n    }\n  }\n  public void run()\n  {\n    byte[] buf = new byte[256];\n    while(running)\n    {\n      try {\n        DatagramPacket packet = new DatagramPacket(buf, buf.length);\n        socket.receive(packet);\n        ByteBuffer bb = ByteBuffer.wrap(buf);\n        int type = bb.getInt(0);\n        int index = bb.getInt(4);\n";
        if (hasInts) {
            serverCode = serverCode + "        if (type == INT_VAR) {\n          int val = bb.getInt(8);\n          tweakmode_int[index] = val;\n        }\n        else ";
        }
        if (hasFloats) {
            serverCode = serverCode + "         if (type == FLOAT_VAR) {\n          float val = bb.getFloat(8);\n          tweakmode_float[index] = val;\n        }\n        else";
        }
        serverCode = serverCode + "        if (type == SHUTDOWN) {\n          running = false;\n        }\n      } catch (SocketTimeoutException e) {\n        // nothing to do here just try receiving again\n      } catch (Exception e) {\n      }\n    }\n    socket.close();\n  }\n}\n\n\n";
        return serverCode;
    }
}

