/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.tweak;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import processing.mode.java.tweak.ColorControlBox;

public class ColorSelector {
    int hue;
    int saturation;
    int brightness;
    public JFrame frame;
    public ColorControlBox colorBox;
    ColorSelectorBox selectorBox;
    ColorSelectorSlider selectorSlider;
    SelectorTopBar topBar;

    public ColorSelector(ColorControlBox colorBox) {
        this.colorBox = colorBox;
        this.createFrame();
    }

    public void createFrame() {
        this.frame = new JFrame();
        this.frame.setBackground(Color.BLACK);
        Box box = Box.createHorizontalBox();
        box.setBackground(Color.BLACK);
        this.selectorSlider = new ColorSelectorSlider();
        if (!this.colorBox.isBW) {
            this.selectorBox = new ColorSelectorBox();
            box.add(this.selectorBox);
        }
        box.add(Box.createHorizontalGlue());
        box.add((Component)this.selectorSlider, "Center");
        box.add(Box.createHorizontalGlue());
        this.frame.getContentPane().add((Component)box, "Center");
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void show(int x, int y) {
        this.frame.setLocation(x, y);
        this.frame.setVisible(true);
        this.frame.repaint();
    }

    public void hide() {
        this.colorBox = null;
        this.frame.setVisible(false);
    }

    public void refreshColor() {
        if (!this.colorBox.ilegalColor) {
            this.setColor(this.colorBox.color);
        }
    }

    public void setColor(Color c) {
        if (this.selectorBox != null) {
            this.selectorBox.setToColor(c);
        }
        this.selectorSlider.setToColor(c);
        this.repaintSelector();
    }

    public void satBrightChanged() {
        this.repaintSelector();
    }

    public void hueChanged() {
        if (this.selectorBox != null) {
            this.selectorBox.renderBack();
        }
        this.repaintSelector();
    }

    public void repaintSelector() {
        if (this.selectorBox != null) {
            this.selectorBox.repaint();
        }
        this.selectorSlider.repaint();
    }

    class ColorSelectorSlider
    extends JComponent {
        final int WIDE = 30;
        BufferedImage backImg;
        int lastY;

        ColorSelectorSlider() {
            if (!ColorSelector.this.colorBox.ilegalColor) {
                this.setToColor(ColorSelector.this.colorBox.color);
            }
            this.renderBack();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ColorSelectorSlider.this.updateMouse(e);
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    ColorSelectorSlider.this.updateMouse(e);
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.backImg, 0, 0, this);
            Graphics2D g2 = (Graphics2D)g;
            if (ColorSelector.this.colorBox.isBW && this.lastY >= 128) {
                g2.setColor(Color.WHITE);
            } else {
                g2.setColor(Color.BLACK);
            }
            AffineTransform tx = g2.getTransform();
            g2.translate(0, this.lastY);
            g.drawRect(1, -2, 6, 4);
            g.drawLine(13, 0, 17, 0);
            g.drawLine(15, -2, 15, 2);
            g.drawRect(24, -2, 4, 4);
            g2.setTransform(tx);
        }

        void renderBack() {
            int[] pixels = new int[7680];
            int index = 0;
            int argb = 0;
            for (int j = 0; j < 256; ++j) {
                if (ColorSelector.this.colorBox.isBW) {
                    int gray = 255 - j;
                    argb = 0xFF000000 | gray << 16 | gray << 8 | gray;
                } else {
                    argb = Color.HSBtoRGB((float)(255 - j) / 255.0f, 1.0f, 1.0f);
                }
                for (int i = 0; i < 30; ++i) {
                    pixels[index++] = argb;
                }
            }
            this.backImg = new BufferedImage(30, 256, 1);
            this.backImg.getRaster().setDataElements(0, 0, 30, 256, pixels);
        }

        void setToColor(Color c) {
            if (ColorSelector.this.colorBox.isBW) {
                ColorSelector.this.hue = c.getRed();
            } else {
                float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                ColorSelector.this.hue = (int)(hsb[0] * 255.0f);
            }
            this.lastY = 255 - ColorSelector.this.hue;
        }

        void updateMouse(MouseEvent event) {
            int mouseY = event.getY();
            if (mouseY >= 0 && mouseY < 256) {
                this.lastY = mouseY;
                this.updateColor();
            }
        }

        public void updateColor() {
            ColorSelector.this.hue = 255 - this.lastY;
            ColorSelector.this.hueChanged();
            ColorSelector.this.colorBox.selectorChanged(ColorSelector.this.hue, ColorSelector.this.saturation, ColorSelector.this.brightness);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(30, 255);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    class ColorSelectorBox
    extends JComponent {
        int lastX;
        int lastY;
        BufferedImage backImg;

        ColorSelectorBox() {
            if (!ColorSelector.this.colorBox.ilegalColor) {
                this.setToColor(ColorSelector.this.colorBox.color);
            }
            this.renderBack();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ColorSelectorBox.this.updateMouse(e);
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    ColorSelectorBox.this.updateMouse(e);
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.backImg, 0, 0, this);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.lastY < 128 ? Color.BLACK : Color.WHITE);
            AffineTransform tx = g2.getTransform();
            g2.translate(this.lastX, this.lastY);
            g2.drawOval(-3, -3, 6, 6);
            g2.drawLine(-8, 0, -6, 0);
            g2.drawLine(6, 0, 8, 0);
            g2.drawLine(0, -8, 0, -6);
            g2.drawLine(0, 6, 0, 8);
            g2.setTransform(tx);
        }

        public void renderBack() {
            int[] pixels = new int[65536];
            int index = 0;
            for (int j = 0; j < 256; ++j) {
                for (int i = 0; i < 256; ++i) {
                    pixels[index++] = Color.HSBtoRGB((float)ColorSelector.this.hue / 255.0f, (float)i / 255.0f, (float)(255 - j) / 255.0f);
                }
            }
            this.backImg = new BufferedImage(256, 256, 1);
            this.backImg.getRaster().setDataElements(0, 0, 256, 256, pixels);
        }

        public void setToColor(Color c) {
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            ColorSelector.this.saturation = (int)(hsb[1] * 255.0f);
            ColorSelector.this.brightness = (int)(hsb[2] * 255.0f);
            this.lastX = ColorSelector.this.saturation;
            this.lastY = 255 - ColorSelector.this.brightness;
        }

        void updateMouse(MouseEvent event) {
            int mouseX = event.getX();
            int mouseY = event.getY();
            if (mouseX >= 0 && mouseX < 256 && mouseY >= 0 && mouseY < 256) {
                this.lastX = mouseX;
                this.lastY = mouseY;
                this.updateColor();
            }
        }

        void updateColor() {
            ColorSelector.this.saturation = this.lastX;
            ColorSelector.this.brightness = 255 - this.lastY;
            ColorSelector.this.satBrightChanged();
            ColorSelector.this.colorBox.selectorChanged(ColorSelector.this.hue, ColorSelector.this.saturation, ColorSelector.this.brightness);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(256, 256);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    public class SelectorTopBar
    extends JComponent {
        int barWidth;
        int barHeight = 16;

        public SelectorTopBar(int w) {
            this.barWidth = w;
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Color.GRAY);
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.barWidth, this.barHeight);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

