/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.runner;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.RunnerListenerEdtAdapter;
import processing.app.SketchException;
import processing.app.exec.StreamRedirectThread;
import processing.core.PApplet;
import processing.data.StringList;
import processing.mode.java.JavaBuild;
import processing.mode.java.JavaEditor;
import processing.mode.java.runner.MessageConsumer;
import processing.mode.java.runner.MessageSiphon;

public class Runner
implements MessageConsumer {
    protected RunnerListener listener;
    protected volatile VirtualMachine vm;
    protected boolean vmReturnedError;
    protected Thread errThread = null;
    protected Thread outThread = null;
    protected SketchException exception;
    protected JavaEditor editor;
    protected JavaBuild build;
    protected Process process;
    protected PrintStream sketchErr;
    protected PrintStream sketchOut;
    protected volatile boolean cancelled;
    protected final Object cancelLock = new Object[0];

    public Runner(JavaBuild build, RunnerListener listener) throws SketchException {
        RunnerListener wrapped;
        this.listener = listener;
        this.build = build;
        Runner.checkLocalHost();
        if (listener instanceof RunnerListenerEdtAdapter && (wrapped = ((RunnerListenerEdtAdapter)listener).getWrapped()) instanceof JavaEditor) {
            this.editor = (JavaEditor)wrapped;
            this.sketchErr = this.editor.getConsole().getErr();
            this.sketchOut = this.editor.getConsole().getOut();
        }
        if (this.editor == null) {
            this.sketchErr = System.err;
            this.sketchOut = System.out;
        }
        String variant = Platform.getVariant();
        for (Library library : build.getImportedLibraries()) {
            if (!library.isUnsupported(variant)) continue;
            this.sketchErr.println(library.getName() + " does not run on this architecture: " + variant);
        }
    }

    private static void checkLocalHost() throws SketchException {
        try {
            InetAddress address = InetAddress.getByName("localhost");
            if (!address.getHostAddress().equals("127.0.0.1")) {
                System.err.println("Your computer is not properly mapping 'localhost' to '127.0.0.1',");
                System.err.println("which prevents sketches from working properly because 'localhost'");
                System.err.println("is needed to connect the PDE to your sketch while it's running.");
                System.err.println("If you don't recall making this change, or know how to fix it:");
                System.err.println("https://www.google.com/search?q=add+localhost+to+hosts+file+" + Platform.getName());
                throw new SketchException("Cannot run due to changes in your 'hosts' file. See the console for details.", false);
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public VirtualMachine launch(String[] args) {
        if (this.launchVirtualMachine(false, args)) {
            this.generateTrace();
        }
        return this.vm;
    }

    public VirtualMachine present(String[] args) {
        if (this.launchVirtualMachine(true, args)) {
            this.generateTrace();
        }
        return this.vm;
    }

    public boolean vmReturnedError() {
        return this.vmReturnedError;
    }

    public VirtualMachine debug(String[] args) {
        if (this.launchVirtualMachine(false, args)) {
            this.redirectStreams(this.vm);
        }
        return this.vm;
    }

    protected void redirectStreams(VirtualMachine vm) {
        MessageSiphon ms = new MessageSiphon(this.process.getErrorStream(), this);
        this.errThread = ms.getThread();
        this.outThread = new StreamRedirectThread("VM output reader", this.process.getInputStream(), (OutputStream)System.out);
        this.errThread.start();
        this.outThread.start();
    }

    public VirtualMachine vm() {
        return this.vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean launchVirtualMachine(boolean present, String[] args) {
        vmParams = this.getMachineParams();
        sketchParams = this.getSketchParams(present, args);
        port = 8000 + (int)(Math.random() * 1000.0);
        portStr = String.valueOf(port);
        jdwpArg = "-agentlib:jdwp=transport=dt_socket,address=" + portStr + ",server=y,suspend=y,quiet=y";
        commandArgs = new StringList();
        commandArgs.append(Platform.getJavaPath());
        commandArgs.append(jdwpArg);
        commandArgs.append(vmParams);
        commandArgs.append(sketchParams);
        if (this.cancelled) {
            return false;
        }
        this.launchJava(commandArgs.array());
        connector = (AttachingConnector)this.findConnector("com.sun.jdi.SocketAttach");
        arguments = connector.defaultArguments();
        portArg = arguments.get("port");
        portArg.setValue(portStr);
        block10: while (true) {
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    do {
                        Messages.log((String)(this.getClass().getName() + " attempting to attach to VM"));
                        var12_12 = this.cancelLock;
                        synchronized (var12_12) {
                            this.vm = connector.attach(arguments);
                            if (this.cancelled && this.vm != null) {
                                Messages.log((String)(this.getClass().getName() + " aborting, launch cancelled"));
                                this.close();
                                return false;
                            }
                        }
                    } while (this.vm == null);
                    Messages.log((String)(this.getClass().getName() + " attached to the VM"));
                    return true;
                }
                catch (ConnectException ce) {
                    Messages.log((String)(this.getClass().getName() + " socket for VM not ready"));
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Messages.err((String)(this.getClass().getName() + " interrupted"), (Throwable)ie);
                    }
                }
                continue block10;
                catch (IOException e) {
                    Messages.err((String)(this.getClass().getName() + " while attaching to VM"), (Throwable)e);
                    continue;
                }
                break;
            }
            break;
        }
        ** GOTO lbl-1000
        catch (IllegalConnectorArgumentsException exc) {
            throw new Error("Internal error: " + exc);
        }
    }

    protected StringList getMachineParams() {
        StringList params = new StringList();
        String options = Preferences.get((String)"run.options");
        if (options.length() > 0) {
            String[] pieces;
            for (String piece : pieces = PApplet.split((String)options, (char)' ')) {
                String p = piece.trim();
                if (p.length() <= 0) continue;
                params.append(p);
            }
        }
        if (Preferences.getBoolean((String)"run.options.memory")) {
            params.append("-Xms" + Preferences.get((String)"run.options.memory.initial") + "m");
            params.append("-Xmx" + Preferences.get((String)"run.options.memory.maximum") + "m");
        }
        params.append("-Djna.nosys=true");
        if (Platform.isMacOS()) {
            params.append("-Xdock:name=" + this.build.getSketchClassName());
        }
        String javaLibraryPath = this.build.getJavaLibraryPath();
        String javaLibraryPathParam = "-Djava.library.path=" + javaLibraryPath + File.pathSeparator + System.getProperty("java.library.path");
        params.append(javaLibraryPathParam);
        Library javafx = this.build.findJavaFX();
        if (javafx != null) {
            File modulesFolder = new File(javafx.getNativePath(), "modules");
            for (String arg : JavaBuild.getArgsJavaFX(modulesFolder.getAbsolutePath())) {
                params.append(arg);
            }
        }
        params.append("-cp");
        params.append(this.build.getClassPath());
        params.append("-ea");
        return params;
    }

    protected StringList getSketchParams(boolean present, String[] args) {
        StringList params = new StringList();
        if (this.build.getFoundMain()) {
            params.append(this.build.getSketchClassName());
        } else {
            params.append("processing.core.PApplet");
            int runDisplay = Preferences.getInteger((String)"run.display");
            if (this.editor != null) {
                GraphicsDevice runDevice;
                GraphicsDevice editorDevice = this.editor.getGraphicsConfiguration().getDevice();
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] devices = ge.getScreenDevices();
                if (runDisplay > 0 && runDisplay <= devices.length) {
                    runDevice = devices[runDisplay - 1];
                } else {
                    if (runDisplay > 0) {
                        System.err.println("Display " + runDisplay + " not available.");
                    }
                    runDevice = editorDevice;
                    for (int i = 0; i < devices.length; ++i) {
                        if (devices[i] != runDevice) continue;
                        if (runDisplay != -1) {
                            System.err.println("Setting 'Run Sketches on Display' preference to display " + (i + 1));
                        }
                        runDisplay = i + 1;
                        Preferences.setInteger((String)"run.display", (int)runDisplay);
                        break;
                    }
                }
                Point windowLocation = this.editor.getSketchLocation();
                if (windowLocation == null) {
                    if (editorDevice == runDevice) {
                        Point editorLocation = this.editor.getLocation();
                        params.append("--editor-location=" + editorLocation.x + "," + editorLocation.y);
                    }
                } else {
                    params.append("--location=" + windowLocation.x + "," + windowLocation.y);
                }
                params.append("--external");
            }
            params.append("--display=" + runDisplay);
            if (present) {
                params.append("--present");
                params.append("--stop-color=" + Preferences.get((String)"run.present.stop.color"));
                params.append("--window-color=" + Preferences.get((String)"run.present.bgcolor"));
            }
            params.append("--sketch-path=" + this.build.getSketchPath());
            if (Platform.isWindows()) {
                int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
                int uiScale = PApplet.constrain((int)(dpi / 96), (int)1, (int)2);
                params.append("--ui-scale=" + uiScale);
            }
            params.append(this.build.getSketchClassName());
        }
        if (args != null) {
            params.append(args);
        }
        return params;
    }

    protected void launchJava(String[] args) {
        new Thread(() -> {
            this.vmReturnedError = false;
            this.process = PApplet.exec((String[])args);
            try {
                int result = this.process.waitFor();
                if (result != 0) {
                    String[] errorStrings = PApplet.loadStrings((InputStream)this.process.getErrorStream());
                    String[] inputStrings = PApplet.loadStrings((InputStream)this.process.getInputStream());
                    PApplet.printArray((Object)inputStrings);
                    if (errorStrings != null && errorStrings.length > 1) {
                        if (errorStrings[0].contains("Invalid maximum heap size")) {
                            Messages.showWarning((String)"Way Too High", (String)"Please lower the value for \u201cmaximum available memory\u201d in the\nPreferences window. For more information, read Help \u2192 Troubleshooting.", null);
                        } else {
                            for (String err : errorStrings) {
                                this.sketchErr.println(err);
                            }
                            this.sketchErr.println("Using startup command: " + PApplet.join((String[])args, (String)" "));
                        }
                    } else {
                        this.sketchErr.println("Could not run the sketch (Target VM failed to initialize).");
                        if (Preferences.getBoolean((String)"run.options.memory")) {
                            this.sketchErr.println("Make sure that you haven't set the maximum available memory too high.");
                        }
                        this.sketchErr.println("For more information, read Help \u2192 Troubleshooting.");
                    }
                    this.listener.statusError("Could not run the sketch.");
                    this.vmReturnedError = true;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    protected void generateTrace() {
        try {
            this.vm.allThreads();
            EventRequestManager mgr = this.vm.eventRequestManager();
            ExceptionRequest excReq = mgr.createExceptionRequest(null, false, true);
            excReq.setSuspendPolicy(2);
            excReq.enable();
        }
        catch (VMDisconnectedException ignore) {
            return;
        }
        Thread eventThread = new Thread(() -> {
            try {
                boolean connected = true;
                while (connected) {
                    com.sun.jdi.event.EventQueue eventQueue = this.vm.eventQueue();
                    EventSet eventSet = eventQueue.remove();
                    for (Event event : eventSet) {
                        if (event instanceof VMStartEvent) {
                            this.vm.resume();
                            continue;
                        }
                        if (event instanceof ExceptionEvent) {
                            this.exceptionEvent((ExceptionEvent)event);
                            continue;
                        }
                        if (!(event instanceof VMDisconnectEvent)) continue;
                        connected = false;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("crashed in event thread due to " + e.getMessage());
                e.printStackTrace();
            }
        });
        eventThread.start();
        this.errThread = new MessageSiphon(this.process.getErrorStream(), this).getThread();
        this.outThread = new StreamRedirectThread("JVM stdout Reader", this.process.getInputStream(), (OutputStream)this.sketchOut);
        this.errThread.start();
        this.outThread.start();
        try {
            if (eventThread != null) {
                eventThread.join();
            }
            this.errThread.join();
            this.outThread.join();
            if (this.editor != null) {
                EventQueue.invokeLater(() -> this.editor.onRunnerExiting(this));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected Connector findConnector(String connectorName) {
        List<Connector> connectors = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector connector : connectors) {
            if (!connector.name().equals(connectorName)) continue;
            return connector;
        }
        Messages.showError((String)"Compiler Error", (String)("findConnector() failed to find " + connectorName + " inside Runner"), null);
        return null;
    }

    public void exceptionEvent(ExceptionEvent event) {
        ObjectReference or = event.exception();
        ReferenceType rt = or.referenceType();
        String exceptionName = rt.name();
        Field messageField = rt.fieldByName("detailMessage");
        Value messageValue = or.getValue(messageField);
        int last = exceptionName.lastIndexOf(46);
        Object message = exceptionName.substring(last + 1);
        if (messageValue != null) {
            String messageStr = messageValue.toString();
            if (messageStr.startsWith("\"")) {
                messageStr = messageStr.substring(1, messageStr.length() - 1);
            }
            message = (String)message + ": " + messageStr;
        }
        this.reportException((String)message, or, event.thread());
        Runner.handleCommonErrors(exceptionName, (String)message, this.listener, this.sketchErr);
        if (this.editor != null) {
            EventQueue.invokeLater(() -> this.editor.onRunnerExiting(this));
        }
    }

    public static boolean handleCommonErrors(String exceptionClass, String message, RunnerListener listener, PrintStream err) {
        if (exceptionClass.equals("java.lang.OutOfMemoryError")) {
            if (message.contains("exceeds VM budget")) {
                listener.statusError("OutOfMemoryError: This code attempts to use more memory than available.");
                err.println("An OutOfMemoryError means that your code is either using up too much memory");
                err.println("because of a bug (e.g. creating an array that's too large, or unintentionally");
                err.println("loading thousands of images), or simply that it's trying to use more memory");
                err.println("than what is supported by the current device.");
            } else {
                listener.statusError("OutOfMemoryError: You may need to increase the memory setting in Preferences.");
                err.println("An OutOfMemoryError means that your code is either using up too much memory");
                err.println("because of a bug (e.g. creating an array that's too large, or unintentionally");
                err.println("loading thousands of images), or that your sketch may need more memory to run.");
                err.println("If your sketch uses a lot of memory (for instance if it loads a lot of data files)");
                err.println("you can increase the memory available to your sketch using the Preferences window.");
            }
        } else if (exceptionClass.equals("java.lang.UnsatisfiedLinkError")) {
            err.println("A library used by this sketch relies on native code that is not available.");
            err.println(message);
        } else if (exceptionClass.equals("java.lang.StackOverflowError")) {
            listener.statusError("StackOverflowError: This sketch is attempting too much recursion.");
            err.println("A StackOverflowError means that you have a bug that's causing a function");
            err.println("to be called recursively (it's calling itself and going in circles),");
            err.println("or you're intentionally calling a recursive function too much,");
            err.println("and your code should be rewritten in a more efficient manner.");
        } else if (exceptionClass.equals("java.lang.UnsupportedClassVersionError")) {
            listener.statusError("UnsupportedClassVersionError: A library is using code compiled with an unsupported version of Java.");
            err.println("This version of Processing only supports libraries and JAR files compiled for Java 1.8 or earlier.");
            err.println("A library used by this sketch was compiled for Java 1.9 or later, ");
            err.println("and needs to be recompiled to be compatible with Java 1.8.");
        } else if (exceptionClass.equals("java.lang.NoSuchMethodError") || exceptionClass.equals("java.lang.NoSuchFieldError")) {
            listener.statusError(exceptionClass.substring(10) + ": You may be using a library that's incompatible with this version of Processing.");
        } else {
            return false;
        }
        return true;
    }

    protected void reportException(String message, ObjectReference or, ThreadReference thread) {
        this.listener.statusError((Exception)((Object)this.findException(message, or, thread)));
    }

    protected SketchException findException(String message, ObjectReference or, ThreadReference thread) {
        block10: {
            block9: {
                try {
                    List<StackFrame> frames = thread.frames();
                    for (StackFrame frame : frames) {
                        try {
                            int lineNumber;
                            Location location = frame.location();
                            String filename = location.sourceName();
                            SketchException rex = this.build.placeException(message, filename, lineNumber = location.lineNumber() - 1);
                            if (rex == null) continue;
                            return rex;
                        }
                        catch (AbsentInformationException e) {
                            this.exception = new SketchException(message);
                            this.exception.hideStackTrace();
                            this.listener.statusError((Exception)((Object)this.exception));
                        }
                    }
                }
                catch (IncompatibleThreadStateException e) {
                    e.printStackTrace(this.sketchErr);
                }
                catch (Exception e) {
                    if ("StackOverflowError".equals(message)) break block9;
                    e.printStackTrace(this.sketchErr);
                }
            }
            try {
                Method method = ((ClassType)or.referenceType()).concreteMethodByName("getStackTrace", "()[Ljava/lang/StackTraceElement;");
                ArrayReference result = (ArrayReference)or.invokeMethod(thread, method, new ArrayList(), 1);
                for (Value val : result.getValues()) {
                    IntegerValue intval;
                    int lineNumber;
                    ObjectReference ref = (ObjectReference)val;
                    StringReference strref = (StringReference)ref.invokeMethod(thread, method = ((ClassType)ref.referenceType()).concreteMethodByName("getFileName", "()Ljava/lang/String;"), new ArrayList(), 1);
                    String filename = strref == null ? "Unknown Source" : strref.value();
                    SketchException rex = this.build.placeException(message, filename, lineNumber = (intval = (IntegerValue)ref.invokeMethod(thread, method = ((ClassType)ref.referenceType()).concreteMethodByName("getLineNumber", "()I"), new ArrayList(), 1)).intValue() - 1);
                    if (rex == null) continue;
                    return rex;
                }
                method = ((ClassType)or.referenceType()).concreteMethodByName("printStackTrace", "()V");
                or.invokeMethod(thread, method, new ArrayList(), 1);
            }
            catch (Exception e) {
                if ("StackOverflowError".equals(message)) break block10;
                e.printStackTrace(this.sketchErr);
            }
        }
        SketchException rex = new SketchException(message);
        rex.hideStackTrace();
        return rex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.cancelLock;
        synchronized (object) {
            this.cancelled = true;
            if (this.vm != null) {
                try {
                    this.vm.exit(0);
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public synchronized void message(String s) {
        if (s.indexOf("__STOP__") == 0) {
            if (this.editor != null) {
                EventQueue.invokeLater(() -> this.editor.internalCloseRunner());
            }
            return;
        }
        if (s.indexOf("__MOVE__") == 0) {
            String nums = s.substring(s.indexOf(32) + 1).trim();
            int space = nums.indexOf(32);
            int left = Integer.parseInt(nums.substring(0, space));
            int top = Integer.parseInt(nums.substring(space + 1));
            this.editor.setSketchLocation(new Point(left, top));
            return;
        }
        this.sketchErr.print(s);
        this.sketchErr.flush();
    }
}

