/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.Language;
import processing.app.Platform;
import processing.mode.java.SourceUtil;
import processing.mode.java.preproc.PdeIssueEmitter;

public class PreprocessIssueMessageSimplifier {
    private static AtomicReference<PreprocessIssueMessageSimplifier> instance = new AtomicReference();
    private List<PreprocIssueMessageSimplifierStrategy> strategies = new ArrayList<PreprocIssueMessageSimplifierStrategy>();

    public static PreprocessIssueMessageSimplifier get() {
        instance.compareAndSet(null, new PreprocessIssueMessageSimplifier());
        return instance.get();
    }

    public static String getLocalStr(String stringName) {
        String retStr;
        String errStr;
        if (Platform.isAvailable()) {
            errStr = Language.text((String)"editor.status.error.syntax");
            retStr = Language.text((String)stringName);
        } else {
            errStr = DefaultErrorLocalStrSet.get().get("editor.status.error.syntax").orElse("Error");
            retStr = DefaultErrorLocalStrSet.get().get(stringName).orElse(stringName);
        }
        return String.format(errStr, retStr);
    }

    public PdeIssueEmitter.IssueMessageSimplification simplify(String originalMessage) {
        Optional<PdeIssueEmitter.IssueMessageSimplification> matching = this.strategies.stream().map(x -> x.simplify(originalMessage)).filter(Optional::isPresent).map(Optional::get).findFirst();
        return matching.orElse(new PdeIssueEmitter.IssueMessageSimplification(originalMessage));
    }

    private PreprocessIssueMessageSimplifier() {
        this.strategies.add(this.createMissingCurlyAtStartSimplifierStrategy());
        this.strategies.add(this.createMissingCurlyAtSemicolonSimplifierStrategy());
        this.strategies.add(this.createInvalidGenericDefinitionStrategy());
        this.strategies.add(this.createMissingIdentifierSimplifierStrategy());
        this.strategies.add(this.createKnownMissingSimplifierStrategy());
        this.strategies.add(this.createExtraneousInputSimplifierStrategy());
        this.strategies.add(this.createMismatchedInputSimplifierStrategy());
        this.strategies.add(this.createInvalidAssignmentStrategy());
        this.strategies.add(this.createVariableDeclarationMissingTypeStrategy());
        this.strategies.add(this.createInvalidIdentifierStrategy());
        this.strategies.add(this.createMissingClassNameStrategy());
        this.strategies.add(this.createMethodMissingNameStrategy());
        this.strategies.add(this.createErrorOnParameterStrategy());
        this.strategies.add(this.createMissingDoubleQuoteStrategy());
        this.strategies.add(this.createMissingSingleQuoteStrategy());
        this.strategies.add(this.createUnbalancedCurlyStrategy());
        this.strategies.add(this.createUnbalancedParenStrategy());
        this.strategies.add(this.createUnbalancedChevStrategy());
        this.strategies.add(new DefaultMessageSimplifier());
    }

    protected static String getOffendingArea(String area) {
        return PreprocessIssueMessageSimplifier.getOffendingArea(area, true);
    }

    private static String getOffendingArea(String area, boolean removeNewline) {
        if (!area.contains("viable alternative")) {
            return area;
        }
        String content = area.replace("no viable alternative at input '", "");
        if (removeNewline) {
            String[] contentLines = content.replace("\n", "\\n").split("\\\\n");
            content = contentLines[contentLines.length - 1];
        }
        if (content.endsWith("'")) {
            return content.substring(0, content.length() - 1);
        }
        return content;
    }

    private static String getLocalizedGenericError(String unlocalized) {
        String template = PreprocessIssueMessageSimplifier.getLocalStr("editor.status.error_on");
        return String.format(template, unlocalized);
    }

    protected PreprocIssueMessageSimplifierStrategy createMissingSingleQuoteStrategy() {
        return new EvenCountTemplateMessageSimplifierStrategy("'", "\\'");
    }

    protected PreprocIssueMessageSimplifierStrategy createMissingDoubleQuoteStrategy() {
        return new EvenCountTemplateMessageSimplifierStrategy("\"", "\\\"");
    }

    protected PreprocIssueMessageSimplifierStrategy createUnbalancedCurlyStrategy() {
        return new TokenPairTemplateMessageSimplifierStrategy("{", "}");
    }

    protected PreprocIssueMessageSimplifierStrategy createUnbalancedChevStrategy() {
        return new TokenPairTemplateMessageSimplifierStrategy("<", ">");
    }

    protected PreprocIssueMessageSimplifierStrategy createUnbalancedParenStrategy() {
        return new TokenPairTemplateMessageSimplifierStrategy("(", ")");
    }

    protected PreprocIssueMessageSimplifierStrategy createRegexStrategyUsingLocalStr(String regex, String localStr) {
        return new RegexTemplateMessageSimplifierStrategy(regex, PreprocessIssueMessageSimplifier.getLocalStr(localStr));
    }

    protected PreprocIssueMessageSimplifierStrategy createErrorOnParameterStrategy() {
        return this.createRegexStrategyUsingLocalStr("([a-zA-Z0-9_]+\\s*,|[a-zA-Z0-9_]+\\)|\\([^\\)]+)", "editor.status.bad.parameter");
    }

    protected PreprocIssueMessageSimplifierStrategy createMethodMissingNameStrategy() {
        return this.createRegexStrategyUsingLocalStr("[a-zA-Z0-9_]+\\s*\\(.*\\)\\s*\\{", "editor.status.missing.name");
    }

    protected PreprocIssueMessageSimplifierStrategy createMissingClassNameStrategy() {
        return this.createRegexStrategyUsingLocalStr(".*(class|interface)\\s*[a-zA-Z0-9_]*\\s+(extends|implements|<.*>)?\\s*[a-zA-Z0-9_]*\\s*\\{.*", "editor.status.missing.name");
    }

    protected PreprocIssueMessageSimplifierStrategy createInvalidIdentifierStrategy() {
        return this.createRegexStrategyUsingLocalStr("([.\\s]*[0-9]+[a-zA-Z_<>]+[0-9a-zA-Z_<>]*|\\s+\\d+[a-zA-Z_<>]+|[0-9a-zA-Z_<>]+\\s+[0-9]+)", "editor.status.bad.identifier");
    }

    protected PreprocIssueMessageSimplifierStrategy createVariableDeclarationMissingTypeStrategy() {
        return this.createRegexStrategyUsingLocalStr("[a-zA-Z_]+[0-9a-zA-Z_]*\\s*(=[^\n\\n;]*)?;'?$", "editor.status.missing.type");
    }

    protected PreprocIssueMessageSimplifierStrategy createInvalidAssignmentStrategy() {
        return this.createRegexStrategyUsingLocalStr("[.\\n]*[0-9a-zA-Z\\_<>]+\\s*=[\\s';]*$", "editor.status.bad.assignment");
    }

    protected PreprocIssueMessageSimplifierStrategy createInvalidGenericDefinitionStrategy() {
        return this.createRegexStrategyUsingLocalStr("<>'?$", "editor.status.bad.generic");
    }

    protected PreprocIssueMessageSimplifierStrategy createMissingCurlyAtStartSimplifierStrategy() {
        return message -> {
            boolean matches = message.endsWith("expecting {'throws', '{'}");
            boolean bl = matches = matches || message.endsWith("expecting {'throws', '{', '[', ';'}");
            if (!matches) {
                return Optional.empty();
            }
            return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(PreprocessIssueMessageSimplifier.getLocalStr("editor.status.missing.left_curly_bracket")));
        };
    }

    protected PreprocIssueMessageSimplifierStrategy createMissingCurlyAtSemicolonSimplifierStrategy() {
        return message -> {
            if (!message.equals("missing ';' at '{'")) {
                return Optional.empty();
            }
            return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(PreprocessIssueMessageSimplifier.getLocalStr("editor.status.missing.right_curly_bracket")));
        };
    }

    protected PreprocIssueMessageSimplifierStrategy createMissingIdentifierSimplifierStrategy() {
        return message -> {
            if (message.toLowerCase().contains("missing identifier at")) {
                String newMessage = String.format(PreprocessIssueMessageSimplifier.getLocalStr("editor.status.missing.name"), message.replace("missing Identifier at", ""));
                return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(newMessage));
            }
            return Optional.empty();
        };
    }

    protected PreprocIssueMessageSimplifierStrategy createKnownMissingSimplifierStrategy() {
        Pattern parsePattern = Pattern.compile(".*missing '(.*)' at .*");
        return message -> {
            if (message.toLowerCase().contains("missing")) {
                Matcher matcher = parsePattern.matcher(message);
                String missingPiece = matcher.find() ? matcher.group(1) : "character";
                String langTemplate = PreprocessIssueMessageSimplifier.getLocalStr("editor.status.missing.default").replace("%c", "%s");
                String newMessage = String.format(langTemplate, missingPiece);
                return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(newMessage));
            }
            return Optional.empty();
        };
    }

    protected PreprocIssueMessageSimplifierStrategy createExtraneousInputSimplifierStrategy() {
        return message -> {
            if (message.toLowerCase().contains("extraneous")) {
                String innerMsg = PreprocessIssueMessageSimplifier.getOffendingArea(message);
                String newMessageOuter = PreprocessIssueMessageSimplifier.getLocalStr("editor.status.extraneous");
                String newMessage = String.format(newMessageOuter, innerMsg);
                return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(newMessage));
            }
            return Optional.empty();
        };
    }

    protected PreprocIssueMessageSimplifierStrategy createMismatchedInputSimplifierStrategy() {
        Pattern parser = Pattern.compile("mismatched input '(.*)' expecting ");
        return message -> {
            if (message.toLowerCase().contains("mismatched input")) {
                Matcher matcher = parser.matcher(message);
                String newMessage = String.format(PreprocessIssueMessageSimplifier.getLocalStr("editor.status.mismatched"), matcher.find() ? matcher.group(1) : message);
                return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(newMessage));
            }
            return Optional.empty();
        };
    }

    public static class DefaultErrorLocalStrSet {
        private static final AtomicReference<DefaultErrorLocalStrSet> instance = new AtomicReference();
        private final Map<String, String> localizations = new HashMap<String, String>();

        public static DefaultErrorLocalStrSet get() {
            instance.compareAndSet(null, new DefaultErrorLocalStrSet());
            return instance.get();
        }

        private DefaultErrorLocalStrSet() {
            this.localizations.put("editor.status.error", "Error");
            this.localizations.put("editor.status.error.syntax", "Syntax Error - %s");
            this.localizations.put("editor.status.bad.assignment", "Error on variable assignment near %s?");
            this.localizations.put("editor.status.bad.identifier", "Identifier cannot start with digits near %s?");
            this.localizations.put("editor.status.bad.parameter", "Error on parameter or method declaration near %s?");
            this.localizations.put("editor.status.extraneous", "Unexpected extra code near %s?");
            this.localizations.put("editor.status.mismatched", "Missing operator or semicolon near %s?");
            this.localizations.put("editor.status.missing.name", "Missing name near %s?");
            this.localizations.put("editor.status.missing.type", "Missing name or type near %s?");
            this.localizations.put("editor.status.missing.default", "Missing '%s'?");
            this.localizations.put("editor.status.missing.right_curly_bracket", "Missing '}'");
            this.localizations.put("editor.status.missing.left_curly_bracket", "Missing '{'");
        }

        public Optional<String> get(String key) {
            return Optional.ofNullable(this.localizations.getOrDefault(key, null));
        }
    }

    protected static interface PreprocIssueMessageSimplifierStrategy {
        public Optional<PdeIssueEmitter.IssueMessageSimplification> simplify(String var1);
    }

    protected static class DefaultMessageSimplifier
    implements PreprocIssueMessageSimplifierStrategy {
        protected DefaultMessageSimplifier() {
        }

        @Override
        public Optional<PdeIssueEmitter.IssueMessageSimplification> simplify(String message) {
            if (message.contains("viable alternative")) {
                String newMessage = String.format(PreprocessIssueMessageSimplifier.getLocalizedGenericError("%s"), PreprocessIssueMessageSimplifier.getOffendingArea(message));
                return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(newMessage));
            }
            return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(message));
        }
    }

    protected static class EvenCountTemplateMessageSimplifierStrategy
    implements PreprocIssueMessageSimplifierStrategy {
        private final String token;
        private final Optional<String> filter;

        protected EvenCountTemplateMessageSimplifierStrategy(String newToken) {
            this.token = newToken;
            this.filter = Optional.empty();
        }

        protected EvenCountTemplateMessageSimplifierStrategy(String newToken, String newFilter) {
            this.token = newToken;
            this.filter = Optional.of(newFilter);
        }

        @Override
        public Optional<PdeIssueEmitter.IssueMessageSimplification> simplify(String message) {
            int count;
            String messageContent = PreprocessIssueMessageSimplifier.getOffendingArea(message);
            if (this.filter.isPresent()) {
                messageContent = messageContent.replace(this.filter.get(), "");
            }
            if ((count = SourceUtil.getCount(messageContent, this.token)) % 2 == 0) {
                return Optional.empty();
            }
            String newMessage = String.format(PreprocessIssueMessageSimplifier.getLocalStr("editor.status.missing.default").replace("%c", "%s"), this.token);
            return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(newMessage));
        }
    }

    protected static class TokenPairTemplateMessageSimplifierStrategy
    implements PreprocIssueMessageSimplifierStrategy {
        private final String token1;
        private final String token2;

        public TokenPairTemplateMessageSimplifierStrategy(String newToken1, String newToken2) {
            this.token1 = newToken1;
            this.token2 = newToken2;
        }

        @Override
        public Optional<PdeIssueEmitter.IssueMessageSimplification> simplify(String message) {
            int count2;
            String messageContent = PreprocessIssueMessageSimplifier.getOffendingArea(message);
            int count1 = SourceUtil.getCount(messageContent, this.token1);
            if (count1 == (count2 = SourceUtil.getCount(messageContent, this.token2))) {
                return Optional.empty();
            }
            String missingToken = count1 < count2 ? this.token1 : this.token2;
            String newMessage = String.format(PreprocessIssueMessageSimplifier.getLocalStr("editor.status.missing.default").replace("%c", "%s"), missingToken);
            return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(newMessage));
        }
    }

    protected static class RegexTemplateMessageSimplifierStrategy
    implements PreprocIssueMessageSimplifierStrategy {
        private final Pattern pattern;
        private final String hintTemplate;

        public RegexTemplateMessageSimplifierStrategy(String newRegex, String newHintTemplate) {
            this.pattern = Pattern.compile(newRegex);
            this.hintTemplate = newHintTemplate;
        }

        @Override
        public Optional<PdeIssueEmitter.IssueMessageSimplification> simplify(String message) {
            if (this.pattern.matcher(message).find()) {
                String newMessage = String.format(this.hintTemplate, PreprocessIssueMessageSimplifier.getOffendingArea(message));
                return Optional.of(new PdeIssueEmitter.IssueMessageSimplification(newMessage, this.getAttributeToPrior()));
            }
            return Optional.empty();
        }

        public boolean getAttributeToPrior() {
            return false;
        }
    }

    public static class PriorTokenFinder {
        private static final String WS_PATTERN = "[ \\t\\r\\n\\u000C]";
        private boolean done;
        private Optional<Integer> tokenPosition;
        private AutomatonState state;
        private int charPosition;
        private Pattern whitespacePattern = Pattern.compile("[ \\t\\r\\n\\u000C]");

        PriorTokenFinder() {
            this.reset();
        }

        boolean isDone() {
            return this.done;
        }

        Optional<Integer> getTokenPositionMaybe() {
            return this.tokenPosition;
        }

        void reset() {
            this.done = false;
            this.tokenPosition = Optional.empty();
            this.state = AutomatonState.UNKNOWN;
            this.charPosition = 0;
        }

        void step(char input) {
            switch (this.state) {
                case UNKNOWN: {
                    this.stepUnknown(input);
                    break;
                }
                case POSSIBLE_TOKEN: {
                    this.stepPossibleToken(input);
                    break;
                }
                case TOKEN_OR_MAYBE_SL_COMMENT: {
                    this.stepTokenOrMaybeSingleLineComment(input);
                    break;
                }
                case TOKEN_OR_MAYBE_COMMENT: {
                    this.stepTokenOrMaybeComment(input);
                    break;
                }
                case MULTI_LINE_COMMENT: {
                    this.stepMultiLineComment(input);
                    break;
                }
                case MAYBE_LEAVE_MULTI_LINE_COMMENT: {
                    this.stepMaybeLeaveMultiLineComment(input);
                    break;
                }
            }
            ++this.charPosition;
        }

        private void stepUnknown(char input) {
            if (this.isWhitespace(input)) {
                return;
            }
            this.tokenPosition = Optional.of(this.charPosition);
            this.state = input == '/' ? AutomatonState.TOKEN_OR_MAYBE_COMMENT : AutomatonState.POSSIBLE_TOKEN;
        }

        private void stepPossibleToken(char input) {
            if (input == '\n') {
                this.enterNonSkipTokenState();
            } else if (input == '/') {
                this.state = AutomatonState.TOKEN_OR_MAYBE_SL_COMMENT;
            }
        }

        private void stepTokenOrMaybeSingleLineComment(char input) {
            if (input == '\n') {
                this.enterNonSkipTokenState();
            } else if (input == '/') {
                this.returnToUnknownState();
            } else {
                this.state = AutomatonState.POSSIBLE_TOKEN;
            }
        }

        private void stepTokenOrMaybeComment(char input) {
            if (input == '\n') {
                this.enterNonSkipTokenState();
            } else if (input == '/') {
                this.returnToUnknownState();
            } else if (input == '*') {
                this.enterMultilineComment();
            } else {
                this.state = AutomatonState.POSSIBLE_TOKEN;
            }
        }

        private void stepMultiLineComment(char input) {
            if (input == '*') {
                this.state = AutomatonState.MAYBE_LEAVE_MULTI_LINE_COMMENT;
            }
        }

        private void stepMaybeLeaveMultiLineComment(char input) {
            if (input == '/') {
                this.state = AutomatonState.UNKNOWN;
            } else if (input != '*') {
                this.state = AutomatonState.MULTI_LINE_COMMENT;
            }
        }

        private void enterMultilineComment() {
            this.tokenPosition = Optional.of(this.charPosition);
            this.state = AutomatonState.MULTI_LINE_COMMENT;
        }

        private void enterNonSkipTokenState() {
            this.done = true;
            this.state = AutomatonState.TOKEN;
        }

        private void returnToUnknownState() {
            this.tokenPosition = Optional.empty();
            this.state = AutomatonState.UNKNOWN;
        }

        private boolean isWhitespace(char input) {
            return this.whitespacePattern.matcher("" + input).find();
        }

        private static enum AutomatonState {
            UNKNOWN,
            POSSIBLE_TOKEN,
            TOKEN_OR_MAYBE_SL_COMMENT,
            TOKEN_OR_MAYBE_COMMENT,
            TOKEN,
            MULTI_LINE_COMMENT,
            MAYBE_LEAVE_MULTI_LINE_COMMENT;

        }
    }
}

