/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import processing.app.Preferences;
import processing.app.SketchException;
import processing.mode.java.preproc.PdeIssueEmitter;
import processing.mode.java.preproc.PdeParseTreeListener;
import processing.mode.java.preproc.PdePreprocessIssue;
import processing.mode.java.preproc.PreprocessorResult;
import processing.mode.java.preproc.ProcessingLexer;
import processing.mode.java.preproc.ProcessingParser;

public class PdePreprocessor {
    private final String sketchName;
    private final int tabSize;
    private final boolean isTesting;
    private final ParseTreeListenerFactory listenerFactory;
    private final List<String> defaultImports;
    private final List<String> coreImports;
    private final Optional<String> destinationPackage;
    private boolean foundMain;

    public static PdePreprocessorBuilder builderFor(String sketchName) {
        return new PdePreprocessorBuilder(sketchName);
    }

    public PdePreprocessor(String newSketchName, int newTabSize, boolean newIsTesting, ParseTreeListenerFactory newFactory, List<String> newDefaultImports, List<String> newCoreImports, Optional<String> newDestinationPackage) {
        this.sketchName = newSketchName;
        this.tabSize = newTabSize;
        this.isTesting = newIsTesting;
        this.listenerFactory = newFactory;
        this.defaultImports = newDefaultImports;
        this.coreImports = newCoreImports;
        this.destinationPackage = newDestinationPackage;
    }

    public PreprocessorResult write(Writer out, String program) throws SketchException {
        return this.write(out, program, null);
    }

    public PreprocessorResult write(Writer outWriter, String inProgram, Iterable<String> codeFolderPackages) throws SketchException {
        ArrayList<String> codeFolderImports = new ArrayList<String>();
        if (codeFolderPackages != null) {
            for (String item : codeFolderPackages) {
                Object fullItem = item.endsWith(".*") ? item : item + ".*";
                codeFolderImports.add((String)fullItem);
            }
        }
        if (Preferences.getBoolean((String)"preproc.substitute_unicode")) {
            inProgram = PdePreprocessor.substituteUnicode((String)inProgram);
        }
        while (((String)inProgram).endsWith("\n")) {
            inProgram = ((String)inProgram).substring(0, ((String)inProgram).length() - 1);
        }
        inProgram = (String)inProgram + "\n";
        CodePointCharStream antlrInStream = CharStreams.fromString((String)inProgram);
        ProcessingLexer lexer = new ProcessingLexer((CharStream)antlrInStream);
        lexer.removeErrorListeners();
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ArrayList<PdePreprocessIssue> preprocessIssues = new ArrayList<PdePreprocessIssue>();
        ArrayList<PdePreprocessIssue> treeIssues = new ArrayList<PdePreprocessIssue>();
        PdeParseTreeListener listener = this.listenerFactory.build(tokens, this.sketchName, this.tabSize, this.destinationPackage);
        listener.setTesting(this.isTesting);
        listener.setCoreImports(this.coreImports);
        listener.setDefaultImports(this.defaultImports);
        listener.setCodeFolderImports(codeFolderImports);
        listener.setTreeErrorListener(treeIssues::add);
        Object finalInProgram = inProgram;
        ProcessingParser parser = new ProcessingParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new PdeIssueEmitter(preprocessIssues::add, () -> PdePreprocessor.lambda$write$0((String)finalInProgram)));
        parser.setBuildParseTree(true);
        ProcessingParser.ProcessingSketchContext tree = parser.processingSketch();
        ParseTreeWalker treeWalker = new ParseTreeWalker();
        treeWalker.walk((ParseTreeListener)listener, (ParseTree)tree);
        String outputProgram = listener.getOutputProgram();
        PrintWriter outPrintWriter = new PrintWriter(outWriter);
        outPrintWriter.print(outputProgram);
        this.foundMain = listener.foundMain();
        if (preprocessIssues.size() > 0) {
            return listener.getResult(preprocessIssues);
        }
        if (treeIssues.size() > 0) {
            return listener.getResult(treeIssues);
        }
        return listener.getResult();
    }

    public boolean hasMain() {
        return this.foundMain;
    }

    public List<String> getCoreImports() {
        return this.coreImports;
    }

    public List<String> getDefaultImports() {
        return this.defaultImports;
    }

    private static String substituteUnicode(String program) {
        char[] p = program.toCharArray();
        int unicodeCount = 0;
        for (char value : p) {
            if (value <= '\u007f') continue;
            ++unicodeCount;
        }
        if (unicodeCount == 0) {
            return program;
        }
        int index = 0;
        char[] p2 = new char[p.length + unicodeCount * 5];
        for (char value : p) {
            if (value < '\u0080') {
                p2[index++] = value;
                continue;
            }
            if (value == '\u00a0') {
                p2[index++] = 32;
                continue;
            }
            p2[index++] = 92;
            p2[index++] = 117;
            char[] str = Integer.toHexString(value).toCharArray();
            for (int m = 0; m < 4 - str.length; ++m) {
                p2[index++] = 48;
            }
            System.arraycopy(str, 0, p2, index, str.length);
            index += str.length;
        }
        return new String(p2, 0, index);
    }

    private static /* synthetic */ String lambda$write$0(String finalInProgram) {
        return finalInProgram;
    }

    public static class PdePreprocessorBuilder {
        private final String mainName;
        private Optional<Integer> tabSize;
        private Optional<Boolean> isTesting;
        private Optional<ParseTreeListenerFactory> parseTreeFactory;
        private Optional<List<String>> defaultImports;
        private Optional<List<String>> coreImports;
        private Optional<String> destinationPackage;
        public static final String[] BASE_CORE_IMPORTS = new String[]{"processing.core.*", "processing.data.*", "processing.event.*", "processing.opengl.*"};
        public static final String[] BASE_DEFAULT_IMPORTS = new String[]{"java.util.HashMap", "java.util.ArrayList", "java.io.File", "java.io.BufferedReader", "java.io.PrintWriter", "java.io.InputStream", "java.io.OutputStream", "java.io.IOException"};

        private PdePreprocessorBuilder(String newMainName) {
            this.mainName = newMainName;
            this.tabSize = Optional.empty();
            this.isTesting = Optional.empty();
            this.parseTreeFactory = Optional.empty();
            this.defaultImports = Optional.empty();
            this.coreImports = Optional.empty();
            this.destinationPackage = Optional.empty();
        }

        public PdePreprocessorBuilder setTabSize(int newTabSize) {
            this.tabSize = Optional.of(newTabSize);
            return this;
        }

        public PdePreprocessorBuilder setIsTesting(boolean newIsTesting) {
            this.isTesting = Optional.of(newIsTesting);
            return this;
        }

        public PdePreprocessorBuilder setParseTreeListenerFactory(ParseTreeListenerFactory newFactory) {
            this.parseTreeFactory = Optional.of(newFactory);
            return this;
        }

        public PdePreprocessorBuilder setDefaultImports(List<String> newDefaultImports) {
            this.defaultImports = Optional.of(newDefaultImports);
            return this;
        }

        public PdePreprocessorBuilder setCoreImports(List<String> newCoreImports) {
            this.coreImports = Optional.of(newCoreImports);
            return this;
        }

        public PdePreprocessorBuilder setDestinationPackage(String newDestinationPackage) {
            this.destinationPackage = Optional.of(newDestinationPackage);
            return this;
        }

        public PdePreprocessor build() {
            int effectiveTabSize = this.tabSize.orElseGet(() -> Preferences.getInteger((String)"editor.tabs.size"));
            boolean effectiveIsTesting = this.isTesting.orElse(false);
            ParseTreeListenerFactory effectiveFactory = this.parseTreeFactory.orElse(PdeParseTreeListener::new);
            List effectiveDefaultImports = this.defaultImports.orElseGet(() -> Arrays.asList(BASE_DEFAULT_IMPORTS));
            List effectiveCoreImports = this.coreImports.orElseGet(() -> Arrays.asList(BASE_CORE_IMPORTS));
            return new PdePreprocessor(this.mainName, effectiveTabSize, effectiveIsTesting, effectiveFactory, effectiveDefaultImports, effectiveCoreImports, this.destinationPackage);
        }
    }

    public static interface ParseTreeListenerFactory {
        public PdeParseTreeListener build(CommonTokenStream var1, String var2, int var3, Optional<String> var4);
    }

    public static enum Mode {
        STATIC,
        ACTIVE,
        JAVA;

    }
}

