/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import processing.app.Base;
import processing.app.Preferences;
import processing.core.PApplet;
import processing.mode.java.ImportStatement;
import processing.mode.java.SourceUtil;
import processing.mode.java.TextTransform;
import processing.mode.java.preproc.PdePreprocessIssue;
import processing.mode.java.preproc.PdePreprocessor;
import processing.mode.java.preproc.PreprocessIssueMessageSimplifier;
import processing.mode.java.preproc.PreprocessorResult;
import processing.mode.java.preproc.ProcessingBaseListener;
import processing.mode.java.preproc.ProcessingParser;
import processing.mode.java.preproc.RewriteResult;
import processing.mode.java.preproc.RewriteResultBuilder;

public class PdeParseTreeListener
extends ProcessingBaseListener {
    private static final String SIZE_METHOD_NAME = "size";
    private static final String SMOOTH_METHOD_NAME = "smooth";
    private static final String NO_SMOOTH_METHOD_NAME = "noSmooth";
    private static final String PIXEL_DENSITY_METHOD_NAME = "pixelDensity";
    private static final String FULLSCREEN_METHOD_NAME = "fullScreen";
    private static final boolean SIMULATE_MULTILINE_STRINGS = true;
    private final String sketchName;
    private boolean isTesting;
    private final TokenStreamRewriter rewriter;
    private Optional<String> destinationPackageName;
    private PdePreprocessor.Mode mode = PdePreprocessor.Mode.JAVA;
    private boolean foundMain;
    private int lineOffset;
    private List<ImportStatement> coreImports = new ArrayList<ImportStatement>();
    private List<ImportStatement> defaultImports = new ArrayList<ImportStatement>();
    private List<ImportStatement> codeFolderImports = new ArrayList<ImportStatement>();
    private List<ImportStatement> foundImports = new ArrayList<ImportStatement>();
    private List<TextTransform.Edit> edits = new ArrayList<TextTransform.Edit>();
    private String sketchWidth;
    private String sketchHeight;
    private String pixelDensity;
    private String smoothParam;
    private String sketchRenderer = null;
    private String fullscreenArgs = "";
    private String sketchOutputFilename = null;
    private boolean sizeRequiresRewrite = false;
    private boolean pixelDensityRequiresRewrite = false;
    private boolean sizeIsFullscreen = false;
    private boolean noSmoothRequiresRewrite = false;
    private boolean smoothRequiresRewrite = false;
    private RewriteResult headerResult;
    private RewriteResult footerResult;
    private String indent1;
    private String indent2;
    private String indent3;
    private Optional<PdeParseTreeErrorListener> pdeParseTreeErrorListenerMaybe;

    public PdeParseTreeListener(TokenStream tokens, String newSketchName, int newTabSize, Optional<String> newDestinationPackageName) {
        this.rewriter = new TokenStreamRewriter(tokens);
        this.sketchName = newSketchName;
        this.destinationPackageName = newDestinationPackageName;
        this.pdeParseTreeErrorListenerMaybe = Optional.empty();
        char[] indentChars = new char[newTabSize];
        Arrays.fill(indentChars, ' ');
        this.indent1 = new String(indentChars);
        this.indent2 = this.indent1 + this.indent1;
        this.indent3 = this.indent2 + this.indent1;
    }

    public void setCodeFolderImports(List<String> codeFolderImports) {
        this.setCodeFolderImportInfo(this.createPlainImportStatementInfos(codeFolderImports));
    }

    public void setCodeFolderImportInfo(List<ImportStatement> codeFolderImports) {
        this.codeFolderImports.clear();
        this.codeFolderImports.addAll(codeFolderImports);
    }

    public void setCoreImports(String[] coreImports) {
        this.setCoreImports(Arrays.asList(coreImports));
    }

    public void setCoreImports(List<String> coreImports) {
        this.setCoreImportInfo(this.createPlainImportStatementInfos(coreImports));
    }

    public void setCoreImportInfo(List<ImportStatement> coreImports) {
        this.coreImports.clear();
        this.coreImports.addAll(coreImports);
    }

    public void setDefaultImports(String[] defaultImports) {
        this.setDefaultImports(Arrays.asList(defaultImports));
    }

    public void setDefaultImports(List<String> defaultImports) {
        this.setDefaultImportInfo(this.createPlainImportStatementInfos(defaultImports));
    }

    public void setDefaultImportInfo(List<ImportStatement> defaultImports) {
        this.defaultImports.clear();
        this.defaultImports.addAll(defaultImports);
    }

    public void setTesting(boolean isTesting) {
        this.isTesting = isTesting;
    }

    public void setTreeErrorListener(PdeParseTreeErrorListener newListener) {
        this.pdeParseTreeErrorListenerMaybe = Optional.of(newListener);
    }

    public boolean foundMain() {
        return this.foundMain;
    }

    public String getOutputProgram() {
        return this.rewriter.getText();
    }

    public TokenStreamRewriter getRewriter() {
        return this.rewriter;
    }

    public PreprocessorResult getResult() {
        return this.getResult(new ArrayList<PdePreprocessIssue>());
    }

    public PreprocessorResult getResult(List<PdePreprocessIssue> issues) {
        ArrayList<ImportStatement> allImports = new ArrayList<ImportStatement>();
        allImports.addAll(this.coreImports);
        allImports.addAll(this.defaultImports);
        allImports.addAll(this.codeFolderImports);
        allImports.addAll(this.foundImports);
        ArrayList<TextTransform.Edit> allEdits = new ArrayList<TextTransform.Edit>();
        allEdits.addAll(this.headerResult.getEdits());
        allEdits.addAll(this.edits);
        allEdits.addAll(this.footerResult.getEdits());
        return new PreprocessorResult(this.mode, this.lineOffset, this.sketchName, allImports, allEdits, this.sketchWidth, this.sketchHeight, this.sketchRenderer, issues);
    }

    @Override
    public void exitProcessingSketch(ProcessingParser.ProcessingSketchContext ctx) {
        this.headerResult = this.prepareHeader(this.rewriter);
        this.lineOffset = this.headerResult.getLineOffset();
        TokenStream tokenStream = this.rewriter.getTokenStream();
        int tokens = tokenStream.size();
        int length = tokenStream.get(tokens - 1).getStopIndex();
        this.footerResult = this.prepareFooter(this.rewriter, length);
    }

    @Override
    public void enterWarnMixedModes(ProcessingParser.WarnMixedModesContext ctx) {
        this.pdeParseTreeErrorListenerMaybe.ifPresent(listener -> {
            Token token = ctx.getStart();
            int line = token.getLine();
            int charOffset = token.getCharPositionInLine();
            listener.onError(new PdePreprocessIssue(line, charOffset, PreprocessIssueMessageSimplifier.getLocalStr("editor.status.bad.mixed_mode")));
        });
    }

    @Override
    public void exitMethodCall(ProcessingParser.MethodCallContext ctx) {
        boolean usesThis;
        boolean impliedThis;
        String methodName = ctx.getChild(0).getText();
        boolean bl = impliedThis = ctx.getParent().getChildCount() == 1;
        if (impliedThis) {
            usesThis = true;
        } else {
            String statmentTarget = ctx.getParent().getChild(0).getText();
            boolean explicitThis = statmentTarget.equals("this");
            boolean explicitSuper = statmentTarget.equals("super");
            boolean bl2 = usesThis = explicitThis || explicitSuper;
        }
        if (!usesThis) {
            return;
        }
        if (SIZE_METHOD_NAME.equals(methodName) || FULLSCREEN_METHOD_NAME.equals(methodName)) {
            this.handleSizeCall(ctx);
        } else if (PIXEL_DENSITY_METHOD_NAME.equals(methodName)) {
            this.handlePixelDensityCall(ctx);
        } else if (NO_SMOOTH_METHOD_NAME.equals(methodName)) {
            this.handleNoSmoothCall(ctx);
        } else if (SMOOTH_METHOD_NAME.equals(methodName)) {
            this.handleSmoothCall(ctx);
        }
    }

    @Override
    public void exitImportDeclaration(ProcessingParser.ImportDeclarationContext ctx) {
        ProcessingParser.QualifiedNameContext startCtx = null;
        if (ctx.getParent() instanceof ProcessingParser.ClassBodyDeclarationContext) {
            this.pdeParseTreeErrorListenerMaybe.ifPresent(listener -> {
                Token token = ctx.getStart();
                int line = token.getLine();
                int charOffset = token.getCharPositionInLine();
                listener.onError(new PdePreprocessIssue(line, charOffset, PreprocessIssueMessageSimplifier.getLocalStr("editor.status.bad.import")));
            });
        }
        boolean isStaticImport = false;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree candidate = ctx.getChild(i);
            String candidateText = candidate.getText().toLowerCase();
            boolean childIsStatic = candidateText.equals("static");
            boolean bl = isStaticImport = isStaticImport || childIsStatic;
            if (!(candidate instanceof ProcessingParser.QualifiedNameContext)) continue;
            startCtx = (ProcessingParser.QualifiedNameContext)ctx.getChild(i);
        }
        if (startCtx == null) {
            return;
        }
        Interval interval = new Interval(startCtx.start.getStartIndex(), ctx.stop.getStopIndex());
        String importString = ctx.start.getInputStream().getText(interval);
        int endImportIndex = importString.length() - 1;
        Object importStringNoSemi = importString.substring(0, endImportIndex);
        if (isStaticImport) {
            importStringNoSemi = "static " + (String)importStringNoSemi;
        }
        this.foundImports.add(ImportStatement.parse((String)importStringNoSemi));
        this.delete(ctx.start, ctx.stop);
    }

    @Override
    public void exitFloatLiteral(ProcessingParser.FloatLiteralContext ctx) {
        String cTxt = ctx.getText().toLowerCase();
        if (!cTxt.endsWith("f") && !cTxt.endsWith("d")) {
            this.insertAfter(ctx.stop, "f");
        }
    }

    @Override
    public void exitMultilineStringLiteral(ProcessingParser.MultilineStringLiteralContext ctx) {
        String fullLiteral = ctx.getText();
        this.delete(ctx.start, ctx.stop);
        int endIndex = fullLiteral.length() - 3;
        String literalContents = fullLiteral.substring(3, endIndex);
        String newLiteralContents = literalContents.replace("\n", "\\n").replace("\"", "\\\"");
        this.insertAfter(ctx.stop, "\"" + newLiteralContents + "\"");
    }

    @Override
    public void exitStaticProcessingSketch(ProcessingParser.StaticProcessingSketchContext ctx) {
        this.mode = PdePreprocessor.Mode.STATIC;
    }

    @Override
    public void exitActiveProcessingSketch(ProcessingParser.ActiveProcessingSketchContext ctx) {
        this.mode = PdePreprocessor.Mode.ACTIVE;
    }

    @Override
    public void exitMethodDeclaration(ProcessingParser.MethodDeclarationContext ctx) {
        ParserRuleContext memCtx = ctx.getParent();
        ParserRuleContext clsBdyDclCtx = memCtx.getParent();
        ParserRuleContext clsBdyCtx = clsBdyDclCtx.getParent();
        ParserRuleContext clsDclCtx = clsBdyCtx.getParent();
        boolean inSketchContext = clsBdyCtx instanceof ProcessingParser.StaticProcessingSketchContext || clsBdyCtx instanceof ProcessingParser.ActiveProcessingSketchContext;
        boolean inPAppletContext = inSketchContext || clsDclCtx instanceof ProcessingParser.ClassDeclarationContext && clsDclCtx.getChildCount() >= 4 && clsDclCtx.getChild(2).getText().equals("extends") && clsDclCtx.getChild(3).getText().endsWith("PApplet");
        ProcessingParser.MethodDeclarationContext possibleModifiers = ctx;
        while (!(possibleModifiers instanceof ProcessingParser.ClassBodyDeclarationContext)) {
            possibleModifiers = possibleModifiers.getParent();
        }
        boolean hasVisibilityModifier = false;
        int numChildren = possibleModifiers.getChildCount();
        ParserRuleContext annoationPoint = null;
        for (int i = 0; i < numChildren; ++i) {
            ParseTree child = possibleModifiers.getChild(i);
            String childText = child.getText();
            boolean childIsVisibility = childText.equals("public");
            childIsVisibility = childIsVisibility || childText.equals("private");
            childIsVisibility = childIsVisibility || childText.equals("protected");
            hasVisibilityModifier = hasVisibilityModifier || childIsVisibility;
            boolean isModifier = child instanceof ProcessingParser.ModifierContext;
            if (!isModifier || !this.isAnnotation((ProcessingParser.ModifierContext)child)) continue;
            annoationPoint = (ParserRuleContext)child;
        }
        if (!hasVisibilityModifier) {
            if (annoationPoint == null) {
                this.insertBefore(possibleModifiers.getStart(), " public ");
            } else {
                this.insertAfter(annoationPoint.getStop(), " public ");
            }
        }
        if ((inSketchContext || inPAppletContext) && hasVisibilityModifier && ctx.getChild(1).getText().equals("main")) {
            this.foundMain = true;
        }
    }

    @Override
    public void exitFunctionWithPrimitiveTypeName(ProcessingParser.FunctionWithPrimitiveTypeNameContext ctx) {
        Object fn = ctx.getChild(0).getText();
        if (!((String)fn).equals("color")) {
            fn = "PApplet.parse" + ((String)fn).substring(0, 1).toUpperCase() + ((String)fn).substring(1);
            this.insertBefore(ctx.start, (String)fn);
            this.delete(ctx.start);
        }
    }

    @Override
    public void exitColorPrimitiveType(ProcessingParser.ColorPrimitiveTypeContext ctx) {
        if (ctx.getText().equals("color")) {
            this.insertAfter(ctx.stop, "int");
            this.delete(ctx.start, ctx.stop);
        }
    }

    @Override
    public void exitHexColorLiteral(ProcessingParser.HexColorLiteralContext ctx) {
        if (ctx.getText().length() == 7) {
            this.insertBefore(ctx.start, ctx.getText().toUpperCase().replace("#", "0xFF"));
        } else {
            this.insertBefore(ctx.start, ctx.getText().toUpperCase().replace("#", "0x"));
        }
        this.delete(ctx.start, ctx.stop);
    }

    protected void handleSizeCall(ParserRuleContext ctx) {
        if (!this.calledFromGlobalOrSetup(ctx)) {
            return;
        }
        ParseTree argsContext = ctx.getChild(2);
        boolean thisRequiresRewrite = false;
        boolean isSize = ctx.getChild(0).getText().equals(SIZE_METHOD_NAME);
        boolean isFullscreen = ctx.getChild(0).getText().equals(FULLSCREEN_METHOD_NAME);
        if (isSize && argsContext.getChildCount() > 2) {
            thisRequiresRewrite = true;
            this.sketchWidth = argsContext.getChild(0).getText();
            boolean invalidWidth = PApplet.parseInt((String)this.sketchWidth, (int)-1) == -1;
            boolean bl = invalidWidth = invalidWidth && !this.sketchWidth.equals("displayWidth");
            if (invalidWidth) {
                thisRequiresRewrite = false;
            }
            this.sketchHeight = argsContext.getChild(2).getText();
            boolean invalidHeight = PApplet.parseInt((String)this.sketchHeight, (int)-1) == -1;
            boolean bl2 = invalidHeight = invalidHeight && !this.sketchHeight.equals("displayHeight");
            if (invalidHeight) {
                thisRequiresRewrite = false;
            }
            if (argsContext.getChildCount() > 3) {
                this.sketchRenderer = argsContext.getChild(4).getText();
            }
            if (argsContext.getChildCount() > 5) {
                this.sketchOutputFilename = argsContext.getChild(6).getText();
            }
            if (argsContext.getChildCount() > 7) {
                thisRequiresRewrite = false;
            }
        }
        if (isFullscreen) {
            this.sketchWidth = "displayWidth";
            this.sketchHeight = "displayHeight";
            thisRequiresRewrite = true;
            this.sizeIsFullscreen = true;
            StringJoiner fullscreenArgsBuilder = new StringJoiner(", ");
            if (argsContext.getChildCount() > 0) {
                String firstArg = argsContext.getChild(0).getText();
                boolean isNumeric = firstArg.matches("\\d+");
                boolean isSpan = firstArg.equals("SPAN");
                boolean isRenderer = !isNumeric && !isSpan;
                fullscreenArgsBuilder.add(firstArg);
                if (isRenderer) {
                    this.sketchRenderer = firstArg;
                }
            }
            if (argsContext.getChildCount() > 2) {
                fullscreenArgsBuilder.add(argsContext.getChild(2).getText());
            }
            this.fullscreenArgs = fullscreenArgsBuilder.toString();
        }
        if (thisRequiresRewrite) {
            this.delete(ctx.getParent().start, ctx.getParent().stop);
            this.insertAfter(ctx.stop, "/* size commented out by preprocessor */");
            this.sizeRequiresRewrite = true;
        }
    }

    protected void handlePixelDensityCall(ParserRuleContext ctx) {
        if (!this.calledFromGlobalOrSetup(ctx)) {
            return;
        }
        ParseTree argsContext = ctx.getChild(2);
        if (argsContext.getChildCount() == 0 || argsContext.getChildCount() > 3) {
            return;
        }
        this.pixelDensity = argsContext.getChild(0).getText();
        this.delete(ctx.getParent().start, ctx.getParent().stop);
        this.insertAfter(ctx.getParent().stop, "/* pixelDensity commented out by preprocessor */");
        this.pixelDensityRequiresRewrite = true;
    }

    protected void handleNoSmoothCall(ParserRuleContext ctx) {
        if (!this.calledFromGlobalOrSetup(ctx)) {
            return;
        }
        ParseTree argsContext = ctx.getChild(2);
        if (argsContext.getChildCount() > 0) {
            return;
        }
        this.delete(ctx.getParent().start, ctx.getParent().stop);
        this.insertAfter(ctx.getParent().stop, "/* noSmooth commented out by preprocessor */");
        this.noSmoothRequiresRewrite = true;
    }

    protected void handleSmoothCall(ParserRuleContext ctx) {
        if (!this.calledFromGlobalOrSetup(ctx)) {
            return;
        }
        ParseTree argsContext = ctx.getChild(2);
        if (argsContext.getChildCount() > 2) {
            return;
        }
        this.smoothParam = argsContext.getChildCount() > 0 ? argsContext.getChild(0).getText() : "";
        this.delete(ctx.getParent().start, ctx.getParent().stop);
        this.insertAfter(ctx.getParent().stop, "/* smooth commented out by preprocessor */");
        this.smoothRequiresRewrite = true;
    }

    protected boolean calledFromGlobalOrSetup(ParserRuleContext callContext) {
        ParserRuleContext outerContext = callContext.getParent().getParent().getParent().getParent();
        if (outerContext instanceof ProcessingParser.StaticProcessingSketchContext) {
            return true;
        }
        ParserRuleContext methodDeclaration = outerContext.getParent().getParent();
        return this.isMethodSetup(methodDeclaration);
    }

    protected boolean isMethodSetup(ParserRuleContext declaration) {
        if (declaration == null || declaration.getChildCount() < 2) {
            return false;
        }
        return declaration.getChild(1).getText().equals("setup");
    }

    protected boolean isAnnotation(ProcessingParser.ModifierContext context) {
        if (context.getChildCount() == 0) {
            return false;
        }
        if (!(context.getChild(0) instanceof ProcessingParser.ClassOrInterfaceModifierContext)) {
            return false;
        }
        ProcessingParser.ClassOrInterfaceModifierContext classModifierCtx = (ProcessingParser.ClassOrInterfaceModifierContext)context.getChild(0);
        return classModifierCtx.getChild(0) instanceof ProcessingParser.AnnotationContext;
    }

    protected void insertBefore(Token location, String text) {
        this.edits.add(PdeParseTreeListener.createInsertBefore(location, text, this.rewriter));
    }

    protected void insertBefore(int locationToken, int locationOffset, String text) {
        this.edits.add(PdeParseTreeListener.createInsertBefore(locationToken, locationOffset, text, this.rewriter));
    }

    protected void insertAfter(Token location, String text) {
        this.edits.add(PdeParseTreeListener.createInsertAfter(location, text, this.rewriter));
    }

    protected void delete(Token start, Token stop) {
        this.edits.add(PdeParseTreeListener.createDelete(start, stop, this.rewriter));
    }

    protected void delete(Token location) {
        this.edits.add(PdeParseTreeListener.createDelete(location, this.rewriter));
    }

    protected RewriteResult prepareHeader(TokenStreamRewriter headerWriter) {
        RewriteResultBuilder resultBuilder = new RewriteResultBuilder();
        PrintWriterWithEditGen decoratedWriter = new PrintWriterWithEditGen(headerWriter, resultBuilder, 0, true);
        this.writeHeaderContents(decoratedWriter, resultBuilder);
        decoratedWriter.finish();
        return resultBuilder.build();
    }

    protected RewriteResult prepareFooter(TokenStreamRewriter footerWriter, int insertPoint) {
        RewriteResultBuilder resultBuilder = new RewriteResultBuilder();
        PrintWriterWithEditGen decoratedWriter = new PrintWriterWithEditGen(footerWriter, resultBuilder, insertPoint, false);
        this.writeFooterContents(decoratedWriter, resultBuilder);
        decoratedWriter.finish();
        return resultBuilder.build();
    }

    protected void writeHeaderContents(PrintWriterWithEditGen decoratedWriter, RewriteResultBuilder resultBuilder) {
        boolean requiresStaticSketchHeader;
        if (this.destinationPackageName.isPresent()) {
            decoratedWriter.addCodeLine("package " + this.destinationPackageName.get() + ";");
            decoratedWriter.addEmptyLine();
        }
        if (!this.isTesting) {
            this.writePreprocessorComment(decoratedWriter, resultBuilder);
        }
        this.writeImports(decoratedWriter, resultBuilder);
        boolean requiresClassHeader = this.mode == PdePreprocessor.Mode.STATIC;
        requiresClassHeader = requiresClassHeader || this.mode == PdePreprocessor.Mode.ACTIVE;
        boolean bl = requiresStaticSketchHeader = this.mode == PdePreprocessor.Mode.STATIC;
        if (requiresClassHeader) {
            this.writeClassHeader(decoratedWriter, resultBuilder);
        }
        if (requiresStaticSketchHeader) {
            this.writeStaticSketchHeader(decoratedWriter, resultBuilder);
        }
    }

    protected void writeFooterContents(PrintWriterWithEditGen decoratedWriter, RewriteResultBuilder resultBuilder) {
        decoratedWriter.addEmptyLine();
        boolean requiresStaticSketchFooter = this.mode == PdePreprocessor.Mode.STATIC;
        boolean requiresClassWrap = this.mode == PdePreprocessor.Mode.STATIC;
        boolean bl = requiresClassWrap = requiresClassWrap || this.mode == PdePreprocessor.Mode.ACTIVE;
        if (requiresStaticSketchFooter) {
            this.writeStaticSketchFooter(decoratedWriter, resultBuilder);
        }
        if (requiresClassWrap) {
            this.writeExtraFieldsAndMethods(decoratedWriter, resultBuilder);
            if (!this.foundMain) {
                this.writeMain(decoratedWriter, resultBuilder);
            }
            this.writeClassFooter(decoratedWriter, resultBuilder);
        }
    }

    protected void writePreprocessorComment(PrintWriterWithEditGen headerWriter, RewriteResultBuilder resultBuilder) {
        String dateStr = new SimpleDateFormat("YYYY-MM-dd").format(new Date());
        String newCode = String.format("/* autogenerated by Processing revision %04d on %s */", Base.getRevision(), dateStr);
        headerWriter.addCodeLine(newCode);
    }

    protected void writeImports(PrintWriterWithEditGen headerWriter, RewriteResultBuilder resultBuilder) {
        this.writeImportList(headerWriter, this.coreImports, resultBuilder);
        this.writeImportList(headerWriter, this.codeFolderImports, resultBuilder);
        this.writeImportList(headerWriter, this.foundImports, resultBuilder);
        this.writeImportList(headerWriter, this.defaultImports, resultBuilder);
    }

    protected void writeImportList(PrintWriterWithEditGen headerWriter, List<ImportStatement> imports, RewriteResultBuilder resultBuilder) {
        this.writeImportList(headerWriter, imports.toArray(new ImportStatement[0]), resultBuilder);
    }

    protected void writeImportList(PrintWriterWithEditGen headerWriter, ImportStatement[] imports, RewriteResultBuilder resultBuilder) {
        for (ImportStatement importDecl : imports) {
            headerWriter.addCodeLine(importDecl.getFullSourceLine());
        }
        if (imports.length > 0) {
            headerWriter.addEmptyLine();
        }
    }

    protected void writeClassHeader(PrintWriterWithEditGen headerWriter, RewriteResultBuilder resultBuilder) {
        headerWriter.addCodeLine("public class " + this.sketchName + " extends PApplet {");
        headerWriter.addEmptyLine();
    }

    protected void writeStaticSketchHeader(PrintWriterWithEditGen headerWriter, RewriteResultBuilder resultBuilder) {
        headerWriter.addCodeLine(this.indent1 + "public void setup() {");
    }

    protected void writeStaticSketchFooter(PrintWriterWithEditGen footerWriter, RewriteResultBuilder resultBuilder) {
        footerWriter.addCodeLine(this.indent2 + "noLoop();");
        footerWriter.addCodeLine(this.indent1 + "}");
    }

    protected void writeExtraFieldsAndMethods(PrintWriterWithEditGen classBodyWriter, RewriteResultBuilder resultBuilder) {
        boolean noRewriteRequired = !this.sizeRequiresRewrite;
        noRewriteRequired = noRewriteRequired && !this.pixelDensityRequiresRewrite;
        noRewriteRequired = noRewriteRequired && !this.noSmoothRequiresRewrite;
        boolean bl = noRewriteRequired = noRewriteRequired && !this.smoothRequiresRewrite;
        if (noRewriteRequired) {
            return;
        }
        String settingsOuterTemplate = this.indent1 + "public void settings() { %s }";
        StringJoiner settingsInner = new StringJoiner("\n");
        if (this.sizeRequiresRewrite) {
            if (this.sizeIsFullscreen) {
                settingsInner.add(String.format("fullScreen(%s);", this.fullscreenArgs));
            } else {
                if (this.sketchWidth.isEmpty() || this.sketchHeight.isEmpty()) {
                    return;
                }
                StringJoiner argJoiner = new StringJoiner(", ");
                argJoiner.add(this.sketchWidth);
                argJoiner.add(this.sketchHeight);
                if (this.sketchRenderer != null) {
                    argJoiner.add(this.sketchRenderer);
                }
                if (this.sketchOutputFilename != null) {
                    argJoiner.add(this.sketchOutputFilename);
                }
                settingsInner.add(String.format("size(%s);", argJoiner.toString()));
            }
        }
        if (this.pixelDensityRequiresRewrite) {
            settingsInner.add(String.format("pixelDensity(%s);", this.pixelDensity));
        }
        if (this.noSmoothRequiresRewrite) {
            settingsInner.add("noSmooth();");
        }
        if (this.smoothRequiresRewrite) {
            settingsInner.add(String.format("smooth(%s);", this.smoothParam));
        }
        String newCode = String.format(settingsOuterTemplate, settingsInner.toString());
        classBodyWriter.addEmptyLine();
        classBodyWriter.addCodeLine(newCode);
    }

    protected void writeMain(PrintWriterWithEditGen footerWriter, RewriteResultBuilder resultBuilder) {
        footerWriter.addEmptyLine();
        footerWriter.addCodeLine(this.indent1 + "static public void main(String[] passedArgs) {");
        footerWriter.addCode(this.indent2 + "String[] appletArgs = new String[] { ");
        if (Preferences.getBoolean((String)"export.application.fullscreen")) {
            footerWriter.addCode("\"--full-screen\", ");
            String bgColor = Preferences.get((String)"run.present.bgcolor");
            footerWriter.addCode("\"--bgcolor=" + bgColor + "\", ");
            if (Preferences.getBoolean((String)"export.application.stop")) {
                String stopColor = Preferences.get((String)"run.present.stop.color");
                footerWriter.addCode("\"--stop-color=" + stopColor + "\", ");
            } else {
                footerWriter.addCode("\"--hide-stop\", ");
            }
        }
        footerWriter.addCode("\"" + this.sketchName + "\"");
        footerWriter.addCodeLine(" };");
        footerWriter.addCodeLine(this.indent2 + "if (passedArgs != null) {");
        footerWriter.addCodeLine(this.indent3 + "PApplet.main(concat(appletArgs, passedArgs));");
        footerWriter.addCodeLine(this.indent2 + "} else {");
        footerWriter.addCodeLine(this.indent3 + "PApplet.main(appletArgs);");
        footerWriter.addCodeLine(this.indent2 + "}");
        footerWriter.addCodeLine(this.indent1 + "}");
    }

    protected void writeClassFooter(PrintWriterWithEditGen footerWriter, RewriteResultBuilder resultBuilder) {
        footerWriter.addCodeLine("}");
    }

    protected static TextTransform.Edit createDelete(Token start, Token stop, TokenStreamRewriter rewriter) {
        rewriter.delete(start, stop);
        int startIndex = start.getStartIndex();
        int length = stop.getStopIndex() - startIndex + 1;
        return TextTransform.Edit.delete(startIndex, length);
    }

    protected static TextTransform.Edit createInsertAfter(Token start, String text, TokenStreamRewriter rewriter) {
        rewriter.insertAfter(start, (Object)text);
        return TextTransform.Edit.insert(start.getStopIndex() + 1, text);
    }

    protected static TextTransform.Edit createInsertBefore(Token before, String text, TokenStreamRewriter rewriter) {
        rewriter.insertBefore(before, (Object)text);
        return TextTransform.Edit.insert(before.getStartIndex(), text);
    }

    protected static TextTransform.Edit createInsertBefore(int before, int beforeOffset, String text, TokenStreamRewriter rewriter) {
        rewriter.insertBefore(before, (Object)text);
        return TextTransform.Edit.insert(beforeOffset, text);
    }

    protected static TextTransform.Edit insertAfter(int start, String text, TokenStreamRewriter rewriter) {
        rewriter.insertAfter(start, (Object)text);
        return TextTransform.Edit.insert(start + 1, text);
    }

    protected static TextTransform.Edit createDelete(Token start, TokenStreamRewriter rewriter) {
        rewriter.delete(start);
        return TextTransform.Edit.delete(start.getStartIndex(), start.getText().length());
    }

    private List<ImportStatement> createPlainImportStatementInfos(List<String> fullyQualifiedNames) {
        return fullyQualifiedNames.stream().map(this::createPlainImportStatementInfo).collect(Collectors.toList());
    }

    private ImportStatement createPlainImportStatementInfo(String fullyQualifiedName) {
        return ImportStatement.parse(fullyQualifiedName);
    }

    public static class PrintWriterWithEditGen {
        private final TokenStreamRewriter writer;
        private final RewriteResultBuilder rewriteResultBuilder;
        private final int insertPoint;
        private final StringBuilder editBuilder;
        private final boolean before;

        public PrintWriterWithEditGen(TokenStreamRewriter writer, RewriteResultBuilder newRewriteResultBuilder, int newInsertPoint, boolean newBefore) {
            this.writer = writer;
            this.rewriteResultBuilder = newRewriteResultBuilder;
            this.insertPoint = newInsertPoint;
            this.editBuilder = new StringBuilder();
            this.before = newBefore;
        }

        public void addEmptyLine() {
            this.addCode("\n");
        }

        public void addCodeLine(String newCode) {
            this.addCode(newCode + "\n");
        }

        public void addCode(String newCode) {
            this.editBuilder.append(newCode);
        }

        public void finish() {
            String newCode = this.editBuilder.toString();
            if (this.before) {
                this.rewriteResultBuilder.addEdit(PdeParseTreeListener.createInsertBefore(this.insertPoint, this.insertPoint, newCode, this.writer));
            } else {
                this.rewriteResultBuilder.addEdit(PdeParseTreeListener.insertAfter(this.insertPoint, newCode, this.writer));
            }
            this.rewriteResultBuilder.addOffset(SourceUtil.getCount(newCode, "\n"));
        }
    }

    public static interface PdeParseTreeErrorListener {
        public void onError(PdePreprocessIssue var1);
    }
}

