/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.debug;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class VariableNode
implements MutableTreeNode {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_OBJECT = 0;
    public static final int TYPE_ARRAY = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_FLOAT = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_CHAR = 5;
    public static final int TYPE_STRING = 6;
    public static final int TYPE_LONG = 7;
    public static final int TYPE_DOUBLE = 8;
    public static final int TYPE_BYTE = 9;
    public static final int TYPE_SHORT = 10;
    public static final int TYPE_VOID = 11;
    protected String type;
    protected String name;
    protected Value value;
    protected List<MutableTreeNode> children = new ArrayList<MutableTreeNode>();
    protected MutableTreeNode parent;

    public VariableNode(String name, String type, Value value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Value getValue() {
        return this.value;
    }

    public String getStringValue() {
        Object str = this.value != null ? (this.getType() == 0 ? "instance of " + this.type : (this.getType() == 1 ? this.value.toString().substring(0, this.value.toString().lastIndexOf(" ")) : (this.getType() == 6 ? ((StringReference)this.value).value() : this.value.toString()))) : "null";
        return str;
    }

    public String getTypeName() {
        return this.type;
    }

    public int getType() {
        if (this.type == null) {
            return -1;
        }
        if (this.type.endsWith("[]")) {
            return 1;
        }
        if (this.type.equals("int")) {
            return 2;
        }
        if (this.type.equals("long")) {
            return 7;
        }
        if (this.type.equals("byte")) {
            return 9;
        }
        if (this.type.equals("short")) {
            return 10;
        }
        if (this.type.equals("float")) {
            return 3;
        }
        if (this.type.equals("double")) {
            return 8;
        }
        if (this.type.equals("char")) {
            return 5;
        }
        if (this.type.equals("java.lang.String")) {
            return 6;
        }
        if (this.type.equals("boolean")) {
            return 4;
        }
        if (this.type.equals("void")) {
            return 11;
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChild(VariableNode c) {
        this.children.add(c);
        c.setParent(this);
    }

    public void addChildren(List<VariableNode> children) {
        for (VariableNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public TreeNode getChildAt(int i) {
        return this.children.get(i);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode tn) {
        return this.children.indexOf(tn);
    }

    @Override
    public boolean getAllowsChildren() {
        if (this.value == null) {
            return false;
        }
        if (this.getType() == 6) {
            return false;
        }
        if (this.getType() == 1) {
            ArrayReference array = (ArrayReference)this.value;
            return array.length() > 0;
        }
        if (this.getType() == 0) {
            ObjectReference obj = (ObjectReference)this.value;
            return !obj.referenceType().visibleFields().isEmpty();
        }
        return false;
    }

    @Override
    public boolean isLeaf() {
        return !this.getAllowsChildren();
    }

    public Enumeration<MutableTreeNode> children() {
        return Collections.enumeration(this.children);
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        Object str = "";
        if (this.type != null) {
            str = (String)str + this.type + " ";
        }
        str = (String)str + this.name;
        str = (String)str + " = " + this.getStringValue();
        return str;
    }

    @Override
    public void insert(MutableTreeNode mtn, int i) {
        this.children.add(i, this);
    }

    @Override
    public void remove(int i) {
        MutableTreeNode mtn = this.children.remove(i);
        if (mtn != null) {
            mtn.setParent(null);
        }
    }

    @Override
    public void remove(MutableTreeNode mtn) {
        this.children.remove(mtn);
        mtn.setParent(null);
    }

    public void removeAllChildren() {
        for (MutableTreeNode mtn : this.children) {
            mtn.setParent(null);
        }
        this.children.clear();
    }

    @Override
    public void setUserObject(Object o) {
        if (o instanceof Value) {
            this.value = (Value)o;
        }
    }

    @Override
    public void removeFromParent() {
        this.parent.remove(this);
        this.parent = null;
    }

    @Override
    public void setParent(MutableTreeNode mtn) {
        this.parent = mtn;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableNode other = (VariableNode)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 97 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }
}

