/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.dom.CompilationUnit;
import processing.mode.java.ImportStatement;
import processing.mode.java.TextTransform;

public class SourceUtil {
    private static final boolean PERFORM_SOURCE_UTIL_TRANSFORMS = false;
    public static final Pattern IMPORT_REGEX = Pattern.compile("(?:^|;)\\s*(import\\s+(?:(static)\\s+)?((?:\\w+\\s*\\.)*)\\s*(\\S+)\\s*;)", 40);
    public static final Pattern IMPORT_REGEX_NO_KEYWORD = Pattern.compile("^\\s*((?:(static)\\s+)?((?:\\w+\\s*\\.)*)\\s*(\\S+))", 40);
    public static final Pattern TYPE_CONSTRUCTOR_REGEX = Pattern.compile("(?<=^|\\W)(int|char|float|boolean|byte)(?=\\s*\\()", 8);
    public static final Pattern HEX_LITERAL_REGEX = Pattern.compile("(?<=^|\\W)(#[A-Fa-f0-9]{6})(?=\\W|$)");
    public static final Pattern FLOATING_POINT_LITERAL_VERIFIER;
    private static final int ACCESS_MODIFIERS_MASK = 7;
    public static final Pattern COLOR_TYPE_REGEX;
    public static final Pattern NUMBER_LITERAL_REGEX;

    public static List<ImportStatement> parseProgramImports(CharSequence source) {
        ArrayList<ImportStatement> result = new ArrayList<ImportStatement>();
        Matcher matcher = IMPORT_REGEX.matcher(source);
        while (matcher.find()) {
            ImportStatement is = ImportStatement.parse(matcher.toMatchResult());
            result.add(is);
        }
        return result;
    }

    public static List<TextTransform.Edit> replaceTypeConstructors(CharSequence source) {
        ArrayList<TextTransform.Edit> result = new ArrayList<TextTransform.Edit>();
        Matcher matcher = TYPE_CONSTRUCTOR_REGEX.matcher(source);
        while (matcher.find()) {
            String match = matcher.group(1);
            int offset = matcher.start(1);
            int length = match.length();
            result.add(TextTransform.Edit.insert(offset, "PApplet."));
            String replace = "parse" + Character.toUpperCase(match.charAt(0)) + match.substring(1);
            result.add(TextTransform.Edit.replace(offset, length, replace));
        }
        return result;
    }

    public static List<TextTransform.Edit> replaceHexLiterals(CharSequence source) {
        ArrayList<TextTransform.Edit> result = new ArrayList<TextTransform.Edit>();
        Matcher matcher = HEX_LITERAL_REGEX.matcher(source);
        while (matcher.find()) {
            int offset = matcher.start(1);
            result.add(TextTransform.Edit.replace(offset, 1, "0xff"));
        }
        return result;
    }

    public static List<TextTransform.Edit> preprocessAST(CompilationUnit cu) {
        return new ArrayList<TextTransform.Edit>();
    }

    public static List<TextTransform.Edit> replaceColorRegex(CharSequence source) {
        ArrayList<TextTransform.Edit> edits = new ArrayList<TextTransform.Edit>();
        Matcher matcher = COLOR_TYPE_REGEX.matcher(source);
        while (matcher.find()) {
            int offset = matcher.start(1);
            edits.add(TextTransform.Edit.replace(offset, 5, "int"));
        }
        return edits;
    }

    public static List<TextTransform.Edit> fixFloatsRegex(CharSequence source) {
        ArrayList<TextTransform.Edit> edits = new ArrayList<TextTransform.Edit>();
        Matcher matcher = NUMBER_LITERAL_REGEX.matcher(source);
        while (matcher.find()) {
            boolean hasSuffix;
            int offset = matcher.start();
            int end = matcher.end();
            String group = matcher.group().toLowerCase();
            boolean isFloatingPoint = group.contains(".") || group.contains("e");
            boolean bl = hasSuffix = end < source.length() && Character.toLowerCase(source.charAt(end)) != 'f' && Character.toLowerCase(source.charAt(end)) != 'd';
            if (!isFloatingPoint || hasSuffix) continue;
            edits.add(TextTransform.Edit.insert(offset, "f"));
        }
        return edits;
    }

    public static void scrubCommentsAndStrings(StringBuilder p) {
    }

    public static int[] checkForMissingBraces(CharSequence c, int start, int end) {
        int depth = 0;
        int lineNumber = 0;
        int lineStart = start;
        for (int i = start; i < end; ++i) {
            char ch = c.charAt(i);
            switch (ch) {
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    --depth;
                    break;
                }
                case '\n': {
                    ++lineNumber;
                    lineStart = i;
                }
            }
            if (depth >= 0) continue;
            return new int[]{depth, lineNumber, i - lineStart, i - start};
        }
        return new int[]{depth, lineNumber - 1, end - lineStart - 2, end - start - 2};
    }

    public static int getCount(String body, String search) {
        int count = 0;
        if (search.length() == 1) {
            for (int i = 0; i < body.length(); ++i) {
                if (body.charAt(i) != search.charAt(0)) continue;
                ++count;
            }
        } else {
            for (int i = 0; i < body.length(); ++i) {
                if (!body.substring(i).startsWith(search)) continue;
                ++count;
            }
        }
        return count;
    }

    static {
        String DIGITS = "(?:[0-9]|[0-9][0-9_]*[0-9])";
        String EXPONENT_PART = "(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))";
        FLOATING_POINT_LITERAL_VERIFIER = Pattern.compile("(?:^(?:[0-9]|[0-9][0-9_]*[0-9])\\.(?:[0-9]|[0-9][0-9_]*[0-9])?(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))?[fFdD]?$)|(?:^\\.(?:[0-9]|[0-9][0-9_]*[0-9])(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))?[fFdD]?$)|(?:^(?:[0-9]|[0-9][0-9_]*[0-9])(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))[fFdD]?$)|(?:^(?:[0-9]|[0-9][0-9_]*[0-9])(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))?[fFdD]$)");
        COLOR_TYPE_REGEX = Pattern.compile("(?:^|^\\p{javaJavaIdentifierPart})(color)\\s(?!\\s*\\()", 264);
        NUMBER_LITERAL_REGEX = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?");
    }
}

