/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import com.google.classpath.ClassPath;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import processing.app.Problem;
import processing.app.Sketch;
import processing.core.PApplet;
import processing.mode.java.ImportStatement;
import processing.mode.java.SketchInterval;
import processing.mode.java.TextTransform;

public class PreprocSketch {
    public final Sketch sketch;
    public final CompilationUnit compilationUnit;
    public final String[] classPathArray;
    public final ClassPath classPath;
    public final URLClassLoader classLoader;
    public final String[] searchClassPathArray;
    public final int[] tabStartOffsets;
    public final String scrubbedPdeCode;
    public final String pdeCode;
    public final String javaCode;
    public final TextTransform.OffsetMapper offsetMapper;
    public final boolean hasSyntaxErrors;
    public final boolean hasCompilationErrors;
    public final List<ImportStatement> programImports;
    public final List<ImportStatement> coreAndDefaultImports;
    public final List<ImportStatement> codeFolderImports;
    public final List<Problem> otherProblems;
    public final List<IProblem> iproblems;
    public final Map<String, Integer> javaFileMapping;

    public boolean inRange(SketchInterval interval) {
        return interval != SketchInterval.BEFORE_START && interval.stopPdeOffset < this.pdeCode.length();
    }

    public String getPdeCode(SketchInterval si) {
        if (si == SketchInterval.BEFORE_START) {
            return "";
        }
        int stop = Math.min(si.stopPdeOffset, this.pdeCode.length());
        int start = Math.min(si.startPdeOffset, stop);
        return this.pdeCode.substring(start, stop);
    }

    public SketchInterval mapJavaToSketch(ASTNode node) {
        return this.mapJavaToSketch(node.getStartPosition(), node.getStartPosition() + node.getLength());
    }

    public SketchInterval mapJavaToSketch(IProblem iproblem) {
        String originalFile = new String(iproblem.getOriginatingFileName());
        boolean isJavaTab = this.javaFileMapping.containsKey(originalFile);
        if (isJavaTab) {
            return new SketchInterval(this.javaFileMapping.get(originalFile), iproblem.getSourceStart(), iproblem.getSourceEnd() + 1, iproblem.getSourceStart(), iproblem.getSourceEnd() + 1);
        }
        return this.mapJavaToSketch(iproblem.getSourceStart(), iproblem.getSourceEnd() + 1);
    }

    public SketchInterval mapJavaToSketch(int startJavaOffset, int stopJavaOffset) {
        int stopPdeOffset;
        int length = stopJavaOffset - startJavaOffset;
        int startPdeOffset = this.javaOffsetToPdeOffset(startJavaOffset);
        if (length == 0) {
            stopPdeOffset = startPdeOffset;
        } else {
            stopPdeOffset = this.javaOffsetToPdeOffset(stopJavaOffset - 1);
            if (stopPdeOffset >= 0 && (stopPdeOffset > startPdeOffset || length == 1)) {
                ++stopPdeOffset;
            }
        }
        if (startPdeOffset < 0 || stopPdeOffset < 0) {
            return SketchInterval.BEFORE_START;
        }
        int tabIndex = this.pdeOffsetToTabIndex(startPdeOffset);
        if (startPdeOffset >= this.pdeCode.length()) {
            startPdeOffset = this.pdeCode.length() - 1;
            stopPdeOffset = startPdeOffset + 1;
        }
        return new SketchInterval(tabIndex, this.pdeOffsetToTabOffset(tabIndex, startPdeOffset), this.pdeOffsetToTabOffset(tabIndex, stopPdeOffset), startPdeOffset, stopPdeOffset);
    }

    private int javaOffsetToPdeOffset(int javaOffset) {
        return this.offsetMapper.getInputOffset(javaOffset);
    }

    public int pdeOffsetToTabIndex(int pdeOffset) {
        int tab = Arrays.binarySearch(this.tabStartOffsets, pdeOffset = Math.max(0, pdeOffset));
        if (tab < 0) {
            tab = -(tab + 1) - 1;
        }
        return tab;
    }

    public int pdeOffsetToTabOffset(int tabIndex, int pdeOffset) {
        int tabStartOffset = this.tabStartOffsets[this.clipTabIndex(tabIndex)];
        return pdeOffset - tabStartOffset;
    }

    public int tabOffsetToJavaOffset(int tabIndex, int tabOffset) {
        int tabStartOffset = this.tabStartOffsets[this.clipTabIndex(tabIndex)];
        int pdeOffset = tabStartOffset + tabOffset;
        return this.offsetMapper.getOutputOffset(pdeOffset);
    }

    public int tabOffsetToJavaLine(int tabIndex, int tabOffset) {
        int javaOffset = this.tabOffsetToJavaOffset(tabIndex, tabOffset);
        return PreprocSketch.offsetToLine(this.javaCode, javaOffset);
    }

    public int tabOffsetToTabLine(int tabIndex, int tabOffset) {
        int tabStartOffset = this.tabStartOffsets[this.clipTabIndex(tabIndex)];
        return PreprocSketch.offsetToLine(this.pdeCode, tabStartOffset, tabStartOffset + tabOffset);
    }

    private static int offsetToLine(String text, int offset) {
        return PreprocSketch.offsetToLine(text, 0, offset);
    }

    private static int offsetToLine(String text, int start, int offset) {
        int line = 0;
        while (offset >= start) {
            offset = text.lastIndexOf(10, offset - 1);
            ++line;
        }
        return line - 1;
    }

    private int clipTabIndex(int tabIndex) {
        return PApplet.constrain((int)tabIndex, (int)0, (int)(this.tabStartOffsets.length - 1));
    }

    public static PreprocSketch empty() {
        return new Builder().build();
    }

    private PreprocSketch(Builder b) {
        this.sketch = b.sketch;
        this.compilationUnit = b.compilationUnit;
        this.classPathArray = b.classPathArray;
        this.classPath = b.classPath;
        this.classLoader = b.classLoader;
        this.searchClassPathArray = b.searchClassPathArray;
        this.tabStartOffsets = b.tabStartOffsets;
        this.scrubbedPdeCode = b.scrubbedPdeCode;
        this.pdeCode = b.pdeCode;
        this.javaCode = b.javaCode;
        this.offsetMapper = b.offsetMapper != null ? b.offsetMapper : TextTransform.OffsetMapper.EMPTY_MAPPER;
        this.hasSyntaxErrors = b.hasSyntaxErrors;
        this.hasCompilationErrors = b.hasCompilationErrors;
        this.otherProblems = b.otherProblems;
        this.javaFileMapping = b.javaFileMapping;
        this.iproblems = b.iproblems;
        this.programImports = Collections.unmodifiableList(b.programImports);
        this.coreAndDefaultImports = Collections.unmodifiableList(b.coreAndDefaultImports);
        this.codeFolderImports = Collections.unmodifiableList(b.codeFolderImports);
    }

    public static class Builder {
        public Sketch sketch;
        public CompilationUnit compilationUnit;
        public String[] classPathArray;
        public ClassPath classPath;
        public URLClassLoader classLoader;
        public String[] searchClassPathArray;
        public int[] tabStartOffsets = new int[0];
        public String scrubbedPdeCode;
        public String pdeCode;
        public String javaCode;
        public TextTransform.OffsetMapper offsetMapper;
        public boolean hasSyntaxErrors;
        public boolean hasCompilationErrors;
        public final List<ImportStatement> programImports = new ArrayList<ImportStatement>();
        public final List<ImportStatement> coreAndDefaultImports = new ArrayList<ImportStatement>();
        public final List<ImportStatement> codeFolderImports = new ArrayList<ImportStatement>();
        public final List<Problem> otherProblems = new ArrayList<Problem>();
        public List<IProblem> iproblems;
        public Map<String, Integer> javaFileMapping;

        public PreprocSketch build() {
            return new PreprocSketch(this);
        }
    }
}

