/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.text.BadLocationException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import processing.app.Messages;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Util;
import processing.data.IntList;
import processing.data.StringList;
import processing.mode.java.ImportStatement;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaMode;
import processing.mode.java.PreprocSketch;
import processing.mode.java.ProblemFactory;
import processing.mode.java.RuntimePathBuilder;
import processing.mode.java.SourceUtil;
import processing.mode.java.TextTransform;
import processing.mode.java.preproc.PdePreprocessor;
import processing.mode.java.preproc.PreprocessorResult;

public class PreprocService {
    private static final int TIMEOUT_MILLIS = 100;
    private static final int BLOCKING_TIMEOUT_SECONDS = 3000;
    protected final JavaEditor editor;
    protected final ASTParser parser = ASTParser.newParser((int)11);
    private final Thread preprocessingThread;
    private final BlockingQueue<Boolean> requestQueue = new ArrayBlockingQueue<Boolean>(1);
    private final Object requestLock = new Object();
    private final AtomicBoolean codeFolderChanged = new AtomicBoolean(true);
    private final AtomicBoolean librariesChanged = new AtomicBoolean(true);
    private volatile boolean running;
    private CompletableFuture<PreprocSketch> preprocessingTask = new CompletableFuture();
    private CompletableFuture<?> lastCallback = new CompletableFuture<Object>(){
        {
            this.complete(null);
        }
    };
    private volatile boolean enabled = true;
    private final Set<Consumer<PreprocSketch>> listeners = new CopyOnWriteArraySet<Consumer<PreprocSketch>>();
    private List<ImportStatement> coreAndDefaultImports;
    private final RuntimePathBuilder runtimePathBuilder = new RuntimePathBuilder();
    private static final Map<String, String> COMPILER_OPTIONS;

    public PreprocService(JavaEditor editor) {
        this.editor = editor;
        this.whenDone(this::fireListeners);
        this.preprocessingThread = new Thread(this::mainLoop, "ECS");
        this.preprocessingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        this.running = true;
        PreprocSketch prevResult = null;
        CompletableFuture<?> runningCallbacks = null;
        Messages.log((String)"PPS: Hi!");
        while (this.running) {
            try {
                try {
                    this.requestQueue.take();
                }
                catch (InterruptedException e) {
                    this.running = false;
                    break;
                }
                Messages.log((String)"PPS: Starting");
                prevResult = this.preprocessSketch(prevResult);
                while (this.requestQueue.isEmpty() && runningCallbacks != null) {
                    try {
                        runningCallbacks.get(100L, TimeUnit.MILLISECONDS);
                        runningCallbacks = null;
                    }
                    catch (TimeoutException e) {}
                }
                Object e = this.requestLock;
                synchronized (e) {
                    if (this.requestQueue.isEmpty()) {
                        runningCallbacks = this.lastCallback;
                        Messages.log((String)"PPS: Done");
                        this.preprocessingTask.complete(prevResult);
                    }
                }
            }
            catch (Exception e) {
                Messages.err((String)"problem in preprocessor service loop", (Throwable)e);
            }
        }
        Messages.log((String)"PPS: Bye!");
    }

    public void dispose() {
        this.cancel();
        this.running = false;
        this.preprocessingThread.interrupt();
    }

    public void cancel() {
        this.requestQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySketchChanged() {
        if (this.enabled) {
            Object object = this.requestLock;
            synchronized (object) {
                if (this.preprocessingTask.isDone()) {
                    this.preprocessingTask = new CompletableFuture();
                    this.whenDone(this::fireListeners);
                }
                this.requestQueue.offer(Boolean.TRUE);
            }
        }
    }

    public void notifyLibrariesChanged() {
        Messages.log((String)"PPS: notified libraries changed");
        this.librariesChanged.set(true);
        this.notifySketchChanged();
    }

    public void notifyCodeFolderChanged() {
        Messages.log((String)"PPS: notified code folder changed");
        this.codeFolderChanged.set(true);
        this.notifySketchChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> registerCallback(Consumer<PreprocSketch> callback) {
        Object object = this.requestLock;
        synchronized (object) {
            this.lastCallback = ((CompletableFuture)this.preprocessingTask.thenAcceptBothAsync(this.lastCallback, (ps, a) -> callback.accept((PreprocSketch)ps))).handleAsync((res, e) -> {
                if (e != null) {
                    Messages.err((String)"PPS: exception in callback", (Throwable)e);
                }
                return res;
            });
            return this.lastCallback;
        }
    }

    public void whenDone(Consumer<PreprocSketch> callback) {
        if (!this.enabled) {
            return;
        }
        this.registerCallback(callback);
    }

    public void whenDoneBlocking(Consumer<PreprocSketch> callback) {
        if (!this.enabled) {
            return;
        }
        try {
            this.registerCallback(callback).get(3000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
    }

    public void registerListener(Consumer<PreprocSketch> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void unregisterListener(Consumer<PreprocSketch> listener) {
        this.listeners.remove(listener);
    }

    private void fireListeners(PreprocSketch ps) {
        for (Consumer<PreprocSketch> listener : this.listeners) {
            try {
                listener.accept(ps);
            }
            catch (Exception e) {
                Messages.err((String)"error when firing preprocessing listener", (Throwable)e);
            }
        }
    }

    private PreprocSketch preprocessSketch(PreprocSketch prevResult) {
        boolean rebuildClassPath;
        boolean rebuildLibraryClassPath;
        PreprocessorResult preprocessorResult;
        boolean firstCheck = prevResult == null;
        PreprocSketch.Builder result = new PreprocSketch.Builder();
        List<ImportStatement> codeFolderImports = result.codeFolderImports;
        List<ImportStatement> programImports = result.programImports;
        JavaMode javaMode = (JavaMode)this.editor.getMode();
        Sketch sketch = result.sketch = this.editor.getSketch();
        String className = sketch.getMainName();
        StringBuilder workBuffer = new StringBuilder();
        int numLines = 1;
        IntList tabStartsList = new IntList();
        ArrayList<JavaSketchCode> javaFiles = new ArrayList<JavaSketchCode>();
        ArrayList<Integer> tabLineStarts = new ArrayList<Integer>();
        for (SketchCode sc : sketch.getCode()) {
            Object newPieceBuilt;
            if (sc.isExtension("pde")) {
                tabStartsList.append(workBuffer.length());
                tabLineStarts.add(numLines);
                newPieceBuilt = this.getSketchTabContents(sc) + "\n";
                numLines += SourceUtil.getCount((String)newPieceBuilt, "\n");
                workBuffer.append((String)newPieceBuilt);
                continue;
            }
            if (!sc.isExtension("java")) continue;
            tabStartsList.append(workBuffer.length());
            tabLineStarts.add(numLines);
            javaFiles.add(new JavaSketchCode(sc, tabStartsList.size() - 1));
            newPieceBuilt = String.format("\n// Skip java file %s.\n", sc.getFileName());
            numLines += SourceUtil.getCount((String)newPieceBuilt, "\n");
            workBuffer.append((String)newPieceBuilt);
        }
        result.tabStartOffsets = tabStartsList.array();
        String pdeStage = result.pdeCode = workBuffer.toString();
        boolean reloadCodeFolder = firstCheck || this.codeFolderChanged.getAndSet(false);
        boolean reloadLibraries = firstCheck || this.librariesChanged.getAndSet(false);
        PdePreprocessor preProcessor = this.editor.createPreprocessor(this.editor.getSketch().getMainName());
        if (this.coreAndDefaultImports == null) {
            this.coreAndDefaultImports = PreprocService.buildCoreAndDefaultImports(preProcessor);
        }
        result.coreAndDefaultImports.addAll(this.coreAndDefaultImports);
        if (reloadCodeFolder) {
            codeFolderImports.addAll(PreprocService.buildCodeFolderImports(sketch));
        } else {
            codeFolderImports.addAll(prevResult.codeFolderImports);
        }
        SourceUtil.scrubCommentsAndStrings(workBuffer);
        result.scrubbedPdeCode = workBuffer.toString();
        try {
            preprocessorResult = preProcessor.write(new StringWriter(), result.scrubbedPdeCode, codeFolderImports.stream().map(ImportStatement::getFullMemberName).collect(Collectors.toList()));
        }
        catch (SketchException e) {
            throw new RuntimeException("Unexpected sketch exception in preprocessing: " + e);
        }
        if (preprocessorResult.getPreprocessIssues().size() > 0) {
            int endNumLines = numLines;
            preprocessorResult.getPreprocessIssues().stream().map(x -> ProblemFactory.build(x, tabLineStarts, endNumLines, this.editor)).forEach(result.otherProblems::add);
            result.hasSyntaxErrors = true;
        }
        programImports.addAll(preprocessorResult.getImportStatements());
        result.programImports.addAll(preprocessorResult.getImportStatements());
        TextTransform toParsable = new TextTransform(pdeStage);
        toParsable.addAll(preprocessorResult.getEdits());
        if (reloadLibraries) {
            this.runtimePathBuilder.markLibrariesChanged();
        }
        boolean bl = rebuildLibraryClassPath = reloadLibraries || PreprocService.checkIfImportsChanged(programImports, prevResult.programImports);
        if (rebuildLibraryClassPath) {
            this.runtimePathBuilder.markLibraryImportsChanged();
        }
        boolean bl2 = rebuildClassPath = reloadCodeFolder || rebuildLibraryClassPath || prevResult.classLoader == null || prevResult.classPath == null || prevResult.classPathArray == null || prevResult.searchClassPathArray == null;
        if (reloadCodeFolder) {
            this.runtimePathBuilder.markCodeFolderChanged();
        }
        if (rebuildClassPath) {
            this.runtimePathBuilder.prepareClassPath(result, javaMode);
        } else {
            result.classLoader = prevResult.classLoader;
            result.classPath = prevResult.classPath;
            result.searchClassPathArray = prevResult.searchClassPathArray;
            result.classPathArray = prevResult.classPathArray;
        }
        String parsableStage = toParsable.apply();
        TextTransform.OffsetMapper parsableMapper = toParsable.getMapper();
        CompileResults parsableCompile = this.compileInMemory(parsableStage, className, result.classPathArray, false);
        CompilationUnit parsableCU = parsableCompile.getCompilationUnit();
        TextTransform toCompilable = new TextTransform(parsableStage);
        toCompilable.addAll(SourceUtil.preprocessAST(parsableCU));
        String compilableStage = toCompilable.apply();
        TextTransform.OffsetMapper compilableMapper = toCompilable.getMapper();
        CompileResults compilableCompile = this.compileInMemory(compilableStage, className, result.classPathArray, false);
        CompilationUnit compilableCU = compilableCompile.getCompilationUnit();
        result.hasSyntaxErrors |= Arrays.stream(compilableCU.getProblems()).anyMatch(IProblem::isError);
        CompileResults bindingsCompile = javaFiles.size() == 0 ? this.compileInMemory(compilableStage, className, result.classPathArray, true) : this.compileFromDisk(compilableStage, className, result.classPathArray, javaFiles);
        List<IProblem> bindingsProblems = bindingsCompile.getProblems();
        result.hasCompilationErrors = bindingsProblems.stream().anyMatch(IProblem::isError);
        result.offsetMapper = parsableMapper.thenMapping(compilableMapper);
        result.javaCode = compilableStage;
        result.compilationUnit = bindingsCompile.getCompilationUnit();
        result.javaFileMapping = bindingsCompile.getJavaFileMapping();
        result.iproblems = bindingsCompile.getProblems();
        return result.build();
    }

    private String getSketchTabContents(SketchCode sketchCode) {
        String code = null;
        if (sketchCode.getDocument() != null) {
            try {
                code = sketchCode.getDocumentText();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        if (code == null) {
            code = sketchCode.getProgram();
        }
        return code;
    }

    private CompileResults compileInMemory(String sketchSource, String className, String[] classPathArray, boolean resolveBindings) {
        this.parser.setSource(sketchSource.toCharArray());
        this.setupParser(resolveBindings, className, classPathArray);
        CompilationUnit compilationUnit = (CompilationUnit)this.parser.createAST(null);
        List<IProblem> problems = Arrays.asList(compilationUnit.getProblems());
        return new CompileResults(compilationUnit, problems, new HashMap<String, Integer>());
    }

    private CompileResults compileFromDisk(String sketchSource, String className, String[] classPathArray, List<JavaSketchCode> javaFiles) {
        ArrayList<Path> temporaryFilesList = new ArrayList<Path>();
        HashMap<String, Integer> javaFileMapping = new HashMap<String, Integer>();
        this.setupParser(true, className, classPathArray);
        Path mainTemporaryFile = this.createTemporaryFile(sketchSource);
        String mainSource = mainTemporaryFile.toString();
        temporaryFilesList.add(mainTemporaryFile);
        for (JavaSketchCode javaFile : javaFiles) {
            String tabContents = this.getSketchTabContents(javaFile.getSketchCode());
            Path newPath = this.createTemporaryFile(tabContents);
            javaFileMapping.put(newPath.toString(), javaFile.getTabIndex());
            temporaryFilesList.add(newPath);
        }
        int numFiles = temporaryFilesList.size();
        String[] temporaryFilesArray = new String[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            temporaryFilesArray[i] = ((Path)temporaryFilesList.get(i)).toString();
        }
        ProcessingASTRequester astRequester = new ProcessingASTRequester(mainSource);
        this.parser.createASTs(temporaryFilesArray, null, new String[0], (FileASTRequestor)astRequester, null);
        this.deleteTemporaryFiles(temporaryFilesList);
        return new CompileResults(astRequester.getMainCompilationUnit(), astRequester.getProblems(), javaFileMapping);
    }

    private void setupParser(boolean resolveBindings, String className, String[] classPathArray) {
        this.parser.setKind(8);
        this.parser.setCompilerOptions(COMPILER_OPTIONS);
        this.parser.setStatementsRecovery(true);
        if (resolveBindings) {
            this.parser.setUnitName(className);
            this.parser.setEnvironment(classPathArray, null, null, false);
            this.parser.setResolveBindings(true);
        }
    }

    private Path createTemporaryFile(String content) {
        try {
            Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
            Files.write(tempFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write to temporary folder.");
        }
    }

    private void deleteTemporaryFiles(List<Path> paths) {
        try {
            for (Path path : paths) {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot delete from temporary folder.");
        }
    }

    private static List<ImportStatement> buildCoreAndDefaultImports(PdePreprocessor preprocessor) {
        ArrayList<ImportStatement> result = new ArrayList<ImportStatement>();
        for (String imp : preprocessor.getCoreImports()) {
            result.add(ImportStatement.parse(imp));
        }
        for (String imp : preprocessor.getDefaultImports()) {
            result.add(ImportStatement.parse(imp));
        }
        return result;
    }

    private static List<ImportStatement> buildCodeFolderImports(Sketch sketch) {
        if (sketch.hasCodeFolder()) {
            File codeFolder = sketch.getCodeFolder();
            String codeFolderClassPath = Util.contentsToClassPath((File)codeFolder);
            StringList codeFolderPackages = Util.packageListFromClassPath((String)codeFolderClassPath);
            return StreamSupport.stream(codeFolderPackages.spliterator(), false).map(ImportStatement::wholePackage).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean checkIfImportsChanged(List<ImportStatement> prevImports, List<ImportStatement> imports) {
        if (imports.size() != prevImports.size()) {
            return true;
        }
        int count = imports.size();
        for (int i = 0; i < count; ++i) {
            if (imports.get(i).isSameAs(prevImports.get(i))) continue;
            return true;
        }
        return false;
    }

    static {
        HashMap<String, String> compilerOptions = new HashMap<String, String>();
        compilerOptions.put("org.eclipse.jdt.core.compiler.compliance", "11");
        compilerOptions.put("org.eclipse.jdt.core.compiler.source", "11");
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        String[] generate = new String[]{"org.eclipse.jdt.core.compiler.debug.lineNumber", "org.eclipse.jdt.core.compiler.debug.sourceFile"};
        String[] ignore = new String[]{"org.eclipse.jdt.core.compiler.problem.unusedImport", "org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "org.eclipse.jdt.core.compiler.problem.rawTypeReference", "org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"};
        String[] warn = new String[]{"org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "org.eclipse.jdt.core.compiler.problem.nullReference", "org.eclipse.jdt.core.compiler.problem.potentialNullReference", "org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "org.eclipse.jdt.core.compiler.problem.unusedLabel", "org.eclipse.jdt.core.compiler.problem.unusedLocal", "org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "org.eclipse.jdt.core.compiler.problem.unusedParameter", "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"};
        for (String s : generate) {
            compilerOptions.put(s, "generate");
        }
        for (String s : ignore) {
            compilerOptions.put(s, "ignore");
        }
        for (String s : warn) {
            compilerOptions.put(s, "warning");
        }
        COMPILER_OPTIONS = Collections.unmodifiableMap(compilerOptions);
    }

    private static class JavaSketchCode {
        private final SketchCode sketchCode;
        private final int tabIndex;

        public JavaSketchCode(SketchCode newSketchCode, int newTabIndex) {
            this.sketchCode = newSketchCode;
            this.tabIndex = newTabIndex;
        }

        public SketchCode getSketchCode() {
            return this.sketchCode;
        }

        public int getTabIndex() {
            return this.tabIndex;
        }
    }

    private static class CompileResults {
        private final CompilationUnit compilationUnit;
        private final List<IProblem> problems;
        private final Map<String, Integer> javaFileMapping;

        public CompileResults(CompilationUnit newCompilationUnit, List<IProblem> newProblems, Map<String, Integer> newJavaFileMapping) {
            this.compilationUnit = newCompilationUnit;
            this.problems = newProblems;
            this.javaFileMapping = newJavaFileMapping;
        }

        public CompilationUnit getCompilationUnit() {
            return this.compilationUnit;
        }

        public List<IProblem> getProblems() {
            return this.problems;
        }

        public Map<String, Integer> getJavaFileMapping() {
            return this.javaFileMapping;
        }
    }

    private static class ProcessingASTRequester
    extends FileASTRequestor {
        private final String mainSource;
        private final List<IProblem> problems;
        private CompilationUnit mainCompilationUnit;

        public ProcessingASTRequester(String newMainSource) {
            this.mainSource = newMainSource;
            this.problems = new ArrayList<IProblem>();
        }

        public void acceptAST(String source, CompilationUnit ast) {
            if (source.equals(this.mainSource)) {
                this.mainCompilationUnit = ast;
            }
            Collections.addAll(this.problems, ast.getProblems());
        }

        public List<IProblem> getProblems() {
            return this.problems;
        }

        public CompilationUnit getMainCompilationUnit() {
            return this.mainCompilationUnit;
        }
    }
}

