/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import org.eclipse.jdt.core.compiler.IProblem;
import processing.app.Problem;
import processing.mode.java.CompileErrorMessageSimplifier;

public class JavaProblem
implements Problem {
    private int tabIndex;
    private int lineNumber;
    private int startOffset;
    private int stopOffset;
    private String message;
    private int type;
    private String[] importSuggestions;
    public static final int ERROR = 1;
    public static final int WARNING = 2;

    public JavaProblem(String message, int type, int tabIndex, int lineNumber) {
        this.message = message;
        this.type = type;
        this.tabIndex = tabIndex;
        this.lineNumber = lineNumber;
    }

    public static JavaProblem fromIProblem(IProblem iProblem, int tabIndex, int lineNumber, String badCode) {
        int type = 0;
        if (iProblem.isError()) {
            type = 1;
        } else if (iProblem.isWarning()) {
            type = 2;
        }
        String message = CompileErrorMessageSimplifier.getSimplifiedErrorMessage(iProblem, badCode);
        return new JavaProblem(message, type, tabIndex, lineNumber);
    }

    public void setPDEOffsets(int startOffset, int stopOffset) {
        this.startOffset = startOffset;
        this.stopOffset = stopOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getStopOffset() {
        return this.stopOffset;
    }

    public boolean isError() {
        return this.type == 1;
    }

    public boolean isWarning() {
        return this.type == 2;
    }

    public String getMessage() {
        return this.message;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String[] getImportSuggestions() {
        return this.importSuggestions;
    }

    public void setImportSuggestions(String[] a) {
        this.importSuggestions = a;
    }

    public String toString() {
        return "TAB " + this.tabIndex + ",LN " + this.lineNumber + "LN START OFF: " + this.startOffset + ",LN STOP OFF: " + this.stopOffset + ",PROB: " + this.message;
    }
}

