/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import processing.app.Base;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.mode.java.JavaBuild;
import processing.mode.java.JavaEditor;
import processing.mode.java.runner.Runner;
import processing.mode.java.tweak.SketchParser;

public class JavaMode
extends Mode {
    static volatile boolean errorCheckEnabled = true;
    static volatile boolean warningsEnabled = true;
    static volatile boolean errorLogsEnabled = false;
    static volatile boolean autoSaveEnabled = true;
    static volatile boolean autoSavePromptEnabled = true;
    static volatile boolean defaultAutoSaveEnabled = true;
    static volatile boolean codeCompletionsEnabled = true;
    static volatile boolean ccTriggerEnabled = false;
    static volatile boolean importSuggestEnabled = true;
    static volatile boolean inspectModeHotkeyEnabled = true;
    public static int autoSaveInterval = 3;
    public static final String prefErrorCheck = "pdex.errorCheckEnabled";
    public static final String prefWarnings = "pdex.warningsEnabled";
    public static final String prefErrorLogs = "pdex.writeErrorLogs";
    public static final String prefAutoSave = "pdex.autoSave.autoSaveEnabled";
    public static final String prefAutoSaveInterval = "pdex.autoSaveInterval";
    public static final String prefAutoSavePrompt = "pdex.autoSave.promptDisplay";
    public static final String prefDefaultAutoSave = "pdex.autoSave.autoSaveByDefault";
    public static final String COMPLETION_PREF = "pdex.completion";
    public static final String COMPLETION_TRIGGER_PREF = "pdex.completion.trigger";
    public static final String SUGGEST_IMPORTS_PREF = "pdex.suggest.imports";
    public static final String INSPECT_MODE_HOTKEY_PREF = "pdex.inspectMode.hotkey";
    private final Set<String> includedSuggestions = ConcurrentHashMap.newKeySet();
    private final Set<String> excludedSuggestions = ConcurrentHashMap.newKeySet();

    public Editor createEditor(Base base, String path, EditorState state) throws EditorException {
        return new JavaEditor(base, path, state, this);
    }

    public JavaMode(Base base, File folder) {
        super(base, folder);
        this.loadPreferences();
        this.loadSuggestionsMap();
    }

    public String getTitle() {
        return "Java";
    }

    public File[] getExampleCategoryFolders() {
        return new File[]{new File(this.examplesFolder, "Basics"), new File(this.examplesFolder, "Topics"), new File(this.examplesFolder, "Demos"), new File(this.examplesFolder, "Books")};
    }

    public String getDefaultExtension() {
        return "pde";
    }

    public String[] getExtensions() {
        return new String[]{"pde", "java"};
    }

    public String[] getIgnorable() {
        return Platform.getSupportedVariants().keyArray();
    }

    public Library getCoreLibrary() {
        if (this.coreLibrary == null) {
            File coreFolder = Platform.getContentFile((String)"core");
            this.coreLibrary = new Library(coreFolder);
        }
        return this.coreLibrary;
    }

    public Runner handleLaunch(Sketch sketch, RunnerListener listener, boolean present) throws SketchException {
        JavaBuild build = new JavaBuild(sketch);
        String appletClassName = build.build(true);
        if (appletClassName != null) {
            Runner runtime = new Runner(build, listener);
            new Thread(() -> {
                if (present) {
                    runtime.present(null);
                } else {
                    runtime.launch(null);
                }
            }).start();
            return runtime;
        }
        return null;
    }

    public Runner handleTweak(Sketch sketch, RunnerListener listener, JavaEditor editor) throws SketchException {
        JavaBuild build = new JavaBuild(sketch);
        String appletClassName = build.build(true);
        if (appletClassName == null) {
            return null;
        }
        editor.initBaseCode();
        boolean requiresTweak = SketchParser.containsTweakComment(editor.baseCode);
        SketchParser parser = new SketchParser(editor.baseCode, requiresTweak);
        boolean launchInteractive = editor.automateSketch(sketch, parser);
        build = new JavaBuild(sketch);
        appletClassName = build.build(false);
        if (appletClassName != null) {
            Runner runtime = new Runner(build, listener);
            new Thread(() -> {
                runtime.launch(null);
                if (launchInteractive) {
                    EventQueue.invokeLater(() -> {
                        editor.initEditorCode(parser.allHandles, false);
                        editor.stopTweakMode(parser.allHandles);
                    });
                }
            }).start();
            if (launchInteractive) {
                EventQueue.invokeLater(() -> {
                    editor.initEditorCode(parser.allHandles, false);
                    editor.updateInterface(parser.allHandles, parser.colorBoxes);
                    editor.startTweakMode();
                });
            }
            return runtime;
        }
        return null;
    }

    public boolean handleExportApplication(Sketch sketch) throws SketchException, IOException {
        JavaBuild build = new JavaBuild(sketch);
        return build.exportApplication();
    }

    public String getSearchPath() {
        return this.getCoreLibrary().getJarPath();
    }

    boolean includeSuggestion(String impName) {
        return this.includedSuggestions.contains(impName);
    }

    boolean excludeSuggestion(String impName) {
        return this.excludedSuggestions.contains(impName);
    }

    public void loadPreferences() {
        Messages.log((String)"Load PDEX prefs");
        errorCheckEnabled = Preferences.getBoolean((String)prefErrorCheck);
        warningsEnabled = Preferences.getBoolean((String)prefWarnings);
        errorLogsEnabled = Preferences.getBoolean((String)prefErrorLogs);
        autoSaveEnabled = Preferences.getBoolean((String)prefAutoSave);
        autoSaveInterval = Preferences.getInteger((String)prefAutoSaveInterval);
        autoSavePromptEnabled = Preferences.getBoolean((String)prefAutoSavePrompt);
        defaultAutoSaveEnabled = Preferences.getBoolean((String)prefDefaultAutoSave);
        codeCompletionsEnabled = Preferences.getBoolean((String)COMPLETION_PREF);
        ccTriggerEnabled = Preferences.getBoolean((String)COMPLETION_TRIGGER_PREF);
        importSuggestEnabled = Preferences.getBoolean((String)SUGGEST_IMPORTS_PREF);
        inspectModeHotkeyEnabled = Preferences.getBoolean((String)INSPECT_MODE_HOTKEY_PREF);
    }

    public void savePreferences() {
        Messages.log((String)"Saving PDEX prefs");
        Preferences.setBoolean((String)prefErrorCheck, (boolean)errorCheckEnabled);
        Preferences.setBoolean((String)prefWarnings, (boolean)warningsEnabled);
        Preferences.setBoolean((String)prefErrorLogs, (boolean)errorLogsEnabled);
        Preferences.setBoolean((String)prefAutoSave, (boolean)autoSaveEnabled);
        Preferences.setInteger((String)prefAutoSaveInterval, (int)autoSaveInterval);
        Preferences.setBoolean((String)prefAutoSavePrompt, (boolean)autoSavePromptEnabled);
        Preferences.setBoolean((String)prefDefaultAutoSave, (boolean)defaultAutoSaveEnabled);
        Preferences.setBoolean((String)COMPLETION_PREF, (boolean)codeCompletionsEnabled);
        Preferences.setBoolean((String)COMPLETION_TRIGGER_PREF, (boolean)ccTriggerEnabled);
        Preferences.setBoolean((String)SUGGEST_IMPORTS_PREF, (boolean)importSuggestEnabled);
        Preferences.setBoolean((String)INSPECT_MODE_HOTKEY_PREF, (boolean)inspectModeHotkeyEnabled);
    }

    private void loadSuggestionsMap() {
        Collections.addAll(this.includedSuggestions, this.getSuggestionIncludeList());
        Collections.addAll(this.excludedSuggestions, this.getSuggestionExcludeList());
    }

    protected String[] getSuggestionIncludeList() {
        return new String[]{"processing.core.PApplet", "processing.core.PFont", "processing.core.PGraphics", "processing.core.PImage", "processing.core.PMatrix2D", "processing.core.PMatrix3D", "processing.core.PStyle", "processing.core.PVector", "processing.core.PShape", "processing.core.PGraphicsJava2D", "processing.core.PGraphics2D", "processing.core.PGraphics3D", "processing.data.FloatDict", "processing.data.FloatList", "processing.data.IntDict", "processing.data.IntList", "processing.data.JSONArray", "processing.data.JSONObject", "processing.data.StringDict", "processing.data.StringList", "processing.data.Table", "processing.data.XML", "processing.event.Event", "processing.event.KeyEvent", "processing.event.MouseEvent", "processing.event.TouchEvent", "processing.opengl.PShader", "processing.opengl.PGL", "java.util.ArrayList", "java.io.BufferedReader", "java.util.HashMap", "java.io.PrintWriter", "java.lang.String"};
    }

    protected String[] getSuggestionExcludeList() {
        return new String[]{"processing.core.PGraphicsRetina2D", "processing.core.PShapeOBJ", "processing.core.PShapeSVG", "processing.data.Sort", "processing.opengl.FrameBuffer", "processing.opengl.LinePath", "processing.opengl.LinePath.PathIterator", "processing.opengl.LineStroker", "processing.opengl.PGraphicsOpenGL"};
    }
}

