/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.SketchException;
import processing.app.ui.ColorChooser;
import processing.core.PApplet;
import processing.data.StringDict;
import processing.data.StringList;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaMode;

public class ExportPrompt {
    static final String EXPORT_VARIANTS = "export.application.variants";
    final JButton exportButton = new JButton(Language.text((String)"prompt.export"));
    final JButton cancelButton = new JButton(Language.text((String)"prompt.cancel"));
    List<JCheckBox> variantButtons;
    final JavaEditor editor;
    static ExportPrompt inst;

    private ExportPrompt(JavaEditor editor) {
        this.editor = editor;
        String pref = Preferences.get((String)EXPORT_VARIANTS);
        if (pref == null) {
            pref = Platform.getVariant();
            Preferences.set((String)EXPORT_VARIANTS, (String)pref);
        }
        StringList selectedVariants = new StringList(pref.split(","));
        this.variantButtons = new ArrayList<JCheckBox>();
        for (StringDict.Entry entry : Platform.getSupportedVariants().entries()) {
            String variant = entry.key;
            JCheckBox button = new JCheckBox(entry.value);
            if (variant.startsWith("macos") && !Platform.isMacOS()) {
                button.setEnabled(false);
            } else {
                button.setSelected(selectedVariants.hasValue(variant));
            }
            button.setActionCommand(variant);
            button.addActionListener(e -> this.updateVariants());
            this.variantButtons.add(button);
        }
    }

    protected void updateVariants() {
        StringList list = new StringList();
        for (JCheckBox button : this.variantButtons) {
            if (!button.isSelected()) continue;
            list.append(button.getActionCommand());
        }
        Preferences.set((String)EXPORT_VARIANTS, (String)list.join(","));
        this.exportButton.setEnabled(this.anyExportButton());
    }

    protected boolean anyExportButton() {
        for (JCheckBox button : this.variantButtons) {
            if (!button.isSelected()) continue;
            return true;
        }
        return false;
    }

    protected static boolean trigger(JavaEditor editor) throws IOException, SketchException {
        if (inst == null) {
            inst = new ExportPrompt(editor);
        }
        return inst.trigger();
    }

    protected boolean trigger() throws IOException, SketchException {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(6));
        String line1 = Language.text((String)"export.description.line1");
        String line2 = Language.text((String)"export.description.line2");
        JLabel label1 = new JLabel(line1, 0);
        JLabel label2 = new JLabel(line2, 0);
        label1.setAlignmentX(0.0f);
        label2.setAlignmentX(0.0f);
        panel.add(label1);
        panel.add(label2);
        panel.add(Box.createVerticalStrut(12));
        JPanel platformPanel = new JPanel();
        int half = (this.variantButtons.size() + 1) / 2;
        Box leftPlatforms = Box.createVerticalBox();
        for (int i = 0; i < half; ++i) {
            leftPlatforms.add(this.variantButtons.get(i));
        }
        Box rightPlatforms = Box.createVerticalBox();
        for (int i = half; i < this.variantButtons.size(); ++i) {
            rightPlatforms.add(this.variantButtons.get(i));
        }
        platformPanel.add(leftPlatforms);
        platformPanel.add(rightPlatforms);
        platformPanel.setBorder(new TitledBorder(Language.text((String)"export.platforms")));
        platformPanel.setAlignmentX(0.0f);
        panel.add(platformPanel);
        int divWidth = platformPanel.getPreferredSize().width;
        int indent = 0;
        JCheckBox showStopButton = new JCheckBox(Language.text((String)"export.options.show_stop_button"));
        showStopButton.setSelected(Preferences.getBoolean((String)"export.application.stop"));
        showStopButton.addItemListener(e -> Preferences.setBoolean((String)"export.application.stop", (boolean)showStopButton.isSelected()));
        showStopButton.setEnabled(Preferences.getBoolean((String)"export.application.present"));
        showStopButton.setBorder(new EmptyBorder(3, 13 + indent, 6, 13));
        JCheckBox presentButton = new JCheckBox(Language.text((String)"export.options.present"));
        presentButton.setSelected(Preferences.getBoolean((String)"export.application.present"));
        presentButton.addItemListener(e -> {
            boolean sal = presentButton.isSelected();
            Preferences.setBoolean((String)"export.application.present", (boolean)sal);
            showStopButton.setEnabled(sal);
        });
        presentButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        JPanel presentPanel = new JPanel();
        presentPanel.setLayout(new BoxLayout(presentPanel, 1));
        Box fullScreenBox = Box.createHorizontalBox();
        fullScreenBox.add(presentButton);
        fullScreenBox.add(new ColorPreference("run.present.bgcolor"));
        fullScreenBox.add(Box.createHorizontalStrut(10));
        fullScreenBox.add(Box.createHorizontalGlue());
        presentPanel.add(fullScreenBox);
        Box showStopBox = Box.createHorizontalBox();
        showStopBox.add(showStopButton);
        showStopBox.add(new ColorPreference("run.present.stop.color"));
        showStopBox.add(Box.createHorizontalStrut(10));
        showStopBox.add(Box.createHorizontalGlue());
        presentPanel.add(showStopBox);
        presentPanel.setBorder(new TitledBorder(Language.text((String)"export.full_screen")));
        presentPanel.setAlignmentX(0.0f);
        panel.add(presentPanel);
        JPanel embedPanel = new JPanel();
        embedPanel.setLayout(new BoxLayout(embedPanel, 1));
        String platformName = null;
        if (Platform.isMacOS()) {
            platformName = "macOS";
        } else if (Platform.isWindows()) {
            platformName = "Windows";
        } else if (Platform.isLinux()) {
            platformName = "Linux";
        }
        boolean embed = Preferences.getBoolean((String)"export.application.embed_java");
        String warning1 = "<html><div width=\"" + divWidth + "\"><font size=\"2\">";
        String warning2a = "Embedding Java will make the " + platformName + " application larger, but it will be far more likely to work. Users on other platforms will need to ";
        String warning2b = "Users will need to ";
        String warning3 = "<a href=\"https://adoptium.net/\">install OpenJDK " + PApplet.javaPlatform + "</a>.";
        String embedWarning = warning1 + warning2a + warning3;
        String nopeWarning = warning1 + "Users will need to " + warning3;
        JLabel warningLabel = new JLabel(embed ? embedWarning : nopeWarning);
        warningLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                Platform.openURL((String)"https://adoptium.net/");
            }
        });
        warningLabel.setBorder(new EmptyBorder(3, 13 + indent, 3, 13));
        JCheckBox embedJavaButton = new JCheckBox(Language.interpolate((String)"export.include_java", (Object[])new Object[]{platformName}));
        embedJavaButton.setSelected(embed);
        embedJavaButton.addItemListener(e -> {
            boolean selected = embedJavaButton.isSelected();
            Preferences.setBoolean((String)"export.application.embed_java", (boolean)selected);
            if (selected) {
                warningLabel.setText(embedWarning);
            } else {
                warningLabel.setText(nopeWarning);
            }
        });
        embedJavaButton.setBorder(new EmptyBorder(3, 13, 3, 13));
        embedPanel.add(embedJavaButton);
        embedPanel.add(warningLabel);
        embedPanel.setBorder(new TitledBorder(Language.text((String)"export.embed_java")));
        panel.add(embedPanel);
        if (Platform.isMacOS()) {
            JPanel signPanel = new JPanel();
            signPanel.setLayout(new BoxLayout(signPanel, 1));
            signPanel.setBorder(new TitledBorder(Language.text((String)"export.code_signing")));
            String APPLE_URL = "https://developer.apple.com/developer-id/";
            Object thePain = "In recent versions of macOS, Apple has introduced the \u201cGatekeeper\u201d system, which makes it more difficult to run applications like those exported from Processing. ";
            thePain = new File("/usr/bin/codesign_allocate").exists() ? (String)thePain + "This application will be \u201cself-signed\u201d which means that Finder may report that the application is from an \u201cunidentified developer\u201d. If the application will not run, try right-clicking the app and selecting Open from the pop-up menu. Or you can visit System Preferences \u2192 Security & Privacy and select Allow apps downloaded from: anywhere. " : (String)thePain + "Gatekeeper requires applications to be \u201csigned\u201d, or they will be reported as damaged. To prevent this message, install Xcode (and the Command Line Tools) from the App Store. ";
            thePain = (String)thePain + "To avoid the messages entirely, manually code sign your app. For more information: <a href=\"\">https://developer.apple.com/developer-id/</a>";
            JLabel area = new JLabel("<html><div width=\"" + divWidth + "\"><font size=\"2\">" + (String)thePain + "</div></html>");
            area.setBorder(new EmptyBorder(3, 13, 3, 13));
            signPanel.add(area);
            signPanel.setAlignmentX(0.0f);
            area.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    Platform.openURL((String)"https://developer.apple.com/developer-id/");
                }
            });
            panel.add(signPanel);
        }
        Object[] options = new JButton[]{this.exportButton, this.cancelButton};
        JOptionPane optionPane = new JOptionPane(panel, -1, 0, null, options, this.exportButton);
        JDialog dialog = new JDialog((Frame)((Object)this.editor), Language.text((String)"export"), true);
        dialog.setContentPane(optionPane);
        this.exportButton.addActionListener(e -> optionPane.setValue(this.exportButton));
        this.cancelButton.addActionListener(e -> optionPane.setValue(this.cancelButton));
        optionPane.addPropertyChangeListener(e -> {
            String prop = e.getPropertyName();
            if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                dialog.setVisible(false);
            }
        });
        dialog.pack();
        dialog.setResizable(false);
        Rectangle bounds = this.editor.getBounds();
        dialog.setLocation(bounds.x + (bounds.width - dialog.getSize().width) / 2, bounds.y + (bounds.height - dialog.getSize().height) / 2);
        dialog.setVisible(true);
        Object value = optionPane.getValue();
        if (value.equals(this.exportButton)) {
            return ((JavaMode)this.editor.getMode()).handleExportApplication(this.editor.getSketch());
        }
        if (value.equals(this.cancelButton) || value.equals(-1)) {
            this.editor.statusNotice(Language.text((String)"export.notice.exporting.cancel"));
        }
        return false;
    }

    class ColorPreference
    extends JPanel
    implements ActionListener {
        ColorChooser chooser;
        String prefName;

        public ColorPreference(String pref) {
            this.prefName = pref;
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setPreferredSize(new Dimension(30, 20));
            this.setMaximumSize(new Dimension(30, 20));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Color color = Preferences.getColor((String)ColorPreference.this.prefName);
                    ColorPreference.this.chooser = new ColorChooser((Frame)((Object)ExportPrompt.this.editor), true, color, Language.text((String)"color_chooser.select"), (ActionListener)ColorPreference.this);
                    ColorPreference.this.chooser.show();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Preferences.getColor((String)this.prefName));
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = this.chooser.getColor();
            Preferences.setColor((String)this.prefName, (Color)color);
            this.repaint();
            this.chooser.hide();
        }
    }
}

