/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import processing.app.Messages;
import processing.app.ui.ZoomTreeCellRenderer;
import processing.mode.java.CompletionGenerator;
import processing.mode.java.JavaEditor;
import processing.mode.java.PreprocService;
import processing.mode.java.PreprocSketch;
import processing.mode.java.SketchInterval;

class ASTViewer {
    final JDialog window;
    final JTree tree;
    final Consumer<PreprocSketch> updateListener = this::buildAndUpdateTree;

    ASTViewer(JavaEditor editor, final PreprocService pps) {
        this.window = new JDialog((Frame)((Object)editor));
        this.tree = new JTree(){

            @Override
            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode treeNode;
                Object o;
                if (value instanceof DefaultMutableTreeNode && (o = (treeNode = (DefaultMutableTreeNode)value).getUserObject()) instanceof ASTNode) {
                    ASTNode node = (ASTNode)o;
                    return CompletionGenerator.getNodeAsString(node);
                }
                return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            }
        };
        this.tree.setCellRenderer((TreeCellRenderer)new ZoomTreeCellRenderer());
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                pps.unregisterListener(ASTViewer.this.updateListener);
                ASTViewer.this.tree.setModel(null);
            }
        });
        this.window.setDefaultCloseOperation(1);
        this.window.setBounds(new Rectangle(680, 100, 460, 620));
        this.window.setTitle("AST View - " + editor.getSketch().getName());
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.tree);
        this.window.add(sp);
        pps.whenDone(this.updateListener);
        pps.registerListener(this.updateListener);
        this.tree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode treeNode;
            if (this.tree.getLastSelectedPathComponent() != null && (treeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()).getUserObject() instanceof ASTNode) {
                ASTNode node = (ASTNode)treeNode.getUserObject();
                pps.whenDone(ps -> {
                    SketchInterval si = ps.mapJavaToSketch(node);
                    if (!ps.inRange(si)) {
                        return;
                    }
                    EventQueue.invokeLater(() -> editor.highlight(si.tabIndex, si.startTabOffset, si.stopTabOffset));
                });
            }
        });
    }

    void dispose() {
        if (this.window != null) {
            this.window.dispose();
        }
    }

    void buildAndUpdateTree(PreprocSketch ps) {
        CompilationUnit cu = ps.compilationUnit;
        if (cu.types().isEmpty()) {
            Messages.err((String)"No Type found in CU");
            return;
        }
        final ArrayDeque treeNodeStack = new ArrayDeque();
        ASTNode type0 = (ASTNode)cu.types().get(0);
        type0.accept(new ASTVisitor(){

            public boolean preVisit2(ASTNode node) {
                treeNodeStack.push(new DefaultMutableTreeNode(node));
                return super.preVisit2(node);
            }

            public void postVisit(ASTNode node) {
                if (treeNodeStack.size() > 1) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treeNodeStack.pop();
                    ((DefaultMutableTreeNode)treeNodeStack.peek()).add(treeNode);
                }
            }
        });
        DefaultMutableTreeNode codeTree = (DefaultMutableTreeNode)treeNodeStack.pop();
        EventQueue.invokeLater(() -> {
            if (this.tree.hasFocus() || this.window.hasFocus()) {
                return;
            }
            this.tree.setModel(new DefaultTreeModel(codeTree));
            ((DefaultTreeModel)this.tree.getModel()).reload();
            this.tree.validate();
            if (!this.window.isVisible()) {
                this.window.setVisible(true);
            }
        });
    }
}

