/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import processing.app.Base;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.ui.Toolkit;
import processing.app.ui.WebFrame;
import processing.awt.ShimAWT;

public class Welcome {
    Base base;
    WebFrame view;

    public Welcome(Base base, boolean sketchbook) throws IOException {
        this.base = base;
        Font dialogFont = Toolkit.getSansFont(14, 0);
        Box panel = Box.createHorizontalBox();
        panel.setBackground(new Color(245, 245, 245));
        Toolkit.setBorder(panel, 15, 20, 15, 20);
        JCheckBox checkbox = new JCheckBox("Show this message on startup");
        checkbox.setFont(dialogFont);
        checkbox.setSelected("true".equals(Preferences.get("welcome.four.beta.show")));
        checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Preferences.setBoolean("welcome.four.beta.show", true);
                } else if (e.getStateChange() == 2) {
                    Preferences.setBoolean("welcome.four.beta.show", false);
                }
            }
        });
        panel.add(checkbox);
        panel.add(Box.createHorizontalGlue());
        JButton button = new JButton("Get Started");
        button.setFont(Toolkit.getSansFont(14, 0));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Welcome.this.view.handleClose();
            }
        });
        panel.add(button);
        this.view = new WebFrame(Welcome.getIndexFile(sketchbook), 425, panel){

            @Override
            public void handleLink(String link) {
                if (link.endsWith("#sketchbook")) {
                    File folder = new File(Preferences.getSketchbookPath()).getParentFile();
                    ShimAWT.selectFolder((String)Language.text("preferences.sketchbook_location.popup"), (String)"sketchbookCallback", (File)folder, (Object)this);
                } else {
                    super.handleLink(link);
                }
            }

            @Override
            public void handleClose() {
                Preferences.setBoolean("welcome.four.beta.seen", true);
                Preferences.save();
                super.handleClose();
            }
        };
        this.view.setVisible(true);
    }

    public void sketchbookCallback(File folder) {
        if (folder != null && this.base != null) {
            this.base.setSketchbookFolder(folder);
        }
    }

    private static File getIndexFile(boolean sketchbook) {
        String filename = "welcome/" + (sketchbook ? "sketchbook.html" : "generic.html");
        File htmlFile = new File("../build/shared/lib/" + filename);
        if (htmlFile.exists()) {
            return htmlFile;
        }
        htmlFile = Platform.getContentFile("../../../../../shared/lib/" + filename);
        if (htmlFile.exists()) {
            return htmlFile;
        }
        try {
            return Base.getLibFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Platform.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new Welcome(null, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

