/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.HTMLEditorKit;
import processing.app.Platform;
import processing.app.ui.Toolkit;
import processing.core.PApplet;
import processing.data.StringDict;

public class WebFrame
extends JFrame {
    JEditorPane editorPane;
    HTMLEditorKit editorKit;
    boolean ready;

    public WebFrame(File file, int width, Container panel) throws IOException {
        URL fileUrl = file.toURI().toURL();
        this.requestContentHeight(width, fileUrl);
        this.editorPane = new JEditorPane();
        this.editorPane.addPropertyChangeListener("page", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object title = WebFrame.this.editorPane.getDocument().getProperty("title");
                if (title instanceof String) {
                    WebFrame.this.setTitle((String)title);
                }
            }
        });
        this.editorPane.setPage(fileUrl);
        this.editorPane.setEditable(false);
        this.editorPane.setPreferredSize(new Dimension(width, width));
        Container pain = this.getContentPane();
        pain.setLayout(new BoxLayout(pain, 1));
        pain.add(this.editorPane);
        if (panel != null) {
            pain.add(panel);
        }
        Toolkit.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFrame.this.handleClose();
            }
        });
        Toolkit.setIcon(this);
        this.editorKit = (HTMLEditorKit)this.editorPane.getEditorKit();
        this.editorKit.setAutoFormSubmission(false);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e instanceof FormSubmitEvent) {
                    String result = ((FormSubmitEvent)e).getData();
                    StringDict dict = new StringDict();
                    if (result.trim().length() != 0) {
                        String[] pairs;
                        for (String pair : pairs = result.split("&")) {
                            String[] pieces = pair.split("=");
                            String attr = PApplet.urlDecode((String)pieces[0]);
                            String valu = PApplet.urlDecode((String)pieces[1]);
                            dict.set(attr, valu);
                        }
                    }
                    WebFrame.this.handleSubmit(dict);
                } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    WebFrame.this.handleLink(e.getURL().toExternalForm());
                }
            }
        });
    }

    @Override
    public void setVisible(final boolean visible) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!WebFrame.this.ready) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                WebFrame.super.setVisible(visible);
            }
        }).start();
    }

    public void handleClose() {
        this.dispose();
    }

    public void handleSubmit(StringDict dict) {
    }

    public void handleLink(String link) {
        Platform.openURL(link);
    }

    void requestContentHeight(final int width, final URL url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                final JEditorPane dummy = new JEditorPane();
                dummy.addPropertyChangeListener("page", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        int high = dummy.getPreferredSize().height;
                        WebFrame.this.editorPane.setPreferredSize(new Dimension(width, high));
                        WebFrame.this.pack();
                        WebFrame.this.setLocationRelativeTo(null);
                        WebFrame.this.ready = true;
                    }
                });
                try {
                    dummy.setPage(url);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                dummy.setSize(width, Short.MAX_VALUE);
            }
        }).start();
    }
}

