/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.basic.BasicScrollBarUI;
import processing.app.ui.Theme;

public class ThemeScrollBarUI
extends BasicScrollBarUI {
    private final Dimension none = new Dimension();
    private String backgroundAttr;
    private String pressedAttr;
    private String rolloverAttr;
    private String enabledAttr;
    private Color backgroundColor;
    private Color pressedColor;
    private Color rolloverColor;
    private Color enabledColor;

    public ThemeScrollBarUI(String backgroundAttr, String pressedAttr, String rolloverAttr, String enabledAttr) {
        this.backgroundAttr = backgroundAttr;
        this.pressedAttr = pressedAttr;
        this.rolloverAttr = rolloverAttr;
        this.enabledAttr = enabledAttr;
    }

    public void updateTheme() {
        this.backgroundColor = Theme.getColor("editor.scrollbar.color");
        this.pressedColor = Theme.getColor("editor.scrollbar.thumb.pressed.color");
        this.rolloverColor = Theme.getColor("editor.scrollbar.thumb.rollover.color");
        this.enabledColor = Theme.getColor("editor.scrollbar.thumb.enabled.color");
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new JButton(){

            @Override
            public Dimension getPreferredSize() {
                return ThemeScrollBarUI.this.none;
            }
        };
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new JButton(){

            @Override
            public Dimension getPreferredSize() {
                return ThemeScrollBarUI.this.none;
            }
        };
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle r) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle r) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JScrollBar sb = (JScrollBar)c;
        if (sb.isEnabled()) {
            Color color = this.isDragging ? this.pressedColor : (this.isThumbRollover() ? this.rolloverColor : this.enabledColor);
            g2.setPaint(color);
            int inset = 3;
            int arc = Math.min(c.getWidth(), c.getHeight()) - inset * 2;
            g2.fillRoundRect(r.x + inset, r.y + inset, r.width - inset * 2, r.height - inset * 2, arc, arc);
            g2.dispose();
        }
    }

    @Override
    protected void setThumbBounds(int x, int y, int width, int height) {
        super.setThumbBounds(x, y, width, height);
        this.scrollbar.repaint();
    }
}

