/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Settings;
import processing.app.syntax.SyntaxStyle;
import processing.core.PApplet;

public class Theme {
    static Settings theme;

    public static void init() {
        try {
            File inputFile = Platform.getContentFile("lib/theme.txt");
            if (inputFile == null) {
                throw new RuntimeException("Missing required file (theme.txt), you may need to reinstall.");
            }
            theme = new Settings(inputFile);
            theme.setColor("run.window.bgcolor", SystemColor.control);
            Theme.load();
        }
        catch (IOException e) {
            Messages.showError("Problem loading theme.txt", "Could not load theme.txt, please re-install Processing", e);
        }
    }

    public static void load() {
        File sketchbookTheme = Theme.getSketchbookFile();
        if (sketchbookTheme.exists()) {
            theme.load(sketchbookTheme);
        }
    }

    public static void save() {
        theme.save(Theme.getSketchbookFile());
    }

    public static File getSketchbookFile() {
        return new File(Base.getSketchbookFolder(), "theme.txt");
    }

    public static String get(String attribute) {
        return theme.get(attribute);
    }

    public static boolean getBoolean(String attribute) {
        return theme.getBoolean(attribute);
    }

    public static int getInteger(String attribute) {
        return theme.getInteger(attribute);
    }

    public static Color getColor(String attribute) {
        return theme.getColor(attribute);
    }

    public static Font getFont(String attribute) {
        return theme.getFont(attribute);
    }

    public static SyntaxStyle getStyle(String attribute) {
        String str = theme.get("editor.token." + attribute + ".style");
        if (str == null) {
            throw new IllegalArgumentException("No style found for " + attribute);
        }
        return SyntaxStyle.fromString(str);
    }

    public static Image makeGradient(String attribute, int wide, int high) {
        int top = Theme.getColor(attribute + ".gradient.top").getRGB();
        int bot = Theme.getColor(attribute + ".gradient.bottom").getRGB();
        BufferedImage outgoing = new BufferedImage(wide, high, 1);
        int[] row = new int[wide];
        WritableRaster wr = outgoing.getRaster();
        for (int i = 0; i < high; ++i) {
            int rgb = PApplet.lerpColor((int)top, (int)bot, (float)((float)i / (float)(high - 1)), (int)1);
            Arrays.fill(row, rgb);
            wr.setDataElements(0, i, wide, 1, row);
        }
        return outgoing;
    }
}

