/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JComponent;
import javax.swing.JFrame;
import processing.app.Platform;
import processing.app.ui.Toolkit;

public class Splash
extends JFrame {
    private static Splash instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Splash(File image2xFile) {
        try {
            Toolkit.setIcon(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        final Image image2x = java.awt.Toolkit.getDefaultToolkit().createImage(image2xFile.getAbsolutePath());
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image2x, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (tracker.isErrorID(0)) {
            this.setSize(0, 0);
            System.err.println("Warning: SplashWindow couldn't load splash image.");
            Splash splash = this;
            synchronized (splash) {
                this.notifyAll();
            }
        } else {
            final int wide = image2x.getWidth(this) / 2;
            final int high = image2x.getHeight(this) / 2;
            JComponent comp = new JComponent(){

                @Override
                public void paintComponent(Graphics g) {
                    Toolkit.prepareGraphics(g);
                    g.drawImage(image2x, 0, 0, wide, high, this);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(wide, high);
                }
            };
            comp.setSize(wide, high);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.getContentPane().add(comp);
            this.setUndecorated(true);
            this.pack();
            this.setLocationRelativeTo(null);
        }
    }

    static void showSplash(File image2xFile) {
        if (instance == null) {
            instance = new Splash(image2xFile);
            instance.setVisible(true);
        }
    }

    static void disposeSplash() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    static void invokeMain(String className, String[] args) {
        try {
            Class.forName(className).getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new InternalError("Failed to invoke main method", e);
        }
    }

    public static boolean getDisableHiDPI() {
        File propsFile = Platform.getContentFile("disable_hidpi");
        return propsFile != null && propsFile.exists();
    }

    public static void setDisableHiDPI(boolean disabled) {
        try {
            File propsFile = Platform.getContentFile("disable_hidpi");
            if (propsFile != null) {
                boolean success;
                if (disabled) {
                    if (!propsFile.exists()) {
                        new FileOutputStream(propsFile).close();
                    }
                } else if (propsFile.exists() && !(success = propsFile.delete())) {
                    System.err.println("Could not delete disable_hidpi");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (Splash.getDisableHiDPI()) {
            System.setProperty("sun.java2d.uiScale.enabled", "false");
        }
        try {
            Splash.showSplash(Platform.getContentFile("lib/about-2x.png"));
            Splash.invokeMain("processing.app.Base", args);
            Splash.disposeSplash();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

