/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.ui.ColorChooser;
import processing.app.ui.Editor;
import processing.app.ui.Splash;
import processing.app.ui.Toolkit;
import processing.awt.ShimAWT;
import processing.core.PApplet;

public class PreferencesFrame {
    JFrame frame;
    GroupLayout layout;
    static final Integer[] FONT_SIZES = new Integer[]{10, 12, 14, 18, 24, 36, 48};
    JTextField sketchbookLocationField;
    JTextField presentColor;
    JTextField presentColorHex;
    JCheckBox editorAntialiasBox;
    JCheckBox deletePreviousBox;
    JCheckBox memoryOverrideBox;
    JTextField memoryField;
    JCheckBox checkUpdatesBox;
    JComboBox<Integer> fontSizeField;
    JComboBox<Integer> consoleFontSizeField;
    JCheckBox inputMethodBox;
    JCheckBox autoAssociateBox;
    ColorChooser selector;
    JCheckBox errorCheckerBox;
    JCheckBox warningsCheckerBox;
    JCheckBox codeCompletionBox;
    JCheckBox importSuggestionsBox;
    JComboBox<String> zoomSelectionBox;
    JCheckBox zoomAutoBox;
    JCheckBox hidpiDisableBox;
    JCheckBox syncSketchNameBox;
    JComboBox<String> displaySelectionBox;
    JComboBox<String> languageSelectionBox;
    int displayCount;
    int defaultDisplayNum;
    String[] monoFontFamilies;
    JComboBox<String> fontSelectionBox;
    JButton okButton;
    Base base;

    public PreferencesFrame(Base base) {
        JLabel preferencePathLabel;
        this.base = base;
        this.frame = new JFrame(Language.text("preferences"));
        Container pain = this.frame.getContentPane();
        this.layout = new GroupLayout(pain);
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        pain.setLayout(this.layout);
        JLabel sketchbookLocationLabel = new JLabel(Language.text("preferences.sketchbook_location") + ":");
        this.sketchbookLocationField = new JTextField(40);
        JButton browseButton = new JButton(Language.getPrompt("browse"));
        browseButton.addActionListener(e -> {
            File defaultLocation = new File(this.sketchbookLocationField.getText());
            ShimAWT.selectFolder((String)Language.text("preferences.sketchbook_location.popup"), (String)"sketchbookCallback", (File)defaultLocation, (Object)this);
        });
        JLabel languageLabel = new JLabel(Language.text("preferences.language") + ": ");
        this.languageSelectionBox = new JComboBox();
        Map<String, String> languages = Language.getLanguages();
        String[] languageSelection = new String[languages.size()];
        languageSelection[0] = languages.get(Language.getLanguage());
        int i = 1;
        for (Map.Entry<String, String> lang : languages.entrySet()) {
            if (lang.getKey().equals(Language.getLanguage())) continue;
            languageSelection[i++] = lang.getValue();
        }
        this.languageSelectionBox.setModel(new DefaultComboBoxModel<String>(languageSelection));
        JLabel languageRestartLabel = new JLabel(" (" + Language.text("preferences.requires_restart") + ")");
        JLabel fontLabel = new JLabel(Language.text("preferences.editor_and_console_font") + ": ");
        String fontTip = "<html>" + Language.text("preferences.editor_and_console_font.tip");
        fontLabel.setToolTipText(fontTip);
        this.fontSelectionBox = new JComboBox<String>(new String[]{Toolkit.getMonoFontName()});
        this.fontSelectionBox.setToolTipText(fontTip);
        this.fontSelectionBox.setEnabled(false);
        JLabel fontSizeLabel = new JLabel(Language.text("preferences.editor_font_size") + ": ");
        this.fontSizeField = new JComboBox<Integer>(FONT_SIZES);
        this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        JLabel consoleFontSizeLabel = new JLabel(Language.text("preferences.console_font_size") + ": ");
        this.consoleFontSizeField = new JComboBox<Integer>(FONT_SIZES);
        this.consoleFontSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        this.fontSizeField.setEditable(true);
        this.consoleFontSizeField.setEditable(true);
        JLabel zoomLabel = new JLabel(Language.text("preferences.zoom") + ": ");
        this.zoomAutoBox = new JCheckBox(Language.text("preferences.zoom.auto"));
        this.zoomAutoBox.addChangeListener(e -> this.zoomSelectionBox.setEnabled(!this.zoomAutoBox.isSelected()));
        this.zoomSelectionBox = new JComboBox();
        this.zoomSelectionBox.setModel(new DefaultComboBoxModel<String>(Toolkit.zoomOptions.array()));
        JLabel zoomRestartLabel = new JLabel(" (" + Language.text("preferences.requires_restart") + ")");
        this.hidpiDisableBox = new JCheckBox("Disable HiDPI Scaling (requires restart)");
        this.hidpiDisableBox.setVisible(false);
        this.syncSketchNameBox = new JCheckBox("<html>Keep sketch name and main tab in sync<br/>(disabling this is experimental: save carefully and report issues)");
        this.syncSketchNameBox.setVerticalTextPosition(1);
        JLabel backgroundColorLabel = new JLabel(Language.text("preferences.background_color") + ": ");
        String colorTip = "<html>" + Language.text("preferences.background_color.tip");
        backgroundColorLabel.setToolTipText(colorTip);
        this.presentColor = new JTextField("      ");
        this.presentColor.setOpaque(true);
        this.presentColor.setEnabled(true);
        this.presentColor.setEditable(false);
        CompoundBorder cb = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, new Color(195, 195, 195)), BorderFactory.createMatteBorder(0, 0, 1, 1, new Color(54, 54, 54)));
        this.presentColor.setBorder(cb);
        this.presentColor.setBackground(Preferences.getColor("run.present.bgcolor"));
        this.presentColorHex = new JTextField(6);
        this.presentColorHex.setText(Preferences.get("run.present.bgcolor").substring(1));
        this.presentColorHex.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                String colorValue = PreferencesFrame.this.presentColorHex.getText().toUpperCase();
                if (colorValue.length() == 7 && colorValue.startsWith("#")) {
                    EventQueue.invokeLater(() -> PreferencesFrame.this.presentColorHex.setText(colorValue.substring(1)));
                }
                if (colorValue.length() == 6 && colorValue.matches("[0123456789ABCDEF]*")) {
                    PreferencesFrame.this.presentColor.setBackground(new Color(PApplet.unhex((String)colorValue)));
                    if (!colorValue.equals(PreferencesFrame.this.presentColorHex.getText())) {
                        EventQueue.invokeLater(() -> PreferencesFrame.this.presentColorHex.setText(colorValue));
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                String colorValue = PreferencesFrame.this.presentColorHex.getText().toUpperCase();
                if (colorValue.length() == 7 && colorValue.startsWith("#")) {
                    EventQueue.invokeLater(() -> PreferencesFrame.this.presentColorHex.setText(colorValue.substring(1)));
                }
                if (colorValue.length() == 6 && colorValue.matches("[0123456789ABCDEF]*")) {
                    PreferencesFrame.this.presentColor.setBackground(new Color(PApplet.unhex((String)colorValue)));
                    if (!colorValue.equals(PreferencesFrame.this.presentColorHex.getText())) {
                        EventQueue.invokeLater(() -> PreferencesFrame.this.presentColorHex.setText(colorValue));
                    }
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.selector = new ColorChooser(this.frame, false, Preferences.getColor("run.present.bgcolor"), Language.text("prompt.ok"), e -> {
            String colorValue = this.selector.getHexColor();
            colorValue = colorValue.substring(1);
            this.presentColorHex.setText(colorValue);
            this.presentColor.setBackground(new Color(PApplet.unhex((String)colorValue)));
            this.selector.hide();
        });
        this.presentColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PreferencesFrame.this.frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PreferencesFrame.this.selector.show();
            }
        });
        JLabel hashLabel = new JLabel("#");
        this.editorAntialiasBox = new JCheckBox(Language.text("preferences.use_smooth_text"));
        this.inputMethodBox = new JCheckBox(Language.text("preferences.enable_complex_text_input") + " (" + Language.text("preferences.enable_complex_text_input_example") + ", " + Language.text("preferences.requires_restart") + ")");
        this.errorCheckerBox = new JCheckBox(Language.text("preferences.continuously_check"));
        this.errorCheckerBox.addItemListener(e -> this.warningsCheckerBox.setEnabled(this.errorCheckerBox.isSelected()));
        this.warningsCheckerBox = new JCheckBox(Language.text("preferences.show_warnings"));
        this.codeCompletionBox = new JCheckBox(Language.text("preferences.code_completion") + " Ctrl-" + Language.text("preferences.cmd_space"));
        this.importSuggestionsBox = new JCheckBox(Language.text("preferences.suggest_imports"));
        this.memoryOverrideBox = new JCheckBox(Language.text("preferences.increase_max_memory") + ": ");
        this.memoryField = new JTextField(4);
        this.memoryOverrideBox.addChangeListener(e -> this.memoryField.setEnabled(this.memoryOverrideBox.isSelected()));
        JLabel mbLabel = new JLabel("MB");
        this.deletePreviousBox = new JCheckBox(Language.text("preferences.delete_previous_folder_on_export"));
        this.checkUpdatesBox = new JCheckBox(Language.text("preferences.check_for_updates_on_startup"));
        JLabel displayLabel = new JLabel(Language.text("preferences.run_sketches_on_display") + ": ");
        String tip = "<html>" + Language.text("preferences.run_sketches_on_display.tip");
        displayLabel.setToolTipText(tip);
        this.displaySelectionBox = new JComboBox();
        this.updateDisplayList();
        this.autoAssociateBox = new JCheckBox(Language.text("preferences.automatically_associate_pde_files"));
        this.autoAssociateBox.setVisible(false);
        JLabel morePreferenceLabel = new JLabel(Language.text("preferences.file") + ":");
        morePreferenceLabel.setForeground(Color.gray);
        final JLabel clickable = preferencePathLabel = new JLabel(Preferences.getPreferencesPath());
        preferencePathLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Platform.openFolder(Base.getSettingsFolder());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                clickable.setForeground(new Color(0, 0, 140));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                clickable.setForeground(Color.BLACK);
            }
        });
        JLabel preferenceHintLabel = new JLabel("(" + Language.text("preferences.file.hint") + ")");
        preferenceHintLabel.setForeground(Color.gray);
        this.okButton = new JButton(Language.getPrompt("ok"));
        this.okButton.addActionListener(e -> {
            this.applyFrame();
            this.disposeFrame();
        });
        JButton cancelButton = new JButton(Language.getPrompt("cancel"));
        cancelButton.addActionListener(e -> this.disposeFrame());
        int buttonWidth = Toolkit.getButtonWidth();
        this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGap(Toolkit.BORDER).addGroup(this.layout.createParallelGroup().addComponent(sketchbookLocationLabel).addGroup(this.layout.createSequentialGroup().addComponent(this.sketchbookLocationField).addComponent(browseButton)).addGroup(this.layout.createSequentialGroup().addComponent(languageLabel).addComponent(this.languageSelectionBox, -2, -1, -2).addComponent(languageRestartLabel)).addGroup(this.layout.createSequentialGroup().addComponent(fontLabel).addComponent(this.fontSelectionBox, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, this.layout.createSequentialGroup().addComponent(fontSizeLabel).addComponent(this.fontSizeField, -2, -1, -2).addComponent(consoleFontSizeLabel).addComponent(this.consoleFontSizeField, -2, -1, -2)).addGroup(this.layout.createSequentialGroup().addComponent(zoomLabel).addComponent(this.zoomAutoBox).addComponent(this.zoomSelectionBox, -2, -1, -2).addComponent(zoomRestartLabel)).addComponent(this.hidpiDisableBox).addGroup(this.layout.createSequentialGroup().addComponent(backgroundColorLabel).addComponent(hashLabel, -2, -1, -2).addGap(0).addComponent(this.presentColorHex, -2, -1, -2).addComponent(this.presentColor, -2, -1, -2)).addComponent(this.editorAntialiasBox).addComponent(this.inputMethodBox).addGroup(this.layout.createSequentialGroup().addComponent(this.errorCheckerBox).addComponent(this.warningsCheckerBox)).addComponent(this.warningsCheckerBox).addComponent(this.codeCompletionBox).addComponent(this.importSuggestionsBox).addGroup(this.layout.createSequentialGroup().addComponent(this.memoryOverrideBox).addComponent(this.memoryField, -2, -1, -2).addComponent(mbLabel)).addComponent(this.deletePreviousBox).addComponent(this.checkUpdatesBox).addComponent(this.syncSketchNameBox).addGroup(this.layout.createSequentialGroup().addComponent(displayLabel).addComponent(this.displaySelectionBox, -2, -1, -2)).addComponent(this.autoAssociateBox).addComponent(morePreferenceLabel).addComponent(preferencePathLabel).addComponent(preferenceHintLabel).addGroup(GroupLayout.Alignment.TRAILING, this.layout.createSequentialGroup().addComponent(this.okButton, buttonWidth, -1, buttonWidth).addComponent(cancelButton, buttonWidth, -1, buttonWidth))).addGap(Toolkit.BORDER));
        this.layout.setVerticalGroup(this.layout.createSequentialGroup().addGap(Toolkit.BORDER).addComponent(sketchbookLocationLabel).addGroup(this.layout.createParallelGroup().addComponent(this.sketchbookLocationField).addComponent(browseButton)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(languageLabel).addComponent(this.languageSelectionBox).addComponent(languageRestartLabel)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(fontLabel).addComponent(this.fontSelectionBox)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(fontSizeLabel).addComponent(this.fontSizeField).addComponent(consoleFontSizeLabel).addComponent(this.consoleFontSizeField)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(zoomLabel).addComponent(this.zoomAutoBox).addComponent(this.zoomSelectionBox).addComponent(zoomRestartLabel)).addComponent(this.hidpiDisableBox).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(backgroundColorLabel).addComponent(hashLabel).addComponent(this.presentColorHex).addComponent(this.presentColor)).addComponent(this.editorAntialiasBox).addComponent(this.inputMethodBox).addGroup(this.layout.createParallelGroup().addComponent(this.errorCheckerBox).addComponent(this.warningsCheckerBox)).addComponent(this.codeCompletionBox).addComponent(this.importSuggestionsBox).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.memoryOverrideBox).addComponent(this.memoryField).addComponent(mbLabel)).addComponent(this.deletePreviousBox).addComponent(this.checkUpdatesBox).addComponent(this.syncSketchNameBox).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(displayLabel).addComponent(this.displaySelectionBox)).addComponent(this.autoAssociateBox).addComponent(morePreferenceLabel).addGap(0).addComponent(preferencePathLabel).addGap(0).addComponent(preferenceHintLabel).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.okButton).addComponent(cancelButton)).addGap(Toolkit.BORDER));
        if (Platform.isWindows()) {
            this.autoAssociateBox.setVisible(true);
            this.hidpiDisableBox.setVisible(true);
        }
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PreferencesFrame.this.disposeFrame();
            }
        });
        ActionListener disposer = actionEvent -> this.disposeFrame();
        Toolkit.registerWindowCloseKeys(this.frame.getRootPane(), disposer);
        Toolkit.setIcon(this.frame);
        this.frame.setResizable(false);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        pain.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke wc = Toolkit.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    PreferencesFrame.this.disposeFrame();
                }
            }
        });
    }

    public void sketchbookCallback(File file) {
        if (file != null) {
            this.sketchbookLocationField.setText(file.getAbsolutePath());
        }
    }

    protected void disposeFrame() {
        this.frame.dispose();
    }

    protected void applyFrame() {
        Object selection;
        Preferences.setBoolean("editor.smooth", this.editorAntialiasBox.isSelected());
        Preferences.setBoolean("export.delete_target_folder", this.deletePreviousBox.isSelected());
        String oldPath = Preferences.getSketchbookPath();
        String newPath = this.sketchbookLocationField.getText();
        if (!newPath.equals(oldPath)) {
            this.base.setSketchbookFolder(new File(newPath));
        }
        Preferences.setBoolean("update.check", this.checkUpdatesBox.isSelected());
        Map<String, String> languages = Language.getLanguages();
        String language = "";
        for (Map.Entry<String, String> lang : languages.entrySet()) {
            if (!lang.getValue().equals(String.valueOf(this.languageSelectionBox.getSelectedItem()))) continue;
            language = lang.getKey().trim().toLowerCase();
            break;
        }
        if (!language.equals(Language.getLanguage()) && !language.equals("")) {
            Language.saveLanguage(language);
        }
        if (this.displaySelectionBox.isEnabled()) {
            int oldDisplayNum = Preferences.getInteger("run.display");
            int displayNum = -1;
            for (int d = 0; d < this.displaySelectionBox.getItemCount(); ++d) {
                if (this.displaySelectionBox.getSelectedIndex() != d) continue;
                displayNum = d == this.defaultDisplayNum - 1 ? -1 : d + 1;
            }
            if (displayNum != oldDisplayNum) {
                Preferences.setInteger("run.display", displayNum);
                for (Editor editor : this.base.getEditors()) {
                    editor.setSketchLocation(null);
                }
            }
        }
        Preferences.setBoolean("run.options.memory", this.memoryOverrideBox.isSelected());
        int memoryMin = Preferences.getInteger("run.options.memory.initial");
        int memoryMax = Preferences.getInteger("run.options.memory.maximum");
        try {
            memoryMax = Integer.parseInt(this.memoryField.getText().trim());
            if (memoryMax < memoryMin) {
                memoryMax = memoryMin;
            }
            Preferences.setInteger("run.options.memory.maximum", memoryMax);
        }
        catch (NumberFormatException e) {
            System.err.println("Ignoring bad memory setting");
        }
        if (this.fontSelectionBox.isEnabled()) {
            String fontFamily = (String)this.fontSelectionBox.getSelectedItem();
            if (Toolkit.getMonoFontName().equals(fontFamily)) {
                fontFamily = "processing.mono";
            }
            Preferences.set("editor.font.family", fontFamily);
        }
        try {
            selection = this.fontSizeField.getSelectedItem();
            if (selection instanceof String) {
                selection = Integer.parseInt((String)selection);
            }
            Preferences.set("editor.font.size", String.valueOf(selection));
        }
        catch (NumberFormatException e) {
            Messages.log("Ignoring invalid font size " + this.fontSizeField);
            this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        }
        try {
            selection = this.consoleFontSizeField.getSelectedItem();
            if (selection instanceof String) {
                selection = Integer.parseInt((String)selection);
            }
            Preferences.set("console.font.size", String.valueOf(selection));
        }
        catch (NumberFormatException e) {
            Messages.log("Ignoring invalid font size " + this.consoleFontSizeField);
            this.consoleFontSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        }
        Preferences.setBoolean("editor.zoom.auto", this.zoomAutoBox.isSelected());
        Preferences.set("editor.zoom", String.valueOf(this.zoomSelectionBox.getSelectedItem()));
        if (Platform.isWindows()) {
            Splash.setDisableHiDPI(this.hidpiDisableBox.isSelected());
        }
        Preferences.setBoolean("editor.sync_folder_and_filename", this.syncSketchNameBox.isSelected());
        Preferences.setColor("run.present.bgcolor", this.presentColor.getBackground());
        Preferences.setBoolean("editor.input_method_support", this.inputMethodBox.isSelected());
        if (this.autoAssociateBox != null) {
            Preferences.setBoolean("platform.auto_file_type_associations", this.autoAssociateBox.isSelected());
        }
        Preferences.setBoolean("pdex.errorCheckEnabled", this.errorCheckerBox.isSelected());
        Preferences.setBoolean("pdex.warningsEnabled", this.warningsCheckerBox.isSelected());
        Preferences.setBoolean("pdex.completion", this.codeCompletionBox.isSelected());
        Preferences.setBoolean("pdex.suggest.imports", this.importSuggestionsBox.isSelected());
        for (Editor editor : this.base.getEditors()) {
            editor.applyPreferences();
        }
    }

    public void showFrame() {
        String zoomSel;
        int zoomIndex;
        this.editorAntialiasBox.setSelected(Preferences.getBoolean("editor.smooth"));
        this.inputMethodBox.setSelected(Preferences.getBoolean("editor.input_method_support"));
        this.errorCheckerBox.setSelected(Preferences.getBoolean("pdex.errorCheckEnabled"));
        this.warningsCheckerBox.setSelected(Preferences.getBoolean("pdex.warningsEnabled"));
        this.warningsCheckerBox.setEnabled(this.errorCheckerBox.isSelected());
        this.codeCompletionBox.setSelected(Preferences.getBoolean("pdex.completion"));
        this.importSuggestionsBox.setSelected(Preferences.getBoolean("pdex.suggest.imports"));
        this.deletePreviousBox.setSelected(Preferences.getBoolean("export.delete_target_folder"));
        this.sketchbookLocationField.setText(Preferences.getSketchbookPath());
        this.checkUpdatesBox.setSelected(Preferences.getBoolean("update.check"));
        this.defaultDisplayNum = this.updateDisplayList();
        int displayNum = Preferences.getInteger("run.display");
        if (displayNum < 1 || displayNum > this.displayCount) {
            displayNum = this.defaultDisplayNum;
        }
        this.displaySelectionBox.setSelectedIndex(displayNum - 1);
        new Thread(this::initFontList).start();
        this.fontSizeField.setSelectedItem(Preferences.getInteger("editor.font.size"));
        this.consoleFontSizeField.setSelectedItem(Preferences.getInteger("console.font.size"));
        boolean zoomAuto = Preferences.getBoolean("editor.zoom.auto");
        if (zoomAuto) {
            this.zoomAutoBox.setSelected(true);
            this.zoomSelectionBox.setEnabled(false);
        }
        if ((zoomIndex = Toolkit.zoomOptions.index(zoomSel = Preferences.get("editor.zoom"))) != -1) {
            this.zoomSelectionBox.setSelectedIndex(zoomIndex);
        } else {
            this.zoomSelectionBox.setSelectedIndex(0);
        }
        if (Platform.isWindows()) {
            this.hidpiDisableBox.setSelected(Splash.getDisableHiDPI());
        }
        this.syncSketchNameBox.setSelected(Preferences.getBoolean("editor.sync_folder_and_filename"));
        this.presentColor.setBackground(Preferences.getColor("run.present.bgcolor"));
        this.presentColorHex.setText(Preferences.get("run.present.bgcolor").substring(1));
        this.memoryOverrideBox.setSelected(Preferences.getBoolean("run.options.memory"));
        this.memoryField.setText(Preferences.get("run.options.memory.maximum"));
        this.memoryField.setEnabled(this.memoryOverrideBox.isSelected());
        if (this.autoAssociateBox != null) {
            this.autoAssociateBox.setSelected(Preferences.getBoolean("platform.auto_file_type_associations"));
        }
        this.frame.getRootPane().setDefaultButton(this.okButton);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    void initFontList() {
        if (this.monoFontFamilies == null) {
            this.monoFontFamilies = Toolkit.getMonoFontFamilies();
            EventQueue.invokeLater(() -> {
                this.fontSelectionBox.setModel(new DefaultComboBoxModel<String>(this.monoFontFamilies));
                String family = Preferences.get("editor.font.family");
                String defaultName = Toolkit.getMonoFontName();
                if ("processing.mono".equals(family)) {
                    family = defaultName;
                }
                this.fontSelectionBox.setSelectedItem(defaultName);
                this.fontSelectionBox.setSelectedItem(family);
                this.fontSelectionBox.setEnabled(true);
            });
        }
    }

    int updateDisplayList() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice defaultDevice = ge.getDefaultScreenDevice();
        GraphicsDevice[] devices = ge.getScreenDevices();
        int defaultNum = -1;
        this.displayCount = devices.length;
        String[] items = new String[this.displayCount];
        for (int i = 0; i < this.displayCount; ++i) {
            DisplayMode mode = devices[i].getDisplayMode();
            Object title = String.format("%d (%d \u2715 %d)", i + 1, mode.getWidth(), mode.getHeight());
            if (devices[i] == defaultDevice) {
                title = (String)title + " default";
                defaultNum = i + 1;
            }
            items[i] = title;
        }
        this.displaySelectionBox.setModel(new DefaultComboBoxModel<String>(items));
        this.displaySelectionBox.setEnabled(this.displayCount != 1);
        return defaultNum;
    }
}

