/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import processing.app.Problem;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.syntax.PdeTextArea;
import processing.app.ui.Editor;
import processing.app.ui.Theme;
import processing.core.PApplet;

public class MarkerColumn
extends JPanel {
    protected Editor editor;
    private Color errorColor;
    private Color warningColor;
    private List<LineMarker> errorPoints = new ArrayList<LineMarker>();

    public MarkerColumn(Editor editor, int height) {
        this.editor = editor;
        this.updateTheme();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MarkerColumn.this.scrollToMarkerAt(e.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                MarkerColumn.this.showMarkerHover(e.getY());
            }
        });
    }

    protected void updateTheme() {
        this.errorColor = Theme.getColor("editor.column.error.color");
        this.warningColor = Theme.getColor("editor.column.warning.color");
    }

    @Override
    public void repaint() {
        this.recalculateMarkerPositions();
        super.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        PdeTextArea pta = this.editor.getPdeTextArea();
        if (pta != null) {
            g.drawImage(pta.getGutterGradient(), 0, 0, this.getWidth(), this.getHeight(), this);
        }
        int currentTabIndex = this.editor.getSketch().getCurrentCodeIndex();
        for (LineMarker m : this.errorPoints) {
            Problem problem = m.problem;
            if (problem.getTabIndex() != currentTabIndex) continue;
            if (problem.isError()) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.warningColor);
            }
            g.drawLine(2, m.y, this.getWidth() - 2, m.y);
        }
    }

    public void updateErrorPoints(List<Problem> problems) {
        this.errorPoints = problems.stream().map(LineMarker::new).collect(Collectors.toList());
        this.repaint();
    }

    private void scrollToMarkerAt(int y) {
        try {
            LineMarker m = this.findClosestMarker(y);
            if (m != null) {
                this.editor.highlight(m.problem);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showMarkerHover(int y) {
        try {
            LineMarker m = this.findClosestMarker(y);
            if (m != null) {
                Problem p = m.problem;
                this.editor.statusToolTip(this, p.getMessage(), p.isError());
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void recalculateMarkerPositions() {
        if (this.errorPoints != null && this.errorPoints.size() > 0) {
            Sketch sketch = this.editor.getSketch();
            SketchCode code = sketch.getCurrentCode();
            int currentTab = sketch.getCurrentCodeIndex();
            int totalLines = PApplet.max((int)1, (int)code.getLineCount());
            int visibleLines = this.editor.getTextArea().getVisibleLines();
            totalLines = PApplet.max((int)totalLines, (int)visibleLines);
            int topMargin = 20;
            int bottomMargin = 40;
            int height = this.getHeight() - topMargin - bottomMargin;
            for (LineMarker m : this.errorPoints) {
                Problem problem = m.problem;
                if (problem.getTabIndex() != currentTab) continue;
                float ratio = (float)(problem.getLineNumber() + 1) / (float)totalLines;
                float y = (float)topMargin + ratio * (float)height;
                m.y = (int)y;
            }
        }
    }

    private LineMarker findClosestMarker(int y) {
        LineMarker closest = null;
        int closestDist = Integer.MAX_VALUE;
        for (LineMarker m : this.errorPoints) {
            int dist = Math.abs(y - m.y);
            if (dist >= 3 || dist >= closestDist) continue;
            closest = m;
            closestDist = dist;
        }
        return closest;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Editor.RIGHT_GUTTER, super.getPreferredSize().height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(Editor.RIGHT_GUTTER, super.getMinimumSize().height);
    }

    private static class LineMarker {
        int y;
        final Problem problem;

        LineMarker(Problem problem) {
            this.problem = problem;
        }
    }
}

