/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import processing.app.Base;
import processing.app.Language;
import processing.app.Library;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.SketchReference;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ExamplesContribution;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;
import processing.app.ui.ZoomTreeCellRenderer;
import processing.core.PApplet;
import processing.data.StringDict;

public class ExamplesFrame
extends JFrame {
    protected Base base;
    protected Mode mode;
    protected File examplesContribFolder;

    public ExamplesFrame(final Base base, final Mode mode) {
        super(Language.interpolate("examples.title", mode.getTitle()));
        this.base = base;
        this.mode = mode;
        this.examplesContribFolder = Base.getSketchbookExamplesFolder();
        Toolkit.setIcon(this);
        Toolkit.registerWindowCloseKeys(this.getRootPane(), e -> this.setVisible(false));
        JPanel examplesPanel = new JPanel();
        examplesPanel.setLayout(new BorderLayout());
        examplesPanel.setBackground(Color.WHITE);
        final JTree tree = new JTree(this.buildTree());
        tree.setOpaque(true);
        tree.setAlignmentX(0.0f);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setShowsRootHandles(true);
        tree.expandRow(0);
        tree.setRootVisible(false);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                    int selRow = tree.getRowForLocation(e.getX(), e.getY());
                    if (node != null && node.isLeaf() && selRow != -1) {
                        SketchReference sketch = (SketchReference)node.getUserObject();
                        base.handleOpen(sketch.getPath(), mode);
                    }
                }
            }
        });
        tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ExamplesFrame.this.setVisible(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                DefaultMutableTreeNode node;
                if (e.getKeyChar() == '\n' && (node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent()) != null && node.isLeaf()) {
                    SketchReference sketch = (SketchReference)node.getUserObject();
                    base.handleOpen(sketch.getPath(), mode);
                }
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                ExamplesFrame.this.updateExpanded(tree);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                ExamplesFrame.this.updateExpanded(tree);
            }
        });
        tree.setBorder(new EmptyBorder(0, 5, 5, 5));
        tree.setToggleClickCount(Platform.isMacOS() ? 2 : 1);
        tree.setCellRenderer(new ZoomTreeCellRenderer());
        JScrollPane treePane = new JScrollPane(tree);
        treePane.setPreferredSize(Toolkit.zoom(250, 300));
        treePane.setBorder(new EmptyBorder(Toolkit.zoom(2), 0, 0, 0));
        treePane.setOpaque(true);
        treePane.setBackground(Color.WHITE);
        treePane.setAlignmentX(0.0f);
        examplesPanel.add((Component)treePane, "Center");
        Box buttons = Box.createHorizontalBox();
        JButton addButton = new JButton(Language.text("examples.add_examples"));
        addButton.addActionListener(e -> ContributionManager.openExamples());
        buttons.add(Box.createHorizontalGlue());
        buttons.add(addButton);
        buttons.add(Box.createHorizontalGlue());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(buttons);
        examplesPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(examplesPanel);
        this.pack();
        this.restoreExpanded(tree);
    }

    public void setVisible() {
        int roughWidth = this.getWidth() + 20;
        Editor editor = this.base.getActiveEditor();
        if (editor == null) {
            this.setLocationRelativeTo(null);
        } else {
            Point p = editor.getLocation();
            if (p.x < roughWidth) {
                this.setLocationRelativeTo(null);
            } else {
                this.setLocation(p.x - roughWidth, p.y);
            }
        }
        this.setVisible(true);
    }

    protected void updateExpanded(JTree tree) {
        Enumeration<TreePath> en = tree.getExpandedDescendants(new TreePath(tree.getModel().getRoot()));
        StringBuilder s = new StringBuilder();
        while (en.hasMoreElements()) {
            Object[] path;
            TreePath tp = en.nextElement();
            for (Object o : path = tp.getPath()) {
                DefaultMutableTreeNode p = (DefaultMutableTreeNode)o;
                String name = (String)p.getUserObject();
                s.append(name);
                s.append(File.separatorChar);
            }
            s.setCharAt(s.length() - 1, File.pathSeparatorChar);
        }
        s.setLength(s.length() - 1);
        String pref = "examples." + this.getClass().getName() + ".visible";
        Preferences.set(pref, s.toString());
        Preferences.save();
    }

    protected void restoreExpanded(JTree tree) {
        String pref = "examples." + this.getClass().getName() + ".visible";
        String value = Preferences.get(pref);
        if (value != null) {
            String[] paths;
            for (String path : paths = PApplet.split((String)value, (String)File.pathSeparator)) {
                String[] items = PApplet.split((String)path, (String)File.separator);
                DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[items.length];
                this.expandTree(tree, null, items, nodes, 0);
            }
        }
    }

    void expandTree(JTree tree, Object object, String[] items, DefaultMutableTreeNode[] nodes, int index) {
        TreeModel model = tree.getModel();
        if (index == 0) {
            nodes[0] = (DefaultMutableTreeNode)model.getRoot();
            this.expandTree(tree, nodes[0], items, nodes, 1);
        } else if (index < items.length) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
            int count = model.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)model.getChild(node, i);
                if (!items[index].equals(child.getUserObject())) continue;
                nodes[index] = child;
                this.expandTree(tree, child, items, nodes, index + 1);
            }
        } else {
            tree.expandPath(new TreePath(nodes));
        }
    }

    protected DefaultMutableTreeNode buildTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        try {
            File[] examples;
            for (File subFolder : examples = this.mode.getExampleCategoryFolders()) {
                DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(subFolder.getName());
                if (!this.base.addSketches(subNode, subFolder, true)) continue;
                root.add(subNode);
            }
            DefaultMutableTreeNode foundationLibraries = new DefaultMutableTreeNode(Language.text("examples.core_libraries"));
            for (Library lib : this.mode.coreLibraries) {
                DefaultMutableTreeNode libNode;
                if (!lib.hasExamples() || !this.base.addSketches(libNode = new DefaultMutableTreeNode(lib.getName()), lib.getExamplesFolder(), true)) continue;
                foundationLibraries.add(libNode);
            }
            if (foundationLibraries.getChildCount() > 0) {
                root.add(foundationLibraries);
            }
            DefaultMutableTreeNode contributedLibExamples = new DefaultMutableTreeNode(Language.text("examples.libraries"));
            for (Library lib : this.mode.contribLibraries) {
                if (!lib.hasExamples()) continue;
                DefaultMutableTreeNode libNode = new DefaultMutableTreeNode(lib.getName());
                this.base.addSketches(libNode, lib.getExamplesFolder(), true);
                contributedLibExamples.add(libNode);
            }
            if (contributedLibExamples.getChildCount() > 0) {
                root.add(contributedLibExamples);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DefaultMutableTreeNode contributedExamplesNode = this.buildContribTree();
        if (contributedExamplesNode.getChildCount() > 0) {
            root.add(contributedExamplesNode);
        }
        return root;
    }

    protected DefaultMutableTreeNode buildContribTree() {
        DefaultMutableTreeNode contribExamplesNode = new DefaultMutableTreeNode(Language.text("examples.contributed"));
        try {
            File[] folders = ContributionType.EXAMPLES.listCandidates(this.examplesContribFolder);
            if (folders != null) {
                for (File sub : folders) {
                    DefaultMutableTreeNode subNode;
                    StringDict props = Contribution.loadProperties(sub, ContributionType.EXAMPLES);
                    if (props == null || !ExamplesContribution.isCompatible(this.base, props) || !this.base.addSketches(subNode = new DefaultMutableTreeNode(props.get("name")), sub, true)) continue;
                    contribExamplesNode.add(subNode);
                    int exampleNodeNumber = -1;
                    for (int i = 0; i < subNode.getChildCount(); ++i) {
                        if (!subNode.getChildAt(i).toString().equals("examples")) continue;
                        exampleNodeNumber = i;
                    }
                    if (exampleNodeNumber == -1) continue;
                    TreeNode exampleNode = subNode.getChildAt(exampleNodeNumber);
                    subNode.remove(exampleNodeNumber);
                    int count = exampleNode.getChildCount();
                    for (int j = 0; j < count; ++j) {
                        subNode.add((DefaultMutableTreeNode)exampleNode.getChildAt(0));
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contribExamplesNode;
    }
}

