/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.ui.Editor;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class EditorStatus
extends BasicSplitPaneDivider {
    static final int HIGH = Toolkit.zoom(28);
    static final int LEFT_MARGIN = Editor.LEFT_GUTTER;
    static final int RIGHT_MARGIN = Toolkit.zoom(20);
    Color urlColor;
    Color[] fgColor;
    Color[] bgColor;
    Image[] bgImage;
    static final boolean USE_IMAGES = false;
    public static final int ERROR = 1;
    public static final int CURSOR_LINE_ERROR = 2;
    public static final int WARNING = 3;
    public static final int CURSOR_LINE_WARNING = 4;
    public static final int NOTICE = 0;
    static final int YES = 1;
    static final int NO = 2;
    static final int CANCEL = 3;
    static final int OK = 4;
    Editor editor;
    int mode;
    String message = "";
    String url;
    int rightEdge;
    int mouseX;
    static final int ROLLOVER_NONE = 0;
    static final int ROLLOVER_URL = 1;
    static final int ROLLOVER_COLLAPSE = 2;
    static final int ROLLOVER_CLIPBOARD = 3;
    int rolloverState;
    Font font;
    FontMetrics metrics;
    int ascent;
    static final String CLIPBOARD_GLYPH = "\u2398";
    static final String COLLAPSE_GLYPH = "\u25c1";
    static final String EXPAND_GLYPH = "\u25b7";
    Font glyphFont;
    int sizeW;
    int sizeH;
    int buttonSize;
    boolean collapsed = false;
    int response;
    boolean indeterminate;
    Thread thread;

    public EditorStatus(BasicSplitPaneUI ui, Editor editor) {
        super(ui);
        this.editor = editor;
        this.empty();
        this.updateTheme();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                EditorStatus.this.updateMouse();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (EditorStatus.this.rolloverState == 1) {
                    Platform.openURL(EditorStatus.this.url);
                } else if (EditorStatus.this.rolloverState == 3) {
                    if (e.isShiftDown()) {
                        String fmt = Preferences.get("search.format");
                        Platform.openURL(String.format(fmt, PApplet.urlEncode((String)EditorStatus.this.message)));
                    } else {
                        Clipboard clipboard = EditorStatus.this.getToolkit().getSystemClipboard();
                        clipboard.setContents(new StringSelection(EditorStatus.this.message), null);
                        System.out.println("Copied to the clipboard. Use shift-click to search the web instead.");
                    }
                } else if (EditorStatus.this.rolloverState == 2) {
                    EditorStatus.this.setCollapsed(!EditorStatus.this.collapsed);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                EditorStatus.this.mouseX = -100;
                EditorStatus.this.updateMouse();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                EditorStatus.this.setCollapsed(false);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                EditorStatus.this.mouseX = e.getX();
                EditorStatus.this.updateMouse();
            }
        });
    }

    void setCollapsed(boolean newState) {
        if (this.collapsed != newState) {
            this.collapsed = newState;
            this.editor.footer.setVisible(!newState);
            this.splitPane.resetToPreferredSizes();
        }
    }

    void updateMouse() {
        switch (this.rolloverState) {
            case 1: 
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 2: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
            case 0: {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }
        this.repaint();
    }

    static String findURL(String message) {
        String[] m = PApplet.match((String)message, (String)"http\\S+");
        if (m != null) {
            return m[0];
        }
        return null;
    }

    protected void updateTheme() {
        this.urlColor = Theme.getColor("status.url.fgcolor");
        this.fgColor = new Color[]{Theme.getColor("status.notice.fgcolor"), Theme.getColor("status.error.fgcolor"), Theme.getColor("status.error.fgcolor"), Theme.getColor("status.warning.fgcolor"), Theme.getColor("status.warning.fgcolor")};
        this.bgColor = new Color[]{Theme.getColor("status.notice.bgcolor"), Theme.getColor("status.error.bgcolor"), Theme.getColor("status.error.bgcolor"), Theme.getColor("status.warning.bgcolor"), Theme.getColor("status.warning.bgcolor")};
        Mode mode = this.editor.getMode();
        this.bgImage = new Image[]{mode.loadImage("/lib/status/notice.png"), mode.loadImage("/lib/status/error.png"), mode.loadImage("/lib/status/error.png"), mode.loadImage("/lib/status/warning.png"), mode.loadImage("/lib/status/warning.png")};
        this.font = Theme.getFont("status.font");
        this.glyphFont = Theme.getFont("status.emoji.font");
        this.metrics = null;
    }

    public void empty() {
        this.mode = 0;
        this.message = "";
        this.url = null;
        this.repaint();
    }

    public void message(String message, int mode) {
        this.message = message;
        this.mode = mode;
        this.url = EditorStatus.findURL(message);
        this.repaint();
    }

    public void notice(String message) {
        this.message(message, 0);
    }

    public void warning(String message) {
        this.message(message, 3);
    }

    public void error(String message) {
        this.message(message, 1);
    }

    public void startIndeterminate() {
        this.indeterminate = true;
        this.thread = new Thread(){

            @Override
            public void run() {
                while (Thread.currentThread() == EditorStatus.this.thread) {
                    EditorStatus.this.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.thread.setName("Editor Status");
        this.thread.start();
    }

    public void stopIndeterminate() {
        this.indeterminate = false;
        this.thread = null;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Toolkit.prepareGraphics(g);
        this.sizeW = this.getWidth();
        this.buttonSize = this.sizeH = this.getHeight();
        g.setFont(this.font);
        if (this.metrics == null) {
            this.metrics = g.getFontMetrics();
            this.ascent = this.metrics.getAscent();
        }
        g.setColor(this.bgColor[this.mode]);
        g.fillRect(0, 0, this.sizeW, this.sizeH);
        this.rolloverState = 0;
        if (this.mouseX > this.sizeW - this.buttonSize && this.mouseX < this.sizeW) {
            this.rolloverState = 2;
        } else if (this.message != null && !this.message.isEmpty()) {
            if (this.sizeW - 2 * this.buttonSize < this.mouseX) {
                this.rolloverState = 3;
            } else if (this.url != null && this.mouseX > LEFT_MARGIN && this.mouseX < LEFT_MARGIN + g.getFontMetrics().stringWidth(this.message)) {
                this.rolloverState = 1;
            }
        }
        if (this.message != null) {
            g.setFont(this.font);
            g.setColor(this.rolloverState == 1 ? this.urlColor : this.fgColor[this.mode]);
            g.drawString(this.message, LEFT_MARGIN, (this.sizeH + this.ascent) / 2);
        }
        if (this.indeterminate) {
            int w = Toolkit.getButtonWidth();
            int x = this.getWidth() - Math.max(RIGHT_MARGIN, (int)((double)this.buttonSize * 1.2)) - w;
            int y = this.sizeH / 3;
            int h = this.sizeH / 3;
            g.setColor(new Color(Integer.MIN_VALUE, true));
            g.drawRect(x, y, w, h);
            for (int i = 0; i < 10; ++i) {
                int r = (int)((double)x + Math.random() * (double)w);
                g.drawLine(r, y, r, y + h);
            }
        } else if (!this.message.isEmpty()) {
            g.setFont(this.glyphFont);
            this.drawButton(g, CLIPBOARD_GLYPH, 1, this.rolloverState == 3);
            g.setFont(this.font);
        }
        String collapseGlyph = this.collapsed ? EXPAND_GLYPH : COLLAPSE_GLYPH;
        this.drawButton(g, collapseGlyph, 0, this.rolloverState == 2);
    }

    private void drawButton(Graphics g, String symbol, int pos, boolean highlight) {
        int left = this.sizeW - (pos + 1) * this.buttonSize;
        g.setColor(this.bgColor[this.mode]);
        g.fillRect(left, 0, this.buttonSize, this.sizeH);
        if (highlight) {
            g.setColor(this.urlColor);
        } else {
            g.setColor(this.fgColor[this.mode]);
        }
        g.drawString(symbol, left + (this.buttonSize - g.getFontMetrics().stringWidth(symbol)) / 2, (this.sizeH + this.ascent) / 2);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(Toolkit.zoom(300), HIGH);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, HIGH);
    }
}

