/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import processing.app.Console;
import processing.app.Preferences;
import processing.app.ui.BufferedStyledDocument;
import processing.app.ui.Editor;
import processing.app.ui.Theme;

public class EditorConsole
extends JScrollPane {
    static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    Editor editor;
    JTextPane consoleTextPane;
    BufferedStyledDocument consoleDoc;
    MutableAttributeSet stdStyle;
    MutableAttributeSet errStyle;
    int maxLineCount;
    int maxCharCount;
    PrintStream sketchOut;
    PrintStream sketchErr;
    static EditorConsole current;
    Timer flushTimer;

    public EditorConsole(Editor editor) {
        this.editor = editor;
        this.maxLineCount = Preferences.getInteger("console.scrollback.lines");
        this.maxCharCount = Preferences.getInteger("console.scrollback.chars");
        this.consoleDoc = new BufferedStyledDocument(10000, this.maxLineCount, this.maxCharCount);
        this.consoleTextPane = new JTextPane(this.consoleDoc);
        this.consoleTextPane.setEditable(false);
        this.updateTheme();
        this.setViewportView(this.consoleTextPane);
        this.sketchOut = new PrintStream(new EditorConsoleStream(false));
        this.sketchErr = new PrintStream(new EditorConsoleStream(true));
        this.startTimer();
    }

    protected void flush() {
        if (this.consoleDoc.insertQueued()) {
            this.consoleTextPane.setCaretPosition(this.consoleDoc.getLength());
        }
    }

    protected void startTimer() {
        if (this.flushTimer == null) {
            this.flushTimer = new Timer(250, evt -> this.flush());
            this.flushTimer.start();
        }
    }

    protected void stopTimer() {
        if (this.flushTimer != null) {
            this.flush();
            this.flushTimer.stop();
            this.flushTimer = null;
        }
    }

    public PrintStream getOut() {
        return this.sketchOut;
    }

    public PrintStream getErr() {
        return this.sketchErr;
    }

    protected void updateTheme() {
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 0);
        this.consoleDoc.setParagraphAttributes(0, 0, standard, true);
        Color bgColor = Theme.getColor("console.color");
        Color fgColorOut = Theme.getColor("console.output.color");
        Color fgColorErr = Theme.getColor("console.error.color");
        this.setBorder(new MatteBorder(0, Editor.LEFT_GUTTER, 0, 0, bgColor));
        Font font = Preferences.getFont("editor.font.family", "console.font.size", 0);
        this.stdStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.stdStyle, fgColorOut);
        StyleConstants.setFontSize(this.stdStyle, font.getSize());
        StyleConstants.setFontFamily(this.stdStyle, font.getFamily());
        StyleConstants.setBold(this.stdStyle, font.isBold());
        StyleConstants.setItalic(this.stdStyle, font.isItalic());
        this.errStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errStyle, fgColorErr);
        StyleConstants.setFontSize(this.errStyle, font.getSize());
        StyleConstants.setFontFamily(this.errStyle, font.getFamily());
        StyleConstants.setBold(this.errStyle, font.isBold());
        StyleConstants.setItalic(this.errStyle, font.isItalic());
        String lookAndFeel = UIManager.getLookAndFeel().getID();
        if (lookAndFeel.equals("Nimbus")) {
            this.getViewport().setBackground(bgColor);
            this.consoleTextPane.setOpaque(false);
            this.consoleTextPane.setBackground(TRANSPARENT);
        } else {
            this.consoleTextPane.setBackground(bgColor);
        }
        FontMetrics metrics = this.getFontMetrics(font);
        int height = metrics.getAscent() + metrics.getDescent();
        int lines = Preferences.getInteger("console.lines");
        int sizeFudge = 6;
        this.setPreferredSize(new Dimension(1024, height * lines + sizeFudge));
        this.setMinimumSize(new Dimension(1024, height * 4 + sizeFudge));
    }

    public static void setEditor(Editor editor) {
        if (current != null) {
            current.stopTimer();
        }
        editor.console.setCurrent();
    }

    void setCurrent() {
        current = this;
        this.startTimer();
        Console.setEditor(this.sketchOut, this.sketchErr);
    }

    private boolean suppressMessage(String what, boolean err) {
        if (err) {
            if (what.contains("invalid context 0x0") || what.contains("invalid drawable")) {
                return true;
            }
            if (what.contains("is calling TIS/TSM in non-main thread environment")) {
                return true;
            }
            if (what.contains("NSWindow drag regions should only be invalidated on the Main Thread")) {
                return true;
            }
            if (what.contains("Make pbuffer:")) {
                return true;
            }
            if (what.contains("XInitThreads() called for concurrent")) {
                return true;
            }
            if (what.contains("accessibilityHitTest")) {
                return true;
            }
        } else if (what.contains("Listening for transport dt_socket at address")) {
            return true;
        }
        return false;
    }

    public void message(String what, boolean err) {
        if (!this.suppressMessage(what, err)) {
            this.consoleDoc.appendString(what, err ? this.errStyle : this.stdStyle);
        }
    }

    public void clear() {
        try {
            this.consoleDoc.remove(0, this.consoleDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    class EditorConsoleStream
    extends OutputStream {
        boolean err;

        public EditorConsoleStream(boolean err) {
            this.err = err;
        }

        @Override
        public void write(byte[] b, int offset, int length) {
            EditorConsole.this.message(new String(b, offset, length), this.err);
        }

        @Override
        public void write(int b) {
            this.write(new byte[]{(byte)b}, 0, 1);
        }
    }
}

