/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import processing.app.Mode;
import processing.app.ui.EditorToolbar;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public abstract class EditorButton
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener {
    public static final int DIM = Toolkit.zoom(30);
    protected String name;
    protected String title;
    protected String titleShift;
    protected String titleAlt;
    protected boolean pressed;
    protected boolean selected;
    protected boolean rollover;
    protected boolean shift;
    protected Image enabledImage;
    protected Image disabledImage;
    protected Image selectedImage;
    protected Image rolloverImage;
    protected Image pressedImage;
    protected Image gradient;
    protected EditorToolbar toolbar;

    public EditorButton(EditorToolbar parent, String name, String title) {
        this(parent, name, title, title, title);
    }

    public EditorButton(EditorToolbar parent, String name, String title, String titleShift) {
        this(parent, name, title, titleShift, title);
    }

    public EditorButton(EditorToolbar parent, String name, String title, String titleShift, String titleAlt) {
        this.name = name;
        this.toolbar = parent;
        this.title = title;
        this.titleShift = titleShift;
        this.titleAlt = titleAlt;
        this.updateTheme();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected Image renderImage(String state) {
        Mode mode = this.toolbar.mode;
        String xmlOrig = mode.loadString(this.name + ".svg");
        if (xmlOrig == null) {
            return mode.loadImageX(this.name + "-" + state);
        }
        String FIELD_COLOR = "#fff";
        String GLYPH_COLOR = "#ff5757";
        String STROKE_COLOR = "silver";
        String field = Theme.get("toolbar.button." + state + ".field");
        String glyph = Theme.get("toolbar.button." + state + ".glyph");
        String stroke = Theme.get("toolbar.button." + state + ".stroke");
        String xmlStr = xmlOrig.replace("#fff", field).replace("#ff5757", glyph).replace("silver", stroke);
        int px = DIM * Toolkit.highResMultiplier();
        return Toolkit.svgToImage(xmlStr, px, px);
    }

    public void updateTheme() {
        this.disabledImage = this.renderImage("disabled");
        this.enabledImage = this.renderImage("enabled");
        this.selectedImage = this.renderImage("selected");
        this.pressedImage = this.renderImage("pressed");
        this.rolloverImage = this.renderImage("rollover");
        if (this.disabledImage == null) {
            this.disabledImage = this.enabledImage;
        }
        if (this.selectedImage == null) {
            this.selectedImage = this.enabledImage;
        }
        if (this.pressedImage == null) {
            this.pressedImage = this.enabledImage;
        }
        if (this.rolloverImage == null) {
            this.rolloverImage = this.enabledImage;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Image image = this.enabledImage;
        if (!this.isEnabled()) {
            image = this.disabledImage;
        } else if (this.selected) {
            image = this.selectedImage;
        } else if (this.pressed) {
            image = this.pressedImage;
        } else if (this.rollover) {
            image = this.rolloverImage;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int dim = this.getSize().width;
        if (this.gradient != null) {
            g.drawImage(this.gradient, 0, 0, dim, dim, this);
        }
        g.drawImage(image, 0, 0, dim, dim, this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public boolean isShiftDown() {
        return this.shift;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setPressed(true);
        this.shift = e.isShiftDown();
        this.actionPerformed(new ActionEvent(this, 1001, null, e.getModifiers()));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setPressed(false);
    }

    public void setPressed(boolean pressed) {
        if (this.isEnabled()) {
            this.pressed = pressed;
            this.repaint();
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getRolloverText(InputEvent e) {
        if (e.isShiftDown()) {
            return this.titleShift;
        }
        if (e.isAltDown()) {
            return this.titleAlt;
        }
        return this.title;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.toolbar.setRollover(this, e);
        this.rollover = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.toolbar.setRollover(null, e);
        this.rollover = false;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(DIM, DIM);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

