/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import processing.app.Language;
import processing.app.Platform;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class ColorChooser {
    int hue;
    int saturation;
    int brightness;
    int red;
    int green;
    int blue;
    ColorRange range;
    ColorSlider slider;
    JTextField hueField;
    JTextField saturationField;
    JTextField brightnessField;
    JTextField redField;
    JTextField greenField;
    JTextField blueField;
    JTextField hexField;
    JPanel colorPanel;
    DocumentListener colorListener;
    JDialog window;
    int labelH;

    public ColorChooser(Frame owner, boolean modal, Color initialColor, String buttonName, ActionListener buttonListener) {
        this.window = new JDialog(owner, Language.text("color_chooser"), modal);
        this.window.getContentPane().setLayout(new BorderLayout());
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.range = new ColorRange();
        Box rangeBox = new Box(1);
        rangeBox.setAlignmentY(0.0f);
        rangeBox.setBorder(BorderFactory.createBevelBorder(1));
        rangeBox.add(this.range);
        box.add(rangeBox);
        box.add(Box.createHorizontalStrut(10));
        this.slider = new ColorSlider();
        Box sliderBox = new Box(1);
        sliderBox.setAlignmentY(0.0f);
        sliderBox.setBorder(BorderFactory.createBevelBorder(1));
        sliderBox.add(this.slider);
        box.add(sliderBox);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.createColorFields(buttonName, buttonListener));
        box.add(Box.createHorizontalStrut(10));
        this.window.getContentPane().add((Component)box, "Center");
        this.window.pack();
        this.window.setResizable(false);
        this.window.setLocationRelativeTo(null);
        this.window.setDefaultCloseOperation(0);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ColorChooser.this.hide();
            }
        });
        Toolkit.registerWindowCloseKeys(this.window.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooser.this.hide();
            }
        });
        Toolkit.setIcon(this.window);
        this.colorListener = new ColorListener();
        this.hueField.getDocument().addDocumentListener(this.colorListener);
        this.saturationField.getDocument().addDocumentListener(this.colorListener);
        this.brightnessField.getDocument().addDocumentListener(this.colorListener);
        this.redField.getDocument().addDocumentListener(this.colorListener);
        this.greenField.getDocument().addDocumentListener(this.colorListener);
        this.blueField.getDocument().addDocumentListener(this.colorListener);
        this.hexField.getDocument().addDocumentListener(this.colorListener);
        this.setColor(initialColor);
    }

    public void show() {
        this.window.setVisible(true);
    }

    public void hide() {
        this.window.setVisible(false);
    }

    public Color getColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public void setColor(Color color) {
        this.updateRGB(color.getRGB());
    }

    public String getHexColor() {
        return "#" + PApplet.hex((int)this.red, (int)2) + PApplet.hex((int)this.green, (int)2) + PApplet.hex((int)this.blue, (int)2);
    }

    protected void updateRGB() {
        this.updateRGB(Color.HSBtoRGB((float)this.hue / 359.0f, (float)this.saturation / 99.0f, (float)this.brightness / 99.0f));
    }

    protected void updateRGB(int rgb) {
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.redField.setText(String.valueOf(this.red));
        this.greenField.setText(String.valueOf(this.green));
        this.blueField.setText(String.valueOf(this.blue));
    }

    protected void updateHSB() {
        float[] hsb = new float[3];
        Color.RGBtoHSB(this.red, this.green, this.blue, hsb);
        this.hue = (int)(hsb[0] * 359.0f);
        this.saturation = (int)(hsb[1] * 99.0f);
        this.brightness = (int)(hsb[2] * 99.0f);
        this.hueField.setText(String.valueOf(this.hue));
        this.saturationField.setText(String.valueOf(this.saturation));
        this.brightnessField.setText(String.valueOf(this.brightness));
    }

    protected void updateHex() {
        this.hexField.setText(this.getHexColor());
    }

    protected int bounded(int current, final JTextField field, final int max) {
        String text = field.getText();
        if (text.length() == 0) {
            return 0;
        }
        try {
            int value = Integer.parseInt(text);
            if (value > max) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        field.setText(String.valueOf(max));
                    }
                });
                return max;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return current;
        }
    }

    protected Container createColorFields(String buttonName, ActionListener buttonListener) {
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        int GAP = Platform.isWindows() ? 5 : 0;
        int BETWEEN = Platform.isWindows() ? 8 : 6;
        Box row = Box.createHorizontalBox();
        if (Platform.isMacOS()) {
            row.add(Box.createHorizontalStrut(17));
        } else {
            row.add(this.createFixedLabel(""));
        }
        this.colorPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(new Color(ColorChooser.this.red, ColorChooser.this.green, ColorChooser.this.blue));
                Dimension size = this.getSize();
                g.fillRect(0, 0, size.width, size.height);
            }
        };
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(1));
        Dimension dim = new Dimension(70, 25);
        this.colorPanel.setMinimumSize(dim);
        this.colorPanel.setMaximumSize(dim);
        this.colorPanel.setPreferredSize(dim);
        row.add(this.colorPanel);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(BETWEEN));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("H"));
        this.hueField = new NumberField(4, false);
        row.add(this.hueField);
        row.add(new JLabel(" \u00b0"));
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(GAP));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("S"));
        this.saturationField = new NumberField(4, false);
        row.add(this.saturationField);
        row.add(new JLabel(" %"));
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(GAP));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("B"));
        this.brightnessField = new NumberField(4, false);
        row.add(this.brightnessField);
        row.add(new JLabel(" %"));
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(BETWEEN));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("R"));
        this.redField = new NumberField(4, false);
        row.add(this.redField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(GAP));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("G"));
        this.greenField = new NumberField(4, false);
        row.add(this.greenField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(GAP));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("B"));
        this.blueField = new NumberField(4, false);
        row.add(this.blueField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(BETWEEN));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel(""));
        int hexCount = Platform.isWindows() ? 7 : 6;
        this.hexField = new NumberField(hexCount, true);
        row.add(this.hexField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(GAP));
        row = Box.createHorizontalBox();
        if (Platform.isMacOS()) {
            row.add(Box.createHorizontalStrut(11));
        } else {
            row.add(this.createFixedLabel(""));
        }
        JButton button = new JButton(buttonName);
        button.addActionListener(buttonListener);
        row.add(button);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        row = Box.createHorizontalBox();
        if (Platform.isMacOS()) {
            row.add(Box.createHorizontalStrut(11));
        } else {
            row.add(this.createFixedLabel(""));
        }
        button = new JButton(Language.text("prompt.cancel"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooser.this.hide();
            }
        });
        row.add(button);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalGlue());
        return box;
    }

    protected JLabel createFixedLabel(String title) {
        JLabel label = new JLabel(title);
        if (this.labelH == 0) {
            this.labelH = label.getPreferredSize().height;
        }
        Dimension dim = new Dimension(15, this.labelH);
        label.setPreferredSize(dim);
        label.setMinimumSize(dim);
        label.setMaximumSize(dim);
        return label;
    }

    public class ColorRange
    extends JComponent {
        static final int WIDE = 256;
        static final int HIGH = 256;
        private int lastX;
        private int lastY;

        public ColorRange() {
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ColorRange.this.updateMouse(e);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    ColorRange.this.updateMouse(e);
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    super.keyPressed(e);
                    if (e.getKeyCode() == 27) {
                        ColorChooser.this.hide();
                    }
                }
            });
        }

        private void updateMouse(MouseEvent e) {
            int mouseX = e.getX();
            int mouseY = e.getY();
            if (mouseX >= 0 && mouseX < 256 && mouseY >= 0 && mouseY < 256) {
                int nsaturation = (int)(100.0f * ((float)mouseX / 255.0f));
                int nbrightness = 100 - (int)(100.0f * ((float)mouseY / 255.0f));
                ColorChooser.this.saturationField.setText(String.valueOf(nsaturation));
                ColorChooser.this.brightnessField.setText(String.valueOf(nbrightness));
                this.lastX = mouseX;
                this.lastY = mouseY;
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            for (int j = 0; j < 256; ++j) {
                for (int i = 0; i < 256; ++i) {
                    g.setColor(Color.getHSBColor((float)ColorChooser.this.hue / 360.0f, (float)i / 256.0f, (float)(255 - j) / 256.0f));
                    g.fillRect(i, j, 1, 1);
                }
            }
            g.setColor(ColorChooser.this.brightness > 50 ? Color.BLACK : Color.WHITE);
            g.drawRect(this.lastX - 5, this.lastY - 5, 10, 10);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(256, 256);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    public class ColorSlider
    extends JComponent {
        static final int WIDE = 20;
        static final int HIGH = 256;

        public ColorSlider() {
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ColorSlider.this.updateMouse(e);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    ColorSlider.this.updateMouse(e);
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    super.keyPressed(e);
                    if (e.getKeyCode() == 27) {
                        ColorChooser.this.hide();
                    }
                }
            });
        }

        private void updateMouse(MouseEvent e) {
            int mouseX = e.getX();
            int mouseY = e.getY();
            if (mouseX >= 0 && mouseX < 20 && mouseY >= 0 && mouseY < 256) {
                int nhue = 359 - (int)(359.0f * ((float)mouseY / 255.0f));
                ColorChooser.this.hueField.setText(String.valueOf(nhue));
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int sel = 255 - (int)(255.0 * ((double)ColorChooser.this.hue / 359.0));
            for (int j = 0; j < 256; ++j) {
                Color color = Color.getHSBColor((float)(255 - j) / 256.0f, 1.0f, 1.0f);
                if (j == sel) {
                    color = Color.BLACK;
                }
                g.setColor(color);
                g.drawRect(0, j, 20, 1);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(20, 256);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    public class ColorListener
    implements DocumentListener {
        boolean updating;

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (this.updating) {
                return;
            }
            this.updating = true;
            Document doc = e.getDocument();
            if (doc == ColorChooser.this.hueField.getDocument()) {
                ColorChooser.this.hue = ColorChooser.this.bounded(ColorChooser.this.hue, ColorChooser.this.hueField, 359);
                ColorChooser.this.updateRGB();
                ColorChooser.this.updateHex();
            } else if (doc == ColorChooser.this.saturationField.getDocument()) {
                ColorChooser.this.saturation = ColorChooser.this.bounded(ColorChooser.this.saturation, ColorChooser.this.saturationField, 99);
                ColorChooser.this.updateRGB();
                ColorChooser.this.updateHex();
            } else if (doc == ColorChooser.this.brightnessField.getDocument()) {
                ColorChooser.this.brightness = ColorChooser.this.bounded(ColorChooser.this.brightness, ColorChooser.this.brightnessField, 99);
                ColorChooser.this.updateRGB();
                ColorChooser.this.updateHex();
            } else if (doc == ColorChooser.this.redField.getDocument()) {
                ColorChooser.this.red = ColorChooser.this.bounded(ColorChooser.this.red, ColorChooser.this.redField, 255);
                ColorChooser.this.updateHSB();
                ColorChooser.this.updateHex();
            } else if (doc == ColorChooser.this.greenField.getDocument()) {
                ColorChooser.this.green = ColorChooser.this.bounded(ColorChooser.this.green, ColorChooser.this.greenField, 255);
                ColorChooser.this.updateHSB();
                ColorChooser.this.updateHex();
            } else if (doc == ColorChooser.this.blueField.getDocument()) {
                ColorChooser.this.blue = ColorChooser.this.bounded(ColorChooser.this.blue, ColorChooser.this.blueField, 255);
                ColorChooser.this.updateHSB();
                ColorChooser.this.updateHex();
            } else if (doc == ColorChooser.this.hexField.getDocument()) {
                Object str = ColorChooser.this.hexField.getText();
                if (((String)str).startsWith("#")) {
                    str = ((String)str).substring(1);
                }
                while (((String)str).length() < 6) {
                    str = (String)str + "0";
                }
                if (((String)str).length() > 6) {
                    str = ((String)str).substring(0, 6);
                }
                ColorChooser.this.updateRGB(Integer.parseInt((String)str, 16));
                ColorChooser.this.updateHSB();
            }
            ColorChooser.this.range.repaint();
            ColorChooser.this.slider.repaint();
            ColorChooser.this.colorPanel.repaint();
            this.updating = false;
        }
    }

    static class NumberField
    extends JTextField {
        public boolean allowHex;

        public NumberField(int cols, boolean allowHex) {
            super(cols);
            this.allowHex = allowHex;
        }

        @Override
        protected Document createDefaultModel() {
            return new NumberDocument(this);
        }

        @Override
        public Dimension getPreferredSize() {
            if (!this.allowHex) {
                return new Dimension(45, super.getPreferredSize().height);
            }
            return super.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    static class NumberDocument
    extends PlainDocument {
        NumberField parentField;

        public NumberDocument(NumberField parentField) {
            this.parentField = parentField;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] chars = str.toCharArray();
            int charCount = 0;
            for (int i = 0; i < chars.length; ++i) {
                boolean ok = Character.isDigit(chars[i]);
                if (this.parentField.allowHex) {
                    if (chars[i] >= 'A' && chars[i] <= 'F') {
                        ok = true;
                    }
                    if (chars[i] >= 'a' && chars[i] <= 'f') {
                        ok = true;
                    }
                    if (offs == 0 && i == 0 && chars[i] == '#') {
                        ok = true;
                    }
                }
                if (!ok) continue;
                if (charCount != i) {
                    chars[charCount] = chars[i];
                }
                ++charCount;
            }
            super.insertString(offs, new String(chars, 0, charCount), a);
        }
    }
}

