/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.File;
import processing.app.Base;
import processing.app.tools.Tool;
import processing.app.ui.Editor;
import processing.app.ui.Theme;

public class UpdateTheme
implements Tool {
    Base base;

    @Override
    public String getMenuTitle() {
        return "Update Theme";
    }

    @Override
    public void init(Base base) {
        this.base = base;
    }

    @Override
    public void run() {
        Editor activeEditor = this.base.getActiveEditor();
        File sketchbookFile = Theme.getSketchbookFile();
        if (!sketchbookFile.exists()) {
            Theme.save();
            if (activeEditor != null) {
                activeEditor.statusNotice("Saved theme.txt to " + sketchbookFile);
                System.out.println("After you make changes to theme.txt, select \u201c" + this.getMenuTitle() + "\u201d again to use the new colors.");
            }
        } else {
            Theme.load();
            for (Editor editor : this.base.getEditors()) {
                editor.updateTheme();
            }
            if (activeEditor != null) {
                activeEditor.statusNotice("Finished updating theme.");
            }
        }
    }
}

