/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Util;
import processing.app.contrib.ContributionManager;
import processing.app.tools.Tool;
import processing.app.ui.Editor;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public class ThemeSelector
extends JFrame
implements Tool {
    static final String[] themeOrder = new String[]{"kyanite", "calcite", "olivine", "beryl", "galena", "jasper", "malachite", "pyrite", "gabbro", "fluorite", "orpiment", "feldspar", "antimony", "serandite", "bauxite", "garnet"};
    static final int COUNT = themeOrder.length;
    String[] themeContents;
    File sketchbookFile;
    int currentIndex;
    ColorfulPanel selector;
    Base base;

    @Override
    public String getMenuTitle() {
        return Language.text("Theme Selector...");
    }

    @Override
    public void init(Base base) {
        this.base = base;
        this.themeContents = new String[COUNT];
        for (int i = 0; i < COUNT; ++i) {
            try {
                File file = Base.getLibFile("themes/" + themeOrder[i] + ".txt");
                this.themeContents[i] = Util.loadFile(file);
                continue;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.selector = new ColorfulPanel();
        pane.add((Component)this.selector, "Center");
        Toolkit.registerWindowCloseKeys(this.getRootPane(), e -> this.setVisible(false));
        this.setTitle(this.getMenuTitle());
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void run() {
        this.sketchbookFile = new File(Base.getSketchbookFolder(), "theme.txt");
        this.currentIndex = this.getCurrentIndex();
        this.setVisible(true);
    }

    private File nextBackupFile() {
        File backupFile;
        int index = 0;
        while ((backupFile = new File(Base.getSketchbookFolder(), String.format("theme.%03d", ++index))).exists()) {
        }
        return backupFile;
    }

    private void setCurrentIndex(int index) {
        this.currentIndex = index;
        try {
            Object backupFile;
            boolean success;
            if (this.sketchbookFile.exists() && this.getCurrentIndex() == -1 && !(success = this.sketchbookFile.renameTo((File)(backupFile = this.nextBackupFile())))) {
                Messages.showWarning("Could not back up theme", "Could not save a backup of theme.txt in your sketchbook folder.\nRename it manually and try setting the theme again.");
                return;
            }
            Util.saveFile(this.themeContents[index], this.sketchbookFile);
            Theme.load();
            ContributionManager.updateTheme();
            for (Editor editor : this.base.getEditors()) {
                editor.updateTheme();
            }
        }
        catch (IOException e) {
            this.base.getActiveEditor().statusError(e);
        }
    }

    private int getCurrentIndex() {
        try {
            if (this.sketchbookFile.exists()) {
                String currentContents = Util.loadFile(this.sketchbookFile);
                for (int i = 0; i < COUNT; ++i) {
                    if (!this.themeContents[i].equals(currentContents)) continue;
                    return i;
                }
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    class ColorfulPanel
    extends JPanel {
        static final int SCALE = 4;
        static final int DIM = 80;
        static final int BETWEEN = 25;
        static final int EACH = 105;
        static final int SIZE = 445;
        static final int OUTSET = 5;
        static final int OUTLINE = 3;
        Image image = Toolkit.getLibImage("themes/4x4.png");

        ColorfulPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int col = ColorfulPanel.this.constrain((e.getX() - 25) / 105);
                    int row = ColorfulPanel.this.constrain((e.getY() - 25) / 105);
                    int index = row * 4 + col;
                    ThemeSelector.this.setCurrentIndex(index);
                    ColorfulPanel.this.repaint();
                }
            });
        }

        private int constrain(int value) {
            return Math.max(0, Math.min(value, 3));
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.image, 0, 0, 445, 445, null);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(3.0f));
            g2.setColor(Color.GRAY);
            int col = ThemeSelector.this.currentIndex % 4;
            int row = ThemeSelector.this.currentIndex / 4;
            g2.drawRect(25 + 105 * col - 5, 25 + 105 * row - 5, 90, 90);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(445, 445);
        }
    }
}

