/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import processing.app.Base;
import processing.app.Language;
import processing.app.tools.CharacterSelector;
import processing.app.tools.SampleComponent;
import processing.app.tools.Tool;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;
import processing.core.PFont;

public class CreateFont
extends JFrame
implements Tool {
    Base base;
    JList<String> fontSelector;
    JTextField sizeSelector;
    JButton charsetButton;
    JCheckBox smoothBox;
    JComponent sample;
    JButton okButton;
    JTextField filenameField;
    String[] fontNames;
    Map<String, Font> nameToFont;
    Font font;
    int selection = -1;
    boolean smooth = true;
    CharacterSelector charSelector;

    public CreateFont() {
        super(Language.text("create_font"));
    }

    @Override
    public String getMenuTitle() {
        return Language.text("menu.tools.create_font");
    }

    @Override
    public void init(Base base) {
        this.base = base;
        Container paine = this.getContentPane();
        paine.setLayout(new BorderLayout());
        JPanel pain = new JPanel();
        pain.setBorder(new EmptyBorder(13, 13, 13, 13));
        paine.add((Component)pain, "Center");
        pain.setLayout(new BoxLayout(pain, 1));
        String labelText = Language.text("create_font.label");
        JTextArea textarea = new JTextArea(labelText);
        textarea.setBorder(new EmptyBorder(10, 10, 20, 10));
        textarea.setBackground(null);
        textarea.setEditable(false);
        textarea.setHighlighter(null);
        textarea.setFont(new Font("Dialog", 0, 12));
        pain.add(textarea);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        this.nameToFont = new HashMap<String, Font>();
        for (Font font : fonts) {
            try {
                if (CreateFont.skipFontFamily(font.getFamily())) continue;
                this.nameToFont.put(font.getPSName(), font);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.fontNames = this.nameToFont.keySet().toArray(new String[0]);
        Arrays.sort(this.fontNames, String.CASE_INSENSITIVE_ORDER);
        this.fontSelector = new JList<String>(this.fontNames);
        this.fontSelector.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.selection = this.fontSelector.getSelectedIndex();
                this.okButton.setEnabled(true);
                this.update();
            }
        });
        this.fontSelector.setSelectionMode(0);
        this.fontSelector.setVisibleRowCount(12);
        JScrollPane fontScroller = new JScrollPane(this.fontSelector);
        pain.add(fontScroller);
        Dimension d1 = new Dimension(13, 13);
        pain.add(new Box.Filler(d1, d1, d1));
        this.sample = new SampleComponent(this);
        this.sample.setFont(new Font("Dialog", 0, 12));
        pain.add(this.sample);
        Dimension d2 = new Dimension(6, 6);
        pain.add(new Box.Filler(d2, d2, d2));
        JPanel panel = new JPanel();
        panel.add(new JLabel(Language.text("create_font.size") + ":"));
        this.sizeSelector = new JTextField(" 48 ");
        this.sizeSelector.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateFont.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateFont.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        panel.add(this.sizeSelector);
        this.smoothBox = new JCheckBox(Language.text("create_font.smooth"));
        this.smoothBox.addActionListener(e -> {
            this.smooth = this.smoothBox.isSelected();
            this.update();
        });
        this.smoothBox.setSelected(this.smooth);
        panel.add(this.smoothBox);
        this.charsetButton = new JButton(Language.text("create_font.characters"));
        this.charsetButton.addActionListener(e -> this.charSelector.setVisible(true));
        panel.add(this.charsetButton);
        pain.add(panel);
        JPanel fileStuff = new JPanel();
        fileStuff.add(new JLabel(Language.text("create_font.filename") + ":"));
        this.filenameField = new JTextField(20);
        fileStuff.add(this.filenameField);
        fileStuff.add(new JLabel(".vlw"));
        pain.add(fileStuff);
        JPanel buttons = new JPanel();
        JButton cancelButton = new JButton(Language.text("prompt.cancel"));
        cancelButton.addActionListener(e -> this.setVisible(false));
        this.okButton = new JButton(Language.text("prompt.ok"));
        this.okButton.addActionListener(e -> this.build());
        this.okButton.setEnabled(false);
        buttons.add(cancelButton);
        buttons.add(this.okButton);
        pain.add(buttons);
        JRootPane root = this.getRootPane();
        root.setDefaultButton(this.okButton);
        ActionListener disposer = actionEvent -> this.setVisible(false);
        Toolkit.registerWindowCloseKeys(root, disposer);
        Toolkit.setIcon(this);
        this.pack();
        this.setResizable(false);
        this.sample.setFont(new Font(this.fontNames[0], 0, 48));
        this.fontSelector.setSelectedIndex(0);
        this.setLocationRelativeTo(null);
        this.charSelector = new CharacterSelector();
    }

    private static boolean skipFontFamily(String family) {
        return family.charAt(0) == '.' || family.charAt(0) == '#' || "Dialog".equals(family) || "DialogInput".equals(family) || "Serif".equals(family) || "SansSerif".equals(family) || "Monospaced".equals(family);
    }

    @Override
    public void run() {
        this.setVisible(true);
    }

    public void update() {
        int fontSize = 0;
        try {
            fontSize = Integer.parseInt(this.sizeSelector.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (fontSize > 0 && fontSize < 256 && this.selection != -1) {
            Font instance = this.nameToFont.get(this.fontNames[this.selection]);
            this.font = instance.deriveFont((float)fontSize);
            this.sample.setFont(this.font);
            Object filenameSuggestion = this.fontNames[this.selection].replace(' ', '_');
            filenameSuggestion = (String)filenameSuggestion + "-" + fontSize;
            this.filenameField.setText((String)filenameSuggestion);
        }
    }

    public void build() {
        int fontSize = 0;
        try {
            fontSize = Integer.parseInt(this.sizeSelector.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (fontSize <= 0) {
            JOptionPane.showMessageDialog(this, "Bad font size, try again.", "Badness", 2);
            return;
        }
        Object filename = this.filenameField.getText().trim();
        if (((String)filename).length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a file name for the font.", "Lameness", 2);
            return;
        }
        if (!((String)filename).endsWith(".vlw")) {
            filename = (String)filename + ".vlw";
        }
        try {
            Font instance = this.nameToFont.get(this.fontNames[this.selection]);
            this.font = instance.deriveFont(0, fontSize);
            PFont f = new PFont(this.font, this.smooth, this.charSelector.getCharacters());
            Editor editor = this.base.getActiveEditor();
            File folder = editor.getSketch().prepareDataFolder();
            f.save((OutputStream)new FileOutputStream(new File(folder, (String)filename)));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while creating font.", "No font for you", 2);
            e.printStackTrace();
        }
        this.setVisible(false);
    }
}

