/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import processing.app.Preferences;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaDefaults;
import processing.app.syntax.Token;
import processing.app.syntax.TokenMarkerState;
import processing.app.syntax.im.CompositionTextPainter;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    protected CompositionTextPainter compositionTextPainter;
    protected JEditTextArea textArea;
    protected TextAreaDefaults defaults;
    private Font plainFont;
    private Font boldFont;
    private boolean antialias;
    protected int tabSize;
    protected FontMetrics fontMetrics;
    protected Highlight highlights;
    int currentLineIndex;
    Token currentLineTokens;
    Segment currentLine;

    public TextAreaPainter(JEditTextArea textArea, TextAreaDefaults defaults) {
        this.textArea = textArea;
        this.defaults = defaults;
        this.setAutoscrolls(true);
        this.setOpaque(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.currentLine = new Segment();
        this.currentLineIndex = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.updateTheme();
    }

    protected void updateTheme() {
        this.setForeground(this.defaults.fgcolor);
        this.setBackground(this.defaults.bgcolor);
        this.plainFont = Preferences.getFont("editor.font.family", "editor.font.size", 0);
        this.boldFont = Preferences.getFont("editor.font.family", "editor.font.size", 1);
        this.antialias = Preferences.getBoolean("editor.smooth");
        this.fontMetrics = super.getFontMetrics(this.plainFont);
        this.tabSize = this.fontMetrics.charWidth(' ') * Preferences.getInteger("editor.tabs.size");
        this.textArea.recalculateVisibleLines();
    }

    public CompositionTextPainter getCompositionTextPainter() {
        if (this.compositionTextPainter == null) {
            this.compositionTextPainter = new CompositionTextPainter(this.textArea);
        }
        return this.compositionTextPainter;
    }

    public final SyntaxStyle[] getStyles() {
        return this.defaults.styles;
    }

    public final void setLineHighlightEnabled(boolean lineHighlight) {
        this.defaults.lineHighlight = lineHighlight;
        this.invalidateSelectedLines();
    }

    public final boolean isBracketHighlightEnabled() {
        return this.defaults.bracketHighlight;
    }

    public final boolean isBlockCaretEnabled() {
        return this.defaults.blockCaret;
    }

    public FontMetrics getFontMetrics() {
        this.fontMetrics = this.getFontMetrics(this.plainFont);
        return this.fontMetrics;
    }

    public FontMetrics getFontMetrics(SyntaxStyle style) {
        return this.getFontMetrics(style.isBold() ? this.boldFont : this.plainFont);
    }

    public int getLineHeight() {
        return this.fontMetrics.getHeight() + this.fontMetrics.getDescent();
    }

    protected int getLineDisplacement() {
        return this.fontMetrics.getLeading() + this.fontMetrics.getMaxDescent();
    }

    @Override
    public void paint(Graphics gfx) {
        this.fontMetrics = this.getFontMetrics(this.plainFont);
        Graphics2D g2 = (Graphics2D)gfx;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        Rectangle clipRect = gfx.getClipBounds();
        gfx.setColor(this.getBackground());
        gfx.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        int height = this.fontMetrics.getHeight();
        int firstLine = this.textArea.getFirstLine();
        int firstInvalid = firstLine + clipRect.y / height;
        int lastInvalid = firstLine + (clipRect.y + clipRect.height - 1) / height;
        try {
            TokenMarkerState tokenMarker = this.textArea.getDocument().getTokenMarker();
            int x = this.textArea.getHorizontalOffset();
            for (int line = firstInvalid; line <= lastInvalid; ++line) {
                this.paintLine(gfx, line, x, tokenMarker);
            }
            if (tokenMarker != null && tokenMarker.isNextLineRequested()) {
                int h = clipRect.y + clipRect.height;
                this.repaint(0, h, this.getWidth(), this.getHeight() - h);
            }
        }
        catch (Exception e) {
            System.err.println("Error repainting line range {" + firstInvalid + "," + lastInvalid + "}:");
            e.printStackTrace();
        }
    }

    public final void invalidateLine(int line) {
        this.repaint(0, this.textArea.lineToY(line) + this.getLineDisplacement(), this.getWidth(), this.fontMetrics.getHeight());
    }

    final void invalidateLineRange(int firstLine, int lastLine) {
        this.repaint(0, this.textArea.lineToY(firstLine) + this.getLineDisplacement(), this.getWidth(), (lastLine - firstLine + 1) * this.fontMetrics.getHeight());
    }

    final void invalidateSelectedLines() {
        this.invalidateLineRange(this.textArea.getSelectionStartLine(), this.textArea.getSelectionStopLine());
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        int offset = this.textArea.getHorizontalOffset();
        int tabCount = ((int)x - offset) / this.tabSize;
        return (tabCount + 1) * this.tabSize + offset;
    }

    @Override
    public Dimension getPreferredSize() {
        this.fontMetrics = this.getFontMetrics(this.plainFont);
        return new Dimension(this.fontMetrics.charWidth('w') * this.defaults.cols, this.fontMetrics.getHeight() * this.defaults.rows);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getCurrentLineIndex() {
        return this.currentLineIndex;
    }

    public void setCurrentLineIndex(int what) {
        this.currentLineIndex = what;
    }

    public Token getCurrentLineTokens() {
        return this.currentLineTokens;
    }

    public void setCurrentLineTokens(Token tokens) {
        this.currentLineTokens = tokens;
    }

    public Segment getCurrentLine() {
        return this.currentLine;
    }

    protected void paintLine(Graphics gfx, int line, int x, TokenMarkerState tokenMarker) {
        this.currentLineIndex = line;
        int y = this.textArea.lineToY(line);
        if (tokenMarker == null) {
            this.paintPlainLine(gfx, line, x, y);
        } else if (line >= 0 && line < this.textArea.getLineCount()) {
            this.paintSyntaxLine(gfx, line, x, y, tokenMarker);
        }
    }

    protected void paintPlainLine(Graphics gfx, int line, int x, int y) {
        this.paintHighlight(gfx, line, y);
        if (line < this.textArea.getLineCount()) {
            this.textArea.getLineText(line, this.currentLine);
            int x0 = x - this.textArea.getHorizontalOffset();
            gfx.setColor(this.defaults.fgcolor);
            gfx.setFont(this.plainFont);
            y += this.fontMetrics.getHeight();
            for (int i = 0; i < this.currentLine.count; ++i) {
                gfx.drawChars(this.currentLine.array, this.currentLine.offset + i, 1, x, y);
                if (this.currentLine.array[this.currentLine.offset + i] == '\t') {
                    x = x0 + (int)this.nextTabStop(x - x0, i);
                    continue;
                }
                x += this.fontMetrics.charWidth(this.currentLine.array[this.currentLine.offset + i]);
            }
            if (this.compositionTextPainter != null && this.compositionTextPainter.hasComposedTextLayout()) {
                this.compositionTextPainter.draw(gfx, this.defaults.lineHighlightColor);
            }
        }
        if (this.defaults.eolMarkers) {
            gfx.setColor(this.defaults.eolMarkerColor);
            gfx.drawString(".", x, y);
        }
    }

    protected void paintSyntaxLine(Graphics gfx, int line, int x, int y, TokenMarkerState tokenMarker) {
        this.textArea.getLineText(this.currentLineIndex, this.currentLine);
        this.currentLineTokens = tokenMarker.markTokens(this.currentLine, this.currentLineIndex);
        this.paintHighlight(gfx, line, y);
        x = this.paintSyntaxLine(gfx, this.currentLine, x, y += this.fontMetrics.getHeight(), this.currentLineTokens, this.defaults.styles);
        if (this.compositionTextPainter != null && this.compositionTextPainter.hasComposedTextLayout()) {
            this.compositionTextPainter.draw(gfx, this.defaults.lineHighlightColor);
        }
        if (this.defaults.eolMarkers) {
            gfx.setColor(this.defaults.eolMarkerColor);
            gfx.drawString(".", x, y);
        }
    }

    protected int paintSyntaxLine(Graphics gfx, Segment line, int x, int y, Token tokens, SyntaxStyle[] styles) {
        byte id;
        int x0 = x - this.textArea.getHorizontalOffset();
        while ((id = tokens.id) != 127) {
            int length = tokens.length;
            if (id == 0) {
                gfx.setColor(this.defaults.fgcolor);
                gfx.setFont(this.plainFont);
            } else {
                SyntaxStyle ss = styles[id];
                gfx.setColor(ss.getColor());
                gfx.setFont(ss.isBold() ? this.boldFont : this.plainFont);
            }
            line.count = length;
            for (int i = 0; i < line.count; ++i) {
                gfx.drawChars(line.array, line.offset + i, 1, x, y);
                if (line.array[line.offset + i] == '\t') {
                    x = x0 + (int)this.nextTabStop(x - x0, i);
                    continue;
                }
                x += this.fontMetrics.charWidth(line.array[line.offset + i]);
            }
            line.offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    protected void paintHighlight(Graphics gfx, int line, int y) {
        if (line >= this.textArea.getSelectionStartLine() && line <= this.textArea.getSelectionStopLine()) {
            this.paintLineHighlight(gfx, line, y);
        }
        if (this.highlights != null) {
            this.highlights.paintHighlight(gfx, line, y);
        }
        if (this.defaults.bracketHighlight && line == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(gfx, line, y);
        }
        if (line == this.textArea.getCaretLine()) {
            this.paintCaret(gfx, line, y);
        }
    }

    protected void paintLineHighlight(Graphics gfx, int line, int y) {
        int selectionEnd;
        int height = this.fontMetrics.getHeight();
        y += this.getLineDisplacement();
        int selectionStart = this.textArea.getSelectionStart();
        if (selectionStart == (selectionEnd = this.textArea.getSelectionStop())) {
            if (this.defaults.lineHighlight) {
                gfx.setColor(this.defaults.lineHighlightColor);
                gfx.fillRect(0, y, this.getWidth(), height);
            }
        } else {
            int x2;
            int x1;
            gfx.setColor(this.defaults.selectionColor);
            int selectionStartLine = this.textArea.getSelectionStartLine();
            int selectionEndLine = this.textArea.getSelectionStopLine();
            int lineStart = this.textArea.getLineStartOffset(line);
            if (selectionStartLine == selectionEndLine) {
                x1 = this.textArea._offsetToX(line, selectionStart - lineStart);
                x2 = this.textArea._offsetToX(line, selectionEnd - lineStart);
            } else if (line == selectionStartLine) {
                x1 = this.textArea._offsetToX(line, selectionStart - lineStart);
                x2 = this.getWidth();
            } else if (line == selectionEndLine) {
                x1 = this.textArea._offsetToX(line, 0);
                x2 = this.textArea._offsetToX(line, selectionEnd - lineStart);
            } else {
                x1 = this.textArea._offsetToX(line, 0);
                x2 = this.getWidth();
            }
            gfx.fillRect(Math.min(x1, x2), y, x1 > x2 ? x1 - x2 : x2 - x1, height);
        }
    }

    protected void paintBracketHighlight(Graphics gfx, int line, int y) {
        int position = this.textArea.getBracketPosition();
        if (position != -1) {
            int x = this.textArea._offsetToX(line, position);
            gfx.setColor(this.defaults.bracketHighlightColor);
            gfx.drawRect(x, y += this.getLineDisplacement(), this.fontMetrics.charWidth('(') - 1, this.fontMetrics.getHeight() - 1);
        }
    }

    protected void paintCaret(Graphics gfx, int line, int y) {
        if (this.textArea.isCaretVisible()) {
            int offset = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(line);
            int caretX = this.textArea._offsetToX(line, offset);
            int caretWidth = 1;
            if (this.defaults.blockCaret || this.textArea.isOverwriteEnabled()) {
                caretWidth = this.fontMetrics.charWidth('w');
            }
            y += this.getLineDisplacement();
            int height = this.fontMetrics.getHeight();
            gfx.setColor(this.defaults.caretColor);
            if (this.textArea.isOverwriteEnabled()) {
                gfx.fillRect(caretX, y + height - 1, caretWidth, 1);
            } else if (caretWidth == 1) {
                ((Graphics2D)gfx).draw(new Line2D.Float(caretX, (float)y + 0.5f, caretX, (float)(y + height) - 0.5f));
            } else {
                gfx.drawRect(caretX, y, caretWidth - 1, height - 1);
            }
        }
    }

    public int getScrollWidth() {
        return super.getWidth();
    }

    public static interface Highlight {
        public void init(JEditTextArea var1, Highlight var2);

        public void paintHighlight(Graphics var1, int var2, int var3);

        public String getToolTipText(MouseEvent var1);
    }
}

