/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import javax.swing.text.Segment;
import processing.app.syntax.KeywordMap;
import processing.app.syntax.TokenMarker;
import processing.app.ui.Editor;

public class PdeTokenMarker
extends TokenMarker {
    protected KeywordMap keywordColoring;

    @Override
    public void addColoring(String keyword, String coloring) {
        if (this.keywordColoring == null) {
            this.keywordColoring = new KeywordMap(false);
        }
        int num = coloring.charAt(coloring.length() - 1) - 49;
        int id = 0;
        switch (coloring.charAt(0)) {
            case 'K': {
                id = 6 + num;
                this.keywordColoring.add(keyword, (byte)id, false);
                if (id != 11) break;
                this.keywordColoring.add(keyword, (byte)id, true);
                break;
            }
            case 'L': {
                id = 3 + num;
                this.keywordColoring.add(keyword, (byte)id, false);
                break;
            }
            case 'F': {
                id = 12 + num;
                this.keywordColoring.add(keyword, (byte)id, true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        char[] array = line.array;
        int offset = line.offset;
        MarkerState ms = new MarkerState(offset);
        int mlength = offset + line.count;
        boolean backslash = false;
        block21: for (int i = offset; i < mlength; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (!backslash) break;
                            backslash = false;
                            break;
                        }
                        case '\"': {
                            this.doKeyword(ms, line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - ms.lastOffset, token);
                            token = (byte)3;
                            ms.lastOffset = ms.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(ms, line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - ms.lastOffset, token);
                            token = (byte)4;
                            ms.lastOffset = ms.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (ms.lastKeyword == offset) {
                                if (this.doKeyword(ms, line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - ms.lastOffset, (byte)5);
                                ms.lastOffset = ms.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(ms, line, i, c)) break;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(ms, line, i, c);
                            if (mlength - i <= 1) break;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - ms.lastOffset, token);
                                    ms.lastOffset = ms.lastKeyword = i;
                                    if (mlength - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - ms.lastOffset, token);
                                    this.addToken(mlength - i, (byte)1);
                                    ms.lastOffset = ms.lastKeyword = mlength;
                                    break block21;
                                }
                            }
                            if (array[i1] == ' ') break;
                            ++i;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_') break;
                            this.doKeyword(ms, line, i, c);
                            break;
                        }
                    }
                    continue block21;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || mlength - i <= 1 || array[i1] != '/') continue block21;
                    this.addToken(++i + 1 - ms.lastOffset, token);
                    token = 0;
                    ms.lastOffset = ms.lastKeyword = i + 1;
                    continue block21;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\"') continue block21;
                    this.addToken(i1 - ms.lastOffset, token);
                    token = 0;
                    ms.lastOffset = ms.lastKeyword = i1;
                    continue block21;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\'') continue block21;
                    this.addToken(i1 - ms.lastOffset, (byte)3);
                    token = 0;
                    ms.lastOffset = ms.lastKeyword = i1;
                    continue block21;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(ms, line, mlength, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(mlength - ms.lastOffset, (byte)17);
                return 0;
            }
            case 7: {
                this.addToken(mlength - ms.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
                this.addToken(mlength - ms.lastOffset, token);
                return token;
            }
        }
        this.addToken(mlength - ms.lastOffset, token);
        return token;
    }

    protected boolean doKeyword(MarkerState ms, Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - ms.lastKeyword;
        boolean paren = Editor.checkParen(line.array, i, line.array.length);
        byte id = this.keywordColoring.lookup(line, ms.lastKeyword, len, paren);
        if (id != 0) {
            if (ms.lastKeyword != ms.lastOffset) {
                this.addToken(ms.lastKeyword - ms.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            ms.lastOffset = i;
        }
        ms.lastKeyword = i1;
        return false;
    }

    class MarkerState {
        int lastOffset;
        int lastKeyword;

        MarkerState(int offset) {
            this.lastOffset = offset;
            this.lastKeyword = offset;
        }
    }
}

