/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import processing.app.Problem;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.PdeTextArea;
import processing.app.syntax.PdeTextAreaDefaults;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.TextAreaDefaults;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.TokenMarkerState;
import processing.app.ui.Editor;
import processing.app.ui.Theme;

public class PdeTextAreaPainter
extends TextAreaPainter {
    public Color errorUnderlineColor;
    public Color warningUnderlineColor;
    protected Font gutterTextFont;
    protected Color gutterTextColor;
    protected Color gutterPastColor;
    protected Color gutterLineHighlightColor;

    public PdeTextAreaPainter(final JEditTextArea textArea, TextAreaDefaults defaults) {
        super(textArea, defaults);
        this.setDoubleBuffered(true);
        this.addMouseListener(new MouseAdapter(){
            long lastTime;

            @Override
            public void mousePressed(MouseEvent event) {
                long thisTime;
                if (PdeTextAreaPainter.this.getEditor().isDebuggerEnabled() && (thisTime = event.getWhen()) - this.lastTime > 100L) {
                    int offset;
                    if (event.getX() < Editor.LEFT_GUTTER && (offset = textArea.xyToOffset(event.getX(), event.getY())) >= 0) {
                        int lineIndex = textArea.getLineOfOffset(offset);
                        PdeTextAreaPainter.this.getEditor().toggleBreakpoint(lineIndex);
                    }
                    this.lastTime = thisTime;
                }
            }
        });
    }

    @Override
    protected void updateTheme() {
        this.errorUnderlineColor = Theme.getColor("editor.error.underline.color");
        this.warningUnderlineColor = Theme.getColor("editor.warning.underline.color");
        this.gutterTextFont = Theme.getFont("editor.gutter.text.font");
        this.gutterTextColor = Theme.getColor("editor.gutter.text.color");
        this.gutterPastColor = new Color(this.gutterTextColor.getRed(), this.gutterTextColor.getGreen(), this.gutterTextColor.getBlue(), 96);
        this.gutterLineHighlightColor = Theme.getColor("editor.gutter.linehighlight.color");
        if (this.defaults instanceof PdeTextAreaDefaults) {
            ((PdeTextAreaDefaults)this.defaults).updateTheme();
        }
        super.updateTheme();
    }

    @Override
    protected void paintLine(Graphics gfx, int line, int x, TokenMarkerState marker) {
        try {
            super.paintLine(gfx, line, x + Editor.LEFT_GUTTER, marker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.paintLeftGutter(gfx, line, x);
        this.paintErrorLine(gfx, line, x);
    }

    protected void paintErrorLine(Graphics gfx, int line, int x) {
        List<Problem> problems = this.getEditor().findProblems(line);
        for (Problem problem : problems) {
            int startOffset = problem.getStartOffset();
            int stopOffset = problem.getStopOffset();
            int lineOffset = this.textArea.getLineStartOffset(line);
            int wiggleStart = Math.max(startOffset, lineOffset);
            int wiggleStop = Math.min(stopOffset, this.textArea.getLineStopOffset(line));
            int y = this.textArea.lineToY(line) + this.getLineDisplacement();
            try {
                int x2;
                int x1;
                String goodCode;
                String badCode;
                try {
                    SyntaxDocument doc = this.textArea.getDocument();
                    badCode = doc.getText(wiggleStart, wiggleStop - wiggleStart);
                    goodCode = doc.getText(lineOffset, wiggleStart - lineOffset);
                }
                catch (BadLocationException bl) {
                    return;
                }
                int trimmedLength = badCode.trim().length();
                int rightTrimmedLength = PdeTextAreaPainter.trimRight(badCode).length();
                int leftTrimLength = rightTrimmedLength - trimmedLength;
                if (trimmedLength == 0) {
                    leftTrimLength = 0;
                    rightTrimmedLength = badCode.length();
                }
                if ((x1 = this.textArea.offsetToX(line, goodCode.length() + leftTrimLength)) == (x2 = this.textArea.offsetToX(line, goodCode.length() + rightTrimmedLength))) {
                    x2 += this.fontMetrics.stringWidth(" ");
                }
                int y1 = y + this.fontMetrics.getHeight() - 2;
                if (line != problem.getLineNumber()) {
                    x1 = Editor.LEFT_GUTTER;
                }
                gfx.setColor(this.errorUnderlineColor);
                if (problem.isWarning()) {
                    gfx.setColor(this.warningUnderlineColor);
                }
                PdeTextAreaPainter.paintSquiggle(gfx, y1, x1, x2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void paintLeftGutter(Graphics gfx, int line, int x) {
        int y = this.textArea.lineToY(line) + this.getLineDisplacement();
        if (line == this.textArea.getSelectionStopLine()) {
            gfx.setColor(this.gutterLineHighlightColor);
            gfx.fillRect(0, y, Editor.LEFT_GUTTER, this.fontMetrics.getHeight());
        } else {
            Rectangle clip = gfx.getClipBounds();
            gfx.setClip(0, y, Editor.LEFT_GUTTER, this.fontMetrics.getHeight());
            gfx.drawImage(((PdeTextArea)this.textArea).getGutterGradient(), 0, 0, this.getWidth(), this.getHeight(), this);
            gfx.setClip(clip);
        }
        String text = null;
        if (this.getEditor().isDebuggerEnabled()) {
            text = this.getPdeTextArea().getGutterText(line);
        }
        gfx.setColor(line < this.textArea.getLineCount() ? this.gutterTextColor : this.gutterPastColor);
        int textRight = Editor.LEFT_GUTTER - Editor.GUTTER_MARGIN;
        int textBaseline = this.textArea.lineToY(line) + this.fontMetrics.getHeight();
        if (text != null) {
            if (text.equals("<>")) {
                PdeTextAreaPainter.drawDiamond(gfx, textRight - 8, textBaseline - 8, 8.0f, 8.0f);
            } else if (text.equals("->")) {
                PdeTextAreaPainter.drawRightArrow(gfx, textRight - 7, (float)textBaseline - 7.5f, 7.0f, 7.0f);
            }
        } else {
            text = String.valueOf(line + 1);
            gfx.setFont(this.gutterTextFont);
            char[] txt = text.toCharArray();
            int tx = textRight - gfx.getFontMetrics().charsWidth(txt, 0, txt.length);
            Utilities.drawTabbedText(new Segment(txt, 0, text.length()), (float)tx, (float)textBaseline, (Graphics2D)gfx, (TabExpander)this, 0);
        }
    }

    private static void drawDiamond(Graphics g, float x, float y, float w, float h) {
        Graphics2D g2 = (Graphics2D)g;
        GeneralPath path = new GeneralPath();
        path.moveTo(x + w / 2.0f, y);
        path.lineTo(x + w, y + h / 2.0f);
        path.lineTo(x + w / 2.0f, y + h);
        path.lineTo(x, y + h / 2.0f);
        path.closePath();
        g2.fill(path);
    }

    private static void drawRightArrow(Graphics g, float x, float y, float w, float h) {
        Graphics2D g2 = (Graphics2D)g;
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        path.lineTo(x + w, y + h / 2.0f);
        path.lineTo(x, y + h);
        path.closePath();
        g2.fill(path);
    }

    private static String trimRight(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && Character.isWhitespace(str.charAt(i)); --i) {
        }
        return str.substring(0, i + 1);
    }

    private static void paintSquiggle(Graphics g, int y, int x1, int x2) {
        for (int xx = x1; xx < x2; xx += 2) {
            g.drawLine(xx, y, xx + 2, y + 1);
            g.drawLine(xx += 2, y + 1, xx + 2, y);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        this.fontMetrics = this.getFontMetrics();
        int line = event.getY() / this.fontMetrics.getHeight() + this.textArea.getFirstLine();
        if (line >= 0 || line < this.textArea.getLineCount()) {
            List<Problem> problems = this.getEditor().findProblems(line);
            for (Problem problem : problems) {
                int lineStart = this.textArea.getLineStartOffset(line);
                int lineEnd = this.textArea.getLineStopOffset(line);
                int errorStart = problem.getStartOffset();
                int errorEnd = problem.getStopOffset() + 1;
                int startOffset = Math.max(errorStart, lineStart) - lineStart;
                int stopOffset = Math.min(errorEnd, lineEnd) - lineStart;
                int x = event.getX();
                if (x < this.textArea.offsetToX(line, startOffset) || x > this.textArea.offsetToX(line, stopOffset)) continue;
                this.getEditor().statusToolTip(this, problem.getMessage(), problem.isError());
                return super.getToolTipText(event);
            }
        }
        this.setToolTipText(null);
        return super.getToolTipText(event);
    }

    @Override
    public int getScrollWidth() {
        return super.getWidth() - Editor.LEFT_GUTTER;
    }

    public Editor getEditor() {
        return this.getPdeTextArea().editor;
    }

    public PdeTextArea getPdeTextArea() {
        return (PdeTextArea)this.textArea;
    }
}

