/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.WinDef;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Optional;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Util;
import processing.app.platform.DefaultPlatform;
import processing.app.platform.WindowsRegistry;
import processing.core.PApplet;

public class WindowsPlatform
extends DefaultPlatform {
    static final String APP_NAME = "Processing";
    static final String[] APP_EXTENSIONS = new String[]{".pde", ".pyde", ".pdez", ".pdex"};
    static final String REG_OPEN_COMMAND = System.getProperty("user.dir").replace('/', '\\') + "\\" + "Processing".toLowerCase() + ".exe \"%1\"";
    static final String REG_DOC = "Processing.Document";
    private static final float RESOLUTION_AT_NO_SCALE = 96.0f;
    private static final int VERTRES = 10;
    private static final int DESKTOPVERTRES = 117;
    private Optional<Float> cachedDisplayScaling = Optional.empty();
    static WinLibC clib;

    @Override
    public void initBase(Base base) {
        super.initBase(base);
        this.checkAssociations();
        this.checkPath();
    }

    protected void checkAssociations() {
        try {
            if (Preferences.getBoolean("platform.auto_file_type_associations")) {
                String knownCommand = WindowsRegistry.getStringValue(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes\\Processing.Document\\shell\\open\\command", "");
                if (knownCommand == null || !knownCommand.equals(REG_OPEN_COMMAND)) {
                    this.setAssociations();
                } else {
                    for (String extension : APP_EXTENSIONS) {
                        if (WindowsRegistry.valueExists(WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER, "Software\\Classes", extension)) continue;
                        this.setAssociations();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setAssociations() throws UnsupportedEncodingException {
        for (String extension : APP_EXTENSIONS) {
            if (this.registerExtension(extension)) continue;
            Messages.log("Could not associate " + extension + "files, turning off auto-associate pref.");
            Preferences.setBoolean("platform.auto_file_type_associations", false);
        }
    }

    private boolean registerExtension(String extension) throws UnsupportedEncodingException {
        WindowsRegistry.REGISTRY_ROOT_KEY rootKey = WindowsRegistry.REGISTRY_ROOT_KEY.CURRENT_USER;
        String docPrefix = "Software\\Classes\\Processing.Document";
        return WindowsRegistry.createKey(rootKey, "Software\\Classes", extension) && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\" + extension, "", REG_DOC) && WindowsRegistry.createKey(rootKey, "Software\\Classes", REG_DOC) && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\Processing.Document", "", "Processing Source Code") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document", "shell") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document\\shell", "open") && WindowsRegistry.createKey(rootKey, "Software\\Classes\\Processing.Document\\shell\\open", "command") && WindowsRegistry.setStringValue(rootKey, "Software\\Classes\\Processing.Document\\shell\\open\\command", "", REG_OPEN_COMMAND);
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        for (String item : pieces) {
            File directory;
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if (!(directory = new File(item)).exists() || item.trim().length() == 0) continue;
            legit[legitCount++] = item;
        }
        String newPath = PApplet.join((String[])(legit = PApplet.subset((String[])legit, (int)0, (int)legitCount)), (String)File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    @Override
    public File getSettingsFolder() throws Exception {
        File override = Base.getSettingsOverride();
        if (override != null) {
            return override;
        }
        try {
            File settingsFolder;
            File settingsFolder2;
            String appDataRoaming = WindowsPlatform.getAppDataPath();
            if (appDataRoaming != null && ((settingsFolder2 = new File(appDataRoaming, APP_NAME)).exists() || settingsFolder2.mkdirs())) {
                return settingsFolder2;
            }
            String appDataLocal = WindowsPlatform.getLocalAppDataPath();
            if (appDataLocal != null && ((settingsFolder = new File(appDataLocal, APP_NAME)).exists() || settingsFolder.mkdirs())) {
                return settingsFolder;
            }
            if (appDataRoaming == null && appDataLocal == null) {
                throw new IOException("Could not get the AppData folder");
            }
            throw new IOException("Permissions error: make sure that " + appDataRoaming + " or " + appDataLocal + " is writable.");
        }
        catch (UnsatisfiedLinkError ule) {
            String path = new File("lib").getCanonicalPath();
            String msg = Util.containsNonASCII(path) ? "Please move Processing to a location with only\nASCII characters in the path and try again.\nhttps://github.com/processing/processing/issues/3543" : "Could not find JNA support files, please reinstall Processing.";
            Messages.showError("Windows JNA Problem", msg, ule);
            return null;
        }
    }

    private static String getAppDataPath() {
        return Shell32Util.getSpecialFolderPath((int)26, (boolean)true);
    }

    private static String getLocalAppDataPath() {
        return Shell32Util.getSpecialFolderPath((int)28, (boolean)true);
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        String documentsPath = WindowsPlatform.getDocumentsPath();
        if (documentsPath != null) {
            return new File(documentsPath, APP_NAME);
        }
        return null;
    }

    private static String getDocumentsPath() {
        return Shell32Util.getSpecialFolderPath((int)5, (boolean)true);
    }

    static WinLibC getLibC() {
        if (clib == null) {
            try {
                clib = (WinLibC)Native.load((String)"msvcrt", WinLibC.class);
            }
            catch (UnsatisfiedLinkError ule) {
                Messages.showTrace("JNA Error", "JNA could not be loaded. Please report here:\nhttp://github.com/processing/processing/issues/new", ule, true);
            }
        }
        return clib;
    }

    @Override
    public void setenv(String variable, String value) {
        WindowsPlatform.getLibC()._putenv(variable + "=" + value);
    }

    @Override
    public String getenv(String variable) {
        return System.getenv(variable);
    }

    @Override
    public int unsetenv(String variable) {
        return WindowsPlatform.getLibC()._putenv(variable + "=");
    }

    @Override
    public float getSystemZoom() {
        if (this.cachedDisplayScaling.isEmpty()) {
            this.cachedDisplayScaling = Optional.of(Float.valueOf(this.calculateSystemZoom()));
        }
        return this.cachedDisplayScaling.get().floatValue();
    }

    private float calculateSystemZoom() {
        WinDef.HDC hdc = GDI32.INSTANCE.CreateCompatibleDC(null);
        if (hdc == null) {
            float resolution = Toolkit.getDefaultToolkit().getScreenResolution();
            return resolution / 96.0f;
        }
        float virtualResolution = GDI32.INSTANCE.GetDeviceCaps(hdc, 10);
        float logicalResolution = GDI32.INSTANCE.GetDeviceCaps(hdc, 117);
        GDI32.INSTANCE.DeleteDC(hdc);
        return logicalResolution / virtualResolution;
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

