/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.ui.Toolkit;
import processing.awt.ShimAWT;
import processing.core.PApplet;

public class DefaultPlatform {
    private final String[] FONT_SCALING_WIDGETS = new String[]{"Button", "CheckBox", "CheckBoxMenuItem", "ComboBox", "List", "Menu", "MenuBar", "MenuItem", "OptionPane", "Panel", "PopupMenu", "ProgressBar", "RadioButton", "RadioButtonMenuItem", "ScrollPane", "TabbedPane", "Table", "TableHeader", "TextArea", "TextPane", "TitledBorder", "ToggleButton", "ToolBar", "ToolTip", "Tree", "Viewport"};
    Base base;

    public void initBase(Base base) {
        this.base = base;
    }

    public void setLookAndFeel() throws Exception {
        String laf = Preferences.get("editor.laf");
        if (laf == null || laf.length() == 0) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } else {
            UIManager.setLookAndFeel(laf);
        }
        String fontName = Preferences.get("ui.font.family");
        int fontSize = Preferences.getInteger("ui.font.size");
        if (!"Dialog".equals(fontName) || fontSize != 12) {
            DefaultPlatform.setUIFont(new FontUIResource(fontName, 0, fontSize));
        }
        UIManager.put("ScrollBar.minimumThumbSize", new Dimension(8, 24));
    }

    private static void setUIFont(FontUIResource f) {
        for (Object key : UIManager.getLookAndFeelDefaults().keySet()) {
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public void setInterfaceZoom() throws Exception {
        if (!Preferences.getBoolean("editor.zoom.auto")) {
            for (String widgetName : this.FONT_SCALING_WIDGETS) {
                this.scaleDefaultFont(widgetName);
            }
            String fontName = Preferences.get("ui.font.family");
            int fontSize = Preferences.getInteger("ui.font.size");
            FontUIResource uiFont = new FontUIResource(fontName, 0, Toolkit.zoom(fontSize));
            UIManager.put("Label.font", uiFont);
            UIManager.put("TextField.font", uiFont);
        }
    }

    public void saveLanguage(String languageCode) {
    }

    public File getSettingsFolder() throws Exception {
        File override = Base.getSettingsOverride();
        if (override != null) {
            return override;
        }
        File home2 = new File(System.getProperty("user.home"));
        return new File(home2, ".processing");
    }

    public File getDefaultSketchbookFolder() throws Exception {
        return new File(System.getProperty("user.home"), "sketchbook");
    }

    public void openURL(String url) throws Exception {
        if (!ShimAWT.openLink((String)url)) {
            PApplet.launch((String[])new String[]{url});
        }
    }

    public boolean openFolderAvailable() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    public void openFolder(File file) throws Exception {
        Desktop.getDesktop().open(file);
    }

    public void setenv(String variable, String value) {
        CLibrary clib = CLibrary.INSTANCE;
        clib.setenv(variable, value, 1);
    }

    public String getenv(String variable) {
        CLibrary clib = CLibrary.INSTANCE;
        return clib.getenv(variable);
    }

    public int unsetenv(String variable) {
        CLibrary clib = CLibrary.INSTANCE;
        return clib.unsetenv(variable);
    }

    public float getSystemZoom() {
        return 1.0f;
    }

    private void scaleDefaultFont(String name) {
        String fontPropertyName = name + ".font";
        Font currentFont = (Font)UIManager.get(fontPropertyName);
        float newSize = Toolkit.zoom(currentFont.getSize());
        Font newFont = currentFont.deriveFont(newSize);
        UIManager.put(fontPropertyName, newFont);
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.load((String)"c", CLibrary.class);

        public int setenv(String var1, String var2, int var3);

        public String getenv(String var1);

        public int unsetenv(String var1);

        public int putenv(String var1);
    }
}

