/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import processing.app.Base;
import processing.app.Messages;
import processing.app.contrib.ContributionType;
import processing.app.contrib.IgnorableException;
import processing.app.contrib.LocalContribution;
import processing.app.tools.Tool;

public class ToolContribution
extends LocalContribution
implements Tool,
Comparable<ToolContribution> {
    private Tool tool;
    private final File referenceFile;

    public static ToolContribution load(File folder) {
        try {
            return new ToolContribution(folder);
        }
        catch (IgnorableException ig) {
            Messages.log(ig.getMessage());
        }
        catch (VerifyError ig) {
        }
        catch (NoClassDefFoundError ncdfe) {
            if (ncdfe.getMessage().contains("processing/app/Editor")) {
                System.err.println("The Editor class has moved to the processing.app.ui package in Processing 3");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private ToolContribution(File folder) throws Throwable {
        super(folder);
        String className = this.initLoader(null);
        if (className != null) {
            Class<?> toolClass = this.loader.loadClass(className);
            this.tool = (Tool)toolClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        this.referenceFile = new File(folder, "reference/index.html");
    }

    public void clearClassLoader() {
        try {
            ((URLClassLoader)this.loader).close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static List<ToolContribution> loadAll(File toolsFolder) {
        File[] list = ContributionType.TOOL.listCandidates(toolsFolder);
        ArrayList<ToolContribution> outgoing = new ArrayList<ToolContribution>();
        if (list != null) {
            for (File folder : list) {
                try {
                    ToolContribution tc = ToolContribution.load(folder);
                    if (tc == null) continue;
                    outgoing.add(tc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(outgoing);
        return outgoing;
    }

    @Override
    public void init(Base base) {
        this.tool.init(base);
    }

    @Override
    public void run() {
        this.tool.run();
    }

    @Override
    public String getMenuTitle() {
        return this.tool.getMenuTitle();
    }

    @Override
    public ContributionType getType() {
        return ContributionType.TOOL;
    }

    public File getReferenceIndexFile() {
        return this.referenceFile;
    }

    public boolean hasReference() {
        return this.referenceFile.exists();
    }

    @Override
    public int compareTo(ToolContribution o) {
        return this.getMenuTitle().compareTo(o.getMenuTitle());
    }
}

