/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JProgressBar;
import processing.app.Base;
import processing.app.Language;
import processing.app.Messages;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgress;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusPanel;
import processing.app.ui.Toolkit;

class StatusPanelDetail {
    private static final int BUTTON_WIDTH = Toolkit.zoom(100);
    private final Base base;
    private final StatusPanel statusPanel;
    private Contribution contrib;
    private JProgressBar progressBar;
    boolean updateInProgress;
    boolean installInProgress;
    boolean removeInProgress;
    static AbstractQueue<String> restoreQueue = new ConcurrentLinkedQueue<String>();

    StatusPanelDetail(Base base, StatusPanel statusPanel) {
        this.base = base;
        this.statusPanel = statusPanel;
    }

    protected Contribution getContrib() {
        return this.contrib;
    }

    private LocalContribution getLocalContrib() {
        return (LocalContribution)this.contrib;
    }

    protected void setContrib(Contribution contrib) {
        this.contrib = contrib;
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.initProgressBar();
        }
        return this.progressBar;
    }

    protected void initProgressBar() {
        this.progressBar = new JProgressBar();
        this.progressBar.setInheritsPopupMenu(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setFont(ManagerFrame.NORMAL_PLAIN);
        this.progressBar.setAlignmentX(0.5f);
        this.progressBar.setOpaque(false);
        this.resetProgressBar();
        int high = this.progressBar.getPreferredSize().height;
        Dimension dim = new Dimension(BUTTON_WIDTH, high);
        this.progressBar.setPreferredSize(dim);
        this.progressBar.setMaximumSize(dim);
        this.progressBar.setMinimumSize(dim);
    }

    private void resetProgressBar() {
        this.progressBar.setString(Language.text("contrib.progress.starting"));
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(false);
    }

    private void installContribution(AvailableContribution info) {
        if (info.link == null) {
            this.statusPanel.setErrorMessage(Language.interpolate("contrib.unsupported_operating_system", new Object[]{info.getType()}));
        } else {
            this.installContribution(info, info.link);
        }
    }

    private void finishInstall(boolean error) {
        this.resetProgressBar();
        if (error) {
            this.statusPanel.setErrorMessage(Language.text("contrib.download_error"));
        }
        this.installInProgress = false;
        if (this.updateInProgress) {
            this.updateInProgress = false;
        }
    }

    private void installContribution(AvailableContribution ad, String url) {
        try {
            URL downloadUrl = new URL(url);
            this.progressBar.setVisible(true);
            ContribProgress downloadProgress = new ContribProgress(this.progressBar){

                @Override
                public void finishedAction() {
                }

                @Override
                public void cancelAction() {
                    StatusPanelDetail.this.finishInstall(false);
                }
            };
            ContribProgress installProgress = new ContribProgress(this.progressBar){

                @Override
                public void finishedAction() {
                    StatusPanelDetail.this.finishInstall(this.isException());
                    StatusPanelDetail.this.restoreSketches();
                }

                @Override
                public void cancelAction() {
                    this.finishedAction();
                }
            };
            ContributionManager.downloadAndInstall(this.base, downloadUrl, ad, downloadProgress, installProgress, this.statusPanel);
        }
        catch (MalformedURLException e) {
            Messages.showWarning(Language.text("contrib.errors.install_failed"), Language.text("contrib.errors.malformed_url"), e);
        }
    }

    protected void install() {
        this.statusPanel.clearMessage();
        this.installInProgress = true;
        if (this.contrib instanceof AvailableContribution) {
            this.installContribution((AvailableContribution)this.contrib);
            ContributionListing.getInstance().replaceContribution(this.contrib, this.contrib);
        }
    }

    protected void update() {
        this.statusPanel.clearMessage();
        this.updateInProgress = true;
        final ContributionListing contribListing = ContributionListing.getInstance();
        if (this.contrib.getType().requiresRestart()) {
            if (this.progressBar == null) {
                this.initProgressBar();
            }
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
            ContribProgress progress = new ContribProgress(this.progressBar){

                @Override
                public void finishedAction() {
                    StatusPanelDetail.this.resetProgressBar();
                    AvailableContribution ad = contribListing.getAvailableContribution(StatusPanelDetail.this.contrib);
                    StatusPanelDetail.this.installContribution(ad, ad.link);
                }

                @Override
                public void cancelAction() {
                    StatusPanelDetail.this.resetProgressBar();
                    StatusPanelDetail.this.statusPanel.clearMessage();
                    StatusPanelDetail.this.updateInProgress = false;
                    if (StatusPanelDetail.this.contrib.isDeletionFlagged()) {
                        StatusPanelDetail.this.getLocalContrib().setUpdateFlag();
                        StatusPanelDetail.this.getLocalContrib().setDeletionFlag(false);
                        contribListing.replaceContribution(StatusPanelDetail.this.contrib, StatusPanelDetail.this.contrib);
                    }
                }
            };
            this.getLocalContrib().removeContribution(this.base, progress, this.statusPanel, true);
        } else {
            AvailableContribution ad = contribListing.getAvailableContribution(this.contrib);
            this.installContribution(ad, ad.link);
        }
    }

    protected void remove() {
        this.statusPanel.clearMessage();
        if (this.contrib.isInstalled() && this.contrib instanceof LocalContribution) {
            this.removeInProgress = true;
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
            ContribProgress progress = new ContribProgress(this.progressBar){

                @Override
                public void finishedAction() {
                    StatusPanelDetail.this.resetProgressBar();
                    StatusPanelDetail.this.removeInProgress = false;
                }

                @Override
                public void cancelAction() {
                    StatusPanelDetail.this.resetProgressBar();
                    StatusPanelDetail.this.removeInProgress = false;
                }
            };
            this.getLocalContrib().removeContribution(this.base, progress, this.statusPanel, false);
        }
    }

    protected static void storeSketchPath(String path) {
        restoreQueue.add(path);
    }

    protected void restoreSketches() {
        while (!restoreQueue.isEmpty()) {
            String path = restoreQueue.remove();
            this.base.handleOpen(path);
        }
    }
}

