/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import processing.app.Base;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Util;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusPanelDetail;
import processing.app.ui.Toolkit;

class StatusPanel
extends JPanel {
    static final int LABEL_WIDTH = Toolkit.zoom(480);
    static final int BUTTON_WIDTH = Toolkit.zoom(150);
    static Icon foundationIcon;
    static Icon installIcon;
    static Icon updateIcon;
    static Icon removeIcon;
    static Font buttonFont;
    JTextPane label;
    JButton installButton;
    JPanel progressPanel;
    JLabel updateLabel;
    JButton updateButton;
    JButton removeButton;
    GroupLayout layout;
    JLabel iconLabel;
    ContributionTab contributionTab;
    private static final String REMOVE_RESTART_MESSAGE;
    private static final String INSTALL_RESTART_MESSAGE;
    private static final String UPDATE_RESTART_MESSAGE;

    public StatusPanel(ContributionTab contributionTab) {
        this.contributionTab = contributionTab;
        if (foundationIcon == null) {
            foundationIcon = Toolkit.getLibIconX("icons/foundation", 32);
            installIcon = Toolkit.getLibIconX("manager/install");
            updateIcon = Toolkit.getLibIconX("manager/update");
            removeIcon = Toolkit.getLibIconX("manager/remove");
            buttonFont = ManagerFrame.NORMAL_PLAIN;
        }
        this.setBackground(new Color(0xEBEBEB));
        this.iconLabel = new JLabel();
        this.iconLabel.setHorizontalAlignment(0);
        this.label = new JTextPane();
        this.label.setEditable(false);
        this.label.setOpaque(false);
        this.label.setContentType("text/html");
        this.label.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
                Platform.openURL(e.getURL().toString());
            }
        });
        this.installButton = Toolkit.createIconButton("Install", installIcon);
        this.installButton.setFont(buttonFont);
        this.installButton.setHorizontalAlignment(2);
        this.installButton.addActionListener(e -> {
            this.installButton.setEnabled(false);
            StatusPanelDetail currentDetail = contributionTab.listPanel.getSelectedDetail();
            currentDetail.install();
            this.updateDetail(currentDetail);
        });
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.setOpaque(false);
        this.updateLabel = new JLabel(" ");
        this.updateLabel.setFont(buttonFont);
        this.updateLabel.setHorizontalAlignment(0);
        this.updateButton = Toolkit.createIconButton("Update", updateIcon);
        this.updateButton.setFont(buttonFont);
        this.updateButton.setHorizontalAlignment(2);
        this.updateButton.addActionListener(e -> {
            this.updateButton.setEnabled(false);
            StatusPanelDetail currentDetail = contributionTab.listPanel.getSelectedDetail();
            currentDetail.update();
            this.updateDetail(currentDetail);
        });
        this.removeButton = Toolkit.createIconButton("Remove", removeIcon);
        this.removeButton.setFont(buttonFont);
        this.removeButton.setHorizontalAlignment(2);
        this.removeButton.addActionListener(e -> {
            this.removeButton.setEnabled(false);
            StatusPanelDetail currentPanel = contributionTab.listPanel.getSelectedDetail();
            currentPanel.remove();
            this.updateDetail(currentPanel);
        });
        this.layout = new GroupLayout(this);
        this.setLayout(this.layout);
        this.layout.setAutoCreateContainerGaps(true);
        this.layout.setAutoCreateGaps(true);
        this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGap(0).addComponent(this.iconLabel, ManagerFrame.STATUS_WIDTH, ManagerFrame.STATUS_WIDTH, ManagerFrame.STATUS_WIDTH).addGap(0).addComponent(this.label, LABEL_WIDTH, LABEL_WIDTH, LABEL_WIDTH).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.installButton, BUTTON_WIDTH, BUTTON_WIDTH, BUTTON_WIDTH).addComponent(this.progressPanel).addComponent(this.updateLabel, BUTTON_WIDTH, BUTTON_WIDTH, BUTTON_WIDTH).addComponent(this.updateButton).addComponent(this.removeButton)).addGap(12));
        this.layout.setVerticalGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel).addComponent(this.label).addGroup(this.layout.createSequentialGroup().addComponent(this.installButton).addGroup(this.layout.createParallelGroup().addComponent(this.progressPanel).addComponent(this.updateLabel)).addComponent(this.updateButton).addComponent(this.removeButton)));
        this.layout.linkSize(0, this.installButton, this.progressPanel, this.updateButton, this.removeButton);
        this.progressPanel.setVisible(false);
        this.installButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.updateLabel.setVisible(true);
        this.layout.setHonorsVisibility(this.updateLabel, false);
        this.validate();
    }

    void setErrorMessage(String message) {
        if (this.label != null) {
            this.label.setText(message);
            this.label.repaint();
        }
    }

    void clearMessage() {
        if (this.label != null) {
            this.label.setText(null);
            this.label.repaint();
        }
    }

    private static String getBodyStyle() {
        return "body {   margin: 0;   padding: 0;  font-family: " + Toolkit.getSansFontName() + ", Helvetica, Arial, sans-serif;  font-size: 11px;}a { color: #444; text-decoration: none; }";
    }

    static String updateDescription(Contribution contrib) {
        Font boldFont = ManagerFrame.SMALL_BOLD;
        String fontFace = "<font face=\"" + boldFont.getName() + "\">";
        StringBuilder desc = new StringBuilder();
        desc.append("<html><body>");
        desc.append(fontFace);
        if (contrib.getUrl() == null) {
            desc.append(contrib.getName());
        } else {
            desc.append("<a href=\"");
            desc.append(contrib.getUrl());
            desc.append("\">");
            desc.append(contrib.getName());
            desc.append("</a>");
        }
        desc.append("</font> ");
        String prettyVersion = contrib.getPrettyVersion();
        if (prettyVersion != null) {
            desc.append(prettyVersion);
        }
        desc.append(" <br/>");
        String authorList = contrib.getAuthorList();
        if (authorList != null && !authorList.isEmpty()) {
            desc.append(Util.markDownLinksToHtml(contrib.getAuthorList()));
        }
        desc.append("<br/><br/>");
        if (contrib.isDeletionFlagged()) {
            desc.append(REMOVE_RESTART_MESSAGE);
        } else if (contrib.isRestartFlagged()) {
            desc.append(INSTALL_RESTART_MESSAGE);
        } else if (contrib.isUpdateFlagged()) {
            desc.append(UPDATE_RESTART_MESSAGE);
        } else {
            Object sentence = contrib.getSentence();
            if (sentence == null || ((String)sentence).isEmpty()) {
                sentence = "<i>" + Language.text("contrib.errors.description_unavailable") + "</i>";
            } else {
                sentence = Util.sanitizeHtmlTags((String)sentence);
                sentence = Util.markDownLinksToHtml((String)sentence);
            }
            desc.append((String)sentence);
        }
        long lastUpdatedUTC = contrib.getLastUpdated();
        if (lastUpdatedUTC != 0L) {
            DateFormat dateFormatter = DateFormat.getDateInstance(2);
            Date lastUpdatedDate = new Date(lastUpdatedUTC);
            if (prettyVersion != null) {
                desc.append(", ");
            }
            desc.append("Last Updated on ");
            desc.append(dateFormatter.format(lastUpdatedDate));
        }
        desc.append("</body></html>");
        return desc.toString();
    }

    void updateDetail(StatusPanelDetail detail) {
        Contribution contrib = detail.getContrib();
        this.iconLabel.setIcon(contrib.isFoundation() ? foundationIcon : null);
        this.label.setText(StatusPanel.updateDescription(contrib));
        ((HTMLDocument)this.label.getDocument()).getStyleSheet().addRule(StatusPanel.getBodyStyle());
        ContributionListing listing = ContributionListing.getInstance();
        this.updateButton.setEnabled(listing.isDownloaded() && listing.hasUpdates(contrib) && !contrib.isUpdateFlagged() && !detail.updateInProgress);
        String latestVersion = listing.getLatestPrettyVersion(contrib);
        String currentVersion = contrib.getPrettyVersion();
        this.installButton.setEnabled(!contrib.isInstalled() && listing.isDownloaded() && contrib.isCompatible(Base.getRevision()) && !detail.installInProgress);
        if (contrib.isCompatible(Base.getRevision())) {
            if (this.installButton.isEnabled()) {
                if (latestVersion != null) {
                    this.updateLabel.setText(latestVersion + " available");
                } else {
                    this.updateLabel.setText("Available");
                }
            } else if (currentVersion != null) {
                this.updateLabel.setText(currentVersion + " installed");
            } else {
                this.updateLabel.setText("Installed");
            }
        } else if (currentVersion != null) {
            this.updateLabel.setText(currentVersion + " not compatible");
        } else {
            this.updateLabel.setText("Not compatible");
        }
        if (this.updateButton.isEnabled() && latestVersion != null) {
            this.updateButton.setText("Update to " + latestVersion);
        } else {
            this.updateButton.setText("Update");
        }
        this.removeButton.setEnabled(contrib.isInstalled() && !detail.removeInProgress);
        this.progressPanel.removeAll();
        this.progressPanel.add(detail.getProgressBar());
        if (detail.updateInProgress || detail.installInProgress || detail.removeInProgress) {
            this.progressPanel.setVisible(true);
            this.updateLabel.setVisible(false);
        } else {
            this.progressPanel.setVisible(false);
            this.updateLabel.setVisible(true);
        }
        this.progressPanel.repaint();
    }

    static {
        REMOVE_RESTART_MESSAGE = String.format("<i>%s</i>", Language.text("contrib.messages.remove_restart"));
        INSTALL_RESTART_MESSAGE = String.format("<i>%s</i>", Language.text("contrib.messages.install_restart"));
        UPDATE_RESTART_MESSAGE = String.format("<i>%s</i>", Language.text("contrib.messages.update_restart"));
    }
}

