/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Language;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ManagerTabs;
import processing.app.contrib.UpdateContributionTab;
import processing.app.ui.Theme;
import processing.app.ui.Toolkit;

public class ManagerFrame {
    static final String ANY_CATEGORY = Language.text("contrib.all");
    static final int AUTHOR_WIDTH = Toolkit.zoom(240);
    static final int STATUS_WIDTH = Toolkit.zoom(66);
    static final String title = "Contribution Manager";
    Base base;
    JFrame frame;
    ManagerTabs tabs;
    ContributionTab librariesTab;
    ContributionTab modesTab;
    ContributionTab toolsTab;
    ContributionTab examplesTab;
    UpdateContributionTab updatesTab;
    static Font SMALL_PLAIN;
    static Font SMALL_BOLD;
    static Font NORMAL_PLAIN;
    static Font NORMAL_BOLD;

    public ManagerFrame(Base base) {
        this.base = base;
        int smallSize = Toolkit.zoom(12);
        int normalSize = Toolkit.zoom(14);
        SMALL_PLAIN = Toolkit.getSansFont(smallSize, 0);
        SMALL_BOLD = Toolkit.getSansFont(smallSize, 1);
        NORMAL_PLAIN = Toolkit.getSansFont(normalSize, 0);
        NORMAL_BOLD = Toolkit.getSansFont(normalSize, 1);
        this.librariesTab = new ContributionTab(this, ContributionType.LIBRARY);
        this.modesTab = new ContributionTab(this, ContributionType.MODE);
        this.toolsTab = new ContributionTab(this, ContributionType.TOOL);
        this.examplesTab = new ContributionTab(this, ContributionType.EXAMPLES);
        this.updatesTab = new UpdateContributionTab(this);
    }

    public void showFrame(ContributionType contributionType) {
        ContributionTab showTab = this.getTab(contributionType);
        if (this.frame == null) {
            this.makeFrame();
            this.tabs.setPanel(showTab);
            this.downloadAndUpdateContributionListing();
        } else {
            this.tabs.setPanel(showTab);
        }
        this.frame.setVisible(true);
        this.tabs.requestFocusInWindow();
    }

    private void makeFrame() {
        this.frame = new JFrame(title);
        this.frame.setMinimumSize(Toolkit.zoom(750, 500));
        this.tabs = new ManagerTabs();
        this.rebuildTabLayouts(false, true);
        this.tabs.addPanel(this.librariesTab, "Libraries");
        this.tabs.addPanel(this.modesTab, "Modes");
        this.tabs.addPanel(this.toolsTab, "Tools");
        this.tabs.addPanel(this.examplesTab, "Examples");
        this.tabs.addPanel(this.updatesTab, "Updates");
        this.frame.setResizable(true);
        this.frame.getContentPane().add(this.tabs);
        this.updateTheme();
        this.frame.validate();
        this.frame.repaint();
        Toolkit.setIcon(this.frame);
        this.registerDisposeListeners();
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
    }

    protected void updateTheme() {
        if (this.frame != null) {
            Color bgColor = Theme.getColor("manager.tab.background");
            this.frame.getContentPane().setBackground(bgColor);
            this.tabs.updateTheme();
        }
    }

    protected void disposeFrame() {
        this.frame.dispose();
    }

    private void registerDisposeListeners() {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ManagerFrame.this.disposeFrame();
            }
        });
        Toolkit.registerWindowCloseKeys(this.frame.getRootPane(), actionEvent -> this.disposeFrame());
        this.frame.getContentPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke wc = Toolkit.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    ManagerFrame.this.disposeFrame();
                }
            }
        });
    }

    void downloadAndUpdateContributionListing() {
        ContributionTab activeTab = this.getActiveTab();
        activeTab.updateContributionListing();
        activeTab.updateCategoryChooser();
        this.rebuildTabLayouts(false, false);
    }

    protected void rebuildTabLayouts(boolean error, boolean loading) {
        this.librariesTab.rebuildLayout(error, loading);
        this.modesTab.rebuildLayout(error, loading);
        this.toolsTab.rebuildLayout(error, loading);
        this.examplesTab.rebuildLayout(error, loading);
        this.updatesTab.rebuildLayout(error, loading);
    }

    protected ContributionTab getTab(ContributionType contributionType) {
        if (contributionType == ContributionType.LIBRARY) {
            return this.librariesTab;
        }
        if (contributionType == ContributionType.MODE) {
            return this.modesTab;
        }
        if (contributionType == ContributionType.TOOL) {
            return this.toolsTab;
        }
        if (contributionType == ContributionType.EXAMPLES) {
            return this.examplesTab;
        }
        return this.updatesTab;
    }

    ContributionTab getActiveTab() {
        return (ContributionTab)this.tabs.getPanel();
    }
}

