/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import processing.app.Base;
import processing.app.Util;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.StatusPanelDetail;
import processing.app.ui.Toolkit;

public class ListPanel
extends JPanel
implements Scrollable {
    ContributionTab contributionTab;
    Map<Contribution, StatusPanelDetail> detailForContrib = new ConcurrentHashMap<Contribution, StatusPanelDetail>();
    private final Contribution.Filter filter;
    private StatusPanelDetail selectedDetail;
    protected ContributionRowFilter rowFilter;
    protected JTable table;
    protected TableRowSorter<ContributionTableModel> sorter;
    protected ContributionTableModel model;
    static Icon upToDateIcon;
    static Icon updateAvailableIcon;
    static Icon incompatibleIcon;
    static Icon foundationIcon;
    static Icon downloadingIcon;
    static final Color HEADER_BGCOLOR;
    static final Color SECTION_COLOR;
    static final Color SELECTION_COLOR;
    static final SectionHeaderContribution[] sections;

    public ListPanel(ContributionTab contributionTab, Contribution.Filter filter, boolean enableSections, ContributionColumn ... columns) {
        this.contributionTab = contributionTab;
        this.filter = filter;
        this.rowFilter = new ContributionRowFilter(filter);
        if (upToDateIcon == null) {
            upToDateIcon = Toolkit.getLibIconX("manager/up-to-date");
            updateAvailableIcon = Toolkit.getLibIconX("manager/update-available");
            incompatibleIcon = Toolkit.getLibIconX("manager/incompatible");
            foundationIcon = Toolkit.getLibIconX("icons/foundation", 16);
            downloadingIcon = Toolkit.getLibIconX("manager/downloading");
        }
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.model = new ContributionTableModel(columns);
        this.model.enableSections(enableSections);
        this.table = new JTable(this.model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                Object rowValue = this.getValueAt(row, column);
                if (rowValue instanceof SectionHeaderContribution) {
                    c.setBackground(SECTION_COLOR);
                } else if (this.isRowSelected(row)) {
                    c.setBackground(SELECTION_COLOR);
                } else {
                    c.setBackground(Color.white);
                }
                return c;
            }

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                if (!(this.getValueAt(rowIndex, columnIndex) instanceof SectionHeaderContribution)) {
                    super.changeSelection(rowIndex, columnIndex, toggle, extend);
                }
            }
        };
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Contribution.class, new ContribStatusRenderer());
        this.table.setFont(ManagerFrame.NORMAL_PLAIN);
        this.table.setRowHeight(Toolkit.zoom(28));
        this.table.setRowMargin(Toolkit.zoom(6));
        this.table.getColumnModel().setColumnMargin(0);
        this.table.getColumnModel().getColumn(0).setMaxWidth(ManagerFrame.STATUS_WIDTH);
        this.table.getColumnModel().getColumn(2).setMinWidth(ManagerFrame.AUTHOR_WIDTH);
        this.table.getColumnModel().getColumn(2).setMaxWidth(ManagerFrame.AUTHOR_WIDTH);
        this.table.setShowGrid(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setAutoCreateRowSorter(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(event -> {
            int row = this.table.getSelectedRow();
            if (row != -1) {
                Contribution contrib = (Contribution)this.table.getValueAt(row, 0);
                this.setSelectedDetail(this.detailForContrib.get(contrib));
                if (!contributionTab.filterHasFocus()) {
                    this.table.requestFocusInWindow();
                }
            }
        });
        this.sorter = new TableRowSorter<ContributionTableModel>(this.model);
        this.table.setRowSorter(this.sorter);
        this.sorter.setRowFilter(this.rowFilter);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            if (this.model.columns[i] == ContributionColumn.NAME) {
                this.sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(i, SortOrder.ASCENDING)));
            }
            this.sorter.setComparator(i, this.model.columns[i].getComparator());
        }
        this.table.getTableHeader().setDefaultRenderer(new ContribHeaderRenderer());
        this.table.setVisible(true);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
    }

    protected int getScrollBarWidth() {
        JScrollPane scrollPane = (JScrollPane)this.getComponent(0);
        return scrollPane.getVerticalScrollBar().getPreferredSize().width;
    }

    private static int getContributionStatusRank(Contribution c) {
        int pos = 4;
        if (c.isInstalled()) {
            pos = 1;
            if (ContributionListing.getInstance().hasUpdates(c)) {
                pos = 2;
            }
            if (!c.isCompatible(Base.getRevision())) {
                pos = 3;
            }
        }
        return pos;
    }

    protected static boolean matches(Contribution contrib, String typed) {
        String search = ".*" + typed.toLowerCase() + ".*";
        return ListPanel.matchField(contrib.getName(), search) || ListPanel.matchField(contrib.getSentence(), search) || ListPanel.matchField(contrib.getAuthorList(), search) || ListPanel.matchField(contrib.getParagraph(), search);
    }

    private static boolean matchField(String field, String regex) {
        return field != null && field.toLowerCase().matches(regex);
    }

    protected void contributionAdded(Contribution contribution) {
        if (this.filter.matches(contribution) && !this.detailForContrib.containsKey(contribution)) {
            StatusPanelDetail newPanel = new StatusPanelDetail(this.contributionTab.base, this.contributionTab.statusPanel);
            this.detailForContrib.put(contribution, newPanel);
            newPanel.setContrib(contribution);
            this.model.fireTableDataChanged();
        }
    }

    protected void contributionRemoved(Contribution contribution) {
        if (this.filter.matches(contribution)) {
            StatusPanelDetail panel = this.detailForContrib.get(contribution);
            if (panel != null) {
                this.detailForContrib.remove(contribution);
            }
            this.model.fireTableDataChanged();
            this.updateUI();
        }
    }

    protected void contributionChanged(Contribution oldContrib, Contribution newContrib) {
        if (this.filter.matches(oldContrib)) {
            StatusPanelDetail panel = this.detailForContrib.get(oldContrib);
            this.detailForContrib.remove(oldContrib);
            panel.setContrib(newContrib);
            this.detailForContrib.put(newContrib, panel);
            this.model.fireTableDataChanged();
        }
    }

    protected void filterLibraries(String category, List<String> filters) {
        this.rowFilter.setCategoryFilter(category);
        this.rowFilter.setStringFilters(filters);
        this.model.fireTableDataChanged();
    }

    protected void fireChange() {
        this.model.fireTableDataChanged();
    }

    private void setSelectedDetail(StatusPanelDetail contribDetail) {
        this.contributionTab.updateStatusDetail(contribDetail);
        if (this.selectedDetail != contribDetail) {
            this.selectedDetail = contribDetail;
            this.requestFocusInWindow();
        }
    }

    protected StatusPanelDetail getSelectedDetail() {
        return this.selectedDetail;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int blockAmount = visibleRect.height;
            visibleRect.y = direction > 0 ? (visibleRect.y += blockAmount) : (visibleRect.y -= blockAmount);
            return blockAmount += this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 0;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        int lastHeight = 0;
        int height = 0;
        int bottomOfScrollArea = visibleRect.y + visibleRect.height;
        for (Component c : this.getComponents()) {
            Dimension d = c.getPreferredSize();
            int nextHeight = height + d.height;
            if (direction > 0) {
                if (nextHeight > bottomOfScrollArea) {
                    return nextHeight - bottomOfScrollArea;
                }
            } else if (nextHeight > visibleRect.y) {
                if (visibleRect.y != height) {
                    return visibleRect.y - height;
                }
                return visibleRect.y - lastHeight;
            }
            lastHeight = height;
            height = nextHeight;
        }
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getRowCount() {
        return this.sorter.getViewRowCount();
    }

    static {
        HEADER_BGCOLOR = new Color(-1315861);
        SECTION_COLOR = new Color(-460552);
        SELECTION_COLOR = new Color(-2031619);
        sections = new SectionHeaderContribution[]{new SectionHeaderContribution(ContributionType.LIBRARY), new SectionHeaderContribution(ContributionType.MODE), new SectionHeaderContribution(ContributionType.TOOL), new SectionHeaderContribution(ContributionType.EXAMPLES)};
    }

    static class ContributionRowFilter
    extends RowFilter<ContributionTableModel, Integer> {
        Contribution.Filter contributionFilter;
        Optional<String> categoryFilter = Optional.empty();
        List<String> stringFilters = Collections.emptyList();

        ContributionRowFilter(Contribution.Filter contributionFilter) {
            this.contributionFilter = contributionFilter;
        }

        public void setCategoryFilter(String categoryFilter) {
            this.categoryFilter = Optional.ofNullable(categoryFilter);
        }

        public void setStringFilters(List<String> filters) {
            this.stringFilters = filters;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends ContributionTableModel, ? extends Integer> entry) {
            Contribution contribution = (Contribution)entry.getValue(0);
            if (contribution instanceof SectionHeaderContribution) {
                return this.includeSection((SectionHeaderContribution)contribution);
            }
            return this.includeContribution(contribution);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean includeContribution(Contribution contribution) {
            if (!this.contributionFilter.matches(contribution)) return false;
            if (this.categoryFilter.map(contribution::hasCategory).orElse(true) == false) return false;
            if (!this.stringFilters.stream().allMatch(pattern -> ListPanel.matches(contribution, pattern))) return false;
            return true;
        }

        private boolean includeSection(SectionHeaderContribution section) {
            return ContributionListing.getInstance().allContributions.stream().filter(contribution -> contribution.getType() == section.getType()).anyMatch(this::includeContribution);
        }
    }

    static class ContributionTableModel
    extends AbstractTableModel {
        ContributionColumn[] columns = new ContributionColumn[]{ContributionColumn.STATUS, ContributionColumn.NAME, ContributionColumn.AUTHOR};
        boolean sectionsEnabled;

        ContributionTableModel(ContributionColumn ... columns) {
            if (columns.length > 0) {
                this.columns = columns;
            }
        }

        @Override
        public int getRowCount() {
            return ContributionListing.getInstance().allContributions.size() + (this.sectionsEnabled ? 4 : 0);
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column < 0 || column > this.columns.length) {
                return "";
            }
            return this.columns[column].name;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Contribution.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= ContributionListing.getInstance().allContributions.size()) {
                return sections[rowIndex - ContributionListing.getInstance().allContributions.size()];
            }
            return ContributionListing.getInstance().allContributions.stream().skip(rowIndex).findFirst().orElse(null);
        }

        public void enableSections(boolean enable) {
            this.sectionsEnabled = enable;
        }
    }

    protected static enum ContributionColumn {
        STATUS(" Status"),
        NAME("Name"),
        AUTHOR("Author"),
        INSTALLED_VERSION("Installed"),
        AVAILABLE_VERSION("Available"),
        STATUS_NO_HEADER("");

        final String name;

        private ContributionColumn(String name) {
            this.name = name;
        }

        Comparator<Contribution> getComparator() {
            Comparator<Contribution> comparator = Comparator.comparing(Contribution::getType).thenComparingInt(contribution -> contribution instanceof SectionHeaderContribution ? 0 : 1);
            if (this == STATUS || this == STATUS_NO_HEADER) {
                return comparator.thenComparingInt(x$0 -> ListPanel.getContributionStatusRank(x$0));
            }
            if (this == AUTHOR) {
                return comparator.thenComparing(contribution -> Util.removeMarkDownLinks(contribution.getAuthorList()));
            }
            return comparator.thenComparing(Contribution::getName, String.CASE_INSENSITIVE_ORDER);
        }
    }

    private class ContribStatusRenderer
    extends DefaultTableCellRenderer {
        private ContribStatusRenderer() {
        }

        @Override
        public void setVerticalAlignment(int alignment) {
            super.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Contribution contribution = (Contribution)value;
            JLabel label = new JLabel();
            ContributionColumn col = ListPanel.this.model.columns[column];
            if (value == null) {
                return label;
            }
            label.setOpaque(true);
            if (value instanceof SectionHeaderContribution && col != ContributionColumn.NAME) {
                return label;
            }
            switch (col) {
                case STATUS: 
                case STATUS_NO_HEADER: {
                    this.configureStatusColumnLabel(label, contribution);
                    break;
                }
                case NAME: {
                    this.configureNameColumnLabel(table, label, contribution);
                    break;
                }
                case AUTHOR: {
                    this.configureAuthorsColumnLabel(label, contribution);
                    break;
                }
                case INSTALLED_VERSION: {
                    label.setText(contribution.getBenignVersion());
                    break;
                }
                case AVAILABLE_VERSION: {
                    label.setText(ContributionListing.getInstance().getLatestPrettyVersion(contribution));
                }
            }
            if (!contribution.isCompatible(Base.getRevision())) {
                label.setForeground(Color.LIGHT_GRAY);
            }
            return label;
        }

        private void configureStatusColumnLabel(JLabel label, Contribution contribution) {
            Icon icon = null;
            label.setFont(ManagerFrame.NORMAL_PLAIN);
            StatusPanelDetail detail = ListPanel.this.detailForContrib.get(contribution);
            if (detail != null && (detail.updateInProgress || detail.installInProgress)) {
                icon = downloadingIcon;
            } else if (contribution.isInstalled()) {
                icon = !contribution.isCompatible(Base.getRevision()) ? incompatibleIcon : (ContributionListing.getInstance().hasUpdates(contribution) ? updateAvailableIcon : (detail != null && (detail.installInProgress || detail.updateInProgress) ? downloadingIcon : upToDateIcon));
            }
            label.setIcon(icon);
            label.setHorizontalAlignment(0);
        }

        private void configureNameColumnLabel(JTable table, JLabel label, Contribution contribution) {
            Font boldFont = ManagerFrame.NORMAL_BOLD;
            FontMetrics fontMetrics = table.getFontMetrics(boldFont);
            int colSize = table.getColumnModel().getColumn(1).getWidth();
            int currentWidth = fontMetrics.stringWidth(contribution.getName() + " | ...");
            String sentence = Util.removeMarkDownLinks(contribution.getSentence());
            StringBuilder text = new StringBuilder("<html><body><font face=\"").append(boldFont.getName()).append("\">").append(contribution.getName());
            if (sentence.length() == 0) {
                text.append("</font>");
            } else {
                int index;
                for (index = 0; index < sentence.length() && (currentWidth += fontMetrics.charWidth(sentence.charAt(index))) < colSize; ++index) {
                }
                text.append(" | </font>").append(sentence, 0, index);
                if (index != sentence.length()) {
                    text.append("...");
                }
            }
            text.append("</body></html>");
            label.setText(text.toString());
            label.setFont(ManagerFrame.NORMAL_PLAIN);
        }

        private void configureAuthorsColumnLabel(JLabel label, Contribution contribution) {
            if (contribution.isFoundation()) {
                label.setIcon(foundationIcon);
            }
            String authorList = contribution.getAuthorList();
            String name = Util.removeMarkDownLinks(authorList);
            label.setText(name);
            label.setHorizontalAlignment(2);
            label.setForeground(Color.BLACK);
            label.setFont(ManagerFrame.NORMAL_BOLD);
        }
    }

    static class ContribHeaderRenderer
    extends DefaultTableCellRenderer {
        public ContribHeaderRenderer() {
            this.setHorizontalTextPosition(2);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JTableHeader tableHeader = table.getTableHeader();
            if (tableHeader != null) {
                this.setForeground(tableHeader.getForeground());
            }
            this.setFont(ManagerFrame.SMALL_PLAIN);
            this.setIcon(this.getSortIcon(table, column));
            this.setBackground(HEADER_BGCOLOR);
            this.setBorder(null);
            return this;
        }

        private Icon getSortIcon(JTable table, int column) {
            RowSorter.SortKey sortKey = this.getSortKey(table);
            if (sortKey != null && table.convertColumnIndexToView(sortKey.getColumn()) == column) {
                switch (sortKey.getSortOrder()) {
                    case ASCENDING: {
                        return UIManager.getIcon("Table.ascendingSortIcon");
                    }
                    case DESCENDING: {
                        return UIManager.getIcon("Table.descendingSortIcon");
                    }
                }
            }
            return null;
        }

        protected RowSorter.SortKey getSortKey(JTable table) {
            return Optional.ofNullable(table.getRowSorter()).map(RowSorter::getSortKeys).map(columns -> columns.isEmpty() ? null : (RowSorter.SortKey)columns.get(0)).orElse(null);
        }
    }

    static class SectionHeaderContribution
    extends Contribution {
        ContributionType type;

        SectionHeaderContribution(ContributionType type) {
            this.type = type;
            this.name = this.getTypeName();
        }

        @Override
        public ContributionType getType() {
            return this.type;
        }

        @Override
        public boolean isInstalled() {
            return false;
        }
    }
}

